/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboSerializeTest;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReaderObjectSwapTest
extends ComboSerializeTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new ComboInput<PojoToSimpleReader>("PojoToSimpleReader", (Type)((Object)PojoToSimpleReader.class), new PojoToSimpleReader(), "foo", "foo", "foo", "foo", "foo", "foo\n", "foo", "foo", "foo", "foo", "foo", "foo", "foo", "foo", "foo", "foo", "666F6F", "666F6F", "<rdf:RDF>\n<rdf:Description>\n<j:value>foo</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>foo</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>foo</j:value>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<PojoToDynamicReader>("PojoToDynamicReader", (Type)((Object)PojoToDynamicReader.class), new PojoToDynamicReader("foo"), "foo-json", "foo-json", "foo-json", "foo-xml", "foo-xml", "foo-xml\n", "foo-xml", "foo-html", "foo-html", "foo-html", "foo-uon", "foo-uon", "foo-uon", "foo-x-www-form-urlencoded", "foo-x-www-form-urlencoded", "foo-x-www-form-urlencoded", "666F6F2D6D73677061636B", "666F6F2D6D73677061636B", "<rdf:RDF>\n<rdf:Description>\n<j:value>foo-xml</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>foo-xml</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>foo-xml</j:value>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<SometimesSwappedBean1>("SometimesSwappedBean1", (Type)((Object)SometimesSwappedBean1.class), new SometimesSwappedBean1("foo"), "foo-application/json", "foo-application/json", "foo-application/json", "foo-text/xml", "foo-text/xml", "foo-text/xml\n", "foo-text/xml", "<table><tr><td>f</td><td>foo</td></tr></table>", "<table><tr><td>f</td><td>foo</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>foo</td>\n\t</tr>\n</table>\n", "(f=foo)", "(f=foo)", "(\n\tf=foo\n)", "f=foo", "f=foo", "f=foo", "81A166A3666F6F", "81A166A3666F6F", "<rdf:RDF>\n<rdf:Description>\n<j:value>foo-text/xml+rdf</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>foo-text/xml+rdf</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>foo-text/xml+rdf</j:value>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<SometimesSwappedBean2>("SometimesSwappedBean2", (Type)((Object)SometimesSwappedBean2.class), new SometimesSwappedBean2("foo"), "{f:'foo'}", "{f:'foo'}", "{\n\tf: 'foo'\n}", "<object><f>foo</f></object>", "<object><f>foo</f></object>", "<object>\n\t<f>foo</f>\n</object>\n", "<object><f>foo</f></object>", "foo-text/html", "foo-text/html", "foo-text/html", "foo-text/uon", "foo-text/uon", "foo-text/uon", "foo-application/x-www-form-urlencoded", "foo-application/x-www-form-urlencoded", "foo-application/x-www-form-urlencoded", "666F6F2D6F6374616C2F6D73677061636B", "666F6F2D6F6374616C2F6D73677061636B", "<rdf:RDF>\n<rdf:Description>\n<jp:f>foo</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>foo</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>foo</jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithSwappedField>("BeanWithSwappedField", (Type)((Object)BeanWithSwappedField.class), new BeanWithSwappedField("x"), "{f:x-json}", "{f:x-json}", "{\n\tf: x-json\n}", "<object><f>x-xml</f></object>", "<object><f>x-xml</f></object>", "<object>\n\t<f>x-xml</f>\n</object>\n", "<object><f>x-xml</f></object>", "<table><tr><td>f</td><td>x-html</td></tr></table>", "<table><tr><td>f</td><td>x-html</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>x-html</td>\n\t</tr>\n</table>\n", "(f=x-uon)", "(f=x-uon)", "(\n\tf=x-uon\n)", "f=x-x-www-form-urlencoded", "f=x-x-www-form-urlencoded", "f=x-x-www-form-urlencoded", "81A166782D6D73677061636B", "81A166782D6D73677061636B", "<rdf:RDF>\n<rdf:Description>\n<jp:f>x-xml</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>x-xml</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>x-xml</jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithSwapped1dField>("BeanWithSwapped1dField", (Type)((Object)BeanWithSwapped1dField.class), new BeanWithSwapped1dField("x"), "{f:[x1-json,x2-json,null]}", "{f:[x1-json,x2-json,null]}", "{\n\tf: [\n\t\tx1-json,\n\t\tx2-json,\n\t\tnull\n\t]\n}", "<object><f>x1-xmlx2-xml<null/></f></object>", "<object><f>x1-xmlx2-xml<null/></f></object>", "<object>\n\t<f>\n\t\tx1-xml\n\t\tx2-xml\n\t\t<null/>\n\t</f>\n</object>\n", "<object><f>x1-xmlx2-xml<null/></f></object>", "<table><tr><td>f</td><td><ul><li>x1-html</li><li>x2-html</li><li><null/></li></ul></td></tr></table>", "<table><tr><td>f</td><td><ul><li>x1-html</li><li>x2-html</li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>x1-html</li>\n\t\t\t\t<li>x2-html</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=@(x1-uon,x2-uon,null))", "(f=@(x1-uon,x2-uon,null))", "(\n\tf=@(\n\t\tx1-uon,\n\t\tx2-uon,\n\t\tnull\n\t)\n)", "f=@(x1-x-www-form-urlencoded,x2-x-www-form-urlencoded,null)", "f=@(x1-x-www-form-urlencoded,x2-x-www-form-urlencoded,null)", "f=@(\n\tx1-x-www-form-urlencoded,\n\tx2-x-www-form-urlencoded,\n\tnull\n)", "81A1669378312D6D73677061636B78322D6D73677061636BC0", "81A1669378312D6D73677061636B78322D6D73677061636BC0", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>x1-xml</rdf:li>\n<rdf:li>x2-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>x1-xml</rdf:li>\n<rdf:li>x2-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>\n      <rdf:Seq>\n        <rdf:li>x1-xml</rdf:li>\n        <rdf:li>x2-xml</rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithSwappedNullField>("BeanWithSwappedNullField", (Type)((Object)BeanWithSwappedNullField.class), new BeanWithSwappedNullField(), "{}", "{}", "{\n}", "<object/>", "<object/>", "<object/>\n", "<object/>", "<table></table>", "<table></table>", "<table>\n</table>\n", "()", "()", "(\n)", "", "", "", "80", "80", "<rdf:RDF>\n</rdf:RDF>\n", "<rdf:RDF>\n</rdf:RDF>\n", "<rdf:RDF>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithSwappedListField>("BeanWithSwappedListField", (Type)((Object)BeanWithSwappedListField.class), new BeanWithSwappedListField("x"), "{f:[x1-json,x2-json,null]}", "{f:[x1-json,x2-json,null]}", "{\n\tf: [\n\t\tx1-json,\n\t\tx2-json,\n\t\tnull\n\t]\n}", "<object><f>x1-xmlx2-xml<null/></f></object>", "<object><f>x1-xmlx2-xml<null/></f></object>", "<object>\n\t<f>\n\t\tx1-xml\n\t\tx2-xml\n\t\t<null/>\n\t</f>\n</object>\n", "<object><f>x1-xmlx2-xml<null/></f></object>", "<table><tr><td>f</td><td><ul><li>x1-html</li><li>x2-html</li><li><null/></li></ul></td></tr></table>", "<table><tr><td>f</td><td><ul><li>x1-html</li><li>x2-html</li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>x1-html</li>\n\t\t\t\t<li>x2-html</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=@(x1-uon,x2-uon,null))", "(f=@(x1-uon,x2-uon,null))", "(\n\tf=@(\n\t\tx1-uon,\n\t\tx2-uon,\n\t\tnull\n\t)\n)", "f=@(x1-x-www-form-urlencoded,x2-x-www-form-urlencoded,null)", "f=@(x1-x-www-form-urlencoded,x2-x-www-form-urlencoded,null)", "f=@(\n\tx1-x-www-form-urlencoded,\n\tx2-x-www-form-urlencoded,\n\tnull\n)", "81A1669378312D6D73677061636B78322D6D73677061636BC0", "81A1669378312D6D73677061636B78322D6D73677061636BC0", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>x1-xml</rdf:li>\n<rdf:li>x2-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>x1-xml</rdf:li>\n<rdf:li>x2-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>\n      <rdf:Seq>\n        <rdf:li>x1-xml</rdf:li>\n        <rdf:li>x2-xml</rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithSwappedMapField>("BeanWithSwappedMapField", (Type)((Object)BeanWithSwappedMapField.class), new BeanWithSwappedMapField("x"), "{f:{foo:x1-json,bar:null,null:x2-json}}", "{f:{foo:x1-json,bar:null,null:x2-json}}", "{\n\tf: {\n\t\tfoo: x1-json,\n\t\tbar: null,\n\t\tnull: x2-json\n\t}\n}", "<object><f><foo>x1-xml</foo><bar _type='null'/><_x0000_>x2-xml</_x0000_></f></object>", "<object><f><foo>x1-xml</foo><bar t='null'/><_x0000_>x2-xml</_x0000_></f></object>", "<object>\n\t<f>\n\t\t<foo>x1-xml</foo>\n\t\t<bar _type='null'/>\n\t\t<_x0000_>x2-xml</_x0000_>\n\t</f>\n</object>\n", "<object><f><foo>x1-xml</foo><bar _type='null'/><_x0000_>x2-xml</_x0000_></f></object>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td>x1-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x2-html</td></tr></table></td></tr></table>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td>x1-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x2-html</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t<td>x1-html</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t<td>x2-html</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=(foo=x1-uon,bar=null,null=x2-uon))", "(f=(foo=x1-uon,bar=null,null=x2-uon))", "(\n\tf=(\n\t\tfoo=x1-uon,\n\t\tbar=null,\n\t\tnull=x2-uon\n\t)\n)", "f=(foo=x1-x-www-form-urlencoded,bar=null,null=x2-x-www-form-urlencoded)", "f=(foo=x1-x-www-form-urlencoded,bar=null,null=x2-x-www-form-urlencoded)", "f=(\n\tfoo=x1-x-www-form-urlencoded,\n\tbar=null,\n\tnull=x2-x-www-form-urlencoded\n)", "81A16683A3666F6F78312D6D73677061636BA3626172C0C078322D6D73677061636B", "81A16683A3666F6F78312D6D73677061636BA3626172C0C078322D6D73677061636B", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo>x1-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x2-xml</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo>x1-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x2-xml</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f rdf:parseType='Resource'>\n      <jp:foo>x1-xml</jp:foo>\n      <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      <jp:_x0000_>x2-xml</jp:_x0000_>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithListBeanSwappedField>("BeanWithListBeanSwappedField", (Type)((Object)BeanWithListBeanSwappedField.class), new BeanWithListBeanSwappedField("x"), "{f:[{f1:x1a-json,f2:[x2a-json,x2b-json,null],f4:[x4a-json,x4b-json,null],f5:{foo:x5a-json,bar:null,null:x5c-json}},null]}", "{f:[{f1:x1a-json,f2:[x2a-json,x2b-json,null],f4:[x4a-json,x4b-json,null],f5:{foo:x5a-json,bar:null,null:x5c-json}},null]}", "{\n\tf: [\n\t\t{\n\t\t\tf1: x1a-json,\n\t\t\tf2: [\n\t\t\t\tx2a-json,\n\t\t\t\tx2b-json,\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf4: [\n\t\t\t\tx4a-json,\n\t\t\t\tx4b-json,\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf5: {\n\t\t\t\tfoo: x5a-json,\n\t\t\t\tbar: null,\n\t\t\t\tnull: x5c-json\n\t\t\t}\n\t\t},\n\t\tnull\n\t]\n}", "<object><f><object><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar _type='null'/><_x0000_>x5c-xml</_x0000_></f5></object><null/></f></object>", "<object><f><object><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar t='null'/><_x0000_>x5c-xml</_x0000_></f5></object><null/></f></object>", "<object>\n\t<f>\n\t\t<object>\n\t\t\t<f1>x1a-xml</f1>\n\t\t\t<f2>\n\t\t\t\tx2a-xml\n\t\t\t\tx2b-xml\n\t\t\t\t<null/>\n\t\t\t</f2>\n\t\t\t<f4>\n\t\t\t\tx4a-xml\n\t\t\t\tx4b-xml\n\t\t\t\t<null/>\n\t\t\t</f4>\n\t\t\t<f5>\n\t\t\t\t<foo>x5a-xml</foo>\n\t\t\t\t<bar _type='null'/>\n\t\t\t\t<_x0000_>x5c-xml</_x0000_>\n\t\t\t</f5>\n\t\t</object>\n\t\t<null/>\n\t</f>\n</object>\n", "<object><f><object><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar _type='null'/><_x0000_>x5c-xml</_x0000_></f5></object><null/></f></object>", "<table><tr><td>f</td><td><table _type='array'><tr><th>f1</th><th>f2</th><th>f4</th><th>f5</th></tr><tr><td>x1a-html</td><td><ul><li>x2a-html</li><li>x2b-html</li><li><null/></li></ul></td><td><ul><li>x4a-html</li><li>x4b-html</li><li><null/></li></ul></td><td><table><tr><td>foo</td><td>x5a-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x5c-html</td></tr></table></td></tr><tr><null/></tr></table></td></tr></table>", "<table><tr><td>f</td><td><table t='array'><tr><th>f1</th><th>f2</th><th>f4</th><th>f5</th></tr><tr><td>x1a-html</td><td><ul><li>x2a-html</li><li>x2b-html</li><li><null/></li></ul></td><td><ul><li>x4a-html</li><li>x4b-html</li><li><null/></li></ul></td><td><table><tr><td>foo</td><td>x5a-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x5c-html</td></tr></table></td></tr><tr><null/></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>f1</th>\n\t\t\t\t\t<th>f2</th>\n\t\t\t\t\t<th>f4</th>\n\t\t\t\t\t<th>f5</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>x1a-html</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t<li>x2a-html</li>\n\t\t\t\t\t\t\t<li>x2b-html</li>\n\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t</ul>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t<li>x4a-html</li>\n\t\t\t\t\t\t\t<li>x4b-html</li>\n\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t</ul>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t\t<td>x5a-html</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t<td>x5c-html</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<null/>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=@((f1=x1a-uon,f2=@(x2a-uon,x2b-uon,null),f4=@(x4a-uon,x4b-uon,null),f5=(foo=x5a-uon,bar=null,null=x5c-uon)),null))", "(f=@((f1=x1a-uon,f2=@(x2a-uon,x2b-uon,null),f4=@(x4a-uon,x4b-uon,null),f5=(foo=x5a-uon,bar=null,null=x5c-uon)),null))", "(\n\tf=@(\n\t\t(\n\t\t\tf1=x1a-uon,\n\t\t\tf2=@(\n\t\t\t\tx2a-uon,\n\t\t\t\tx2b-uon,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf4=@(\n\t\t\t\tx4a-uon,\n\t\t\t\tx4b-uon,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf5=(\n\t\t\t\tfoo=x5a-uon,\n\t\t\t\tbar=null,\n\t\t\t\tnull=x5c-uon\n\t\t\t)\n\t\t),\n\t\tnull\n\t)\n)", "f=@((f1=x1a-x-www-form-urlencoded,f2=@(x2a-x-www-form-urlencoded,x2b-x-www-form-urlencoded,null),f4=@(x4a-x-www-form-urlencoded,x4b-x-www-form-urlencoded,null),f5=(foo=x5a-x-www-form-urlencoded,bar=null,null=x5c-x-www-form-urlencoded)),null)", "f=@((f1=x1a-x-www-form-urlencoded,f2=@(x2a-x-www-form-urlencoded,x2b-x-www-form-urlencoded,null),f4=@(x4a-x-www-form-urlencoded,x4b-x-www-form-urlencoded,null),f5=(foo=x5a-x-www-form-urlencoded,bar=null,null=x5c-x-www-form-urlencoded)),null)", "f=@(\n\t(\n\t\tf1=x1a-x-www-form-urlencoded,\n\t\tf2=@(\n\t\t\tx2a-x-www-form-urlencoded,\n\t\t\tx2b-x-www-form-urlencoded,\n\t\t\tnull\n\t\t),\n\t\tf4=@(\n\t\t\tx4a-x-www-form-urlencoded,\n\t\t\tx4b-x-www-form-urlencoded,\n\t\t\tnull\n\t\t),\n\t\tf5=(\n\t\t\tfoo=x5a-x-www-form-urlencoded,\n\t\t\tbar=null,\n\t\t\tnull=x5c-x-www-form-urlencoded\n\t\t)\n\t),\n\tnull\n)", "81A1669284A266317831612D6D73677061636BA26632937832612D6D73677061636B7832622D6D73677061636BC0A26634937834612D6D73677061636B7834622D6D73677061636BC0A2663583A3666F6F7835612D6D73677061636BA3626172C0C07835632D6D73677061636BC0", "81A1669284A266317831612D6D73677061636BA26632937832612D6D73677061636B7832622D6D73677061636BC0A26634937834612D6D73677061636B7834622D6D73677061636BC0A2663583A3666F6F7835612D6D73677061636BA3626172C0C07835632D6D73677061636BC0", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:f1>x1a-xml</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>x2a-xml</rdf:li>\n<rdf:li>x2b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>x4a-xml</rdf:li>\n<rdf:li>x4b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>x5a-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x5c-xml</jp:_x0000_>\n</jp:f5>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:f1>x1a-xml</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>x2a-xml</rdf:li>\n<rdf:li>x2b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>x4a-xml</rdf:li>\n<rdf:li>x4b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>x5a-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x5c-xml</jp:_x0000_>\n</jp:f5>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>\n      <rdf:Seq>\n        <rdf:li rdf:parseType='Resource'>\n          <jp:f1>x1a-xml</jp:f1>\n          <jp:f2>\n            <rdf:Seq>\n              <rdf:li>x2a-xml</rdf:li>\n              <rdf:li>x2b-xml</rdf:li>\n              <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n            </rdf:Seq>\n          </jp:f2>\n          <jp:f4>\n            <rdf:Seq>\n              <rdf:li>x4a-xml</rdf:li>\n              <rdf:li>x4b-xml</rdf:li>\n              <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n            </rdf:Seq>\n          </jp:f4>\n          <jp:f5 rdf:parseType='Resource'>\n            <jp:foo>x5a-xml</jp:foo>\n            <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n            <jp:_x0000_>x5c-xml</jp:_x0000_>\n          </jp:f5>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")}, {new ComboInput<BeanWithMapBeanSwappedField>("BeanWithMapBeanSwappedField", (Type)((Object)BeanWithMapBeanSwappedField.class), new BeanWithMapBeanSwappedField("x"), "{f:{foo:{f1:x1a-json,f2:[x2a-json,x2b-json,null],f4:[x4a-json,x4b-json,null],f5:{foo:x5a-json,bar:null,null:x5c-json}},bar:null,null:{f1:x1a-json,f2:[x2a-json,x2b-json,null],f4:[x4a-json,x4b-json,null],f5:{foo:x5a-json,bar:null,null:x5c-json}}}}", "{f:{foo:{f1:x1a-json,f2:[x2a-json,x2b-json,null],f4:[x4a-json,x4b-json,null],f5:{foo:x5a-json,bar:null,null:x5c-json}},bar:null,null:{f1:x1a-json,f2:[x2a-json,x2b-json,null],f4:[x4a-json,x4b-json,null],f5:{foo:x5a-json,bar:null,null:x5c-json}}}}", "{\n\tf: {\n\t\tfoo: {\n\t\t\tf1: x1a-json,\n\t\t\tf2: [\n\t\t\t\tx2a-json,\n\t\t\t\tx2b-json,\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf4: [\n\t\t\t\tx4a-json,\n\t\t\t\tx4b-json,\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf5: {\n\t\t\t\tfoo: x5a-json,\n\t\t\t\tbar: null,\n\t\t\t\tnull: x5c-json\n\t\t\t}\n\t\t},\n\t\tbar: null,\n\t\tnull: {\n\t\t\tf1: x1a-json,\n\t\t\tf2: [\n\t\t\t\tx2a-json,\n\t\t\t\tx2b-json,\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf4: [\n\t\t\t\tx4a-json,\n\t\t\t\tx4b-json,\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf5: {\n\t\t\t\tfoo: x5a-json,\n\t\t\t\tbar: null,\n\t\t\t\tnull: x5c-json\n\t\t\t}\n\t\t}\n\t}\n}", "<object><f><foo><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar _type='null'/><_x0000_>x5c-xml</_x0000_></f5></foo><bar _type='null'/><_x0000_><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar _type='null'/><_x0000_>x5c-xml</_x0000_></f5></_x0000_></f></object>", "<object><f><foo><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar t='null'/><_x0000_>x5c-xml</_x0000_></f5></foo><bar t='null'/><_x0000_><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar t='null'/><_x0000_>x5c-xml</_x0000_></f5></_x0000_></f></object>", "<object>\n\t<f>\n\t\t<foo>\n\t\t\t<f1>x1a-xml</f1>\n\t\t\t<f2>\n\t\t\t\tx2a-xml\n\t\t\t\tx2b-xml\n\t\t\t\t<null/>\n\t\t\t</f2>\n\t\t\t<f4>\n\t\t\t\tx4a-xml\n\t\t\t\tx4b-xml\n\t\t\t\t<null/>\n\t\t\t</f4>\n\t\t\t<f5>\n\t\t\t\t<foo>x5a-xml</foo>\n\t\t\t\t<bar _type='null'/>\n\t\t\t\t<_x0000_>x5c-xml</_x0000_>\n\t\t\t</f5>\n\t\t</foo>\n\t\t<bar _type='null'/>\n\t\t<_x0000_>\n\t\t\t<f1>x1a-xml</f1>\n\t\t\t<f2>\n\t\t\t\tx2a-xml\n\t\t\t\tx2b-xml\n\t\t\t\t<null/>\n\t\t\t</f2>\n\t\t\t<f4>\n\t\t\t\tx4a-xml\n\t\t\t\tx4b-xml\n\t\t\t\t<null/>\n\t\t\t</f4>\n\t\t\t<f5>\n\t\t\t\t<foo>x5a-xml</foo>\n\t\t\t\t<bar _type='null'/>\n\t\t\t\t<_x0000_>x5c-xml</_x0000_>\n\t\t\t</f5>\n\t\t</_x0000_>\n\t</f>\n</object>\n", "<object><f><foo><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar _type='null'/><_x0000_>x5c-xml</_x0000_></f5></foo><bar _type='null'/><_x0000_><f1>x1a-xml</f1><f2>x2a-xmlx2b-xml<null/></f2><f4>x4a-xmlx4b-xml<null/></f4><f5><foo>x5a-xml</foo><bar _type='null'/><_x0000_>x5c-xml</_x0000_></f5></_x0000_></f></object>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td><table><tr><td>f1</td><td>x1a-html</td></tr><tr><td>f2</td><td><ul><li>x2a-html</li><li>x2b-html</li><li><null/></li></ul></td></tr><tr><td>f4</td><td><ul><li>x4a-html</li><li>x4b-html</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>x5a-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x5c-html</td></tr></table></td></tr></table></td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td><table><tr><td>f1</td><td>x1a-html</td></tr><tr><td>f2</td><td><ul><li>x2a-html</li><li>x2b-html</li><li><null/></li></ul></td></tr><tr><td>f4</td><td><ul><li>x4a-html</li><li>x4b-html</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>x5a-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x5c-html</td></tr></table></td></tr></table></td></tr></table></td></tr></table>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td><table><tr><td>f1</td><td>x1a-html</td></tr><tr><td>f2</td><td><ul><li>x2a-html</li><li>x2b-html</li><li><null/></li></ul></td></tr><tr><td>f4</td><td><ul><li>x4a-html</li><li>x4b-html</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>x5a-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x5c-html</td></tr></table></td></tr></table></td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td><table><tr><td>f1</td><td>x1a-html</td></tr><tr><td>f2</td><td><ul><li>x2a-html</li><li>x2b-html</li><li><null/></li></ul></td></tr><tr><td>f4</td><td><ul><li>x4a-html</li><li>x4b-html</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>x5a-html</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>x5c-html</td></tr></table></td></tr></table></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f1</td>\n\t\t\t\t\t\t\t\t<td>x1a-html</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f2</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>x2a-html</li>\n\t\t\t\t\t\t\t\t\t\t<li>x2b-html</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f4</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>x4a-html</li>\n\t\t\t\t\t\t\t\t\t\t<li>x4b-html</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f5</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>x5a-html</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t\t<td>x5c-html</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f1</td>\n\t\t\t\t\t\t\t\t<td>x1a-html</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f2</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>x2a-html</li>\n\t\t\t\t\t\t\t\t\t\t<li>x2b-html</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f4</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>x4a-html</li>\n\t\t\t\t\t\t\t\t\t\t<li>x4b-html</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f5</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>x5a-html</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t\t<td>x5c-html</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=(foo=(f1=x1a-uon,f2=@(x2a-uon,x2b-uon,null),f4=@(x4a-uon,x4b-uon,null),f5=(foo=x5a-uon,bar=null,null=x5c-uon)),bar=null,null=(f1=x1a-uon,f2=@(x2a-uon,x2b-uon,null),f4=@(x4a-uon,x4b-uon,null),f5=(foo=x5a-uon,bar=null,null=x5c-uon))))", "(f=(foo=(f1=x1a-uon,f2=@(x2a-uon,x2b-uon,null),f4=@(x4a-uon,x4b-uon,null),f5=(foo=x5a-uon,bar=null,null=x5c-uon)),bar=null,null=(f1=x1a-uon,f2=@(x2a-uon,x2b-uon,null),f4=@(x4a-uon,x4b-uon,null),f5=(foo=x5a-uon,bar=null,null=x5c-uon))))", "(\n\tf=(\n\t\tfoo=(\n\t\t\tf1=x1a-uon,\n\t\t\tf2=@(\n\t\t\t\tx2a-uon,\n\t\t\t\tx2b-uon,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf4=@(\n\t\t\t\tx4a-uon,\n\t\t\t\tx4b-uon,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf5=(\n\t\t\t\tfoo=x5a-uon,\n\t\t\t\tbar=null,\n\t\t\t\tnull=x5c-uon\n\t\t\t)\n\t\t),\n\t\tbar=null,\n\t\tnull=(\n\t\t\tf1=x1a-uon,\n\t\t\tf2=@(\n\t\t\t\tx2a-uon,\n\t\t\t\tx2b-uon,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf4=@(\n\t\t\t\tx4a-uon,\n\t\t\t\tx4b-uon,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf5=(\n\t\t\t\tfoo=x5a-uon,\n\t\t\t\tbar=null,\n\t\t\t\tnull=x5c-uon\n\t\t\t)\n\t\t)\n\t)\n)", "f=(foo=(f1=x1a-x-www-form-urlencoded,f2=@(x2a-x-www-form-urlencoded,x2b-x-www-form-urlencoded,null),f4=@(x4a-x-www-form-urlencoded,x4b-x-www-form-urlencoded,null),f5=(foo=x5a-x-www-form-urlencoded,bar=null,null=x5c-x-www-form-urlencoded)),bar=null,null=(f1=x1a-x-www-form-urlencoded,f2=@(x2a-x-www-form-urlencoded,x2b-x-www-form-urlencoded,null),f4=@(x4a-x-www-form-urlencoded,x4b-x-www-form-urlencoded,null),f5=(foo=x5a-x-www-form-urlencoded,bar=null,null=x5c-x-www-form-urlencoded)))", "f=(foo=(f1=x1a-x-www-form-urlencoded,f2=@(x2a-x-www-form-urlencoded,x2b-x-www-form-urlencoded,null),f4=@(x4a-x-www-form-urlencoded,x4b-x-www-form-urlencoded,null),f5=(foo=x5a-x-www-form-urlencoded,bar=null,null=x5c-x-www-form-urlencoded)),bar=null,null=(f1=x1a-x-www-form-urlencoded,f2=@(x2a-x-www-form-urlencoded,x2b-x-www-form-urlencoded,null),f4=@(x4a-x-www-form-urlencoded,x4b-x-www-form-urlencoded,null),f5=(foo=x5a-x-www-form-urlencoded,bar=null,null=x5c-x-www-form-urlencoded)))", "f=(\n\tfoo=(\n\t\tf1=x1a-x-www-form-urlencoded,\n\t\tf2=@(\n\t\t\tx2a-x-www-form-urlencoded,\n\t\t\tx2b-x-www-form-urlencoded,\n\t\t\tnull\n\t\t),\n\t\tf4=@(\n\t\t\tx4a-x-www-form-urlencoded,\n\t\t\tx4b-x-www-form-urlencoded,\n\t\t\tnull\n\t\t),\n\t\tf5=(\n\t\t\tfoo=x5a-x-www-form-urlencoded,\n\t\t\tbar=null,\n\t\t\tnull=x5c-x-www-form-urlencoded\n\t\t)\n\t),\n\tbar=null,\n\tnull=(\n\t\tf1=x1a-x-www-form-urlencoded,\n\t\tf2=@(\n\t\t\tx2a-x-www-form-urlencoded,\n\t\t\tx2b-x-www-form-urlencoded,\n\t\t\tnull\n\t\t),\n\t\tf4=@(\n\t\t\tx4a-x-www-form-urlencoded,\n\t\t\tx4b-x-www-form-urlencoded,\n\t\t\tnull\n\t\t),\n\t\tf5=(\n\t\t\tfoo=x5a-x-www-form-urlencoded,\n\t\t\tbar=null,\n\t\t\tnull=x5c-x-www-form-urlencoded\n\t\t)\n\t)\n)", "81A16683A3666F6F84A266317831612D6D73677061636BA26632937832612D6D73677061636B7832622D6D73677061636BC0A26634937834612D6D73677061636B7834622D6D73677061636BC0A2663583A3666F6F7835612D6D73677061636BA3626172C0C07835632D6D73677061636BA3626172C0C084A266317831612D6D73677061636BA26632937832612D6D73677061636B7832622D6D73677061636BC0A26634937834612D6D73677061636B7834622D6D73677061636BC0A2663583A3666F6F7835612D6D73677061636BA3626172C0C07835632D6D73677061636B", "81A16683A3666F6F84A266317831612D6D73677061636BA26632937832612D6D73677061636B7832622D6D73677061636BC0A26634937834612D6D73677061636B7834622D6D73677061636BC0A2663583A3666F6F7835612D6D73677061636BA3626172C0C07835632D6D73677061636BA3626172C0C084A266317831612D6D73677061636BA26632937832612D6D73677061636B7832622D6D73677061636BC0A26634937834612D6D73677061636B7834622D6D73677061636BC0A2663583A3666F6F7835612D6D73677061636BA3626172C0C07835632D6D73677061636B", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo rdf:parseType='Resource'>\n<jp:f1>x1a-xml</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>x2a-xml</rdf:li>\n<rdf:li>x2b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>x4a-xml</rdf:li>\n<rdf:li>x4b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>x5a-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x5c-xml</jp:_x0000_>\n</jp:f5>\n</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_ rdf:parseType='Resource'>\n<jp:f1>x1a-xml</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>x2a-xml</rdf:li>\n<rdf:li>x2b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>x4a-xml</rdf:li>\n<rdf:li>x4b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>x5a-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x5c-xml</jp:_x0000_>\n</jp:f5>\n</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo rdf:parseType='Resource'>\n<jp:f1>x1a-xml</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>x2a-xml</rdf:li>\n<rdf:li>x2b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>x4a-xml</rdf:li>\n<rdf:li>x4b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>x5a-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x5c-xml</jp:_x0000_>\n</jp:f5>\n</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_ rdf:parseType='Resource'>\n<jp:f1>x1a-xml</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>x2a-xml</rdf:li>\n<rdf:li>x2b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>x4a-xml</rdf:li>\n<rdf:li>x4b-xml</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>x5a-xml</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>x5c-xml</jp:_x0000_>\n</jp:f5>\n</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f rdf:parseType='Resource'>\n      <jp:foo rdf:parseType='Resource'>\n        <jp:f1>x1a-xml</jp:f1>\n        <jp:f2>\n          <rdf:Seq>\n            <rdf:li>x2a-xml</rdf:li>\n            <rdf:li>x2b-xml</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f2>\n        <jp:f4>\n          <rdf:Seq>\n            <rdf:li>x4a-xml</rdf:li>\n            <rdf:li>x4b-xml</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f4>\n        <jp:f5 rdf:parseType='Resource'>\n          <jp:foo>x5a-xml</jp:foo>\n          <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          <jp:_x0000_>x5c-xml</jp:_x0000_>\n        </jp:f5>\n      </jp:foo>\n      <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      <jp:_x0000_ rdf:parseType='Resource'>\n        <jp:f1>x1a-xml</jp:f1>\n        <jp:f2>\n          <rdf:Seq>\n            <rdf:li>x2a-xml</rdf:li>\n            <rdf:li>x2b-xml</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f2>\n        <jp:f4>\n          <rdf:Seq>\n            <rdf:li>x4a-xml</rdf:li>\n            <rdf:li>x4b-xml</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f4>\n        <jp:f5 rdf:parseType='Resource'>\n          <jp:foo>x5a-xml</jp:foo>\n          <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          <jp:_x0000_>x5c-xml</jp:_x0000_>\n        </jp:f5>\n      </jp:_x0000_>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n")});
    }

    public ReaderObjectSwapTest(ComboInput<?> comboInput) {
        super(comboInput);
    }

    @Override
    protected Serializer applySettings(Serializer s) throws Exception {
        return s;
    }

    public static class B {
        public PojoToDynamicReader f1;
        public PojoToDynamicReader[] f2;
        public PojoToDynamicReader f3;
        public List<PojoToDynamicReader> f4;
        public Map<String, PojoToDynamicReader> f5;

        public B(String f) {
            this.f1 = new PojoToDynamicReader(f + "1a");
            this.f2 = new PojoToDynamicReader[]{new PojoToDynamicReader(f + "2a"), new PojoToDynamicReader(f + "2b"), null};
            this.f3 = null;
            this.f4 = new AList().append((Object)new PojoToDynamicReader(f + "4a")).append((Object)new PojoToDynamicReader(f + "4b")).append(null);
            this.f5 = new AMap().append((Object)"foo", (Object)new PojoToDynamicReader(f + "5a")).append((Object)"bar", null).append(null, (Object)new PojoToDynamicReader(f + "5c"));
        }
    }

    public static class BeanWithMapBeanSwappedField {
        public Map<String, B> f;

        public BeanWithMapBeanSwappedField(String f) {
            this.f = new AMap().append((Object)"foo", (Object)new B(f)).append((Object)"bar", null).append(null, (Object)new B(f));
        }
    }

    public static class BeanWithListBeanSwappedField {
        public List<B> f;

        public BeanWithListBeanSwappedField(String f) {
            this.f = new AList().append((Object)new B(f)).append(null);
        }
    }

    public static class BeanWithSwappedMapField {
        public Map<String, PojoToDynamicReader> f;

        public BeanWithSwappedMapField(String f) {
            this.f = new AMap().append((Object)"foo", (Object)new PojoToDynamicReader(f + "1")).append((Object)"bar", null).append(null, (Object)new PojoToDynamicReader(f + "2"));
        }
    }

    public static class BeanWithSwappedListField {
        public List<PojoToDynamicReader> f;

        public BeanWithSwappedListField(String f) {
            this.f = new AList().append((Object)new PojoToDynamicReader(f + "1")).append((Object)new PojoToDynamicReader(f + "2")).append(null);
        }
    }

    public static class BeanWithSwappedNullField {
        public PojoToDynamicReader f;
    }

    public static class BeanWithSwapped1dField {
        public PojoToDynamicReader[] f;

        public BeanWithSwapped1dField(String f) {
            this.f = new PojoToDynamicReader[]{new PojoToDynamicReader(f + "1"), new PojoToDynamicReader(f + 2), null};
        }
    }

    public static class BeanWithSwappedField {
        public PojoToDynamicReader f;

        public BeanWithSwappedField(String f) {
            this.f = new PojoToDynamicReader(f);
        }
    }

    public static class SometimesSwappedBeanSwap2
    extends PojoSwap<SometimesSwappedBean2, Object> {
        public Object swap(BeanSession session, SometimesSwappedBean2 o) throws Exception {
            MediaType mt = session.getMediaType();
            if (mt.hasSubType("json") || mt.hasSubType("xml")) {
                return o;
            }
            return new StringReader(o.f + "-" + mt);
        }
    }

    @Swap(value=SometimesSwappedBeanSwap2.class)
    public static class SometimesSwappedBean2 {
        public String f;

        public SometimesSwappedBean2(String f) {
            this.f = f;
        }
    }

    public static class SometimesSwappedBeanSwap1
    extends PojoSwap<SometimesSwappedBean1, Object> {
        public Object swap(BeanSession session, SometimesSwappedBean1 o) throws Exception {
            MediaType mt = session.getMediaType();
            if (mt.hasSubType("json") || mt.hasSubType("xml")) {
                return new StringReader(o.f + "-" + mt);
            }
            return o;
        }
    }

    @Swap(value=SometimesSwappedBeanSwap1.class)
    public static class SometimesSwappedBean1 {
        public String f;

        public SometimesSwappedBean1(String f) {
            this.f = f;
        }
    }

    public static class PojoToDynamicReaderSwap
    extends PojoSwap<PojoToDynamicReader, Object> {
        public Object swap(BeanSession session, PojoToDynamicReader o) throws Exception {
            return new StringReader(o.f + "-" + (String)session.getMediaType().getSubTypes().get(0));
        }
    }

    @Swap(value=PojoToDynamicReaderSwap.class)
    public static class PojoToDynamicReader {
        private String f;

        public PojoToDynamicReader(String f) {
            this.f = f;
        }
    }

    public static class PojoToSimpleReaderSwap
    extends PojoSwap<PojoToSimpleReader, Reader> {
        public Reader swap(BeanSession session, PojoToSimpleReader o) throws Exception {
            return new StringReader("foo");
        }
    }

    @Swap(value=PojoToSimpleReaderSwap.class)
    public static class PojoToSimpleReader {
    }
}

