/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.io.StringReader;
import java.util.HashMap;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.transforms.ParsedReaderSwap;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;

public class ReaderFilterTest {
    @Test
    public void testJson() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().pojoSwaps(new Class[]{ParsedReaderSwap.Json.class}).build();
        StringReader r = new StringReader("{foo:'bar',baz:'quz'}");
        HashMap<String, StringReader> m = new HashMap<String, StringReader>();
        m.put("X", r);
        Assert.assertEquals((Object)"{X:{foo:'bar',baz:'quz'}}", (Object)s.serialize(m));
    }

    @Test
    public void testXml() throws Exception {
        XmlSerializer s = XmlSerializer.create().sq().pojoSwaps(new Class[]{ParsedReaderSwap.Xml.class}).build();
        StringReader r = new StringReader("<object><foo _type='string'>bar</foo><baz _type='string'>quz</baz></object>");
        HashMap<String, StringReader> m = new HashMap<String, StringReader>();
        m.put("X", r);
        Assert.assertEquals((Object)"<object><X _type='object'><foo>bar</foo><baz>quz</baz></X></object>", (Object)s.serialize(m));
    }

    @Test
    public void testHtml() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().pojoSwaps(new Class[]{ParsedReaderSwap.Html.class}).build();
        StringReader r = new StringReader("<table><tr><td>foo</td><td>bar</td></tr><tr><td>baz</td><td>quz</td></tr></table>");
        HashMap<String, StringReader> m = new HashMap<String, StringReader>();
        m.put("X", r);
        Assert.assertEquals((Object)"<table><tr><td>X</td><td><table><tr><td>foo</td><td>bar</td></tr><tr><td>baz</td><td>quz</td></tr></table></td></tr></table>", (Object)s.serialize(m));
    }

    @Test
    public void testPlainText() throws Exception {
        PlainTextSerializer s = PlainTextSerializer.create().pojoSwaps(new Class[]{ParsedReaderSwap.PlainText.class}).build();
        StringReader r = new StringReader("{foo:'bar',baz:'quz'}");
        HashMap<String, StringReader> m = new HashMap<String, StringReader>();
        m.put("X", r);
        Assert.assertEquals((Object)"{X:'{foo:\\'bar\\',baz:\\'quz\\'}'}", (Object)s.serialize(m));
    }

    @Test
    public void testUon() throws Exception {
        UonSerializer s = UonSerializer.create().pojoSwaps(new Class[]{ParsedReaderSwap.Uon.class}).build();
        StringReader r = new StringReader("(foo=bar,baz=quz)");
        HashMap<String, StringReader> m = new HashMap<String, StringReader>();
        m.put("X", r);
        Assert.assertEquals((Object)"(X=(foo=bar,baz=quz))", (Object)s.serialize(m));
    }

    @Test
    public void testUrlEncoding() throws Exception {
        UrlEncodingSerializer s = UrlEncodingSerializer.create().pojoSwaps(new Class[]{ParsedReaderSwap.PlainText.class}).build();
        StringReader r = new StringReader("foo=bar&baz=quz");
        HashMap<String, StringReader> m = new HashMap<String, StringReader>();
        m.put("X", r);
        Assert.assertEquals((Object)"X='foo=bar%26baz=quz'", (Object)s.serialize(m));
    }
}

