/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import org.apache.juneau.BeanSession;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;

public class PojoSwapTest {
    @Test
    public void doTest() throws Exception {
        SerializerGroup g = SerializerGroup.create().append(new Class[]{JsonSerializer.class, XmlSerializer.class, HtmlSerializer.class}).sq().pojoSwaps(new Class[]{MyJsonSwap.class, MyXmlSwap.class, MyOtherSwap.class}).build();
        MyPojo myPojo = new MyPojo();
        String json = g.getWriterSerializer("text/json").serialize((Object)myPojo);
        Assert.assertEquals((Object)"'It\\'s JSON!'", (Object)json);
        String xml = g.getWriterSerializer("text/xml").serialize((Object)myPojo);
        Assert.assertEquals((Object)"<string>It's XML!</string>", (Object)xml);
        String html = g.getWriterSerializer("text/html").serialize((Object)myPojo);
        Assert.assertEquals((Object)"<string>It's something else!</string>", (Object)html);
    }

    public static class MyOtherSwap
    extends PojoSwap<MyPojo, String> {
        public MediaType[] forMediaTypes() {
            return MediaType.forStrings((String[])new String[]{"*/*"});
        }

        public String swap(BeanSession session, MyPojo o) throws Exception {
            return "It's something else!";
        }
    }

    public static class MyXmlSwap
    extends PojoSwap<MyPojo, String> {
        public MediaType[] forMediaTypes() {
            return MediaType.forStrings((String[])new String[]{"*/xml"});
        }

        public String swap(BeanSession session, MyPojo o) throws Exception {
            return "It's XML!";
        }
    }

    public static class MyJsonSwap
    extends PojoSwap<MyPojo, String> {
        public MediaType[] forMediaTypes() {
            return MediaType.forStrings((String[])new String[]{"*/json"});
        }

        public String swap(BeanSession session, MyPojo o) throws Exception {
            return "It's JSON!";
        }
    }

    public static class MyPojo {
    }
}

