/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.BeanSession;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transform.StringSwap;
import org.apache.juneau.utils.AList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class DefaultSwapsTest {
    private static final WriterSerializer SERIALIZER = SimpleJsonSerializer.DEFAULT;
    private static Vector<String> A = new Vector();
    private static Vector<String> Ac;
    private static List<String> B;
    private static List<String> Bc;
    private static Locale C;
    private static GregorianCalendar D;
    private static Date E;
    private static Instant FA;
    private static ZonedDateTime FB;
    private static LocalDate FC;
    private static LocalDateTime FD;
    private static LocalTime FE;
    private static OffsetDateTime FF;
    private static OffsetTime FG;
    private static Year FH;
    private static YearMonth FI;
    private static Temporal FJ;
    private static TimeZone G;
    private static XMLGregorianCalendar H;
    private static ZoneId I;

    @BeforeClass
    public static void beforeClass() {
        TestUtils.setTimeZone("GMT-5");
    }

    @AfterClass
    public static void afterClass() {
        TestUtils.unsetTimeZone();
    }

    private void test(String expected, Object o) throws Exception {
        Assert.assertEquals((Object)expected, (Object)SERIALIZER.serialize(o));
    }

    private void test(String expected, Object o, Class<?> configClass) throws Exception {
        Assert.assertEquals((Object)expected, (Object)SERIALIZER.builder().applyAnnotations(new Class[]{configClass}).build().serialize(o));
    }

    private void test(String expected, Object o, PojoSwap<?, ?> swap) throws Exception {
        Assert.assertEquals((Object)expected, (Object)SERIALIZER.builder().pojoSwaps(new Object[]{swap}).build().serializeToString(o));
    }

    private void test(String expected, Object o, PojoSwap<?, ?> swap, Class<?> configClass) throws Exception {
        Assert.assertEquals((Object)expected, (Object)SERIALIZER.builder().pojoSwaps(new Object[]{swap}).applyAnnotations(new Class[]{configClass}).build().serializeToString(o));
    }

    @Test
    public void a01_Enumeration() throws Exception {
        this.test("['foo','bar']", A.elements());
    }

    @Test
    public void a02_Enumeration_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)A.elements(), (PojoSwap<?, ?>)new ASwap());
    }

    @Test
    public void a03_Enumeration_overrideAnnotation() throws Exception {
        this.test("{f1:['foo','bar'],f2:'FOO'}", new ABean());
    }

    @Test
    public void a01c_Enumeration_usingConfig() throws Exception {
        this.test("['foo','bar']", Ac.elements(), AcBean.class);
    }

    @Test
    public void a02c_Enumeration_overrideSwap_usingConfig() throws Exception {
        this.test("'FOO'", Ac.elements(), (PojoSwap<?, ?>)new AcSwap(), AcBean.class);
    }

    @Test
    public void a03c_Enumeration_overrideAnnotation_usingConfig() throws Exception {
        this.test("{f1:['foo','bar'],f2:'FOO'}", (Object)new AcBean(), AcBean.class);
    }

    @Test
    public void b01_Iterator() throws Exception {
        this.test("['foo','bar']", B.iterator());
    }

    @Test
    public void b02_Iterator_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)B.iterator(), (PojoSwap<?, ?>)new BSwap());
    }

    @Test
    public void b03_Iterator_overrideAnnotation() throws Exception {
        this.test("{f1:['foo','bar'],f2:'FOO'}", new BBean());
    }

    @Test
    public void b01c_Iterator_usingConfig() throws Exception {
        this.test("['foo','bar']", Bc.iterator(), BcBean.class);
    }

    @Test
    public void b02c_Iterator_overrideSwap_usingConfig() throws Exception {
        this.test("'FOO'", Bc.iterator(), (PojoSwap<?, ?>)new BcSwap(), BcBean.class);
    }

    @Test
    public void b03c_Iterator_overrideAnnotation_usingConfig() throws Exception {
        this.test("{f1:['foo','bar'],f2:'FOO'}", (Object)new BcBean(), BcBean.class);
    }

    @Test
    public void c01_Locale() throws Exception {
        this.test("'ja-JP'", C);
    }

    @Test
    public void c02_Locale_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)C, (PojoSwap<?, ?>)new CSwap());
    }

    @Test
    public void c03_Locale_overrideAnnotation() throws Exception {
        this.test("{f1:'ja-JP',f2:'FOO'}", new CBean());
    }

    @Test
    public void d01_Calendar() throws Exception {
        this.test("'2012-12-21T12:34:56Z'", D);
    }

    @Test
    public void d02_Calendar_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)D, (PojoSwap<?, ?>)new DSwap());
    }

    @Test
    public void d03_Calendar_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T12:34:56Z',f2:'FOO'}", new DBean());
    }

    @Test
    public void e01_Date() throws Exception {
        this.test("'2012-12-21T07:34:56'", E);
    }

    @Test
    public void e02_Date_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)E, (PojoSwap<?, ?>)new ESwap());
    }

    @Test
    public void e03_Date_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T07:34:56',f2:'FOO'}", new EBean());
    }

    @Test
    public void fa01_Instant() throws Exception {
        this.test("'2012-12-21T12:34:56Z'", FA);
    }

    @Test
    public void fa02_Instant_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FA, (PojoSwap<?, ?>)new FASwap());
    }

    @Test
    public void fa03_Instant_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T12:34:56Z',f2:'FOO'}", new FABean());
    }

    @Test
    public void fb01_ZonedDateTime() throws Exception {
        this.test("'2012-12-21T12:34:56Z'", FB);
    }

    @Test
    public void fb02_ZonedDateTime_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FB, (PojoSwap<?, ?>)new FBSwap());
    }

    @Test
    public void fb03_ZonedDateTime_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T12:34:56Z',f2:'FOO'}", new FBBean());
    }

    @Test
    public void fc01_LocalDate() throws Exception {
        this.test("'2012-12-21'", FC);
    }

    @Test
    public void fc02_LocalDate_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FC, (PojoSwap<?, ?>)new FCSwap());
    }

    @Test
    public void fc03_LocalDate_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21',f2:'FOO'}", new FCBean());
    }

    @Test
    public void fd01_LocalDateTime() throws Exception {
        this.test("'2012-12-21T12:34:56'", FD);
    }

    @Test
    public void fd02_LocalDateTime_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FD, (PojoSwap<?, ?>)new FDSwap());
    }

    @Test
    public void fd03_LocalDateTime_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T12:34:56',f2:'FOO'}", new FDBean());
    }

    @Test
    public void fe01_LocalTime() throws Exception {
        this.test("'12:34:56'", FE);
    }

    @Test
    public void fe02_LocalTime_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FE, (PojoSwap<?, ?>)new FESwap());
    }

    @Test
    public void fe03_LocalTime_overrideAnnotation() throws Exception {
        this.test("{f1:'12:34:56',f2:'FOO'}", new FEBean());
    }

    @Test
    public void ff01_OffsetDateTime() throws Exception {
        this.test("'2012-12-21T12:34:56-05:00'", FF);
    }

    @Test
    public void ff02_OffsetDateTime_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FF, (PojoSwap<?, ?>)new FFSwap());
    }

    @Test
    public void ff03_OffsetDateTime_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T12:34:56-05:00',f2:'FOO'}", new FFBean());
    }

    @Test
    public void fg01_OffsetTime() throws Exception {
        this.test("'12:34:56-05:00'", FG);
    }

    @Test
    public void fg02_OffsetTime_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FG, (PojoSwap<?, ?>)new FGSwap());
    }

    @Test
    public void fg03_OffsetTime_overrideAnnotation() throws Exception {
        this.test("{f1:'12:34:56-05:00',f2:'FOO'}", new FGBean());
    }

    @Test
    public void fh01_Year() throws Exception {
        this.test("'2012'", FH);
    }

    @Test
    public void fh02_Year_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FH, (PojoSwap<?, ?>)new FHSwap());
    }

    @Test
    public void fh03_Year_overrideAnnotation() throws Exception {
        this.test("{f1:'2012',f2:'FOO'}", new FHBean());
    }

    @Test
    public void fi01_YearMonth() throws Exception {
        this.test("'2012-12'", FI);
    }

    @Test
    public void fi02_YearMonth_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FI, (PojoSwap<?, ?>)new FISwap());
    }

    @Test
    public void fi03_YearMonth_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12',f2:'FOO'}", new FIBean());
    }

    @Test
    public void fj01_Temporal() throws Exception {
        this.test("'2012-12-21T05:00:00Z'", FJ);
    }

    @Test
    public void fj02_Temporal_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)FJ, (PojoSwap<?, ?>)new FJSwap());
    }

    @Test
    public void fj03_Temporal_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T05:00:00Z',f2:'FOO'}", new FJBean());
    }

    @Test
    public void g01_TimeZone() throws Exception {
        this.test("'GMT'", G);
    }

    @Test
    public void g02_TimeZone_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)G, (PojoSwap<?, ?>)new GSwap());
    }

    @Test
    public void g03_TimeZone_overrideAnnotation() throws Exception {
        this.test("{f1:'GMT',f2:'FOO'}", new GBean());
    }

    @Test
    public void h01_XMLGregorianCalendar() throws Exception {
        this.test("'2012-12-21T12:34:56.789Z'", H);
    }

    @Test
    public void h02_XMLGregorianCalendar_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)H, (PojoSwap<?, ?>)new HSwap());
    }

    @Test
    public void h03_XMLGregorianCalendar_overrideAnnotation() throws Exception {
        this.test("{f1:'2012-12-21T12:34:56.789Z',f2:'FOO'}", new HBean());
    }

    @Test
    public void i01_ZoneId() throws Exception {
        this.test("'Z'", I);
    }

    @Test
    public void i02_ZoneId_overrideSwap() throws Exception {
        this.test("'FOO'", (Object)I, (PojoSwap<?, ?>)new ISwap());
    }

    @Test
    public void i03_ZoneId_overrideAnnotation() throws Exception {
        this.test("{f1:'Z',f2:'FOO'}", new IBean());
    }

    static /* synthetic */ Vector access$000() {
        return A;
    }

    static /* synthetic */ List access$100() {
        return B;
    }

    static /* synthetic */ Locale access$200() {
        return C;
    }

    static /* synthetic */ GregorianCalendar access$300() {
        return D;
    }

    static /* synthetic */ Date access$400() {
        return E;
    }

    static /* synthetic */ Instant access$500() {
        return FA;
    }

    static /* synthetic */ ZonedDateTime access$600() {
        return FB;
    }

    static /* synthetic */ LocalDate access$700() {
        return FC;
    }

    static /* synthetic */ LocalDateTime access$800() {
        return FD;
    }

    static /* synthetic */ LocalTime access$900() {
        return FE;
    }

    static /* synthetic */ OffsetDateTime access$1000() {
        return FF;
    }

    static /* synthetic */ OffsetTime access$1100() {
        return FG;
    }

    static /* synthetic */ Year access$1200() {
        return FH;
    }

    static /* synthetic */ YearMonth access$1300() {
        return FI;
    }

    static /* synthetic */ Temporal access$1400() {
        return FJ;
    }

    static /* synthetic */ TimeZone access$1500() {
        return G;
    }

    static /* synthetic */ XMLGregorianCalendar access$1600() {
        return H;
    }

    static /* synthetic */ ZoneId access$1700() {
        return I;
    }

    static {
        A.add("foo");
        A.add("bar");
        Ac = new Vector();
        Ac.add("foo");
        Ac.add("bar");
        B = new AList().appendAll((Object[])new String[]{"foo", "bar"});
        Bc = new AList().appendAll((Object[])new String[]{"foo", "bar"});
        C = Locale.JAPAN;
        D = GregorianCalendar.from(ZonedDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse("2012-12-21T12:34:56Z")));
        E = Date.from(Instant.from(DateTimeFormatter.ISO_INSTANT.parse("2012-12-21T12:34:56Z")));
        FA = Instant.parse("2012-12-21T12:34:56Z");
        FB = ZonedDateTime.parse("2012-12-21T12:34:56Z");
        FC = LocalDate.parse("2012-12-21");
        FD = LocalDateTime.parse("2012-12-21T12:34:56");
        FE = LocalTime.parse("12:34:56");
        FF = OffsetDateTime.parse("2012-12-21T12:34:56-05:00");
        FG = OffsetTime.parse("12:34:56-05:00");
        FH = Year.parse("2012");
        FI = YearMonth.parse("2012-12");
        FJ = HijrahDate.from(FB);
        G = TimeZone.getTimeZone("Z");
        try {
            H = DatatypeFactory.newInstance().newXMLGregorianCalendar("2012-12-21T12:34:56.789Z");
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        I = ZoneId.of("Z");
    }

    public static class IBean {
        public ZoneId f1 = DefaultSwapsTest.access$1700();
        @Swap(value=ISwap.class)
        public ZoneId f2 = DefaultSwapsTest.access$1700();
    }

    public static class ISwap
    extends StringSwap<ZoneId> {
        public String swap(BeanSession session, ZoneId o) throws Exception {
            return "FOO";
        }
    }

    public static class HBean {
        public XMLGregorianCalendar f1 = DefaultSwapsTest.access$1600();
        @Swap(value=HSwap.class)
        public XMLGregorianCalendar f2 = DefaultSwapsTest.access$1600();
    }

    public static class HSwap
    extends StringSwap<XMLGregorianCalendar> {
        public String swap(BeanSession session, XMLGregorianCalendar o) throws Exception {
            return "FOO";
        }
    }

    public static class GBean {
        public TimeZone f1 = DefaultSwapsTest.access$1500();
        @Swap(value=GSwap.class)
        public TimeZone f2 = DefaultSwapsTest.access$1500();
    }

    public static class GSwap
    extends StringSwap<TimeZone> {
        public String swap(BeanSession session, TimeZone o) throws Exception {
            return "FOO";
        }
    }

    public static class FJBean {
        public Temporal f1 = DefaultSwapsTest.access$1400();
        @Swap(value=FJSwap.class)
        public Temporal f2 = DefaultSwapsTest.access$1400();
    }

    public static class FJSwap
    extends StringSwap<Temporal> {
        public String swap(BeanSession session, Temporal o) throws Exception {
            return "FOO";
        }
    }

    public static class FIBean {
        public YearMonth f1 = DefaultSwapsTest.access$1300();
        @Swap(value=FISwap.class)
        public YearMonth f2 = DefaultSwapsTest.access$1300();
    }

    public static class FISwap
    extends StringSwap<YearMonth> {
        public String swap(BeanSession session, YearMonth o) throws Exception {
            return "FOO";
        }
    }

    public static class FHBean {
        public Year f1 = DefaultSwapsTest.access$1200();
        @Swap(value=FHSwap.class)
        public Year f2 = DefaultSwapsTest.access$1200();
    }

    public static class FHSwap
    extends StringSwap<Year> {
        public String swap(BeanSession session, Year o) throws Exception {
            return "FOO";
        }
    }

    public static class FGBean {
        public OffsetTime f1 = DefaultSwapsTest.access$1100();
        @Swap(value=FGSwap.class)
        public OffsetTime f2 = DefaultSwapsTest.access$1100();
    }

    public static class FGSwap
    extends StringSwap<OffsetTime> {
        public String swap(BeanSession session, OffsetTime o) throws Exception {
            return "FOO";
        }
    }

    public static class FFBean {
        public OffsetDateTime f1 = DefaultSwapsTest.access$1000();
        @Swap(value=FFSwap.class)
        public OffsetDateTime f2 = DefaultSwapsTest.access$1000();
    }

    public static class FFSwap
    extends StringSwap<OffsetDateTime> {
        public String swap(BeanSession session, OffsetDateTime o) throws Exception {
            return "FOO";
        }
    }

    public static class FEBean {
        public LocalTime f1 = DefaultSwapsTest.access$900();
        @Swap(value=FESwap.class)
        public LocalTime f2 = DefaultSwapsTest.access$900();
    }

    public static class FESwap
    extends StringSwap<LocalTime> {
        public String swap(BeanSession session, LocalTime o) throws Exception {
            return "FOO";
        }
    }

    public static class FDBean {
        public LocalDateTime f1 = DefaultSwapsTest.access$800();
        @Swap(value=FDSwap.class)
        public LocalDateTime f2 = DefaultSwapsTest.access$800();
    }

    public static class FDSwap
    extends StringSwap<LocalDateTime> {
        public String swap(BeanSession session, LocalDateTime o) throws Exception {
            return "FOO";
        }
    }

    public static class FCBean {
        public LocalDate f1 = DefaultSwapsTest.access$700();
        @Swap(value=FCSwap.class)
        public LocalDate f2 = DefaultSwapsTest.access$700();
    }

    public static class FCSwap
    extends StringSwap<LocalDate> {
        public String swap(BeanSession session, LocalDate o) throws Exception {
            return "FOO";
        }
    }

    public static class FBBean {
        public ZonedDateTime f1 = DefaultSwapsTest.access$600();
        @Swap(value=FBSwap.class)
        public ZonedDateTime f2 = DefaultSwapsTest.access$600();
    }

    public static class FBSwap
    extends StringSwap<ZonedDateTime> {
        public String swap(BeanSession session, ZonedDateTime o) throws Exception {
            return "FOO";
        }
    }

    public static class FABean {
        public Instant f1 = DefaultSwapsTest.access$500();
        @Swap(value=FASwap.class)
        public Instant f2 = DefaultSwapsTest.access$500();
    }

    public static class FASwap
    extends StringSwap<Instant> {
        public String swap(BeanSession session, Instant o) throws Exception {
            return "FOO";
        }
    }

    public static class EBean {
        public Date f1 = DefaultSwapsTest.access$400();
        @Swap(value=ESwap.class)
        public Date f2 = DefaultSwapsTest.access$400();
    }

    public static class ESwap
    extends StringSwap<Date> {
        public String swap(BeanSession session, Date o) throws Exception {
            return "FOO";
        }
    }

    public static class DBean {
        public GregorianCalendar f1 = DefaultSwapsTest.access$300();
        @Swap(value=DSwap.class)
        public GregorianCalendar f2 = DefaultSwapsTest.access$300();
    }

    public static class DSwap
    extends StringSwap<Calendar> {
        public String swap(BeanSession session, Calendar o) throws Exception {
            return "FOO";
        }
    }

    public static class CBean {
        public Locale f1 = DefaultSwapsTest.access$200();
        @Swap(value=CSwap.class)
        public Locale f2 = DefaultSwapsTest.access$200();
    }

    public static class CSwap
    extends StringSwap<Locale> {
        public String swap(BeanSession session, Locale o) throws Exception {
            return "FOO";
        }
    }

    @BeanConfig(applySwap={@Swap(on="BcBean.f2", value=BcSwap.class)})
    public static class BcBean {
        public Iterator<?> f1 = DefaultSwapsTest.access$100().iterator();
        public Iterator<?> f2 = DefaultSwapsTest.access$100().iterator();
    }

    public static class BcSwap
    extends StringSwap<Iterator<?>> {
        public String swap(BeanSession session, Iterator<?> o) throws Exception {
            return "FOO";
        }
    }

    public static class BBean {
        public Iterator<?> f1 = DefaultSwapsTest.access$100().iterator();
        @Swap(value=BSwap.class)
        public Iterator<?> f2 = DefaultSwapsTest.access$100().iterator();
    }

    public static class BSwap
    extends StringSwap<Iterator<?>> {
        public String swap(BeanSession session, Iterator<?> o) throws Exception {
            return "FOO";
        }
    }

    @BeanConfig(applySwap={@Swap(on="AcBean.f2", value=AcSwap.class)})
    public static class AcBean {
        public Enumeration<String> f1 = DefaultSwapsTest.access$000().elements();
        public Enumeration<String> f2 = DefaultSwapsTest.access$000().elements();
    }

    public static class AcSwap
    extends StringSwap<Enumeration<?>> {
        public String swap(BeanSession session, Enumeration<?> o) throws Exception {
            return "FOO";
        }
    }

    public static class ABean {
        public Enumeration<String> f1 = DefaultSwapsTest.access$000().elements();
        @Swap(value=ASwap.class)
        public Enumeration<String> f2 = DefaultSwapsTest.access$000().elements();
    }

    public static class ASwap
    extends StringSwap<Enumeration<?>> {
        public String swap(BeanSession session, Enumeration<?> o) throws Exception {
            return "FOO";
        }
    }
}

