/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.util.Date;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transforms.DateSwap;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class DateSwapTest {
    @BeforeClass
    public static void beforeClass() {
        TestUtils.setTimeZone("GMT-5");
    }

    @AfterClass
    public static void afterClass() {
        TestUtils.unsetTimeZone();
    }

    @Test
    public void testBeanWithDate() throws Exception {
        A testBeanA = new A().init();
        String jsonData = JsonSerializer.create().pojoSwaps(new Class[]{DateSwap.ISO8601DT.class}).build().serialize((Object)testBeanA);
        ObjectMap data = (ObjectMap)JsonParser.create().pojoSwaps(new Class[]{DateSwap.ISO8601DT.class}).build().parse(jsonData, ObjectMap.class);
        DateSwap.ISO8601DT dateSwap = new DateSwap.ISO8601DT();
        String sValue = data.getString("birthday");
        dateSwap.unswap(BeanContext.DEFAULT.createSession(), sValue, data.getBeanSession().getClassMeta(Date.class));
        data.getSwapped("birthday", (PojoSwap)dateSwap);
    }

    public static class A {
        public Date birthday;

        public A init() {
            this.birthday = new Date();
            return this;
        }
    }
}

