/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import jakarta.xml.bind.DatatypeConverter;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transforms.CalendarLongSwap;
import org.apache.juneau.transforms.CalendarSwap;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CalendarSwapTest {
    static Calendar testDate = new GregorianCalendar(TimeZone.getTimeZone("PST"));

    @Before
    public void beforeTest() {
        TestUtils.setLocale(Locale.US);
    }

    @After
    public void afterTest() {
        TestUtils.unsetLocale();
    }

    private RdfSerializer getRdfSerializer() {
        return RdfSerializer.create().sq().locale(Locale.getDefault()).useWhitespace(false).set("RdfCommon.jena.rdfXml.allowBadURIs.b", (Object)true).set("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b", (Object)false).set("RdfCommon.jena.rdfXml.showXmlDeclaration.s", (Object)false).build();
    }

    private String stripRdf(String s) {
        return s.replaceFirst("<rdf:RDF[^>]+>\\s*", "").replaceAll("</rdf:RDF>$", "").trim().replaceAll("[\\r\\n]", "");
    }

    @Test
    public void testTimezone() throws Exception {
        BeanSessionArgs beanSessionArgs = BeanSessionArgs.create().locale(Locale.getDefault());
        BeanSession session = BeanContext.DEFAULT.createSession(beanSessionArgs);
        CalendarSwap.ISO8601DT f = new CalendarSwap.ISO8601DT();
        String s = "2001-01-31T12:34:56Z";
        Calendar c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)s, (Object)f.swap(session, (Object)c));
        s = "2001-01-31T09:34:56-03:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)s, (Object)f.swap(session, (Object)c));
        s = "2001-01-31T06:34:56-06:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)s, (Object)f.swap(session, (Object)c));
        f = new CalendarSwap.ISO8601DTZ();
        s = "2001-01-31T12:34:56Z";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)s, (Object)f.swap(session, (Object)c));
        s = "2001-01-31T09:34:56-03:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"2001-01-31T12:34:56Z", (Object)f.swap(session, (Object)c));
        s = "2001-01-31T06:34:56-06:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"2001-01-31T12:34:56Z", (Object)f.swap(session, (Object)c));
        f = new CalendarSwap.RFC2822DT();
        s = "2001-01-31T12:34:56Z";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"Wed, 31 Jan 2001 12:34:56 +0000", (Object)f.swap(session, (Object)c));
        s = "2001-01-31T09:34:56-03:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"Wed, 31 Jan 2001 09:34:56 -0300", (Object)f.swap(session, (Object)c));
        s = "2001-01-31T06:34:56-06:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"Wed, 31 Jan 2001 06:34:56 -0600", (Object)f.swap(session, (Object)c));
        f = new CalendarSwap.RFC2822DTZ();
        s = "2001-01-31T12:34:56Z";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"Wed, 31 Jan 2001 12:34:56 GMT", (Object)f.swap(session, (Object)c));
        s = "2001-01-31T09:34:56-03:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"Wed, 31 Jan 2001 12:34:56 GMT", (Object)f.swap(session, (Object)c));
        s = "2001-01-31T06:34:56-06:00";
        c = DatatypeConverter.parseDateTime((String)s);
        Assert.assertEquals((Object)"Wed, 31 Jan 2001 12:34:56 GMT", (Object)f.swap(session, (Object)c));
    }

    @Test
    public void testBeanProperyFilterJson() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().locale(Locale.getDefault()).build();
        JsonParser p = JsonParser.DEFAULT.builder().locale(Locale.getDefault()).build();
        Calendar c = testDate;
        A t = new A(c);
        String json = s.serialize((Object)t);
        Assert.assertEquals((Object)"{d1:'1901-03-03T18:11:12Z',d2:'Sun, 03 Mar 1901 18:11:12 GMT',d3:-2172116928000}", (Object)json);
        t = (A)p.parse(json, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
    }

    @Test
    public void testBeanProperyFilterXml() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ.builder().locale(Locale.getDefault()).build();
        XmlParser p = XmlParser.DEFAULT.builder().locale(Locale.getDefault()).build();
        Calendar c = testDate;
        A t = new A(c);
        String xml = s.serialize((Object)t);
        Assert.assertEquals((Object)"<object><d1>1901-03-03T18:11:12Z</d1><d2>Sun, 03 Mar 1901 18:11:12 GMT</d2><d3>-2172116928000</d3></object>", (Object)xml);
        t = (A)p.parse(xml, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
    }

    @Test
    public void testBeanProperyFilterHtml() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().locale(Locale.getDefault()).addKeyValueTableHeaders().build();
        HtmlParser p = HtmlParser.DEFAULT.builder().locale(Locale.getDefault()).build();
        Calendar c = testDate;
        A t = new A(c);
        String html = s.serialize((Object)t);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>d1</td><td>1901-03-03T18:11:12Z</td></tr><tr><td>d2</td><td>Sun, 03 Mar 1901 18:11:12 GMT</td></tr><tr><td>d3</td><td>-2172116928000</td></tr></table>", (Object)html);
        t = (A)p.parse(html, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
    }

    @Test
    public void testBeanProperyFilterUon() throws Exception {
        UonSerializer s = UonSerializer.DEFAULT_ENCODING.builder().locale(Locale.getDefault()).build();
        UonParser p = UonParser.DEFAULT.builder().locale(Locale.getDefault()).build();
        UonParser pe = UonParser.DEFAULT_DECODING.builder().locale(Locale.getDefault()).build();
        Calendar c = testDate;
        A t = new A(c);
        String url = s.serialize((Object)t);
        Assert.assertEquals((Object)"(d1=1901-03-03T18:11:12Z,d2='Sun,+03+Mar+1901+18:11:12+GMT',d3=-2172116928000)", (Object)url);
        t = (A)pe.parse(url, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
        url = URLDecoder.decode(url, "UTF-8");
        t = (A)p.parse(url, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
    }

    @Test
    public void testBeanProperyFilterUrlEncoding() throws Exception {
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT.builder().locale(Locale.getDefault()).build();
        UrlEncodingParser p = UrlEncodingParser.DEFAULT.builder().locale(Locale.getDefault()).build();
        Calendar c = testDate;
        A t = new A(c);
        String url = s.serialize((Object)t);
        Assert.assertEquals((Object)"d1=1901-03-03T18:11:12Z&d2='Sun,+03+Mar+1901+18:11:12+GMT'&d3=-2172116928000", (Object)url);
        t = (A)p.parse(url, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
        url = URLDecoder.decode(url, "UTF-8");
        t = (A)p.parse(url, A.class);
        Assert.assertEquals((long)t.d1.getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD2().getTime().getTime(), (long)c.getTime().getTime());
        Assert.assertEquals((long)t.getD3().getTime().getTime(), (long)c.getTime().getTime());
    }

    @Test
    public void testBeanProperyFilterRdfXmlWithNs() throws Exception {
        RdfSerializer s = this.getRdfSerializer();
        Calendar c = testDate;
        A t = new A(c);
        String rdf = this.stripRdf(s.serialize((Object)t));
        Assert.assertEquals((Object)"<rdf:Description><jp:d1>1901-03-03T18:11:12Z</jp:d1><jp:d2>Sun, 03 Mar 1901 18:11:12 GMT</jp:d2><jp:d3>-2172116928000</jp:d3></rdf:Description>", (Object)rdf);
    }

    static {
        testDate.setTimeInMillis(0L);
        testDate.set(1901, 2, 3, 10, 11, 12);
    }

    @Bean(sort=true)
    public static class A {
        @Swap(value=CalendarSwap.ISO8601DTZ.class)
        public Calendar d1;
        private Calendar d2;
        private Calendar d3;

        public A(Calendar date) {
            this.d2 = this.d3 = date;
            this.d1 = this.d3;
        }

        public A() {
        }

        @Swap(value=CalendarSwap.RFC2822DTZ.class)
        public Calendar getD2() {
            return this.d2;
        }

        public void setD2(Calendar d2) {
            this.d2 = d2;
        }

        public Calendar getD3() {
            return this.d3;
        }

        @Swap(value=CalendarLongSwap.class)
        public void setD3(Calendar d3) {
            this.d3 = d3;
        }
    }
}

