/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboRoundTripTest;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transforms.CalendarLongSwap;
import org.apache.juneau.transforms.CalendarMapSwap;
import org.apache.juneau.transforms.CalendarSwap;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CalendarSwapComboTest
extends ComboRoundTripTest {
    private static Calendar singleDate = new GregorianCalendar(TimeZone.getTimeZone("PST"));
    private static Calendar[] dateArray;
    private static ObjectMap dateMap;
    private final Class<?> swapClass;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new ComboInput2<Calendar>("CalendarSwap.ToString/singleDate", Calendar.class, singleDate, CalendarSwap.ToString.class, "'Sun Mar 03 10:11:12 PST 1901'", "'Sun Mar 03 10:11:12 PST 1901'", "'Sun Mar 03 10:11:12 PST 1901'", "<string>Sun Mar 03 10:11:12 PST 1901</string>", "<string>Sun Mar 03 10:11:12 PST 1901</string>", "<string>Sun Mar 03 10:11:12 PST 1901</string>\n", "<string>Sun Mar 03 10:11:12 PST 1901</string>", "<string>Sun Mar 03 10:11:12 PST 1901</string>", "<string>Sun Mar 03 10:11:12 PST 1901</string>", "<string>Sun Mar 03 10:11:12 PST 1901</string>", "'Sun Mar 03 10:11:12 PST 1901'", "'Sun Mar 03 10:11:12 PST 1901'", "'Sun Mar 03 10:11:12 PST 1901'", "_value='Sun+Mar+03+10:11:12+PST+1901'", "_value='Sun+Mar+03+10:11:12+PST+1901'", "_value='Sun+Mar+03+10:11:12+PST+1901'", "BC53756E204D61722030332031303A31313A3132205053542031393031", "BC53756E204D61722030332031303A31313A3132205053542031393031", "<rdf:RDF>\n<rdf:Description>\n<j:value>Sun Mar 03 10:11:12 PST 1901</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>Sun Mar 03 10:11:12 PST 1901</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>Sun Mar 03 10:11:12 PST 1901</j:value>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar o) {
                TestUtils.assertInstanceOf(Calendar.class, o);
            }
        }}, {new ComboInput2<Calendar[]>("CalendarSwap.ToString/dateArray", Calendar[].class, dateArray, CalendarSwap.ToString.class, "['Sun Mar 03 10:11:12 PST 1901']", "['Sun Mar 03 10:11:12 PST 1901']", "[\n\t'Sun Mar 03 10:11:12 PST 1901'\n]", "<array><string>Sun Mar 03 10:11:12 PST 1901</string></array>", "<array><string>Sun Mar 03 10:11:12 PST 1901</string></array>", "<array>\n\t<string>Sun Mar 03 10:11:12 PST 1901</string>\n</array>\n", "<array><string>Sun Mar 03 10:11:12 PST 1901</string></array>", "<ul><li>Sun Mar 03 10:11:12 PST 1901</li></ul>", "<ul><li>Sun Mar 03 10:11:12 PST 1901</li></ul>", "<ul>\n\t<li>Sun Mar 03 10:11:12 PST 1901</li>\n</ul>\n", "@('Sun Mar 03 10:11:12 PST 1901')", "@('Sun Mar 03 10:11:12 PST 1901')", "@(\n\t'Sun Mar 03 10:11:12 PST 1901'\n)", "0='Sun+Mar+03+10:11:12+PST+1901'", "0='Sun+Mar+03+10:11:12+PST+1901'", "0='Sun+Mar+03+10:11:12+PST+1901'", "91BC53756E204D61722030332031303A31313A3132205053542031393031", "91BC53756E204D61722030332031303A31313A3132205053542031393031", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>Sun Mar 03 10:11:12 PST 1901</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>Sun Mar 03 10:11:12 PST 1901</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>Sun Mar 03 10:11:12 PST 1901</rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar[] o) {
                TestUtils.assertInstanceOf(Calendar.class, o[0]);
            }
        }}, {new ComboInput2<ObjectMap>("CalendarSwap.ToString", TestUtils.getType(Map.class, new Type[]{String.class, Calendar.class}), dateMap, CalendarSwap.ToString.class, "{foo:'Sun Mar 03 10:11:12 PST 1901'}", "{foo:'Sun Mar 03 10:11:12 PST 1901'}", "{\n\tfoo: 'Sun Mar 03 10:11:12 PST 1901'\n}", "<object><foo>Sun Mar 03 10:11:12 PST 1901</foo></object>", "<object><foo>Sun Mar 03 10:11:12 PST 1901</foo></object>", "<object>\n\t<foo>Sun Mar 03 10:11:12 PST 1901</foo>\n</object>\n", "<object><foo>Sun Mar 03 10:11:12 PST 1901</foo></object>", "<table><tr><td>foo</td><td>Sun Mar 03 10:11:12 PST 1901</td></tr></table>", "<table><tr><td>foo</td><td>Sun Mar 03 10:11:12 PST 1901</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td>Sun Mar 03 10:11:12 PST 1901</td>\n\t</tr>\n</table>\n", "(foo='Sun Mar 03 10:11:12 PST 1901')", "(foo='Sun Mar 03 10:11:12 PST 1901')", "(\n\tfoo='Sun Mar 03 10:11:12 PST 1901'\n)", "foo='Sun+Mar+03+10:11:12+PST+1901'", "foo='Sun+Mar+03+10:11:12+PST+1901'", "foo='Sun+Mar+03+10:11:12+PST+1901'", "81A3666F6FBC53756E204D61722030332031303A31313A3132205053542031393031", "81A3666F6FBC53756E204D61722030332031303A31313A3132205053542031393031", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>Sun Mar 03 10:11:12 PST 1901</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>Sun Mar 03 10:11:12 PST 1901</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo>Sun Mar 03 10:11:12 PST 1901</jp:foo>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(ObjectMap o) {
                TestUtils.assertInstanceOf(Calendar.class, o.get((Object)"foo"));
            }
        }}, {new ComboInput2<Calendar>("CalendarSwap.ISO8601DT/singleDate", Calendar.class, singleDate, CalendarSwap.ISO8601DT.class, "'1901-03-03T10:11:12-08:00'", "'1901-03-03T10:11:12-08:00'", "'1901-03-03T10:11:12-08:00'", "<string>1901-03-03T10:11:12-08:00</string>", "<string>1901-03-03T10:11:12-08:00</string>", "<string>1901-03-03T10:11:12-08:00</string>\n", "<string>1901-03-03T10:11:12-08:00</string>", "<string>1901-03-03T10:11:12-08:00</string>", "<string>1901-03-03T10:11:12-08:00</string>", "<string>1901-03-03T10:11:12-08:00</string>", "1901-03-03T10:11:12-08:00", "1901-03-03T10:11:12-08:00", "1901-03-03T10:11:12-08:00", "_value=1901-03-03T10:11:12-08:00", "_value=1901-03-03T10:11:12-08:00", "_value=1901-03-03T10:11:12-08:00", "B9313930312D30332D30335431303A31313A31322D30383A3030", "B9313930312D30332D30335431303A31313A31322D30383A3030", "<rdf:RDF>\n<rdf:Description>\n<j:value>1901-03-03T10:11:12-08:00</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>1901-03-03T10:11:12-08:00</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>1901-03-03T10:11:12-08:00</j:value>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar o) {
                TestUtils.assertInstanceOf(Calendar.class, o);
            }
        }}, {new ComboInput2<Calendar[]>("CalendarSwap.ISO8601DT/dateArray", Calendar[].class, dateArray, CalendarSwap.ISO8601DT.class, "['1901-03-03T10:11:12-08:00']", "['1901-03-03T10:11:12-08:00']", "[\n\t'1901-03-03T10:11:12-08:00'\n]", "<array><string>1901-03-03T10:11:12-08:00</string></array>", "<array><string>1901-03-03T10:11:12-08:00</string></array>", "<array>\n\t<string>1901-03-03T10:11:12-08:00</string>\n</array>\n", "<array><string>1901-03-03T10:11:12-08:00</string></array>", "<ul><li>1901-03-03T10:11:12-08:00</li></ul>", "<ul><li>1901-03-03T10:11:12-08:00</li></ul>", "<ul>\n\t<li>1901-03-03T10:11:12-08:00</li>\n</ul>\n", "@(1901-03-03T10:11:12-08:00)", "@(1901-03-03T10:11:12-08:00)", "@(\n\t1901-03-03T10:11:12-08:00\n)", "0=1901-03-03T10:11:12-08:00", "0=1901-03-03T10:11:12-08:00", "0=1901-03-03T10:11:12-08:00", "91B9313930312D30332D30335431303A31313A31322D30383A3030", "91B9313930312D30332D30335431303A31313A31322D30383A3030", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>1901-03-03T10:11:12-08:00</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>1901-03-03T10:11:12-08:00</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>1901-03-03T10:11:12-08:00</rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar[] o) {
                TestUtils.assertInstanceOf(Calendar.class, o[0]);
            }
        }}, {new ComboInput2<ObjectMap>("CalendarSwap.ISO8601DT/dateMap", TestUtils.getType(Map.class, new Type[]{String.class, Calendar.class}), dateMap, CalendarSwap.ISO8601DT.class, "{foo:'1901-03-03T10:11:12-08:00'}", "{foo:'1901-03-03T10:11:12-08:00'}", "{\n\tfoo: '1901-03-03T10:11:12-08:00'\n}", "<object><foo>1901-03-03T10:11:12-08:00</foo></object>", "<object><foo>1901-03-03T10:11:12-08:00</foo></object>", "<object>\n\t<foo>1901-03-03T10:11:12-08:00</foo>\n</object>\n", "<object><foo>1901-03-03T10:11:12-08:00</foo></object>", "<table><tr><td>foo</td><td>1901-03-03T10:11:12-08:00</td></tr></table>", "<table><tr><td>foo</td><td>1901-03-03T10:11:12-08:00</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td>1901-03-03T10:11:12-08:00</td>\n\t</tr>\n</table>\n", "(foo=1901-03-03T10:11:12-08:00)", "(foo=1901-03-03T10:11:12-08:00)", "(\n\tfoo=1901-03-03T10:11:12-08:00\n)", "foo=1901-03-03T10:11:12-08:00", "foo=1901-03-03T10:11:12-08:00", "foo=1901-03-03T10:11:12-08:00", "81A3666F6FB9313930312D30332D30335431303A31313A31322D30383A3030", "81A3666F6FB9313930312D30332D30335431303A31313A31322D30383A3030", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>1901-03-03T10:11:12-08:00</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>1901-03-03T10:11:12-08:00</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo>1901-03-03T10:11:12-08:00</jp:foo>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(ObjectMap o) {
                TestUtils.assertInstanceOf(Calendar.class, o.get((Object)"foo"));
            }
        }}, {new ComboInput2<Calendar>("CalendarSwap.RFC2822DTZ/singleDate", Calendar.class, singleDate, CalendarSwap.RFC2822DTZ.class, "'Sun, 03 Mar 1901 18:11:12 GMT'", "'Sun, 03 Mar 1901 18:11:12 GMT'", "'Sun, 03 Mar 1901 18:11:12 GMT'", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>\n", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>", "<string>Sun, 03 Mar 1901 18:11:12 GMT</string>", "'Sun, 03 Mar 1901 18:11:12 GMT'", "'Sun, 03 Mar 1901 18:11:12 GMT'", "'Sun, 03 Mar 1901 18:11:12 GMT'", "_value='Sun,+03+Mar+1901+18:11:12+GMT'", "_value='Sun,+03+Mar+1901+18:11:12+GMT'", "_value='Sun,+03+Mar+1901+18:11:12+GMT'", "BD53756E2C203033204D617220313930312031383A31313A313220474D54", "BD53756E2C203033204D617220313930312031383A31313A313220474D54", "<rdf:RDF>\n<rdf:Description>\n<j:value>Sun, 03 Mar 1901 18:11:12 GMT</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>Sun, 03 Mar 1901 18:11:12 GMT</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>Sun, 03 Mar 1901 18:11:12 GMT</j:value>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar o) {
                TestUtils.assertInstanceOf(Calendar.class, o);
            }
        }}, {new ComboInput2<Calendar[]>("CalendarSwap.RFC2822DTZ/dateArray", Calendar[].class, dateArray, CalendarSwap.RFC2822DTZ.class, "['Sun, 03 Mar 1901 18:11:12 GMT']", "['Sun, 03 Mar 1901 18:11:12 GMT']", "[\n\t'Sun, 03 Mar 1901 18:11:12 GMT'\n]", "<array><string>Sun, 03 Mar 1901 18:11:12 GMT</string></array>", "<array><string>Sun, 03 Mar 1901 18:11:12 GMT</string></array>", "<array>\n\t<string>Sun, 03 Mar 1901 18:11:12 GMT</string>\n</array>\n", "<array><string>Sun, 03 Mar 1901 18:11:12 GMT</string></array>", "<ul><li>Sun, 03 Mar 1901 18:11:12 GMT</li></ul>", "<ul><li>Sun, 03 Mar 1901 18:11:12 GMT</li></ul>", "<ul>\n\t<li>Sun, 03 Mar 1901 18:11:12 GMT</li>\n</ul>\n", "@('Sun, 03 Mar 1901 18:11:12 GMT')", "@('Sun, 03 Mar 1901 18:11:12 GMT')", "@(\n\t'Sun, 03 Mar 1901 18:11:12 GMT'\n)", "0='Sun,+03+Mar+1901+18:11:12+GMT'", "0='Sun,+03+Mar+1901+18:11:12+GMT'", "0='Sun,+03+Mar+1901+18:11:12+GMT'", "91BD53756E2C203033204D617220313930312031383A31313A313220474D54", "91BD53756E2C203033204D617220313930312031383A31313A313220474D54", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>Sun, 03 Mar 1901 18:11:12 GMT</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>Sun, 03 Mar 1901 18:11:12 GMT</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>Sun, 03 Mar 1901 18:11:12 GMT</rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar[] o) {
                TestUtils.assertInstanceOf(Calendar.class, o[0]);
            }
        }}, {new ComboInput2<ObjectMap>("CalendarSwap.RFC2822DTZ/dateMap", TestUtils.getType(Map.class, new Type[]{String.class, Calendar.class}), dateMap, CalendarSwap.RFC2822DTZ.class, "{foo:'Sun, 03 Mar 1901 18:11:12 GMT'}", "{foo:'Sun, 03 Mar 1901 18:11:12 GMT'}", "{\n\tfoo: 'Sun, 03 Mar 1901 18:11:12 GMT'\n}", "<object><foo>Sun, 03 Mar 1901 18:11:12 GMT</foo></object>", "<object><foo>Sun, 03 Mar 1901 18:11:12 GMT</foo></object>", "<object>\n\t<foo>Sun, 03 Mar 1901 18:11:12 GMT</foo>\n</object>\n", "<object><foo>Sun, 03 Mar 1901 18:11:12 GMT</foo></object>", "<table><tr><td>foo</td><td>Sun, 03 Mar 1901 18:11:12 GMT</td></tr></table>", "<table><tr><td>foo</td><td>Sun, 03 Mar 1901 18:11:12 GMT</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td>Sun, 03 Mar 1901 18:11:12 GMT</td>\n\t</tr>\n</table>\n", "(foo='Sun, 03 Mar 1901 18:11:12 GMT')", "(foo='Sun, 03 Mar 1901 18:11:12 GMT')", "(\n\tfoo='Sun, 03 Mar 1901 18:11:12 GMT'\n)", "foo='Sun,+03+Mar+1901+18:11:12+GMT'", "foo='Sun,+03+Mar+1901+18:11:12+GMT'", "foo='Sun,+03+Mar+1901+18:11:12+GMT'", "81A3666F6FBD53756E2C203033204D617220313930312031383A31313A313220474D54", "81A3666F6FBD53756E2C203033204D617220313930312031383A31313A313220474D54", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>Sun, 03 Mar 1901 18:11:12 GMT</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>Sun, 03 Mar 1901 18:11:12 GMT</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo>Sun, 03 Mar 1901 18:11:12 GMT</jp:foo>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(ObjectMap o) {
                TestUtils.assertInstanceOf(Calendar.class, o.get((Object)"foo"));
            }
        }}, {new ComboInput2<Calendar>("CalendarLongSwap", Calendar.class, singleDate, CalendarLongSwap.class, "-2172116928000", "-2172116928000", "-2172116928000", "<number>-2172116928000</number>", "<number>-2172116928000</number>", "<number>-2172116928000</number>\n", "<number>-2172116928000</number>", "<number>-2172116928000</number>", "<number>-2172116928000</number>", "<number>-2172116928000</number>", "-2172116928000", "-2172116928000", "-2172116928000", "_value=-2172116928000", "_value=-2172116928000", "_value=-2172116928000", "D3FFFFFE0643BDFA00", "D3FFFFFE0643BDFA00", "<rdf:RDF>\n<rdf:Description>\n<j:value>-2172116928000</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>-2172116928000</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>-2172116928000</j:value>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar o) {
                TestUtils.assertInstanceOf(Calendar.class, o);
            }
        }}, {new ComboInput2<Calendar[]>("CalendarLongSwap/dateArray", Calendar[].class, dateArray, CalendarLongSwap.class, "[-2172116928000]", "[-2172116928000]", "[\n\t-2172116928000\n]", "<array><number>-2172116928000</number></array>", "<array><number>-2172116928000</number></array>", "<array>\n\t<number>-2172116928000</number>\n</array>\n", "<array><number>-2172116928000</number></array>", "<ul><li><number>-2172116928000</number></li></ul>", "<ul><li><number>-2172116928000</number></li></ul>", "<ul>\n\t<li><number>-2172116928000</number></li>\n</ul>\n", "@(-2172116928000)", "@(-2172116928000)", "@(\n\t-2172116928000\n)", "0=-2172116928000", "0=-2172116928000", "0=-2172116928000", "91D3FFFFFE0643BDFA00", "91D3FFFFFE0643BDFA00", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>-2172116928000</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>-2172116928000</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>-2172116928000</rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar[] o) {
                TestUtils.assertInstanceOf(Calendar.class, o[0]);
            }
        }}, {new ComboInput2<ObjectMap>("CalendarLongSwap/dateMap", TestUtils.getType(Map.class, new Type[]{String.class, Calendar.class}), dateMap, CalendarLongSwap.class, "{foo:-2172116928000}", "{foo:-2172116928000}", "{\n\tfoo: -2172116928000\n}", "<object><foo _type='number'>-2172116928000</foo></object>", "<object><foo t='number'>-2172116928000</foo></object>", "<object>\n\t<foo _type='number'>-2172116928000</foo>\n</object>\n", "<object><foo _type='number'>-2172116928000</foo></object>", "<table><tr><td>foo</td><td><number>-2172116928000</number></td></tr></table>", "<table><tr><td>foo</td><td><number>-2172116928000</number></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td><number>-2172116928000</number></td>\n\t</tr>\n</table>\n", "(foo=-2172116928000)", "(foo=-2172116928000)", "(\n\tfoo=-2172116928000\n)", "foo=-2172116928000", "foo=-2172116928000", "foo=-2172116928000", "81A3666F6FD3FFFFFE0643BDFA00", "81A3666F6FD3FFFFFE0643BDFA00", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>-2172116928000</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>-2172116928000</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo>-2172116928000</jp:foo>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(ObjectMap o) {
                TestUtils.assertInstanceOf(Calendar.class, o.get((Object)"foo"));
            }
        }}, {new ComboInput2<Calendar>("CalendarMapSwap/singleDate", Calendar.class, singleDate, CalendarMapSwap.class, "{time:-2172116928000,timeZone:'PST'}", "{time:-2172116928000,timeZone:'PST'}", "{\n\ttime: -2172116928000,\n\ttimeZone: 'PST'\n}", "<object><time _type='number'>-2172116928000</time><timeZone>PST</timeZone></object>", "<object><time t='number'>-2172116928000</time><timeZone>PST</timeZone></object>", "<object>\n\t<time _type='number'>-2172116928000</time>\n\t<timeZone>PST</timeZone>\n</object>\n", "<object><time _type='number'>-2172116928000</time><timeZone>PST</timeZone></object>", "<table><tr><td>time</td><td><number>-2172116928000</number></td></tr><tr><td>timeZone</td><td>PST</td></tr></table>", "<table><tr><td>time</td><td><number>-2172116928000</number></td></tr><tr><td>timeZone</td><td>PST</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>time</td>\n\t\t<td><number>-2172116928000</number></td>\n\t</tr>\n\t<tr>\n\t\t<td>timeZone</td>\n\t\t<td>PST</td>\n\t</tr>\n</table>\n", "(time=-2172116928000,timeZone=PST)", "(time=-2172116928000,timeZone=PST)", "(\n\ttime=-2172116928000,\n\ttimeZone=PST\n)", "time=-2172116928000&timeZone=PST", "time=-2172116928000&timeZone=PST", "time=-2172116928000\n&timeZone=PST", "82A474696D65D3FFFFFE0643BDFA00A874696D655A6F6E65A3505354", "82A474696D65D3FFFFFE0643BDFA00A874696D655A6F6E65A3505354", "<rdf:RDF>\n<rdf:Description>\n<jp:time>-2172116928000</jp:time>\n<jp:timeZone>PST</jp:timeZone>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:time>-2172116928000</jp:time>\n<jp:timeZone>PST</jp:timeZone>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:time>-2172116928000</jp:time>\n    <jp:timeZone>PST</jp:timeZone>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar o) {
                TestUtils.assertInstanceOf(Calendar.class, o);
            }
        }}, {new ComboInput2<Calendar[]>("CalendarMapSwap/dateArray", Calendar[].class, dateArray, CalendarMapSwap.class, "[{time:-2172116928000,timeZone:'PST'}]", "[{time:-2172116928000,timeZone:'PST'}]", "[\n\t{\n\t\ttime: -2172116928000,\n\t\ttimeZone: 'PST'\n\t}\n]", "<array><object><time _type='number'>-2172116928000</time><timeZone>PST</timeZone></object></array>", "<array><object><time t='number'>-2172116928000</time><timeZone>PST</timeZone></object></array>", "<array>\n\t<object>\n\t\t<time _type='number'>-2172116928000</time>\n\t\t<timeZone>PST</timeZone>\n\t</object>\n</array>\n", "<array><object><time _type='number'>-2172116928000</time><timeZone>PST</timeZone></object></array>", "<ul><li><table><tr><td>time</td><td><number>-2172116928000</number></td></tr><tr><td>timeZone</td><td>PST</td></tr></table></li></ul>", "<ul><li><table><tr><td>time</td><td><number>-2172116928000</number></td></tr><tr><td>timeZone</td><td>PST</td></tr></table></li></ul>", "<ul>\n\t<li>\n\t\t<table>\n\t\t\t<tr>\n\t\t\t\t<td>time</td>\n\t\t\t\t<td><number>-2172116928000</number></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>timeZone</td>\n\t\t\t\t<td>PST</td>\n\t\t\t</tr>\n\t\t</table>\n\t</li>\n</ul>\n", "@((time=-2172116928000,timeZone=PST))", "@((time=-2172116928000,timeZone=PST))", "@(\n\t(\n\t\ttime=-2172116928000,\n\t\ttimeZone=PST\n\t)\n)", "0=(time=-2172116928000,timeZone=PST)", "0=(time=-2172116928000,timeZone=PST)", "0=(\n\ttime=-2172116928000,\n\ttimeZone=PST\n)", "9182A474696D65D3FFFFFE0643BDFA00A874696D655A6F6E65A3505354", "9182A474696D65D3FFFFFE0643BDFA00A874696D655A6F6E65A3505354", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:time>-2172116928000</jp:time>\n<jp:timeZone>PST</jp:timeZone>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:time>-2172116928000</jp:time>\n<jp:timeZone>PST</jp:timeZone>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li rdf:parseType='Resource'>\n      <jp:time>-2172116928000</jp:time>\n      <jp:timeZone>PST</jp:timeZone>\n    </rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar[] o) {
                TestUtils.assertInstanceOf(Calendar.class, o[0]);
            }
        }}, {new ComboInput2<ObjectMap>("CalendarMapSwap/dateMap", TestUtils.getType(Map.class, new Type[]{String.class, Calendar.class}), dateMap, CalendarMapSwap.class, "{foo:{time:-2172116928000,timeZone:'PST'}}", "{foo:{time:-2172116928000,timeZone:'PST'}}", "{\n\tfoo: {\n\t\ttime: -2172116928000,\n\t\ttimeZone: 'PST'\n\t}\n}", "<object><foo _type='object'><time _type='number'>-2172116928000</time><timeZone>PST</timeZone></foo></object>", "<object><foo t='object'><time t='number'>-2172116928000</time><timeZone>PST</timeZone></foo></object>", "<object>\n\t<foo _type='object'>\n\t\t<time _type='number'>-2172116928000</time>\n\t\t<timeZone>PST</timeZone>\n\t</foo>\n</object>\n", "<object><foo _type='object'><time _type='number'>-2172116928000</time><timeZone>PST</timeZone></foo></object>", "<table><tr><td>foo</td><td><table><tr><td>time</td><td><number>-2172116928000</number></td></tr><tr><td>timeZone</td><td>PST</td></tr></table></td></tr></table>", "<table><tr><td>foo</td><td><table><tr><td>time</td><td><number>-2172116928000</number></td></tr><tr><td>timeZone</td><td>PST</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>time</td>\n\t\t\t\t\t<td><number>-2172116928000</number></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>timeZone</td>\n\t\t\t\t\t<td>PST</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "(foo=(time=-2172116928000,timeZone=PST))", "(foo=(time=-2172116928000,timeZone=PST))", "(\n\tfoo=(\n\t\ttime=-2172116928000,\n\t\ttimeZone=PST\n\t)\n)", "foo=(time=-2172116928000,timeZone=PST)", "foo=(time=-2172116928000,timeZone=PST)", "foo=(\n\ttime=-2172116928000,\n\ttimeZone=PST\n)", "81A3666F6F82A474696D65D3FFFFFE0643BDFA00A874696D655A6F6E65A3505354", "81A3666F6F82A474696D65D3FFFFFE0643BDFA00A874696D655A6F6E65A3505354", "<rdf:RDF>\n<rdf:Description>\n<jp:foo rdf:parseType='Resource'>\n<jp:time>-2172116928000</jp:time>\n<jp:timeZone>PST</jp:timeZone>\n</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo rdf:parseType='Resource'>\n<jp:time>-2172116928000</jp:time>\n<jp:timeZone>PST</jp:timeZone>\n</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo rdf:parseType='Resource'>\n      <jp:time>-2172116928000</jp:time>\n      <jp:timeZone>PST</jp:timeZone>\n    </jp:foo>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(ObjectMap o) {
                TestUtils.assertInstanceOf(Calendar.class, o.get((Object)"foo"));
            }
        }}, {new ComboInput2<Calendar>("CalendarSwap.DateMedium/singleDate", Calendar.class, singleDate, CalendarSwap.DateMedium.class, "'Mar 3, 1901'", "'Mar 3, 1901'", "'Mar 3, 1901'", "<string>Mar 3, 1901</string>", "<string>Mar 3, 1901</string>", "<string>Mar 3, 1901</string>\n", "<string>Mar 3, 1901</string>", "<string>Mar 3, 1901</string>", "<string>Mar 3, 1901</string>", "<string>Mar 3, 1901</string>", "'Mar 3, 1901'", "'Mar 3, 1901'", "'Mar 3, 1901'", "_value='Mar+3,+1901'", "_value='Mar+3,+1901'", "_value='Mar+3,+1901'", "AB4D617220332C2031393031", "AB4D617220332C2031393031", "<rdf:RDF>\n<rdf:Description>\n<j:value>Mar 3, 1901</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>Mar 3, 1901</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>Mar 3, 1901</j:value>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar o) {
                TestUtils.assertInstanceOf(Calendar.class, o);
            }
        }}, {new ComboInput2<Calendar[]>("CalendarSwap.DateMedium/dateArray", Calendar[].class, dateArray, CalendarSwap.DateMedium.class, "['Mar 3, 1901']", "['Mar 3, 1901']", "[\n\t'Mar 3, 1901'\n]", "<array><string>Mar 3, 1901</string></array>", "<array><string>Mar 3, 1901</string></array>", "<array>\n\t<string>Mar 3, 1901</string>\n</array>\n", "<array><string>Mar 3, 1901</string></array>", "<ul><li>Mar 3, 1901</li></ul>", "<ul><li>Mar 3, 1901</li></ul>", "<ul>\n\t<li>Mar 3, 1901</li>\n</ul>\n", "@('Mar 3, 1901')", "@('Mar 3, 1901')", "@(\n\t'Mar 3, 1901'\n)", "0='Mar+3,+1901'", "0='Mar+3,+1901'", "0='Mar+3,+1901'", "91AB4D617220332C2031393031", "91AB4D617220332C2031393031", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>Mar 3, 1901</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>Mar 3, 1901</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>Mar 3, 1901</rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(Calendar[] o) {
                TestUtils.assertInstanceOf(Calendar.class, o[0]);
            }
        }}, {new ComboInput2<ObjectMap>("CalendarSwap.DateMedium/dateMap", TestUtils.getType(Map.class, new Type[]{String.class, Calendar.class}), dateMap, CalendarSwap.DateMedium.class, "{foo:'Mar 3, 1901'}", "{foo:'Mar 3, 1901'}", "{\n\tfoo: 'Mar 3, 1901'\n}", "<object><foo>Mar 3, 1901</foo></object>", "<object><foo>Mar 3, 1901</foo></object>", "<object>\n\t<foo>Mar 3, 1901</foo>\n</object>\n", "<object><foo>Mar 3, 1901</foo></object>", "<table><tr><td>foo</td><td>Mar 3, 1901</td></tr></table>", "<table><tr><td>foo</td><td>Mar 3, 1901</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td>Mar 3, 1901</td>\n\t</tr>\n</table>\n", "(foo='Mar 3, 1901')", "(foo='Mar 3, 1901')", "(\n\tfoo='Mar 3, 1901'\n)", "foo='Mar+3,+1901'", "foo='Mar+3,+1901'", "foo='Mar+3,+1901'", "81A3666F6FAB4D617220332C2031393031", "81A3666F6FAB4D617220332C2031393031", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>Mar 3, 1901</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>Mar 3, 1901</jp:foo>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo>Mar 3, 1901</jp:foo>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(ObjectMap o) {
                TestUtils.assertInstanceOf(Calendar.class, o.get((Object)"foo"));
            }
        }});
    }

    public CalendarSwapComboTest(ComboInput2<?> comboInput) {
        super(comboInput);
        this.swapClass = ((ComboInput2)comboInput).swapClass;
    }

    @BeforeClass
    public static void beforeClass() {
        TestUtils.setTimeZone("PST");
        TestUtils.setLocale(Locale.US);
    }

    @AfterClass
    public static void afterClass() {
        TestUtils.unsetTimeZone();
        TestUtils.unsetLocale();
    }

    @Override
    protected Serializer applySettings(Serializer s) throws Exception {
        return s.builder().pojoSwaps(new Class[]{this.swapClass}).build();
    }

    @Override
    protected Parser applySettings(Parser p) throws Exception {
        return p.builder().pojoSwaps(new Class[]{this.swapClass}).build();
    }

    static {
        singleDate.setTimeInMillis(0L);
        singleDate.set(1901, 2, 3, 10, 11, 12);
        dateArray = new Calendar[]{singleDate};
        dateMap = new ObjectMap().append("foo", (Object)singleDate);
    }

    public static class ComboInput2<T>
    extends ComboInput<T> {
        private final Class<?> swapClass;

        public ComboInput2(String label, Type type, T in, Class<?> swapClass, String json, String jsonT, String jsonR, String xml, String xmlT, String xmlR, String xmlNs, String html, String htmlT, String htmlR, String uon, String uonT, String uonR, String urlEncoding, String urlEncodingT, String urlEncodingR, String msgPack, String msgPackT, String rdfXml, String rdfXmlT, String rdfXmlR) {
            super(label, type, in, json, jsonT, jsonR, xml, xmlT, xmlR, xmlNs, html, htmlT, htmlR, uon, uonT, uonR, urlEncoding, urlEncodingT, urlEncodingR, msgPack, msgPackT, rdfXml, rdfXmlT, rdfXmlR);
            this.swapClass = swapClass;
        }
    }
}

