/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboRoundTripTest;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transforms.ByteArraySwap;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ByteArrayBase64SwapComboTest
extends ComboRoundTripTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new ComboInput<byte[]>("ByteArray1d", byte[].class, new byte[]{1, 2, 3}, "'AQID'", "'AQID'", "'AQID'", "<string>AQID</string>", "<string>AQID</string>", "<string>AQID</string>\n", "<string>AQID</string>", "<string>AQID</string>", "<string>AQID</string>", "<string>AQID</string>", "AQID", "AQID", "AQID", "_value=AQID", "_value=AQID", "_value=AQID", "A441514944", "A441514944", "<rdf:RDF>\n<rdf:Description>\n<j:value>AQID</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<j:value>AQID</j:value>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <j:value>AQID</j:value>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(byte[] o) {
                TestUtils.assertInstanceOf(byte[].class, o);
            }
        }}, {new ComboInput<byte[][]>("ByteArray2d", byte[][].class, (byte[][])new byte[][]{{1, 2, 3}, {4, 5, 6}, null}, "['AQID','BAUG',null]", "['AQID','BAUG',null]", "[\n\t'AQID',\n\t'BAUG',\n\tnull\n]", "<array><string>AQID</string><string>BAUG</string><null/></array>", "<array><string>AQID</string><string>BAUG</string><null/></array>", "<array>\n\t<string>AQID</string>\n\t<string>BAUG</string>\n\t<null/>\n</array>\n", "<array><string>AQID</string><string>BAUG</string><null/></array>", "<ul><li>AQID</li><li>BAUG</li><li><null/></li></ul>", "<ul><li>AQID</li><li>BAUG</li><li><null/></li></ul>", "<ul>\n\t<li>AQID</li>\n\t<li>BAUG</li>\n\t<li><null/></li>\n</ul>\n", "@(AQID,BAUG,null)", "@(AQID,BAUG,null)", "@(\n\tAQID,\n\tBAUG,\n\tnull\n)", "0=AQID&1=BAUG&2=null", "0=AQID&1=BAUG&2=null", "0=AQID\n&1=BAUG\n&2=null", "93A441514944A442415547C0", "93A441514944A442415547C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>AQID</rdf:li>\n    <rdf:li>BAUG</rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(byte[][] o) {
                TestUtils.assertInstanceOf(byte[][].class, o);
            }
        }}, {new ComboInput<List<byte[]>>("ListOfByteArrays", TestUtils.getType(List.class, new Type[]{byte[].class}), (List)new AList().append((Object)new byte[]{1, 2, 3}).append((Object)new byte[]{4, 5, 6}).append(null), "['AQID','BAUG',null]", "['AQID','BAUG',null]", "[\n\t'AQID',\n\t'BAUG',\n\tnull\n]", "<array><string>AQID</string><string>BAUG</string><null/></array>", "<array><string>AQID</string><string>BAUG</string><null/></array>", "<array>\n\t<string>AQID</string>\n\t<string>BAUG</string>\n\t<null/>\n</array>\n", "<array><string>AQID</string><string>BAUG</string><null/></array>", "<ul><li>AQID</li><li>BAUG</li><li><null/></li></ul>", "<ul><li>AQID</li><li>BAUG</li><li><null/></li></ul>", "<ul>\n\t<li>AQID</li>\n\t<li>BAUG</li>\n\t<li><null/></li>\n</ul>\n", "@(AQID,BAUG,null)", "@(AQID,BAUG,null)", "@(\n\tAQID,\n\tBAUG,\n\tnull\n)", "0=AQID&1=BAUG&2=null", "0=AQID&1=BAUG&2=null", "0=AQID\n&1=BAUG\n&2=null", "93A441514944A442415547C0", "93A441514944A442415547C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>AQID</rdf:li>\n    <rdf:li>BAUG</rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(List<byte[]> o) {
                TestUtils.assertInstanceOf(List.class, o);
                TestUtils.assertInstanceOf(byte[].class, o.get(0));
            }
        }}, {new ComboInput<Map<String, byte[]>>("MapOfByteArrays", TestUtils.getType(Map.class, new Type[]{String.class, byte[].class}), (Map)new AMap().append((Object)"foo", (Object)new byte[]{1, 2, 3}).append((Object)"bar", null).append(null, (Object)new byte[]{4, 5, 6}).append((Object)"null", (Object)new byte[]{7, 8, 9}), "{foo:'AQID',bar:null,null:'BAUG','null':'BwgJ'}", "{foo:'AQID',bar:null,null:'BAUG','null':'BwgJ'}", "{\n\tfoo: 'AQID',\n\tbar: null,\n\tnull: 'BAUG',\n\t'null': 'BwgJ'\n}", "<object><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_><null>BwgJ</null></object>", "<object><foo>AQID</foo><bar t='null'/><_x0000_>BAUG</_x0000_><null>BwgJ</null></object>", "<object>\n\t<foo>AQID</foo>\n\t<bar _type='null'/>\n\t<_x0000_>BAUG</_x0000_>\n\t<null>BwgJ</null>\n</object>\n", "<object><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_><null>BwgJ</null></object>", "<table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr><tr><td>null</td><td>BwgJ</td></tr></table>", "<table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr><tr><td>null</td><td>BwgJ</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>foo</td>\n\t\t<td>AQID</td>\n\t</tr>\n\t<tr>\n\t\t<td>bar</td>\n\t\t<td><null/></td>\n\t</tr>\n\t<tr>\n\t\t<td><null/></td>\n\t\t<td>BAUG</td>\n\t</tr>\n\t<tr>\n\t\t<td>null</td>\n\t\t<td>BwgJ</td>\n\t</tr>\n</table>\n", "(foo=AQID,bar=null,null=BAUG,'null'=BwgJ)", "(foo=AQID,bar=null,null=BAUG,'null'=BwgJ)", "(\n\tfoo=AQID,\n\tbar=null,\n\tnull=BAUG,\n\t'null'=BwgJ\n)", "foo=AQID&bar=null&null=BAUG&'null'=BwgJ", "foo=AQID&bar=null&null=BAUG&'null'=BwgJ", "foo=AQID\n&bar=null\n&null=BAUG\n&'null'=BwgJ", "84A3666F6FA441514944A3626172C0C0A442415547A46E756C6CA44277674A", "84A3666F6FA441514944A3626172C0C0A442415547A46E756C6CA44277674A", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n<jp:null>BwgJ</jp:null>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n<jp:null>BwgJ</jp:null>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:foo>AQID</jp:foo>\n    <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n    <jp:_x0000_>BAUG</jp:_x0000_>\n    <jp:null>BwgJ</jp:null>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, byte[]> o) {
                TestUtils.assertInstanceOf(Map.class, o);
                TestUtils.assertInstanceOf(String.class, o.keySet().iterator().next());
                TestUtils.assertInstanceOf(byte[].class, o.values().iterator().next());
            }
        }}, {new ComboInput<BeanWithByteArrayField>("BeanWithByteArrayField", BeanWithByteArrayField.class, new BeanWithByteArrayField().init(), "{f:'AQID'}", "{f:'AQID'}", "{\n\tf: 'AQID'\n}", "<object><f>AQID</f></object>", "<object><f>AQID</f></object>", "<object>\n\t<f>AQID</f>\n</object>\n", "<object><f>AQID</f></object>", "<table><tr><td>f</td><td>AQID</td></tr></table>", "<table><tr><td>f</td><td>AQID</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>AQID</td>\n\t</tr>\n</table>\n", "(f=AQID)", "(f=AQID)", "(\n\tf=AQID\n)", "f=AQID", "f=AQID", "f=AQID", "81A166A441514944", "81A166A441514944", "<rdf:RDF>\n<rdf:Description>\n<jp:f>AQID</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>AQID</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>AQID</jp:f>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArrayField o) {
                TestUtils.assertInstanceOf(BeanWithByteArrayField.class, o);
            }
        }}, {new ComboInput<BeanWithByteArray2dField>("BeanWithByteArray2dField", BeanWithByteArray2dField.class, new BeanWithByteArray2dField().init(), "{f:['AQID','BAUG',null]}", "{f:['AQID','BAUG',null]}", "{\n\tf: [\n\t\t'AQID',\n\t\t'BAUG',\n\t\tnull\n\t]\n}", "<object><f><string>AQID</string><string>BAUG</string><null/></f></object>", "<object><f><string>AQID</string><string>BAUG</string><null/></f></object>", "<object>\n\t<f>\n\t\t<string>AQID</string>\n\t\t<string>BAUG</string>\n\t\t<null/>\n\t</f>\n</object>\n", "<object><f><string>AQID</string><string>BAUG</string><null/></f></object>", "<table><tr><td>f</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr></table>", "<table><tr><td>f</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>AQID</li>\n\t\t\t\t<li>BAUG</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=@(AQID,BAUG,null))", "(f=@(AQID,BAUG,null))", "(\n\tf=@(\n\t\tAQID,\n\t\tBAUG,\n\t\tnull\n\t)\n)", "f=@(AQID,BAUG,null)", "f=@(AQID,BAUG,null)", "f=@(\n\tAQID,\n\tBAUG,\n\tnull\n)", "81A16693A441514944A442415547C0", "81A16693A441514944A442415547C0", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>\n      <rdf:Seq>\n        <rdf:li>AQID</rdf:li>\n        <rdf:li>BAUG</rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArray2dField o) {
                TestUtils.assertInstanceOf(BeanWithByteArray2dField.class, o);
            }
        }}, {new ComboInput<BeanWithByteArrayNullField>("BeanWithByteArrayNullField", BeanWithByteArrayNullField.class, new BeanWithByteArrayNullField().init(), "{f:null}", "{f:null}", "{\n\tf: null\n}", "<object><f _type='null'/></object>", "<object><f t='null'/></object>", "<object>\n\t<f _type='null'/>\n</object>\n", "<object><f _type='null'/></object>", "<table><tr><td>f</td><td><null/></td></tr></table>", "<table><tr><td>f</td><td><null/></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td><null/></td>\n\t</tr>\n</table>\n", "(f=null)", "(f=null)", "(\n\tf=null\n)", "f=null", "f=null", "f=null", "81A166C0", "81A166C0", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArrayNullField o) {
                TestUtils.assertInstanceOf(BeanWithByteArrayNullField.class, o);
            }
        }}, {new ComboInput<BeanWithByteArrayListField>("BeanWithByteArrayListField", BeanWithByteArrayListField.class, new BeanWithByteArrayListField().init(), "{f:['AQID','BAUG',null]}", "{f:['AQID','BAUG',null]}", "{\n\tf: [\n\t\t'AQID',\n\t\t'BAUG',\n\t\tnull\n\t]\n}", "<object><f><string>AQID</string><string>BAUG</string><null/></f></object>", "<object><f><string>AQID</string><string>BAUG</string><null/></f></object>", "<object>\n\t<f>\n\t\t<string>AQID</string>\n\t\t<string>BAUG</string>\n\t\t<null/>\n\t</f>\n</object>\n", "<object><f><string>AQID</string><string>BAUG</string><null/></f></object>", "<table><tr><td>f</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr></table>", "<table><tr><td>f</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>AQID</li>\n\t\t\t\t<li>BAUG</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=@(AQID,BAUG,null))", "(f=@(AQID,BAUG,null))", "(\n\tf=@(\n\t\tAQID,\n\t\tBAUG,\n\t\tnull\n\t)\n)", "f=@(AQID,BAUG,null)", "f=@(AQID,BAUG,null)", "f=@(\n\tAQID,\n\tBAUG,\n\tnull\n)", "81A16693A441514944A442415547C0", "81A16693A441514944A442415547C0", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>\n      <rdf:Seq>\n        <rdf:li>AQID</rdf:li>\n        <rdf:li>BAUG</rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArrayListField o) {
                TestUtils.assertInstanceOf(BeanWithByteArrayListField.class, o);
            }
        }}, {new ComboInput<BeanWithByteArrayMapField>("BeanWithByteArrayMapField", BeanWithByteArrayMapField.class, new BeanWithByteArrayMapField().init(), "{f:{foo:'AQID',bar:null,null:'BAUG'}}", "{f:{foo:'AQID',bar:null,null:'BAUG'}}", "{\n\tf: {\n\t\tfoo: 'AQID',\n\t\tbar: null,\n\t\tnull: 'BAUG'\n\t}\n}", "<object><f><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f></object>", "<object><f><foo>AQID</foo><bar t='null'/><_x0000_>BAUG</_x0000_></f></object>", "<object>\n\t<f>\n\t\t<foo>AQID</foo>\n\t\t<bar _type='null'/>\n\t\t<_x0000_>BAUG</_x0000_>\n\t</f>\n</object>\n", "<object><f><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f></object>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t<td>AQID</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t<td>BAUG</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=(foo=AQID,bar=null,null=BAUG))", "(f=(foo=AQID,bar=null,null=BAUG))", "(\n\tf=(\n\t\tfoo=AQID,\n\t\tbar=null,\n\t\tnull=BAUG\n\t)\n)", "f=(foo=AQID,bar=null,null=BAUG)", "f=(foo=AQID,bar=null,null=BAUG)", "f=(\n\tfoo=AQID,\n\tbar=null,\n\tnull=BAUG\n)", "81A16683A3666F6FA441514944A3626172C0C0A442415547", "81A16683A3666F6FA441514944A3626172C0C0A442415547", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f rdf:parseType='Resource'>\n      <jp:foo>AQID</jp:foo>\n      <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      <jp:_x0000_>BAUG</jp:_x0000_>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArrayMapField o) {
                TestUtils.assertInstanceOf(BeanWithByteArrayMapField.class, o);
            }
        }}, {new ComboInput<BeanWithByteArrayBeanListField>("BeanWithByteArrayBeanListField", BeanWithByteArrayBeanListField.class, new BeanWithByteArrayBeanListField().init(), "{f:[{f1:'AQID',f2:['AQID','BAUG',null],f3:null,f4:['AQID','BAUG',null],f5:{foo:'AQID',bar:null,null:'BAUG'}},null]}", "{f:[{f1:'AQID',f2:['AQID','BAUG',null],f3:null,f4:['AQID','BAUG',null],f5:{foo:'AQID',bar:null,null:'BAUG'}},null]}", "{\n\tf: [\n\t\t{\n\t\t\tf1: 'AQID',\n\t\t\tf2: [\n\t\t\t\t'AQID',\n\t\t\t\t'BAUG',\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf3: null,\n\t\t\tf4: [\n\t\t\t\t'AQID',\n\t\t\t\t'BAUG',\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf5: {\n\t\t\t\tfoo: 'AQID',\n\t\t\t\tbar: null,\n\t\t\t\tnull: 'BAUG'\n\t\t\t}\n\t\t},\n\t\tnull\n\t]\n}", "<object><f><object><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 _type='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f5></object><null/></f></object>", "<object><f><object><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 t='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar t='null'/><_x0000_>BAUG</_x0000_></f5></object><null/></f></object>", "<object>\n\t<f>\n\t\t<object>\n\t\t\t<f1>AQID</f1>\n\t\t\t<f2>\n\t\t\t\t<string>AQID</string>\n\t\t\t\t<string>BAUG</string>\n\t\t\t\t<null/>\n\t\t\t</f2>\n\t\t\t<f3 _type='null'/>\n\t\t\t<f4>\n\t\t\t\t<string>AQID</string>\n\t\t\t\t<string>BAUG</string>\n\t\t\t\t<null/>\n\t\t\t</f4>\n\t\t\t<f5>\n\t\t\t\t<foo>AQID</foo>\n\t\t\t\t<bar _type='null'/>\n\t\t\t\t<_x0000_>BAUG</_x0000_>\n\t\t\t</f5>\n\t\t</object>\n\t\t<null/>\n\t</f>\n</object>\n", "<object><f><object><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 _type='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f5></object><null/></f></object>", "<table><tr><td>f</td><td><ul><li><table><tr><td>f1</td><td>AQID</td></tr><tr><td>f2</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f3</td><td><null/></td></tr><tr><td>f4</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>f</td><td><ul><li><table><tr><td>f1</td><td>AQID</td></tr><tr><td>f2</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f3</td><td><null/></td></tr><tr><td>f4</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<table>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>f1</td>\n\t\t\t\t\t\t\t<td>AQID</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>f2</td>\n\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t<li>AQID</li>\n\t\t\t\t\t\t\t\t\t<li>BAUG</li>\n\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>f3</td>\n\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>f4</td>\n\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t<li>AQID</li>\n\t\t\t\t\t\t\t\t\t<li>BAUG</li>\n\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>f5</td>\n\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t\t\t\t<td>AQID</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t<td>BAUG</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=@((f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),null))", "(f=@((f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),null))", "(\n\tf=@(\n\t\t(\n\t\t\tf1=AQID,\n\t\t\tf2=@(\n\t\t\t\tAQID,\n\t\t\t\tBAUG,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf3=null,\n\t\t\tf4=@(\n\t\t\t\tAQID,\n\t\t\t\tBAUG,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf5=(\n\t\t\t\tfoo=AQID,\n\t\t\t\tbar=null,\n\t\t\t\tnull=BAUG\n\t\t\t)\n\t\t),\n\t\tnull\n\t)\n)", "f=@((f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),null)", "f=@((f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),null)", "f=@(\n\t(\n\t\tf1=AQID,\n\t\tf2=@(\n\t\t\tAQID,\n\t\t\tBAUG,\n\t\t\tnull\n\t\t),\n\t\tf3=null,\n\t\tf4=@(\n\t\t\tAQID,\n\t\t\tBAUG,\n\t\t\tnull\n\t\t),\n\t\tf5=(\n\t\t\tfoo=AQID,\n\t\t\tbar=null,\n\t\t\tnull=BAUG\n\t\t)\n\t),\n\tnull\n)", "81A1669285A26631A441514944A2663293A441514944A442415547C0A26633C0A2663493A441514944A442415547C0A2663583A3666F6FA441514944A3626172C0C0A442415547C0", "81A1669285A26631A441514944A2663293A441514944A442415547C0A26633C0A2663493A441514944A442415547C0A2663583A3666F6FA441514944A3626172C0C0A442415547C0", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:f1>AQID</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f5>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:f1>AQID</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f5>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f>\n      <rdf:Seq>\n        <rdf:li rdf:parseType='Resource'>\n          <jp:f1>AQID</jp:f1>\n          <jp:f2>\n            <rdf:Seq>\n              <rdf:li>AQID</rdf:li>\n              <rdf:li>BAUG</rdf:li>\n              <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n            </rdf:Seq>\n          </jp:f2>\n          <jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          <jp:f4>\n            <rdf:Seq>\n              <rdf:li>AQID</rdf:li>\n              <rdf:li>BAUG</rdf:li>\n              <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n            </rdf:Seq>\n          </jp:f4>\n          <jp:f5 rdf:parseType='Resource'>\n            <jp:foo>AQID</jp:foo>\n            <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n            <jp:_x0000_>BAUG</jp:_x0000_>\n          </jp:f5>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArrayBeanListField o) {
                TestUtils.assertInstanceOf(BeanWithByteArrayBeanListField.class, o);
            }
        }}, {new ComboInput<BeanWithByteArrayBeanMapField>("BeanWithByteArrayBeanMapField", BeanWithByteArrayBeanMapField.class, new BeanWithByteArrayBeanMapField().init(), "{f:{foo:{f1:'AQID',f2:['AQID','BAUG',null],f3:null,f4:['AQID','BAUG',null],f5:{foo:'AQID',bar:null,null:'BAUG'}},bar:null,null:{f1:'AQID',f2:['AQID','BAUG',null],f3:null,f4:['AQID','BAUG',null],f5:{foo:'AQID',bar:null,null:'BAUG'}}}}", "{f:{foo:{f1:'AQID',f2:['AQID','BAUG',null],f3:null,f4:['AQID','BAUG',null],f5:{foo:'AQID',bar:null,null:'BAUG'}},bar:null,null:{f1:'AQID',f2:['AQID','BAUG',null],f3:null,f4:['AQID','BAUG',null],f5:{foo:'AQID',bar:null,null:'BAUG'}}}}", "{\n\tf: {\n\t\tfoo: {\n\t\t\tf1: 'AQID',\n\t\t\tf2: [\n\t\t\t\t'AQID',\n\t\t\t\t'BAUG',\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf3: null,\n\t\t\tf4: [\n\t\t\t\t'AQID',\n\t\t\t\t'BAUG',\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf5: {\n\t\t\t\tfoo: 'AQID',\n\t\t\t\tbar: null,\n\t\t\t\tnull: 'BAUG'\n\t\t\t}\n\t\t},\n\t\tbar: null,\n\t\tnull: {\n\t\t\tf1: 'AQID',\n\t\t\tf2: [\n\t\t\t\t'AQID',\n\t\t\t\t'BAUG',\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf3: null,\n\t\t\tf4: [\n\t\t\t\t'AQID',\n\t\t\t\t'BAUG',\n\t\t\t\tnull\n\t\t\t],\n\t\t\tf5: {\n\t\t\t\tfoo: 'AQID',\n\t\t\t\tbar: null,\n\t\t\t\tnull: 'BAUG'\n\t\t\t}\n\t\t}\n\t}\n}", "<object><f><foo><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 _type='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f5></foo><bar _type='null'/><_x0000_><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 _type='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f5></_x0000_></f></object>", "<object><f><foo><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 t='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar t='null'/><_x0000_>BAUG</_x0000_></f5></foo><bar t='null'/><_x0000_><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 t='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar t='null'/><_x0000_>BAUG</_x0000_></f5></_x0000_></f></object>", "<object>\n\t<f>\n\t\t<foo>\n\t\t\t<f1>AQID</f1>\n\t\t\t<f2>\n\t\t\t\t<string>AQID</string>\n\t\t\t\t<string>BAUG</string>\n\t\t\t\t<null/>\n\t\t\t</f2>\n\t\t\t<f3 _type='null'/>\n\t\t\t<f4>\n\t\t\t\t<string>AQID</string>\n\t\t\t\t<string>BAUG</string>\n\t\t\t\t<null/>\n\t\t\t</f4>\n\t\t\t<f5>\n\t\t\t\t<foo>AQID</foo>\n\t\t\t\t<bar _type='null'/>\n\t\t\t\t<_x0000_>BAUG</_x0000_>\n\t\t\t</f5>\n\t\t</foo>\n\t\t<bar _type='null'/>\n\t\t<_x0000_>\n\t\t\t<f1>AQID</f1>\n\t\t\t<f2>\n\t\t\t\t<string>AQID</string>\n\t\t\t\t<string>BAUG</string>\n\t\t\t\t<null/>\n\t\t\t</f2>\n\t\t\t<f3 _type='null'/>\n\t\t\t<f4>\n\t\t\t\t<string>AQID</string>\n\t\t\t\t<string>BAUG</string>\n\t\t\t\t<null/>\n\t\t\t</f4>\n\t\t\t<f5>\n\t\t\t\t<foo>AQID</foo>\n\t\t\t\t<bar _type='null'/>\n\t\t\t\t<_x0000_>BAUG</_x0000_>\n\t\t\t</f5>\n\t\t</_x0000_>\n\t</f>\n</object>\n", "<object><f><foo><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 _type='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f5></foo><bar _type='null'/><_x0000_><f1>AQID</f1><f2><string>AQID</string><string>BAUG</string><null/></f2><f3 _type='null'/><f4><string>AQID</string><string>BAUG</string><null/></f4><f5><foo>AQID</foo><bar _type='null'/><_x0000_>BAUG</_x0000_></f5></_x0000_></f></object>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td><table><tr><td>f1</td><td>AQID</td></tr><tr><td>f2</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f3</td><td><null/></td></tr><tr><td>f4</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table></td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td><table><tr><td>f1</td><td>AQID</td></tr><tr><td>f2</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f3</td><td><null/></td></tr><tr><td>f4</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table></td></tr></table></td></tr></table>", "<table><tr><td>f</td><td><table><tr><td>foo</td><td><table><tr><td>f1</td><td>AQID</td></tr><tr><td>f2</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f3</td><td><null/></td></tr><tr><td>f4</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table></td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td><table><tr><td>f1</td><td>AQID</td></tr><tr><td>f2</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f3</td><td><null/></td></tr><tr><td>f4</td><td><ul><li>AQID</li><li>BAUG</li><li><null/></li></ul></td></tr><tr><td>f5</td><td><table><tr><td>foo</td><td>AQID</td></tr><tr><td>bar</td><td><null/></td></tr><tr><td><null/></td><td>BAUG</td></tr></table></td></tr></table></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f1</td>\n\t\t\t\t\t\t\t\t<td>AQID</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f2</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>AQID</li>\n\t\t\t\t\t\t\t\t\t\t<li>BAUG</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f3</td>\n\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f4</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>AQID</li>\n\t\t\t\t\t\t\t\t\t\t<li>BAUG</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f5</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>AQID</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t\t<td>BAUG</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f1</td>\n\t\t\t\t\t\t\t\t<td>AQID</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f2</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>AQID</li>\n\t\t\t\t\t\t\t\t\t\t<li>BAUG</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f3</td>\n\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f4</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>AQID</li>\n\t\t\t\t\t\t\t\t\t\t<li>BAUG</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>f5</td>\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>AQID</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>bar</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td><null/></td>\n\t\t\t\t\t\t\t\t\t\t\t<td>BAUG</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "(f=(foo=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),bar=null,null=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG))))", "(f=(foo=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),bar=null,null=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG))))", "(\n\tf=(\n\t\tfoo=(\n\t\t\tf1=AQID,\n\t\t\tf2=@(\n\t\t\t\tAQID,\n\t\t\t\tBAUG,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf3=null,\n\t\t\tf4=@(\n\t\t\t\tAQID,\n\t\t\t\tBAUG,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf5=(\n\t\t\t\tfoo=AQID,\n\t\t\t\tbar=null,\n\t\t\t\tnull=BAUG\n\t\t\t)\n\t\t),\n\t\tbar=null,\n\t\tnull=(\n\t\t\tf1=AQID,\n\t\t\tf2=@(\n\t\t\t\tAQID,\n\t\t\t\tBAUG,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf3=null,\n\t\t\tf4=@(\n\t\t\t\tAQID,\n\t\t\t\tBAUG,\n\t\t\t\tnull\n\t\t\t),\n\t\t\tf5=(\n\t\t\t\tfoo=AQID,\n\t\t\t\tbar=null,\n\t\t\t\tnull=BAUG\n\t\t\t)\n\t\t)\n\t)\n)", "f=(foo=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),bar=null,null=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)))", "f=(foo=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)),bar=null,null=(f1=AQID,f2=@(AQID,BAUG,null),f3=null,f4=@(AQID,BAUG,null),f5=(foo=AQID,bar=null,null=BAUG)))", "f=(\n\tfoo=(\n\t\tf1=AQID,\n\t\tf2=@(\n\t\t\tAQID,\n\t\t\tBAUG,\n\t\t\tnull\n\t\t),\n\t\tf3=null,\n\t\tf4=@(\n\t\t\tAQID,\n\t\t\tBAUG,\n\t\t\tnull\n\t\t),\n\t\tf5=(\n\t\t\tfoo=AQID,\n\t\t\tbar=null,\n\t\t\tnull=BAUG\n\t\t)\n\t),\n\tbar=null,\n\tnull=(\n\t\tf1=AQID,\n\t\tf2=@(\n\t\t\tAQID,\n\t\t\tBAUG,\n\t\t\tnull\n\t\t),\n\t\tf3=null,\n\t\tf4=@(\n\t\t\tAQID,\n\t\t\tBAUG,\n\t\t\tnull\n\t\t),\n\t\tf5=(\n\t\t\tfoo=AQID,\n\t\t\tbar=null,\n\t\t\tnull=BAUG\n\t\t)\n\t)\n)", "81A16683A3666F6F85A26631A441514944A2663293A441514944A442415547C0A26633C0A2663493A441514944A442415547C0A2663583A3666F6FA441514944A3626172C0C0A442415547A3626172C0C085A26631A441514944A2663293A441514944A442415547C0A26633C0A2663493A441514944A442415547C0A2663583A3666F6FA441514944A3626172C0C0A442415547", "81A16683A3666F6F85A26631A441514944A2663293A441514944A442415547C0A26633C0A2663493A441514944A442415547C0A2663583A3666F6FA441514944A3626172C0C0A442415547A3626172C0C085A26631A441514944A2663293A441514944A442415547C0A26633C0A2663493A441514944A442415547C0A2663583A3666F6FA441514944A3626172C0C0A442415547", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo rdf:parseType='Resource'>\n<jp:f1>AQID</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f5>\n</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_ rdf:parseType='Resource'>\n<jp:f1>AQID</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f5>\n</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f rdf:parseType='Resource'>\n<jp:foo rdf:parseType='Resource'>\n<jp:f1>AQID</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f5>\n</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_ rdf:parseType='Resource'>\n<jp:f1>AQID</jp:f1>\n<jp:f2>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f2>\n<jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:f4>\n<rdf:Seq>\n<rdf:li>AQID</rdf:li>\n<rdf:li>BAUG</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:f4>\n<jp:f5 rdf:parseType='Resource'>\n<jp:foo>AQID</jp:foo>\n<jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n<jp:_x0000_>BAUG</jp:_x0000_>\n</jp:f5>\n</jp:_x0000_>\n</jp:f>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f rdf:parseType='Resource'>\n      <jp:foo rdf:parseType='Resource'>\n        <jp:f1>AQID</jp:f1>\n        <jp:f2>\n          <rdf:Seq>\n            <rdf:li>AQID</rdf:li>\n            <rdf:li>BAUG</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f2>\n        <jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n        <jp:f4>\n          <rdf:Seq>\n            <rdf:li>AQID</rdf:li>\n            <rdf:li>BAUG</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f4>\n        <jp:f5 rdf:parseType='Resource'>\n          <jp:foo>AQID</jp:foo>\n          <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          <jp:_x0000_>BAUG</jp:_x0000_>\n        </jp:f5>\n      </jp:foo>\n      <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      <jp:_x0000_ rdf:parseType='Resource'>\n        <jp:f1>AQID</jp:f1>\n        <jp:f2>\n          <rdf:Seq>\n            <rdf:li>AQID</rdf:li>\n            <rdf:li>BAUG</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f2>\n        <jp:f3 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n        <jp:f4>\n          <rdf:Seq>\n            <rdf:li>AQID</rdf:li>\n            <rdf:li>BAUG</rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </jp:f4>\n        <jp:f5 rdf:parseType='Resource'>\n          <jp:foo>AQID</jp:foo>\n          <jp:bar rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          <jp:_x0000_>BAUG</jp:_x0000_>\n        </jp:f5>\n      </jp:_x0000_>\n    </jp:f>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithByteArrayBeanMapField o) {
                TestUtils.assertInstanceOf(BeanWithByteArrayBeanMapField.class, o);
            }
        }});
    }

    public ByteArrayBase64SwapComboTest(ComboInput<?> comboInput) {
        super(comboInput);
    }

    @Override
    protected Serializer applySettings(Serializer s) throws Exception {
        return s.builder().pojoSwaps(new Class[]{ByteArraySwap.Base64.class}).trimNullProperties(false).build();
    }

    @Override
    protected Parser applySettings(Parser p) throws Exception {
        return p.builder().pojoSwaps(new Class[]{ByteArraySwap.Base64.class}).build();
    }

    public static class B {
        public byte[] f1;
        public byte[][] f2;
        public byte[] f3;
        public List<byte[]> f4;
        public Map<String, byte[]> f5;

        public B init() {
            this.f1 = new byte[]{1, 2, 3};
            this.f2 = new byte[][]{{1, 2, 3}, {4, 5, 6}, null};
            this.f3 = null;
            this.f4 = new AList().append((Object)new byte[]{1, 2, 3}).append((Object)new byte[]{4, 5, 6}).append(null);
            this.f5 = new AMap().append((Object)"foo", (Object)new byte[]{1, 2, 3}).append((Object)"bar", null).append(null, (Object)new byte[]{4, 5, 6});
            return this;
        }
    }

    public static class BeanWithByteArrayBeanMapField {
        public Map<String, B> f;

        public BeanWithByteArrayBeanMapField init() {
            this.f = new AMap().append((Object)"foo", (Object)new B().init()).append((Object)"bar", null).append(null, (Object)new B().init());
            return this;
        }
    }

    public static class BeanWithByteArrayBeanListField {
        public List<B> f;

        public BeanWithByteArrayBeanListField init() {
            this.f = new AList().append((Object)new B().init()).append(null);
            return this;
        }
    }

    public static class BeanWithByteArrayMapField {
        public Map<String, byte[]> f;

        public BeanWithByteArrayMapField init() {
            this.f = new AMap().append((Object)"foo", (Object)new byte[]{1, 2, 3}).append((Object)"bar", null).append(null, (Object)new byte[]{4, 5, 6});
            return this;
        }
    }

    public static class BeanWithByteArrayListField {
        public List<byte[]> f;

        public BeanWithByteArrayListField init() {
            this.f = new AList().append((Object)new byte[]{1, 2, 3}).append((Object)new byte[]{4, 5, 6}).append(null);
            return this;
        }
    }

    public static class BeanWithByteArrayNullField {
        public byte[] f;

        public BeanWithByteArrayNullField init() {
            this.f = null;
            return this;
        }
    }

    public static class BeanWithByteArray2dField {
        public byte[][] f;

        public BeanWithByteArray2dField init() {
            this.f = new byte[][]{{1, 2, 3}, {4, 5, 6}, null};
            return this;
        }
    }

    public static class BeanWithByteArrayField {
        public byte[] f;

        public BeanWithByteArrayField init() {
            this.f = new byte[]{1, 2, 3};
            return this;
        }
    }
}

