/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboRoundTripTest;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.Builder;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BuilderComboTest
extends ComboRoundTripTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new ComboInput<A>("A", A.class, new A(null).init(), "{a:1}", "{a:1}", "{\n\ta: 1\n}", "<object><a>1</a></object>", "<object><a>1</a></object>", "<object>\n\t<a>1</a>\n</object>\n", "<object><a>1</a></object>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(a=1)", "(a=1)", "(\n\ta=1\n)", "a=1", "a=1", "a=1", "81A16101", "81A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(A o) {
                TestUtils.assertInstanceOf(A.class, o);
                Assert.assertTrue((boolean)o.createdByBuilder);
            }
        }}, {new ComboInput<B>("B", B.class, new B(null).init(), "{a:1}", "{a:1}", "{\n\ta: 1\n}", "<object><a>1</a></object>", "<object><a>1</a></object>", "<object>\n\t<a>1</a>\n</object>\n", "<object><a>1</a></object>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(a=1)", "(a=1)", "(\n\ta=1\n)", "a=1", "a=1", "a=1", "81A16101", "81A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(B o) {
                TestUtils.assertInstanceOf(B.class, o);
                Assert.assertTrue((boolean)o.createdByBuilder);
            }
        }}, {new ComboInput<C>("C", C.class, new C(null).init(), "{a:1}", "{a:1}", "{\n\ta: 1\n}", "<object><a>1</a></object>", "<object><a>1</a></object>", "<object>\n\t<a>1</a>\n</object>\n", "<object><a>1</a></object>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(a=1)", "(a=1)", "(\n\ta=1\n)", "a=1", "a=1", "a=1", "81A16101", "81A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(C o) {
                TestUtils.assertInstanceOf(C.class, o);
                Assert.assertTrue((boolean)o.createdByBuilder);
            }
        }}, {new ComboInput<D>("D", D.class, new D(null).init(), "{a:1}", "{a:1}", "{\n\ta: 1\n}", "<object><a>1</a></object>", "<object><a>1</a></object>", "<object>\n\t<a>1</a>\n</object>\n", "<object><a>1</a></object>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(a=1)", "(a=1)", "(\n\ta=1\n)", "a=1", "a=1", "a=1", "81A16101", "81A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(D o) {
                TestUtils.assertInstanceOf(D.class, o);
                Assert.assertTrue((boolean)o.createdByBuilder);
            }
        }}, {new ComboInput<E>("E", E.class, new E(null).init(), "{a:1}", "{a:1}", "{\n\ta: 1\n}", "<object><a>1</a></object>", "<object><a>1</a></object>", "<object>\n\t<a>1</a>\n</object>\n", "<object><a>1</a></object>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table><tr><td>a</td><td>1</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(a=1)", "(a=1)", "(\n\ta=1\n)", "a=1", "a=1", "a=1", "81A16101", "81A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(E o) {
                TestUtils.assertInstanceOf(E.class, o);
                Assert.assertTrue((boolean)o.createdByBuilder);
            }
        }}, {new ComboInput<H>("H", H.class, new H(null).init(), "{fooBar:1}", "{fooBar:1}", "{\n\tfooBar: 1\n}", "<object><fooBar>1</fooBar></object>", "<object><fooBar>1</fooBar></object>", "<object>\n\t<fooBar>1</fooBar>\n</object>\n", "<object><fooBar>1</fooBar></object>", "<table><tr><td>fooBar</td><td>1</td></tr></table>", "<table><tr><td>fooBar</td><td>1</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>fooBar</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(fooBar=1)", "(fooBar=1)", "(\n\tfooBar=1\n)", "fooBar=1", "fooBar=1", "fooBar=1", "81A6666F6F42617201", "81A6666F6F42617201", "<rdf:RDF>\n<rdf:Description>\n<jp:fooBar>1</jp:fooBar>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:fooBar>1</jp:fooBar>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:fooBar>1</jp:fooBar>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(H o) {
                TestUtils.assertInstanceOf(H.class, o);
                Assert.assertTrue((boolean)o.createdByBuilder);
            }
        }});
    }

    public BuilderComboTest(ComboInput<?> comboInput) {
        super(comboInput);
    }

    @Override
    protected Serializer applySettings(Serializer s) throws Exception {
        return s.builder().trimNullProperties(false).build();
    }

    @Override
    protected Parser applySettings(Parser p) throws Exception {
        return p.builder().build();
    }

    public static class HBuilder {
        private int fooBar;

        public H build() {
            H x = new H(this);
            x.createdByBuilder = true;
            return x;
        }

        @Beanp
        public HBuilder fooBar(int fooBar) {
            this.fooBar = fooBar;
            return this;
        }
    }

    public static class H {
        public int fooBar;
        boolean createdByBuilder;

        private H(HBuilder x) {
            if (x != null) {
                this.fooBar = x.fooBar;
            }
        }

        public H init() {
            this.fooBar = 1;
            return this;
        }

        public static HBuilder create() {
            return new HBuilder();
        }
    }

    public static class EBuilder {
        public int a;

        public E build() {
            E x = new E(this);
            x.createdByBuilder = true;
            return x;
        }
    }

    @org.apache.juneau.annotation.Builder(value=EBuilder.class)
    public static class E {
        public int a;
        boolean createdByBuilder;

        public E(EBuilder x) {
            if (x != null) {
                this.a = x.a;
            }
        }

        public E init() {
            this.a = 1;
            return this;
        }
    }

    public static class DBuilder {
        public int a;
    }

    @org.apache.juneau.annotation.Builder(value=DBuilder.class)
    public static class D {
        public int a;
        boolean createdByBuilder;

        public D(DBuilder x) {
            if (x != null) {
                this.a = x.a;
                this.createdByBuilder = true;
            }
        }

        public D init() {
            this.a = 1;
            return this;
        }
    }

    public static class CBuilder
    implements Builder<B> {
        public int a;

        public C build() {
            C x = new C(this);
            x.createdByBuilder = true;
            return x;
        }
    }

    public static class C {
        public int a;
        boolean createdByBuilder;

        public C(CBuilder x) {
            if (x != null) {
                this.a = x.a;
            }
        }

        public C init() {
            this.a = 1;
            return this;
        }
    }

    public static class BBuilder
    implements Builder<B> {
        public int a;
    }

    public static class B {
        public int a;
        boolean createdByBuilder;

        public B(BBuilder x) {
            if (x != null) {
                this.a = x.a;
                this.createdByBuilder = true;
            }
        }

        public B init() {
            this.a = 1;
            return this;
        }
    }

    public static class ABuilder {
        public int a;

        public A build() {
            A x = new A(this);
            x.createdByBuilder = true;
            return x;
        }
    }

    public static class A {
        public int a;
        boolean createdByBuilder;

        private A(ABuilder x) {
            if (x != null) {
                this.a = x.a;
            }
        }

        public A init() {
            this.a = 1;
            return this;
        }

        public static ABuilder create() {
            return new ABuilder();
        }
    }
}

