/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.transform.MapSwap;
import org.apache.juneau.transforms.ByteArraySwap;
import org.junit.Assert;
import org.junit.Test;

public class BeanMapTest {
    @Test
    public void testFilteredEntry() throws Exception {
        BeanSession session = BeanContext.create().pojoSwaps(new Class[]{ByteArraySwap.Base64.class}).build().createSession();
        BeanMap m = session.toBeanMap((Object)new A());
        Assert.assertEquals((Object)"AQID", (Object)m.get((Object)"f1"));
        m.put("f1", (Object)"BAUG");
        Assert.assertEquals((Object)"BAUG", (Object)m.get((Object)"f1"));
        Assert.assertEquals((long)4L, (long)((A)m.getBean()).f1[0]);
        Assert.assertNull((Object)m.get((Object)"f3"));
    }

    @Test
    public void testFilteredEntryWithMultipleMatchingFilters() throws Exception {
        BeanSession session = BeanContext.create().pojoSwaps(new Class[]{B2Swap.class, B1Swap.class}).build().createSession();
        BeanMap bm = session.toBeanMap((Object)B.create());
        ObjectMap om = (ObjectMap)bm.get((Object)"b1");
        Assert.assertEquals((Object)"b2", (Object)om.getString("type"));
        session = BeanContext.create().pojoSwaps(new Class[]{B1Swap.class, B2Swap.class}).build().createSession();
        bm = session.toBeanMap((Object)B.create());
        om = (ObjectMap)bm.get((Object)"b1");
        Assert.assertEquals((Object)"b1", (Object)om.getString("type"));
    }

    public static class B2Swap
    extends MapSwap<B2> {
        public ObjectMap swap(BeanSession session, B2 b2) {
            return new ObjectMap().append("type", (Object)"b2").append("f1", (Object)b2.f1);
        }
    }

    public static class B1Swap
    extends MapSwap<B1> {
        public ObjectMap swap(BeanSession session, B1 b1) {
            return new ObjectMap().append("type", (Object)"b1").append("f1", (Object)b1.f1);
        }
    }

    public static class B2
    extends B1 {
        public String f2;
    }

    public static class B1 {
        public String f1;
    }

    public static class B {
        public B1 b1;

        static B create() {
            B b = new B();
            B2 b2 = new B2();
            b2.f1 = "f1";
            b2.f2 = "f2";
            b.b1 = b2;
            return b;
        }
    }

    public static class A {
        public byte[] f1 = new byte[]{1, 2, 3};
        public byte[] f3 = null;
    }
}

