/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BeanFilterTest {
    @Test
    public void testInterfaceBeanFilters() throws Exception {
        BeanSession session = BeanContext.create().beanFilters(new Class[]{A1.class}).build().createSession();
        BeanMap bm = session.newBeanMap(A3.class);
        Assert.assertEquals((Object)"f1", (Object)bm.get((Object)"f1"));
        Assert.assertNull((Object)bm.get((Object)"f2"));
        Assert.assertNull((Object)bm.get((Object)"f3"));
        session = BeanContext.create().beanFilters(new Class[]{A2.class}).build().createSession();
        bm = session.newBeanMap(A3.class);
        Assert.assertEquals((Object)"f1", (Object)bm.get((Object)"f1"));
        Assert.assertEquals((Object)"f2", (Object)bm.get((Object)"f2"));
        Assert.assertNull((Object)bm.get((Object)"f3"));
    }

    @Test
    public void testAbstractClassBeanFilters() throws Exception {
        BeanSession session = BeanContext.create().beanFilters(new Class[]{B1.class}).build().createSession();
        BeanMap bm = session.newBeanMap(Test2.class);
        Assert.assertEquals((Object)"f1", (Object)bm.get((Object)"f1"));
        Assert.assertNull((Object)bm.get((Object)"f2"));
        Assert.assertNull((Object)bm.get((Object)"f3"));
        session = BeanContext.create().beanFilters(new Class[]{B2.class}).build().createSession();
        bm = session.newBeanMap(Test2.class);
        Assert.assertEquals((Object)"f1", (Object)bm.get((Object)"f1"));
        Assert.assertEquals((Object)"f2", (Object)bm.get((Object)"f2"));
        Assert.assertNull((Object)bm.get((Object)"f3"));
    }

    @Test
    public void testFilteredWithStopClass() throws Exception {
        C3 c3 = new C3();
        TestUtils.assertObjectEquals("{f3:3,p3:3}", c3);
    }

    @Test
    public void testFilterWithStopClassOnParentClass() throws Exception {
        D3 d3 = new D3();
        TestUtils.assertObjectEquals("{f3:3,p3:3}", d3);
    }

    @Test
    public void testFilteredWithStopClassOnParentClassWithOverriddenAnnotation() throws Exception {
        E3 e3 = new E3();
        TestUtils.assertObjectEquals("{f3:3,p3:3}", e3);
    }

    @Test
    public void testFilteredWithStopClassesAtMulitpleLevels() throws Exception {
        F3 e3 = new F3();
        TestUtils.assertObjectEquals("{f3:3,p3:3}", e3);
    }

    @Bean(stopClass=F2.class)
    public class F3
    extends F2 {
        public int f3;

        public F3() {
            this.f3 = 3;
        }

        public int getP3() {
            return 3;
        }
    }

    public class F2
    extends F1 {
        public int f2;

        public F2() {
            this.f2 = 2;
        }

        public int getP2() {
            return 2;
        }
    }

    @Bean(stopClass=F1.class)
    public class F1 {
        public int f1 = 1;

        public int getP1() {
            return 1;
        }
    }

    @Bean(bpx="foo")
    public class E3
    extends E2 {
        public int f3;

        public E3() {
            this.f3 = 3;
        }

        public int getP3() {
            return 3;
        }
    }

    @Bean(stopClass=E2.class)
    public class E2
    extends E1 {
        public int f2;

        public E2() {
            this.f2 = 2;
        }

        public int getP2() {
            return 2;
        }
    }

    public class E1 {
        public int f1 = 1;

        public int getP1() {
            return 1;
        }
    }

    public class D3
    extends D2 {
        public int f3;

        public D3() {
            this.f3 = 3;
        }

        public int getP3() {
            return 3;
        }
    }

    @Bean(stopClass=D2.class)
    public class D2
    extends D1 {
        public int f2;

        public D2() {
            this.f2 = 2;
        }

        public int getP2() {
            return 2;
        }
    }

    public class D1 {
        public int f1 = 1;

        public int getP1() {
            return 1;
        }
    }

    @Bean(stopClass=C2.class)
    public class C3
    extends C2 {
        public int f3;

        public C3() {
            this.f3 = 3;
        }

        public int getP3() {
            return 3;
        }
    }

    public class C2
    extends C1 {
        public int f2;

        public C2() {
            this.f2 = 2;
        }

        public int getP2() {
            return 2;
        }
    }

    public class C1 {
        public int f1 = 1;

        public int getP1() {
            return 1;
        }
    }

    public static class Test2
    extends B2 {
        @Override
        public String getF1() {
            return "f1";
        }

        @Override
        public String getF2() {
            return "f2";
        }

        public String getF3() {
            return "f3";
        }
    }

    public static abstract class B2
    extends B1 {
        @Override
        public abstract String getF1();

        public abstract String getF2();
    }

    public static abstract class B1 {
        public abstract String getF1();
    }

    public static class A3
    implements A2 {
        @Override
        public String getF1() {
            return "f1";
        }

        @Override
        public String getF2() {
            return "f2";
        }

        public String getF3() {
            return "f3";
        }
    }

    public static interface A2
    extends A1 {
        public String getF2();
    }

    public static interface A1 {
        public String getF1();
    }
}

