/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboRoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BeanDictionaryComboTest
extends ComboRoundTripTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new ComboInput<A>("A", A.class, new A().init(), "{_type:'A',a:1}", "{t:'A',a:1}", "{\n\t_type: 'A',\n\ta: 1\n}", "<A><a>1</a></A>", "<A><a>1</a></A>", "<A>\n\t<a>1</a>\n</A>\n", "<A><a>1</a></A>", "<table _type='A'><tr><td>a</td><td>1</td></tr></table>", "<table t='A'><tr><td>a</td><td>1</td></tr></table>", "<table _type='A'>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(_type=A,a=1)", "(t=A,a=1)", "(\n\t_type=A,\n\ta=1\n)", "_type=A&a=1", "t=A&a=1", "_type=A\n&a=1", "82A55F74797065A141A16101", "82A174A141A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:_type>A</jp:_type>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(A o) {
                TestUtils.assertInstanceOf(A.class, o);
            }
        }}, {new ComboInput<A[]>("A[]", A[].class, new A[]{new A().init()}, "[{_type:'A',a:1}]", "[{t:'A',a:1}]", "[\n\t{\n\t\t_type: 'A',\n\t\ta: 1\n\t}\n]", "<array><A><a>1</a></A></array>", "<array><A><a>1</a></A></array>", "<array>\n\t<A>\n\t\t<a>1</a>\n\t</A>\n</array>\n", "<array><A><a>1</a></A></array>", "<table _type='array'><tr><th>a</th></tr><tr _type='A'><td>1</td></tr></table>", "<table t='array'><tr><th>a</th></tr><tr t='A'><td>1</td></tr></table>", "<table _type='array'>\n\t<tr>\n\t\t<th>a</th>\n\t</tr>\n\t<tr _type='A'>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "@((_type=A,a=1))", "@((t=A,a=1))", "@(\n\t(\n\t\t_type=A,\n\t\ta=1\n\t)\n)", "0=(_type=A,a=1)", "0=(t=A,a=1)", "0=(\n\t_type=A,\n\ta=1\n)", "9182A55F74797065A141A16101", "9182A174A141A16101", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li rdf:parseType='Resource'>\n      <jp:_type>A</jp:_type>\n      <jp:a>1</jp:a>\n    </rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(A[] o) {
                TestUtils.assertInstanceOf(A.class, o[0]);
            }
        }}, {new ComboInput<A[][][]>("A[][][]", A[][][].class, (A[][][])new A[][][]{{{new A().init(), null}, null}, null}, "[[[{_type:'A',a:1},null],null],null]", "[[[{t:'A',a:1},null],null],null]", "[\n\t[\n\t\t[\n\t\t\t{\n\t\t\t\t_type: 'A',\n\t\t\t\ta: 1\n\t\t\t},\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array>", "<array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<A>\n\t\t\t\t<a>1</a>\n\t\t\t</A>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@((_type=A,a=1),null),null),null)", "@(@(@((t=A,a=1),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\t_type=A,\n\t\t\t\ta=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@((_type=A,a=1),null),null)&1=null", "0=@(@((t=A,a=1),null),null)&1=null", "0=@(\n\t@(\n\t\t(\n\t\t\t_type=A,\n\t\t\ta=1\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "92929282A55F74797065A141A16101C0C0C0", "92929282A174A141A16101C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li rdf:parseType='Resource'>\n              <jp:_type>A</jp:_type>\n              <jp:a>1</jp:a>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(A[][][] o) {
                TestUtils.assertInstanceOf(A.class, o[0][0][0]);
            }
        }}, {new ComboInput<List<A[][][]>>("List<A[][][]>", TestUtils.getType(List.class, new Type[]{A[][][].class}), (List)new AList().append((Object)new A[][][]{{{new A().init(), null}, null}, null}).append(null), "[[[[{_type:'A',a:1},null],null],null],null]", "[[[[{t:'A',a:1},null],null],null],null]", "[\n\t[\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\t_type: 'A',\n\t\t\t\t\ta: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></array>", "<array><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<A>\n\t\t\t\t\t<a>1</a>\n\t\t\t\t</A>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t</ul>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@(@((_type=A,a=1),null),null),null),null)", "@(@(@(@((t=A,a=1),null),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\t_type=A,\n\t\t\t\t\ta=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@(@((_type=A,a=1),null),null),null)&1=null", "0=@(@(@((t=A,a=1),null),null),null)&1=null", "0=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\t_type=A,\n\t\t\t\ta=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "9292929282A55F74797065A141A16101C0C0C0C0", "9292929282A174A141A16101C0C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:_type>A</jp:_type>\n                  <jp:a>1</jp:a>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(List<A[][][]> o) {
                TestUtils.assertInstanceOf(A.class, o.get(0)[0][0][0]);
            }
        }}, {new ComboInput<Map<String, A[][][]>>("Map<String,A[][][]>", TestUtils.getType(Map.class, new Type[]{String.class, A[][][].class}), (Map)new AMap().append((Object)"x", (Object)new A[][][]{{{new A().init(), null}, null}, null}), "{x:[[[{_type:'A',a:1},null],null],null]}", "{x:[[[{t:'A',a:1},null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\t_type: 'A',\n\t\t\t\t\ta: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><A><a>1</a></A><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><A><a>1</a></A><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<A>\n\t\t\t\t\t<a>1</a>\n\t\t\t\t</A>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><A><a>1</a></A><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@((_type=A,a=1),null),null),null))", "(x=@(@(@((t=A,a=1),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\t_type=A,\n\t\t\t\t\ta=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@((_type=A,a=1),null),null),null)", "x=@(@(@((t=A,a=1),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\t_type=A,\n\t\t\t\ta=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A17892929282A55F74797065A141A16101C0C0C0", "81A17892929282A174A141A16101C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:_type>A</jp:_type>\n                  <jp:a>1</jp:a>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, A[][][]> o) {
                TestUtils.assertInstanceOf(A.class, o.get("x")[0][0][0]);
            }
        }}, {new ComboInput<Map<String, List<A[][][]>>>("Map<String,List<A[][][]>>", TestUtils.getType(Map.class, new Type[]{String.class, List.class, A[][][].class}), (Map)new AMap().append((Object)"x", (Object)new AList().append((Object)new A[][][]{{{new A().init(), null}, null}, null}).append(null)), "{x:[[[[{_type:'A',a:1},null],null],null],null]}", "{x:[[[[{t:'A',a:1},null],null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t[\n\t\t\t\t\t{\n\t\t\t\t\t\t_type: 'A',\n\t\t\t\t\t\ta: 1\n\t\t\t\t\t},\n\t\t\t\t\tnull\n\t\t\t\t],\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<array>\n\t\t\t\t\t<A>\n\t\t\t\t\t\t<a>1</a>\n\t\t\t\t\t</A>\n\t\t\t\t\t<null/>\n\t\t\t\t</array>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@(@((_type=A,a=1),null),null),null),null))", "(x=@(@(@(@((t=A,a=1),null),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t@(\n\t\t\t\t\t(\n\t\t\t\t\t\t_type=A,\n\t\t\t\t\t\ta=1\n\t\t\t\t\t),\n\t\t\t\t\tnull\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@(@((_type=A,a=1),null),null),null),null)", "x=@(@(@(@((t=A,a=1),null),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\t_type=A,\n\t\t\t\t\ta=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A1789292929282A55F74797065A141A16101C0C0C0C0", "81A1789292929282A174A141A16101C0C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType='Resource'>\n                      <jp:_type>A</jp:_type>\n                      <jp:a>1</jp:a>\n                    </rdf:li>\n                    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n                  </rdf:Seq>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, List<A[][][]>> o) {
                TestUtils.assertInstanceOf(A.class, o.get("x").get(0)[0][0][0]);
            }
        }}, {new ComboInput<IA>("IA", IA.class, (IA)new A().init(), "{_type:'A',a:1}", "{t:'A',a:1}", "{\n\t_type: 'A',\n\ta: 1\n}", "<A><a>1</a></A>", "<A><a>1</a></A>", "<A>\n\t<a>1</a>\n</A>\n", "<A><a>1</a></A>", "<table _type='A'><tr><td>a</td><td>1</td></tr></table>", "<table t='A'><tr><td>a</td><td>1</td></tr></table>", "<table _type='A'>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(_type=A,a=1)", "(t=A,a=1)", "(\n\t_type=A,\n\ta=1\n)", "_type=A&a=1", "t=A&a=1", "_type=A\n&a=1", "82A55F74797065A141A16101", "82A174A141A16101", "<rdf:RDF>\n<rdf:Description>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:_type>A</jp:_type>\n    <jp:a>1</jp:a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(IA o) {
                TestUtils.assertInstanceOf(A.class, o);
            }
        }}, {new ComboInput<IA[]>("IA[]", IA[].class, new IA[]{new A().init()}, "[{_type:'A',a:1}]", "[{t:'A',a:1}]", "[\n\t{\n\t\t_type: 'A',\n\t\ta: 1\n\t}\n]", "<array><A><a>1</a></A></array>", "<array><A><a>1</a></A></array>", "<array>\n\t<A>\n\t\t<a>1</a>\n\t</A>\n</array>\n", "<array><A><a>1</a></A></array>", "<table _type='array'><tr><th>a</th></tr><tr _type='A'><td>1</td></tr></table>", "<table t='array'><tr><th>a</th></tr><tr t='A'><td>1</td></tr></table>", "<table _type='array'>\n\t<tr>\n\t\t<th>a</th>\n\t</tr>\n\t<tr _type='A'>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "@((_type=A,a=1))", "@((t=A,a=1))", "@(\n\t(\n\t\t_type=A,\n\t\ta=1\n\t)\n)", "0=(_type=A,a=1)", "0=(t=A,a=1)", "0=(\n\t_type=A,\n\ta=1\n)", "9182A55F74797065A141A16101", "9182A174A141A16101", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li rdf:parseType='Resource'>\n      <jp:_type>A</jp:_type>\n      <jp:a>1</jp:a>\n    </rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(IA[] o) {
                TestUtils.assertInstanceOf(A.class, o[0]);
            }
        }}, {new ComboInput<IA[][][]>("IA[][][]", IA[][][].class, (IA[][][])new IA[][][]{{{new A().init(), null}, null}, null}, "[[[{_type:'A',a:1},null],null],null]", "[[[{t:'A',a:1},null],null],null]", "[\n\t[\n\t\t[\n\t\t\t{\n\t\t\t\t_type: 'A',\n\t\t\t\ta: 1\n\t\t\t},\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array>", "<array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<A>\n\t\t\t\t<a>1</a>\n\t\t\t</A>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@((_type=A,a=1),null),null),null)", "@(@(@((t=A,a=1),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\t_type=A,\n\t\t\t\ta=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@((_type=A,a=1),null),null)&1=null", "0=@(@((t=A,a=1),null),null)&1=null", "0=@(\n\t@(\n\t\t(\n\t\t\t_type=A,\n\t\t\ta=1\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "92929282A55F74797065A141A16101C0C0C0", "92929282A174A141A16101C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li rdf:parseType='Resource'>\n              <jp:_type>A</jp:_type>\n              <jp:a>1</jp:a>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(IA[][][] o) {
                TestUtils.assertInstanceOf(A.class, o[0][0][0]);
            }
        }}, {new ComboInput<List<IA[][][]>>("List<IA[][][]>", TestUtils.getType(List.class, new Type[]{IA[][][].class}), (List)new AList().append((Object)new IA[][][]{{{new A().init(), null}, null}, null}).append(null), "[[[[{_type:'A',a:1},null],null],null],null]", "[[[[{t:'A',a:1},null],null],null],null]", "[\n\t[\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\t_type: 'A',\n\t\t\t\t\ta: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></array>", "<array><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<A>\n\t\t\t\t\t<a>1</a>\n\t\t\t\t</A>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t</ul>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@(@((_type=A,a=1),null),null),null),null)", "@(@(@(@((t=A,a=1),null),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\t_type=A,\n\t\t\t\t\ta=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@(@((_type=A,a=1),null),null),null)&1=null", "0=@(@(@((t=A,a=1),null),null),null)&1=null", "0=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\t_type=A,\n\t\t\t\ta=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "9292929282A55F74797065A141A16101C0C0C0C0", "9292929282A174A141A16101C0C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:_type>A</jp:_type>\n                  <jp:a>1</jp:a>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(List<IA[][][]> o) {
                TestUtils.assertInstanceOf(A.class, o.get(0)[0][0][0]);
            }
        }}, {new ComboInput<Map<String, IA[][][]>>("Map<String,IA[][][]>", TestUtils.getType(Map.class, new Type[]{String.class, IA[][][].class}), (Map)new AMap().append((Object)"x", (Object)new IA[][][]{{{new A().init(), null}, null}, null}), "{x:[[[{_type:'A',a:1},null],null],null]}", "{x:[[[{t:'A',a:1},null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\t_type: 'A',\n\t\t\t\t\ta: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><A><a>1</a></A><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><A><a>1</a></A><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<A>\n\t\t\t\t\t<a>1</a>\n\t\t\t\t</A>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><A><a>1</a></A><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@((_type=A,a=1),null),null),null))", "(x=@(@(@((t=A,a=1),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\t_type=A,\n\t\t\t\t\ta=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@((_type=A,a=1),null),null),null)", "x=@(@(@((t=A,a=1),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\t_type=A,\n\t\t\t\ta=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A17892929282A55F74797065A141A16101C0C0C0", "81A17892929282A174A141A16101C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:_type>A</jp:_type>\n                  <jp:a>1</jp:a>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, IA[][][]> o) {
                TestUtils.assertInstanceOf(A.class, o.get("x")[0][0][0]);
            }
        }}, {new ComboInput<Map<String, List<IA[][][]>>>("Map<String,List<IA[][][]>>", TestUtils.getType(Map.class, new Type[]{String.class, List.class, IA[][][].class}), (Map)new AMap().append((Object)"x", (Object)new AList().append((Object)new IA[][][]{{{new A().init(), null}, null}, null}).append(null)), "{x:[[[[{_type:'A',a:1},null],null],null],null]}", "{x:[[[[{t:'A',a:1},null],null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t[\n\t\t\t\t\t{\n\t\t\t\t\t\t_type: 'A',\n\t\t\t\t\t\ta: 1\n\t\t\t\t\t},\n\t\t\t\t\tnull\n\t\t\t\t],\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<array>\n\t\t\t\t\t<A>\n\t\t\t\t\t\t<a>1</a>\n\t\t\t\t\t</A>\n\t\t\t\t\t<null/>\n\t\t\t\t</array>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><array><A><a>1</a></A><null/></array><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table _type='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table t='A'><tr><td>a</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@(@((_type=A,a=1),null),null),null),null))", "(x=@(@(@(@((t=A,a=1),null),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t@(\n\t\t\t\t\t(\n\t\t\t\t\t\t_type=A,\n\t\t\t\t\t\ta=1\n\t\t\t\t\t),\n\t\t\t\t\tnull\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@(@((_type=A,a=1),null),null),null),null)", "x=@(@(@(@((t=A,a=1),null),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\t_type=A,\n\t\t\t\t\ta=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A1789292929282A55F74797065A141A16101C0C0C0C0", "81A1789292929282A174A141A16101C0C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>A</jp:_type>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>A</jp:t>\n<jp:a>1</jp:a>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType='Resource'>\n                      <jp:_type>A</jp:_type>\n                      <jp:a>1</jp:a>\n                    </rdf:li>\n                    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n                  </rdf:Seq>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, List<IA[][][]>> o) {
                TestUtils.assertInstanceOf(A.class, o.get("x").get(0)[0][0][0]);
            }
        }}, {new ComboInput<B>("B", B.class, new B().init(), "{z:'B',b:1}", "{z:'B',b:1}", "{\n\tz: 'B',\n\tb: 1\n}", "<B><b>1</b></B>", "<B><b>1</b></B>", "<B>\n\t<b>1</b>\n</B>\n", "<B><b>1</b></B>", "<table z='B'><tr><td>b</td><td>1</td></tr></table>", "<table z='B'><tr><td>b</td><td>1</td></tr></table>", "<table z='B'>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(z=B,b=1)", "(z=B,b=1)", "(\n\tz=B,\n\tb=1\n)", "z=B&b=1", "z=B&b=1", "z=B\n&b=1", "82A17AA142A16201", "82A17AA142A16201", "<rdf:RDF>\n<rdf:Description>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:z>B</jp:z>\n    <jp:b>1</jp:b>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(B o) {
                TestUtils.assertInstanceOf(B.class, o);
            }
        }}, {new ComboInput<B[]>("B[]", B[].class, new B[]{new B().init()}, "[{z:'B',b:1}]", "[{z:'B',b:1}]", "[\n\t{\n\t\tz: 'B',\n\t\tb: 1\n\t}\n]", "<array><B><b>1</b></B></array>", "<array><B><b>1</b></B></array>", "<array>\n\t<B>\n\t\t<b>1</b>\n\t</B>\n</array>\n", "<array><B><b>1</b></B></array>", "<table _type='array'><tr><th>b</th></tr><tr z='B'><td>1</td></tr></table>", "<table t='array'><tr><th>b</th></tr><tr z='B'><td>1</td></tr></table>", "<table _type='array'>\n\t<tr>\n\t\t<th>b</th>\n\t</tr>\n\t<tr z='B'>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "@((z=B,b=1))", "@((z=B,b=1))", "@(\n\t(\n\t\tz=B,\n\t\tb=1\n\t)\n)", "0=(z=B,b=1)", "0=(z=B,b=1)", "0=(\n\tz=B,\n\tb=1\n)", "9182A17AA142A16201", "9182A17AA142A16201", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li rdf:parseType='Resource'>\n      <jp:z>B</jp:z>\n      <jp:b>1</jp:b>\n    </rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(B[] o) {
                TestUtils.assertInstanceOf(B.class, o[0]);
            }
        }}, {new ComboInput<B[][][]>("B[][][]", B[][][].class, (B[][][])new B[][][]{{{new B().init(), null}, null}, null}, "[[[{z:'B',b:1},null],null],null]", "[[[{z:'B',b:1},null],null],null]", "[\n\t[\n\t\t[\n\t\t\t{\n\t\t\t\tz: 'B',\n\t\t\t\tb: 1\n\t\t\t},\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array>", "<array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<B>\n\t\t\t\t<b>1</b>\n\t\t\t</B>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@((z=B,b=1),null),null),null)", "@(@(@((z=B,b=1),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\tz=B,\n\t\t\t\tb=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@((z=B,b=1),null),null)&1=null", "0=@(@((z=B,b=1),null),null)&1=null", "0=@(\n\t@(\n\t\t(\n\t\t\tz=B,\n\t\t\tb=1\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "92929282A17AA142A16201C0C0C0", "92929282A17AA142A16201C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li rdf:parseType='Resource'>\n              <jp:z>B</jp:z>\n              <jp:b>1</jp:b>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(B[][][] o) {
                TestUtils.assertInstanceOf(B.class, o[0][0][0]);
            }
        }}, {new ComboInput<List<B[][][]>>("List<B[][][]>", TestUtils.getType(List.class, new Type[]{B[][][].class}), (List)new AList().append((Object)new B[][][]{{{new B().init(), null}, null}, null}).append(null), "[[[[{z:'B',b:1},null],null],null],null]", "[[[[{z:'B',b:1},null],null],null],null]", "[\n\t[\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\tz: 'B',\n\t\t\t\t\tb: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></array>", "<array><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<B>\n\t\t\t\t\t<b>1</b>\n\t\t\t\t</B>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t</ul>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@(@((z=B,b=1),null),null),null),null)", "@(@(@(@((z=B,b=1),null),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\tz=B,\n\t\t\t\t\tb=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@(@((z=B,b=1),null),null),null)&1=null", "0=@(@(@((z=B,b=1),null),null),null)&1=null", "0=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\tz=B,\n\t\t\t\tb=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "9292929282A17AA142A16201C0C0C0C0", "9292929282A17AA142A16201C0C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:z>B</jp:z>\n                  <jp:b>1</jp:b>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(List<B[][][]> o) {
                TestUtils.assertInstanceOf(B.class, o.get(0)[0][0][0]);
            }
        }}, {new ComboInput<Map<String, B[][][]>>("Map<String,B[][][]>", TestUtils.getType(Map.class, new Type[]{String.class, B[][][].class}), (Map)new AMap().append((Object)"x", (Object)new B[][][]{{{new B().init(), null}, null}, null}), "{x:[[[{z:'B',b:1},null],null],null]}", "{x:[[[{z:'B',b:1},null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\tz: 'B',\n\t\t\t\t\tb: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><B><b>1</b></B><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><B><b>1</b></B><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<B>\n\t\t\t\t\t<b>1</b>\n\t\t\t\t</B>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><B><b>1</b></B><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@((z=B,b=1),null),null),null))", "(x=@(@(@((z=B,b=1),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\tz=B,\n\t\t\t\t\tb=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@((z=B,b=1),null),null),null)", "x=@(@(@((z=B,b=1),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\tz=B,\n\t\t\t\tb=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A17892929282A17AA142A16201C0C0C0", "81A17892929282A17AA142A16201C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:z>B</jp:z>\n                  <jp:b>1</jp:b>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, B[][][]> o) {
                TestUtils.assertInstanceOf(B.class, o.get("x")[0][0][0]);
            }
        }}, {new ComboInput<Map<String, List<B[][][]>>>("Map<String,List<B[][][]>>", TestUtils.getType(Map.class, new Type[]{String.class, List.class, B[][][].class}), (Map)new AMap().append((Object)"x", (Object)new AList().append((Object)new B[][][]{{{new B().init(), null}, null}, null}).append(null)), "{x:[[[[{z:'B',b:1},null],null],null],null]}", "{x:[[[[{z:'B',b:1},null],null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t[\n\t\t\t\t\t{\n\t\t\t\t\t\tz: 'B',\n\t\t\t\t\t\tb: 1\n\t\t\t\t\t},\n\t\t\t\t\tnull\n\t\t\t\t],\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<array>\n\t\t\t\t\t<B>\n\t\t\t\t\t\t<b>1</b>\n\t\t\t\t\t</B>\n\t\t\t\t\t<null/>\n\t\t\t\t</array>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@(@((z=B,b=1),null),null),null),null))", "(x=@(@(@(@((z=B,b=1),null),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t@(\n\t\t\t\t\t(\n\t\t\t\t\t\tz=B,\n\t\t\t\t\t\tb=1\n\t\t\t\t\t),\n\t\t\t\t\tnull\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@(@((z=B,b=1),null),null),null),null)", "x=@(@(@(@((z=B,b=1),null),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\tz=B,\n\t\t\t\t\tb=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A1789292929282A17AA142A16201C0C0C0C0", "81A1789292929282A17AA142A16201C0C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType='Resource'>\n                      <jp:z>B</jp:z>\n                      <jp:b>1</jp:b>\n                    </rdf:li>\n                    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n                  </rdf:Seq>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, List<B[][][]>> o) {
                TestUtils.assertInstanceOf(B.class, o.get("x").get(0)[0][0][0]);
            }
        }}, {new ComboInput<IB>("IB", IB.class, (IB)new B().init(), "{z:'B',b:1}", "{z:'B',b:1}", "{\n\tz: 'B',\n\tb: 1\n}", "<B><b>1</b></B>", "<B><b>1</b></B>", "<B>\n\t<b>1</b>\n</B>\n", "<B><b>1</b></B>", "<table z='B'><tr><td>b</td><td>1</td></tr></table>", "<table z='B'><tr><td>b</td><td>1</td></tr></table>", "<table z='B'>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "(z=B,b=1)", "(z=B,b=1)", "(\n\tz=B,\n\tb=1\n)", "z=B&b=1", "z=B&b=1", "z=B\n&b=1", "82A17AA142A16201", "82A17AA142A16201", "<rdf:RDF>\n<rdf:Description>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:z>B</jp:z>\n    <jp:b>1</jp:b>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(IB o) {
                TestUtils.assertInstanceOf(B.class, o);
            }
        }}, {new ComboInput<IB[]>("IB[]", IB[].class, new IB[]{new B().init()}, "[{z:'B',b:1}]", "[{z:'B',b:1}]", "[\n\t{\n\t\tz: 'B',\n\t\tb: 1\n\t}\n]", "<array><B><b>1</b></B></array>", "<array><B><b>1</b></B></array>", "<array>\n\t<B>\n\t\t<b>1</b>\n\t</B>\n</array>\n", "<array><B><b>1</b></B></array>", "<table _type='array'><tr><th>b</th></tr><tr z='B'><td>1</td></tr></table>", "<table t='array'><tr><th>b</th></tr><tr z='B'><td>1</td></tr></table>", "<table _type='array'>\n\t<tr>\n\t\t<th>b</th>\n\t</tr>\n\t<tr z='B'>\n\t\t<td>1</td>\n\t</tr>\n</table>\n", "@((z=B,b=1))", "@((z=B,b=1))", "@(\n\t(\n\t\tz=B,\n\t\tb=1\n\t)\n)", "0=(z=B,b=1)", "0=(z=B,b=1)", "0=(\n\tz=B,\n\tb=1\n)", "9182A17AA142A16201", "9182A17AA142A16201", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li rdf:parseType='Resource'>\n      <jp:z>B</jp:z>\n      <jp:b>1</jp:b>\n    </rdf:li>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(IB[] o) {
                TestUtils.assertInstanceOf(B.class, o[0]);
            }
        }}, {new ComboInput<IB[][][]>("IB[][][]", IB[][][].class, (IB[][][])new IB[][][]{{{new B().init(), null}, null}, null}, "[[[{z:'B',b:1},null],null],null]", "[[[{z:'B',b:1},null],null],null]", "[\n\t[\n\t\t[\n\t\t\t{\n\t\t\t\tz: 'B',\n\t\t\t\tb: 1\n\t\t\t},\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array>", "<array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<B>\n\t\t\t\t<b>1</b>\n\t\t\t</B>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@((z=B,b=1),null),null),null)", "@(@(@((z=B,b=1),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\tz=B,\n\t\t\t\tb=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@((z=B,b=1),null),null)&1=null", "0=@(@((z=B,b=1),null),null)&1=null", "0=@(\n\t@(\n\t\t(\n\t\t\tz=B,\n\t\t\tb=1\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "92929282A17AA142A16201C0C0C0", "92929282A17AA142A16201C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li rdf:parseType='Resource'>\n              <jp:z>B</jp:z>\n              <jp:b>1</jp:b>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(IB[][][] o) {
                TestUtils.assertInstanceOf(B.class, o[0][0][0]);
            }
        }}, {new ComboInput<List<IB[][][]>>("List<IB[][][]>", TestUtils.getType(List.class, new Type[]{IB[][][].class}), (List)new AList().append((Object)new IB[][][]{{{new B().init(), null}, null}, null}).append(null), "[[[[{z:'B',b:1},null],null],null],null]", "[[[[{z:'B',b:1},null],null],null],null]", "[\n\t[\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\tz: 'B',\n\t\t\t\t\tb: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t],\n\tnull\n]", "<array><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></array>", "<array><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></array>", "<array>\n\t<array>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<B>\n\t\t\t\t\t<b>1</b>\n\t\t\t\t</B>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</array>\n\t<null/>\n</array>\n", "<array><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></array>", "<ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\t<ul>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t</ul>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li><null/></li>\n\t\t\t\t</ul>\n\t\t\t</li>\n\t\t\t<li><null/></li>\n\t\t</ul>\n\t</li>\n\t<li><null/></li>\n</ul>\n", "@(@(@(@((z=B,b=1),null),null),null),null)", "@(@(@(@((z=B,b=1),null),null),null),null)", "@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\tz=B,\n\t\t\t\t\tb=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "0=@(@(@((z=B,b=1),null),null),null)&1=null", "0=@(@(@((z=B,b=1),null),null),null)&1=null", "0=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\tz=B,\n\t\t\t\tb=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)\n&1=null", "9292929282A17AA142A16201C0C0C0C0", "9292929282A17AA142A16201C0C0C0C0", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Seq>\n    <rdf:li>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:z>B</jp:z>\n                  <jp:b>1</jp:b>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </rdf:li>\n    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n  </rdf:Seq>\n</rdf:RDF>\n"){

            @Override
            public void verify(List<IB[][][]> o) {
                TestUtils.assertInstanceOf(B.class, o.get(0)[0][0][0]);
            }
        }}, {new ComboInput<Map<String, IB[][][]>>("Map<String,IB[][][]>", TestUtils.getType(Map.class, new Type[]{String.class, IB[][][].class}), (Map)new AMap().append((Object)"x", (Object)new IB[][][]{{{new B().init(), null}, null}, null}), "{x:[[[{z:'B',b:1},null],null],null]}", "{x:[[[{z:'B',b:1},null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t{\n\t\t\t\t\tz: 'B',\n\t\t\t\t\tb: 1\n\t\t\t\t},\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><B><b>1</b></B><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><B><b>1</b></B><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<B>\n\t\t\t\t\t<b>1</b>\n\t\t\t\t</B>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><B><b>1</b></B><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@((z=B,b=1),null),null),null))", "(x=@(@(@((z=B,b=1),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\tz=B,\n\t\t\t\t\tb=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@((z=B,b=1),null),null),null)", "x=@(@(@((z=B,b=1),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t(\n\t\t\t\tz=B,\n\t\t\t\tb=1\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A17892929282A17AA142A16201C0C0C0", "81A17892929282A17AA142A16201C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li rdf:parseType='Resource'>\n                  <jp:z>B</jp:z>\n                  <jp:b>1</jp:b>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, IB[][][]> o) {
                TestUtils.assertInstanceOf(B.class, o.get("x")[0][0][0]);
            }
        }}, {new ComboInput<Map<String, List<IB[][][]>>>("Map<String,List<IB[][][]>>", TestUtils.getType(Map.class, new Type[]{String.class, List.class, IB[][][].class}), (Map)new AMap().append((Object)"x", (Object)new AList().append((Object)new IB[][][]{{{new B().init(), null}, null}, null}).append(null)), "{x:[[[[{z:'B',b:1},null],null],null],null]}", "{x:[[[[{z:'B',b:1},null],null],null],null]}", "{\n\tx: [\n\t\t[\n\t\t\t[\n\t\t\t\t[\n\t\t\t\t\t{\n\t\t\t\t\t\tz: 'B',\n\t\t\t\t\t\tb: 1\n\t\t\t\t\t},\n\t\t\t\t\tnull\n\t\t\t\t],\n\t\t\t\tnull\n\t\t\t],\n\t\t\tnull\n\t\t],\n\t\tnull\n\t]\n}", "<object><x _type='array'><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></x></object>", "<object><x t='array'><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></x></object>", "<object>\n\t<x _type='array'>\n\t\t<array>\n\t\t\t<array>\n\t\t\t\t<array>\n\t\t\t\t\t<B>\n\t\t\t\t\t\t<b>1</b>\n\t\t\t\t\t</B>\n\t\t\t\t\t<null/>\n\t\t\t\t</array>\n\t\t\t\t<null/>\n\t\t\t</array>\n\t\t\t<null/>\n\t\t</array>\n\t\t<null/>\n\t</x>\n</object>\n", "<object><x _type='array'><array><array><array><B><b>1</b></B><null/></array><null/></array><null/></array><null/></x></object>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table><tr><td>x</td><td><ul><li><ul><li><ul><li><ul><li><table z='B'><tr><td>b</td><td>1</td></tr></table></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></li><li><null/></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>x</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t\t\t\t<li>\n\t\t\t\t\t\t\t\t\t\t\t<table z='B'>\n\t\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t\t<li><null/></li>\n\t\t\t\t\t</ul>\n\t\t\t\t</li>\n\t\t\t\t<li><null/></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(x=@(@(@(@((z=B,b=1),null),null),null),null))", "(x=@(@(@(@((z=B,b=1),null),null),null),null))", "(\n\tx=@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t@(\n\t\t\t\t\t(\n\t\t\t\t\t\tz=B,\n\t\t\t\t\t\tb=1\n\t\t\t\t\t),\n\t\t\t\t\tnull\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t)\n)", "x=@(@(@(@((z=B,b=1),null),null),null),null)", "x=@(@(@(@((z=B,b=1),null),null),null),null)", "x=@(\n\t@(\n\t\t@(\n\t\t\t@(\n\t\t\t\t(\n\t\t\t\t\tz=B,\n\t\t\t\t\tb=1\n\t\t\t\t),\n\t\t\t\tnull\n\t\t\t),\n\t\t\tnull\n\t\t),\n\t\tnull\n\t),\n\tnull\n)", "81A1789292929282A17AA142A16201C0C0C0C0", "81A1789292929282A17AA142A16201C0C0C0C0", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:x>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:z>B</jp:z>\n<jp:b>1</jp:b>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</rdf:li>\n<rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n</rdf:Seq>\n</jp:x>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:x>\n      <rdf:Seq>\n        <rdf:li>\n          <rdf:Seq>\n            <rdf:li>\n              <rdf:Seq>\n                <rdf:li>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType='Resource'>\n                      <jp:z>B</jp:z>\n                      <jp:b>1</jp:b>\n                    </rdf:li>\n                    <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n                  </rdf:Seq>\n                </rdf:li>\n                <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n              </rdf:Seq>\n            </rdf:li>\n            <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n          </rdf:Seq>\n        </rdf:li>\n        <rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n      </rdf:Seq>\n    </jp:x>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(Map<String, List<IB[][][]>> o) {
                TestUtils.assertInstanceOf(B.class, o.get("x").get(0)[0][0][0]);
            }
        }});
    }

    public BeanDictionaryComboTest(ComboInput<?> comboInput) {
        super(comboInput);
    }

    @Override
    protected Serializer applySettings(Serializer s) throws Exception {
        return s.builder().trimNullProperties(false).build();
    }

    @Override
    protected Parser applySettings(Parser p) throws Exception {
        return p.builder().build();
    }

    @Bean(typeName="B")
    public static class B
    implements IB {
        public int b;

        public B init() {
            this.b = 1;
            return this;
        }
    }

    @Bean(dictionary={B.class}, typePropertyName="z")
    public static interface IB {
    }

    @Bean(typeName="A")
    public static class A
    implements IA {
        public int a;

        public A init() {
            this.a = 1;
            return this;
        }
    }

    @Bean(dictionary={A.class})
    public static interface IA {
    }
}

