/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.AutoObjectSwap;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AutoObjectSwapTest {
    private static final Map<String, String> STRINGMAP = AMap.create().append((Object)"foo", (Object)"bar");
    private static final ObjectMap OBJECTMAP = new ObjectMap().append("foo", (Object)"bar");

    private static PojoSwap find(Class<?> c) {
        return AutoObjectSwap.find((BeanContext)BeanContext.DEFAULT, (ClassInfo)ClassInfo.of(c));
    }

    private static PojoSwap find(BeanContext bc, Class<?> c) {
        return AutoObjectSwap.find((BeanContext)bc, (ClassInfo)ClassInfo.of(c));
    }

    private static BeanContext bc(Class<?> applyAnnotations) {
        return BeanContext.DEFAULT.builder().applyAnnotations(new Class[]{applyAnnotations}).build();
    }

    @Test
    public void a01_swap_swap() throws Exception {
        TestUtils.assertObjectEquals("{foo:'bar'}", AutoObjectSwapTest.find(A01.class).swap(null, (Object)new A01()));
    }

    @Test
    public void a02_swap_toObject() throws Exception {
        TestUtils.assertObjectEquals("{foo:'bar'}", AutoObjectSwapTest.find(A02.class).swap(null, (Object)new A02()));
    }

    @Test(expected=SerializeException.class)
    public void a03_swap_serializeException() throws Exception {
        AutoObjectSwapTest.find(A03.class).swap(null, null);
    }

    @Test(expected=SerializeException.class)
    public void a04_swap_runtimeException() throws Exception {
        AutoObjectSwapTest.find(A04.class).swap(null, null);
    }

    @Test
    public void b01_unswap_unswap() throws Exception {
        Assert.assertNotNull((Object)AutoObjectSwapTest.find(B01.class).unswap(null, STRINGMAP, null));
    }

    @Test
    public void b02_unswap_create() throws Exception {
        Assert.assertNotNull((Object)AutoObjectSwapTest.find(B02.class).unswap(null, (Object)OBJECTMAP, null));
    }

    @Test
    public void b03_unswap_fromObject() throws Exception {
        Assert.assertNotNull((Object)AutoObjectSwapTest.find(B03.class).unswap(null, STRINGMAP, null));
    }

    @Test(expected=ParseException.class)
    public void b04_unswap_noMethod() throws Exception {
        AutoObjectSwapTest.find(B04.class).unswap(null, STRINGMAP, null);
    }

    @Test
    public void c01_unswap_constructor() throws Exception {
        Assert.assertNotNull((Object)AutoObjectSwapTest.find(C01.class).unswap(null, STRINGMAP, null));
    }

    @Test
    public void d01_ignoreClass_beanIgnore() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(D01.class));
    }

    @Test
    public void d01c_ignoreClass_beanIgnore_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(AutoObjectSwapTest.bc(D01c.class), D01c.class));
    }

    @Test
    public void d02_ignoreClass_memberClass() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(D02.D02A.class));
    }

    @Test
    public void e01_ignoreSwapMethod_beanIgnore() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(E01.class));
    }

    @Test
    public void e01c_ignoreSwapMethod_beanIgnore_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(AutoObjectSwapTest.bc(E01c.class), E01c.class));
    }

    @Test
    public void e02_ignoreSwapMethod_deprecated() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(E02.class));
    }

    @Test
    public void e04_ignoreSwapMethod_wrongParameters() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(E04.class));
    }

    @Test
    public void e05_ignoreSwapMethod_notStatic() throws Exception {
        Assert.assertNull((Object)AutoObjectSwapTest.find(E05.class));
    }

    @Test(expected=ParseException.class)
    public void f01_ignoreUnswapMethod_beanIgnore() throws Exception {
        AutoObjectSwapTest.find(F01.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f01c_ignoreUnswapMethod_beanIgnore_usingConfig() throws Exception {
        AutoObjectSwapTest.find(AutoObjectSwapTest.bc(F01c.class), F01c.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f02_ignoreUnswapMethod_deprecated() throws Exception {
        AutoObjectSwapTest.find(F02.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f03_ignoreUnswapMethod_wrongReturnType() throws Exception {
        AutoObjectSwapTest.find(F03.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f04_ignoreUnswapMethod_wrongParameters() throws Exception {
        AutoObjectSwapTest.find(F04.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f05_ignoreUnswapMethod_notStatic() throws Exception {
        AutoObjectSwapTest.find(F05.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f06_ignoreUnswapMethod_wrongName() throws Exception {
        AutoObjectSwapTest.find(F06.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g01_ignoreUnswapConstructor_beanIgnore() throws Exception {
        AutoObjectSwapTest.find(G01.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g01c_ignoreUnswapConstructor_beanIgnore_usingConfig() throws Exception {
        AutoObjectSwapTest.find(AutoObjectSwapTest.bc(G01c.class), G01c.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g02_ignoreUnswapConstructor_deprecated() throws Exception {
        AutoObjectSwapTest.find(G02.class).unswap(null, null, null);
    }

    public static class G02 {
        @Deprecated
        public G02(Map<String, String> o) {
        }

        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="G01c(Map)")})
    public static class G01c {
        public G01c(Map<String, String> o) {
        }

        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class G01 {
        @BeanIgnore
        public G01(Map<String, String> o) {
        }

        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class F06 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public static F06 createx(Map<String, String> o) {
            return null;
        }
    }

    public static class F05 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public F05 create(Map<String, String> o) {
            return null;
        }
    }

    public static class F04 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public static F04 create(List<String> o) {
            return null;
        }
    }

    public static class F03 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public static Object create(Map<String, String> o) {
            return null;
        }
    }

    public static class F02 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        @Deprecated
        public static F02 create(Map<String, String> o) {
            return null;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="F01c.create(java.util.Map)")})
    public static class F01c {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public static F01 create(Map<String, String> o) {
            return null;
        }
    }

    public static class F01 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        @BeanIgnore
        public static F01 create(Map<String, String> o) {
            return null;
        }
    }

    public static class E05 {
        public static Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class E04 {
        public Map<String, String> swap(Map<String, String> foo) {
            return STRINGMAP;
        }
    }

    public static class E02 {
        @Deprecated
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="E01c.swap")})
    public static class E01c {
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class E01 {
        @BeanIgnore
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class D02 {

        public class D02A {
            public Map<String, String> swap() {
                return STRINGMAP;
            }
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="D01c")})
    public static class D01c {
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    @BeanIgnore
    public static class D01 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class C01 {
        public C01() {
        }

        public C01(Map<String, String> o) {
            TestUtils.assertObjectEquals("{foo:'bar'}", o);
        }

        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class B04 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }

    public static class B03 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public static B03 fromObject(Map<String, String> o) {
            TestUtils.assertObjectEquals("{foo:'bar'}", o);
            return new B03();
        }
    }

    public static class B02 {
        public ObjectMap swap() {
            return OBJECTMAP;
        }

        public static B02 create(ObjectMap o) {
            TestUtils.assertObjectEquals("{foo:'bar'}", o);
            return new B02();
        }
    }

    public static class B01 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }

        public static B01 unswap(Map<String, String> o) {
            TestUtils.assertObjectEquals("{foo:'bar'}", o);
            return new B01();
        }
    }

    public static class A04 {
        public ObjectMap toObject() {
            throw new RuntimeException("foo");
        }
    }

    public static class A03 {
        public ObjectMap toObject() throws SerializeException {
            throw new SerializeException("foo", new Object[0]);
        }
    }

    public static class A02 {
        public ObjectMap toObject() {
            return OBJECTMAP;
        }
    }

    public static class A01 {
        public Map<String, String> swap() {
            return STRINGMAP;
        }
    }
}

