/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.AutoNumberSwap;
import org.apache.juneau.transform.PojoSwap;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AutoNumberSwapTest {
    private static PojoSwap find(Class<?> c) {
        return AutoNumberSwap.find((BeanContext)BeanContext.DEFAULT, (ClassInfo)ClassInfo.of(c));
    }

    private static PojoSwap find(BeanContext bc, Class<?> c) {
        return AutoNumberSwap.find((BeanContext)bc, (ClassInfo)ClassInfo.of(c));
    }

    private static BeanContext bc(Class<?> applyAnnotations) {
        return BeanContext.DEFAULT.builder().applyAnnotations(new Class[]{applyAnnotations}).build();
    }

    @Test
    public void a01_swap_toNumber() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A01.class).swap(null, (Object)new A01()));
    }

    @Test
    public void a02_swap_toInteger() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A02.class).swap(null, (Object)new A02()));
    }

    @Test
    public void a03_swap_toIntPrimitive() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A03.class).swap(null, (Object)new A03()));
    }

    @Test
    public void a04_swap_toLong() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A04.class).swap(null, (Object)new A04()));
    }

    @Test
    public void a05_swap_toLongPrimitive() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A05.class).swap(null, (Object)new A05()));
    }

    @Test
    public void a06_swap_toFloat() throws Exception {
        TestUtils.assertObjectEquals("1.0", AutoNumberSwapTest.find(A06.class).swap(null, (Object)new A06()));
    }

    @Test
    public void a07_swap_toFloatPrimitive() throws Exception {
        TestUtils.assertObjectEquals("1.0", AutoNumberSwapTest.find(A07.class).swap(null, (Object)new A07()));
    }

    @Test
    public void a08_swap_toDouble() throws Exception {
        TestUtils.assertObjectEquals("1.0", AutoNumberSwapTest.find(A08.class).swap(null, (Object)new A08()));
    }

    @Test
    public void a09_swap_toDoublePrimitive() throws Exception {
        TestUtils.assertObjectEquals("1.0", AutoNumberSwapTest.find(A09.class).swap(null, (Object)new A09()));
    }

    @Test
    public void a10_swap_toShort() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A10.class).swap(null, (Object)new A10()));
    }

    @Test
    public void a11_swap_toShortPrimitive() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A11.class).swap(null, (Object)new A11()));
    }

    @Test
    public void a12_swap_toByte() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A12.class).swap(null, (Object)new A12()));
    }

    @Test
    public void a13_swap_toBytePrimitive() throws Exception {
        TestUtils.assertObjectEquals("1", AutoNumberSwapTest.find(A13.class).swap(null, (Object)new A13()));
    }

    @Test(expected=SerializeException.class)
    public void a14_swap_serializeException() throws Exception {
        AutoNumberSwapTest.find(A14.class).swap(null, null);
    }

    @Test(expected=SerializeException.class)
    public void a15_swap_runtimeException() throws Exception {
        AutoNumberSwapTest.find(A15.class).swap(null, null);
    }

    @Test
    public void b01_unswap_fromInteger() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B01.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b02_unswap_fromInt() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B02.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b03_unswap_fromLong() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B03.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b04_unswap_fromLongPrimitive() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B04.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b05_unswap_fromFloat() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B05.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b06_unswap_fromFloatPrimitive() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B06.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b07_unswap_fromDouble() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B07.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b08_unswap_fromDoublePrimitive() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B08.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b09_unswap_fromShort() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B09.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b10_unswap_fromShortPrimitive() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B10.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b11_unswap_fromByte() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B11.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b12_unswap_fromBytePrimitive() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B12.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b13_unswap_create() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B13.class).unswap(null, (Object)1, null));
    }

    @Test
    public void b14_unswap_valueOf() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(B14.class).unswap(null, (Object)1, null));
    }

    @Test(expected=ParseException.class)
    public void b15_unswap_noMethod() throws Exception {
        AutoNumberSwapTest.find(B15.class).unswap(null, (Object)1, null);
    }

    @Test
    public void c01_unswapConstructor_Integer() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C01.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c02_unswapConstructor_int() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C02.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c03_unswapConstructor_Long() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C03.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c04_unswapConstructor_long() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C04.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c05_unswapConstructor_Float() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C05.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c06_unswapConstructor_float() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C06.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c07_unswapConstructor_Double() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C07.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c08_unswapConstructor_double() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C08.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c09_unswapConstructor_Short() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C09.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c10_unswapConstructor_short() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C10.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c11_unswapConstructor_Byte() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C11.class).unswap(null, (Object)1, null));
    }

    @Test
    public void c12_unswapConstructor_byte() throws Exception {
        Assert.assertNotNull((Object)AutoNumberSwapTest.find(C12.class).unswap(null, (Object)1, null));
    }

    @Test(expected=ParseException.class)
    public void c13_unswapConstructor_noConstructor() throws Exception {
        AutoNumberSwapTest.find(C13.class).unswap(null, (Object)1, null);
    }

    @Test
    public void d01_ignoreClass_beanIgnore() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(D01.class));
    }

    @Test
    public void d01c_ignoreClass_beanIgnore_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(AutoNumberSwapTest.bc(D01c.class), D01c.class));
    }

    @Test
    public void d02_ignoreClass_memberClass() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(D02.D02A.class));
    }

    @Test
    public void d03_ignoreClass_numberSubclass() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(Integer.class));
        Assert.assertNull((Object)AutoNumberSwapTest.find(Number.class));
        Assert.assertNull((Object)AutoNumberSwapTest.find(Integer.TYPE));
    }

    @Test
    public void d04_ignoreClass_primitive() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(Character.TYPE));
    }

    @Test
    public void e01_ignoreSwapMethod_beanIgnore() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(E01.class));
    }

    @Test
    public void e01c_ignoreSwapMethod_beanIgnore_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(AutoNumberSwapTest.bc(E01c.class), E01c.class));
    }

    @Test
    public void e02_ignoreSwapMethod_deprecated() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(E02.class));
    }

    @Test
    public void e03_ignoreSwapMethod_wrongReturnType() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(E03.class));
    }

    @Test
    public void e04_ignoreSwapMethod_wrongParameters() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(E04.class));
    }

    @Test
    public void e05_ignoreSwapMethod_notStatic() throws Exception {
        Assert.assertNull((Object)AutoNumberSwapTest.find(E05.class));
    }

    @Test(expected=ParseException.class)
    public void f01_ignoreUnswapMethod_beanIgnore() throws Exception {
        AutoNumberSwapTest.find(F01.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f01c_ignoreUnswapMethod_beanIgnore_usingConfig() throws Exception {
        AutoNumberSwapTest.find(AutoNumberSwapTest.bc(F01c.class), F01c.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f02_ignoreUnswapMethod_deprecated() throws Exception {
        AutoNumberSwapTest.find(F02.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f03_ignoreUnswapMethod_wrongReturnType() throws Exception {
        AutoNumberSwapTest.find(F03.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f04_ignoreUnswapMethod_wrongParameters() throws Exception {
        AutoNumberSwapTest.find(F04.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f05_ignoreUnswapMethod_notStatic() throws Exception {
        AutoNumberSwapTest.find(F05.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f06_ignoreUnswapMethod_wrongName() throws Exception {
        AutoNumberSwapTest.find(F06.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g01_ignoreUnswapConstructor_beanIgnore() throws Exception {
        AutoNumberSwapTest.find(G01.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g01c_ignoreUnswapConstructor_beanIgnore_usingConfig() throws Exception {
        AutoNumberSwapTest.find(AutoNumberSwapTest.bc(G01c.class), G01c.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g02_ignoreUnswapConstructor_deprecated() throws Exception {
        AutoNumberSwapTest.find(G02.class).unswap(null, null, null);
    }

    public static class G02 {
        @Deprecated
        public G02(Integer o) {
        }

        public Integer toInteger() {
            return 1;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="G01c(java.lang.Integer)")})
    public static class G01c {
        public G01c(Integer o) {
        }

        public Integer toInteger() {
            return 1;
        }
    }

    public static class G01 {
        @BeanIgnore
        public G01(Integer o) {
        }

        public Integer toInteger() {
            return 1;
        }
    }

    public static class F06 {
        public Integer toInteger() {
            return 1;
        }

        public static F06 createx(Integer o) {
            return null;
        }
    }

    public static class F05 {
        public Integer toInteger() {
            return 1;
        }

        public F05 create(Integer o) {
            return null;
        }
    }

    public static class F04 {
        public Integer toInteger() {
            return 1;
        }

        public static F04 create(Map<String, String> o) {
            return null;
        }
    }

    public static class F03 {
        public Integer toInteger() {
            return 1;
        }

        public static Object create(Integer o) {
            return null;
        }
    }

    public static class F02 {
        public Integer toInteger() {
            return 1;
        }

        @Deprecated
        public static F02 create(Integer o) {
            return null;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="F01c.create(java.lang.Integer)")})
    public static class F01c {
        public Integer toInteger() {
            return 1;
        }

        public static F01 create(Integer o) {
            return null;
        }
    }

    public static class F01 {
        public Integer toInteger() {
            return 1;
        }

        @BeanIgnore
        public static F01 create(Integer o) {
            return null;
        }
    }

    public static class E05 {
        public static Integer toInteger() {
            return 1;
        }
    }

    public static class E04 {
        public Integer toInteger(List<String> foo) {
            return 1;
        }
    }

    public static class E03 {
        public Object toInteger() {
            return 1;
        }
    }

    public static class E02 {
        @Deprecated
        public Integer toInteger() {
            return 1;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="E01c.toInteger")})
    public static class E01c {
        public Integer toInteger() {
            return 1;
        }
    }

    public static class E01 {
        @BeanIgnore
        public Integer toInteger() {
            return 1;
        }
    }

    public static class D02 {

        public class D02A {
            public Integer toInteger() {
                return 1;
            }
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="D01c")})
    public static class D01c {
        public Integer toInteger() {
            return 1;
        }
    }

    @BeanIgnore
    public static class D01 {
        public Integer toInteger() {
            return 1;
        }
    }

    public static class C13 {
        public Integer toInteger() {
            return 1;
        }
    }

    public static class C12 {
        public C12() {
        }

        public C12(byte o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public byte toByte() {
            return 1;
        }
    }

    public static class C11 {
        public C11() {
        }

        public C11(Byte o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public Byte toByte() {
            return (byte)1;
        }
    }

    public static class C10 {
        public C10() {
        }

        public C10(short o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public short toShort() {
            return 1;
        }
    }

    public static class C09 {
        public C09() {
        }

        public C09(Short o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public Short toShort() {
            return (short)1;
        }
    }

    public static class C08 {
        public C08() {
        }

        public C08(double o) {
            TestUtils.assertObjectEquals("1.0", o);
        }

        public double toDouble() {
            return 1.0;
        }
    }

    public static class C07 {
        public C07() {
        }

        public C07(Double o) {
            TestUtils.assertObjectEquals("1.0", o);
        }

        public Double toDouble() {
            return 1.0;
        }
    }

    public static class C06 {
        public C06() {
        }

        public C06(float o) {
            TestUtils.assertObjectEquals("1.0", Float.valueOf(o));
        }

        public float toFloat() {
            return 1.0f;
        }
    }

    public static class C05 {
        public C05() {
        }

        public C05(Float o) {
            TestUtils.assertObjectEquals("1.0", o);
        }

        public Float toFloat() {
            return Float.valueOf(1.0f);
        }
    }

    public static class C04 {
        public C04() {
        }

        public C04(long o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public long toLong() {
            return 1L;
        }
    }

    public static class C03 {
        public C03() {
        }

        public C03(Long o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public Long toLong() {
            return 1L;
        }
    }

    public static class C02 {
        public C02() {
        }

        public C02(int o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public int toInt() {
            return 1;
        }
    }

    public static class C01 {
        public C01() {
        }

        public C01(Integer o) {
            TestUtils.assertObjectEquals("1", o);
        }

        public Integer toInteger() {
            return 1;
        }
    }

    public static class B15 {
        public int toInt() {
            return 1;
        }
    }

    public static class B14 {
        public int toInt() {
            return 1;
        }

        public static B14 valueOf(int o) {
            TestUtils.assertObjectEquals("1", o);
            return new B14();
        }
    }

    public static class B13 {
        public int toInt() {
            return 1;
        }

        public static B13 create(int o) {
            TestUtils.assertObjectEquals("1", o);
            return new B13();
        }
    }

    public static class B12 {
        public byte toByte() {
            return 1;
        }

        public static B12 fromByte(byte o) {
            TestUtils.assertObjectEquals("1", o);
            return new B12();
        }
    }

    public static class B11 {
        public Byte toByte() {
            return (byte)1;
        }

        public static B11 fromByte(Byte o) {
            TestUtils.assertObjectEquals("1", o);
            return new B11();
        }
    }

    public static class B10 {
        public short toShort() {
            return 1;
        }

        public static B10 fromShort(short o) {
            TestUtils.assertObjectEquals("1", o);
            return new B10();
        }
    }

    public static class B09 {
        public Short toShort() {
            return (short)1;
        }

        public static B09 fromShort(Short o) {
            TestUtils.assertObjectEquals("1", o);
            return new B09();
        }
    }

    public static class B08 {
        public double toDouble() {
            return 1.0;
        }

        public static B08 fromDouble(double o) {
            TestUtils.assertObjectEquals("1.0", o);
            return new B08();
        }
    }

    public static class B07 {
        public Double toDouble() {
            return 1.0;
        }

        public static B07 fromDouble(Double o) {
            TestUtils.assertObjectEquals("1.0", o);
            return new B07();
        }
    }

    public static class B06 {
        public float toFloat() {
            return 1.0f;
        }

        public static B06 fromFloat(float o) {
            TestUtils.assertObjectEquals("1.0", Float.valueOf(o));
            return new B06();
        }
    }

    public static class B05 {
        public Float toFloat() {
            return Float.valueOf(1.0f);
        }

        public static B05 fromFloat(Float o) {
            TestUtils.assertObjectEquals("1.0", o);
            return new B05();
        }
    }

    public static class B04 {
        public long toLong() {
            return 1L;
        }

        public static B04 fromLong(long o) {
            TestUtils.assertObjectEquals("1", o);
            return new B04();
        }
    }

    public static class B03 {
        public Long toLong() {
            return 1L;
        }

        public static B03 fromLong(Long o) {
            TestUtils.assertObjectEquals("1", o);
            return new B03();
        }
    }

    public static class B02 {
        public int toInt() {
            return 1;
        }

        public static B02 fromInt(int o) {
            TestUtils.assertObjectEquals("1", o);
            return new B02();
        }
    }

    public static class B01 {
        public Integer toInteger() {
            return 1;
        }

        public static B01 fromInteger(Integer o) {
            TestUtils.assertObjectEquals("1", o);
            return new B01();
        }
    }

    public static class A15 {
        public Integer toInteger() {
            throw new RuntimeException("foo");
        }
    }

    public static class A14 {
        public Integer toInteger() throws SerializeException {
            throw new SerializeException("foo", new Object[0]);
        }
    }

    public static class A13 {
        public byte toByte() {
            return 1;
        }
    }

    public static class A12 {
        public Byte toByte() {
            return (byte)1;
        }
    }

    public static class A11 {
        public short toShort() {
            return 1;
        }
    }

    public static class A10 {
        public Short toShort() {
            return (short)1;
        }
    }

    public static class A09 {
        public double toDouble() {
            return 1.0;
        }
    }

    public static class A08 {
        public Double toDouble() {
            return 1.0;
        }
    }

    public static class A07 {
        public float toFloat() {
            return 1.0f;
        }
    }

    public static class A06 {
        public Float toFloat() {
            return Float.valueOf(1.0f);
        }
    }

    public static class A05 {
        public long toLong() {
            return 1L;
        }
    }

    public static class A04 {
        public Long toLong() {
            return 1L;
        }
    }

    public static class A03 {
        public int toInt() {
            return 1;
        }
    }

    public static class A02 {
        public Integer toInteger() {
            return 1;
        }
    }

    public static class A01 {
        public Number toNumber() {
            return 1;
        }
    }
}

