/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectList;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.AutoListSwap;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AutoListSwapTest {
    private static final List<String> STRINGLIST = AList.create((Object[])new String[]{"foo"});
    private static final ObjectList OBJECTLIST = new ObjectList().append(new Object[]{"foo"});

    private static PojoSwap find(Class<?> c) {
        return AutoListSwap.find((BeanContext)BeanContext.DEFAULT, (ClassInfo)ClassInfo.of(c));
    }

    private static PojoSwap find(BeanContext bc, Class<?> c) {
        return AutoListSwap.find((BeanContext)bc, (ClassInfo)ClassInfo.of(c));
    }

    private static BeanContext bc(Class<?> applyAnnotations) {
        return BeanContext.DEFAULT.builder().applyAnnotations(new Class[]{applyAnnotations}).build();
    }

    @Test
    public void a01_swap_toList() throws Exception {
        TestUtils.assertObjectEquals("['foo']", AutoListSwapTest.find(A01.class).swap(null, (Object)new A01()));
    }

    @Test
    public void a02_swap_toObjectList() throws Exception {
        TestUtils.assertObjectEquals("['foo']", AutoListSwapTest.find(A02.class).swap(null, (Object)new A02()));
    }

    @Test(expected=SerializeException.class)
    public void a03_swap_serializeException() throws Exception {
        AutoListSwapTest.find(A03.class).swap(null, null);
    }

    @Test(expected=SerializeException.class)
    public void a04_swap_runtimeException() throws Exception {
        AutoListSwapTest.find(A04.class).swap(null, null);
    }

    @Test
    public void b01_unswap_fromList() throws Exception {
        Assert.assertNotNull((Object)AutoListSwapTest.find(B01.class).unswap(null, STRINGLIST, null));
    }

    @Test
    public void b02_unswap_fromObjectList() throws Exception {
        Assert.assertNotNull((Object)AutoListSwapTest.find(B02.class).unswap(null, (Object)OBJECTLIST, null));
    }

    @Test
    public void b03_unswap_create() throws Exception {
        Assert.assertNotNull((Object)AutoListSwapTest.find(B03.class).unswap(null, STRINGLIST, null));
    }

    @Test(expected=ParseException.class)
    public void b04_unswap_noMethod() throws Exception {
        AutoListSwapTest.find(B04.class).unswap(null, STRINGLIST, null);
    }

    @Test
    public void c01_unswap_constructor() throws Exception {
        Assert.assertNotNull((Object)AutoListSwapTest.find(C01.class).unswap(null, STRINGLIST, null));
    }

    @Test
    public void d01_ignoreClass_beanIgnore() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(D01.class));
    }

    @Test
    public void d02_ignoreClass_memberClass() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(D02.D02A.class));
    }

    @Test
    public void d03_ignoreClass_beanIgnore_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(AutoListSwapTest.bc(D01c.class), D01c.class));
    }

    @Test
    public void d04_ignoreClass_memberClass_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(AutoListSwapTest.bc(D01c.class), D02c.D02Ac.class));
    }

    @Test
    public void e01_ignoreSwapMethod_beanIgnore() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(E01.class));
    }

    @Test
    public void e01c_ignoreSwapMethod_beanIgnore_usingConfig() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(BeanContext.DEFAULT.builder().applyAnnotations(new Class[]{E01c.class}).build(), E01c.class));
    }

    @Test
    public void e02_ignoreSwapMethod_deprecated() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(E02.class));
    }

    @Test
    public void e03_ignoreSwapMethod_wrongReturnType() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(E03.class));
    }

    @Test
    public void e04_ignoreSwapMethod_wrongParameters() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(E04.class));
    }

    @Test
    public void e05_ignoreSwapMethod_notStatic() throws Exception {
        Assert.assertNull((Object)AutoListSwapTest.find(E05.class));
    }

    @Test(expected=ParseException.class)
    public void f01_ignoreUnswapMethod_beanIgnore() throws Exception {
        AutoListSwapTest.find(F01.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f01c_ignoreUnswapMethod_beanIgnore_applyConfig() throws Exception {
        AutoListSwapTest.find(AutoListSwapTest.bc(F01c.class), F01c.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f02_ignoreUnswapMethod_deprecated() throws Exception {
        AutoListSwapTest.find(F02.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f03_ignoreUnswapMethod_wrongReturnType() throws Exception {
        AutoListSwapTest.find(F03.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f04_ignoreUnswapMethod_wrongParameters() throws Exception {
        AutoListSwapTest.find(F04.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f05_ignoreUnswapMethod_notStatic() throws Exception {
        AutoListSwapTest.find(F05.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void f06_ignoreUnswapMethod_wrongName() throws Exception {
        AutoListSwapTest.find(F06.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g01_ignoreUnswapConstructor_beanIgnore() throws Exception {
        AutoListSwapTest.find(G01.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g01c_ignoreUnswapConstructor_beanIgnore_usingConfig() throws Exception {
        AutoListSwapTest.find(AutoListSwapTest.bc(G01c.class), G01c.class).unswap(null, null, null);
    }

    @Test(expected=ParseException.class)
    public void g02_ignoreUnswapConstructor_deprecated() throws Exception {
        AutoListSwapTest.find(G02.class).unswap(null, null, null);
    }

    public static class G02 {
        @Deprecated
        public G02(List<String> o) {
        }

        public List<String> toList() {
            return STRINGLIST;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="G01c(List)")})
    public static class G01c {
        public G01c(List<String> o) {
        }

        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class G01 {
        @BeanIgnore
        public G01(List<String> o) {
        }

        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class F06 {
        public List<String> toList() {
            return STRINGLIST;
        }

        public static F06 createx(List<String> o) {
            return null;
        }
    }

    public static class F05 {
        public List<String> toList() {
            return STRINGLIST;
        }

        public F05 create(List<String> o) {
            return null;
        }
    }

    public static class F04 {
        public List<String> toList() {
            return STRINGLIST;
        }

        public static F04 create(Map<String, String> o) {
            return null;
        }
    }

    public static class F03 {
        public List<String> toList() {
            return STRINGLIST;
        }

        public static Object create(List<String> o) {
            return null;
        }
    }

    public static class F02 {
        public List<String> toList() {
            return STRINGLIST;
        }

        @Deprecated
        public static F02 create(List<String> o) {
            return null;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="F01c.create")})
    public static class F01c {
        public List<String> toList() {
            return STRINGLIST;
        }

        public static F01c create(List<String> o) {
            return null;
        }
    }

    public static class F01 {
        public List<String> toList() {
            return STRINGLIST;
        }

        @BeanIgnore
        public static F01 create(List<String> o) {
            return null;
        }
    }

    public static class E05 {
        public static List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class E04 {
        public List<String> toList(List<String> foo) {
            return STRINGLIST;
        }
    }

    public static class E03 {
        public Object toList() {
            return STRINGLIST;
        }
    }

    public static class E02 {
        @Deprecated
        public List<String> toList() {
            return STRINGLIST;
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="E01c.toList")})
    public static class E01c {
        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class E01 {
        @BeanIgnore
        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class D02c {

        public class D02Ac {
            public List<String> toList() {
                return STRINGLIST;
            }
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="D01c")})
    public static class D01c {
        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class D02 {

        public class D02A {
            public List<String> toList() {
                return STRINGLIST;
            }
        }
    }

    @BeanIgnore
    public static class D01 {
        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class C01 {
        public C01() {
        }

        public C01(List<String> o) {
            TestUtils.assertObjectEquals("['foo']", o);
        }

        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class B04 {
        public List<String> toList() {
            return STRINGLIST;
        }
    }

    public static class B03 {
        public List<String> toList() {
            return STRINGLIST;
        }

        public static B03 create(List<String> o) {
            TestUtils.assertObjectEquals("['foo']", o);
            return new B03();
        }
    }

    public static class B02 {
        public ObjectList toObjectList() {
            return OBJECTLIST;
        }

        public static B02 fromObjectList(ObjectList o) {
            TestUtils.assertObjectEquals("['foo']", o);
            return new B02();
        }
    }

    public static class B01 {
        public List<String> toList() {
            return STRINGLIST;
        }

        public static B01 fromList(List<String> o) {
            TestUtils.assertObjectEquals("['foo']", o);
            return new B01();
        }
    }

    public static class A04 {
        public ObjectList toObjectList() {
            throw new RuntimeException("foo");
        }
    }

    public static class A03 {
        public ObjectList toObjectList() throws SerializeException {
            throw new SerializeException("foo", new Object[0]);
        }
    }

    public static class A02 {
        public ObjectList toObjectList() {
            return OBJECTLIST;
        }
    }

    public static class A01 {
        public List<String> toList() {
            return STRINGLIST;
        }
    }
}

