/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.testutils;

import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.StringMessage;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;

public class TestUtils {
    private static JsonSerializer js = JsonSerializer.create().ssq().trimNullProperties(false).addBeanTypes().addRootType().build();
    private static JsonSerializer jsSorted = JsonSerializer.create().ssq().sortCollections().sortMaps().trimNullProperties(false).addBeanTypes().addRootType().build();
    private static JsonSerializer js2 = JsonSerializer.create().ssq().addBeanTypes().addRootType().build();
    private static JsonSerializer js3 = JsonSerializer.create().ssq().sortProperties().addBeanTypes().addRootType().build();
    private static final BeanSession beanSession = BeanContext.DEFAULT.createSession();
    private static Pattern pTargetNs = Pattern.compile("targetNamespace=['\"]([^'\"]+)['\"]");
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static ThreadLocal<TimeZone> systemTimeZone = new ThreadLocal();
    private static ThreadLocal<Locale> systemLocale = new ThreadLocal();

    public static final void assertEqualObjects(Object o1, Object o2) throws SerializeException {
        TestUtils.assertEqualObjects(o1, o2, false);
    }

    public static final void assertEqualObjects(Object o1, Object o2, boolean sort) throws SerializeException {
        String s2;
        JsonSerializer s = sort ? jsSorted : js;
        String s1 = s.serialize(o1);
        if (s1.equals(s2 = s.serialize(o2))) {
            return;
        }
        throw new ComparisonFailure(null, s1, s2);
    }

    public static final void checkXmlWhitespace(String out) throws SerializeException {
        if (out.indexOf(0) != -1) {
            for (String s : out.split("\u0000")) {
                TestUtils.checkXmlWhitespace(s);
            }
            return;
        }
        int indent = -1;
        Pattern startTag = Pattern.compile("^(\\s*)<[^/>]+(\\s+\\S+=['\"]\\S*['\"])*\\s*>$");
        Pattern endTag = Pattern.compile("^(\\s*)</[^>]+>$");
        Pattern combinedTag = Pattern.compile("^(\\s*)<[^>/]+(\\s+\\S+=['\"]\\S*['\"])*\\s*/>$");
        Pattern contentOnly = Pattern.compile("^(\\s*)[^\\s\\<]+$");
        Pattern tagWithContent = Pattern.compile("^(\\s*)<[^>]+>.*</[^>]+>$");
        String[] lines = out.split("\n");
        try {
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                Matcher m = startTag.matcher(line);
                if (m.matches()) {
                    if (m.group(1).length() == ++indent) continue;
                    throw new SerializeException("Wrong indentation detected on start tag line ''{0}''", new Object[]{i + 1});
                }
                m = endTag.matcher(line);
                if (m.matches()) {
                    if (m.group(1).length() != indent) {
                        throw new SerializeException("Wrong indentation detected on end tag line ''{0}''", new Object[]{i + 1});
                    }
                    --indent;
                    continue;
                }
                m = combinedTag.matcher(line);
                if (m.matches()) {
                    if (m.group(1).length() != ++indent) {
                        throw new SerializeException("Wrong indentation detected on combined tag line ''{0}''", new Object[]{i + 1});
                    }
                    --indent;
                    continue;
                }
                m = contentOnly.matcher(line);
                if (m.matches()) {
                    if (m.group(1).length() != ++indent) {
                        throw new SerializeException("Wrong indentation detected on content-only line ''{0}''", new Object[]{i + 1});
                    }
                    --indent;
                    continue;
                }
                m = tagWithContent.matcher(line);
                if (m.matches()) {
                    if (m.group(1).length() != ++indent) {
                        throw new SerializeException("Wrong indentation detected on tag-with-content line ''{0}''", new Object[]{i + 1});
                    }
                    --indent;
                    continue;
                }
                throw new SerializeException("Unmatched whitespace line at line number ''{0}''", new Object[]{i + 1});
            }
            if (indent != -1) {
                throw new SerializeException("Possible unmatched tag.  indent=''{0}''", new Object[]{indent});
            }
        }
        catch (SerializeException e) {
            TestUtils.printLines(lines);
            throw e;
        }
    }

    private static final void printLines(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            System.err.println(String.format("%4s:" + lines[i], i + 1));
        }
    }

    private static final void validateXml(String xml, String xmlSchema) throws Exception {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(true);
        DocumentBuilder documentBuilder = f.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (xmlSchema.indexOf(0) != -1) {
            final HashMap<String, String> schemas = new HashMap<String, String>();
            String[] ss = xmlSchema.split("\u0000");
            xmlSchema = ss[0];
            for (String s : ss) {
                Matcher m = pTargetNs.matcher(s);
                if (!m.find()) continue;
                schemas.put(m.group(1), s);
            }
            factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    String schema = (String)schemas.get(namespaceURI);
                    if (schema == null) {
                        throw new FormattedRuntimeException("No schema found for namespaceURI ''{0}''", new Object[]{namespaceURI});
                    }
                    try {
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                        LSInput in = domImplementationLS.createLSInput();
                        in.setCharacterStream(new StringReader(schema));
                        in.setSystemId(systemId);
                        return in;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        Schema schema = factory.newSchema(new StreamSource(new StringReader(xmlSchema)));
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    public static final void validateXml(Object o) throws Exception {
        TestUtils.validateXml(o, XmlSerializer.DEFAULT_NS_SQ);
    }

    public static void validateXml(Object o, XmlSerializer s) throws Exception {
        s = s.builder().ws().ns().addNamespaceUrisToRoot().build();
        String xml = s.serialize(o);
        String xmlSchema = null;
        try {
            xmlSchema = s.getSchemaSerializer().serialize(o);
            TestUtils.checkXmlWhitespace(xml);
            TestUtils.checkXmlWhitespace(xmlSchema);
            TestUtils.validateXml(xml, xmlSchema);
        }
        catch (Exception e) {
            System.err.println("---XML---");
            System.err.println(xml);
            System.err.println("---XMLSchema---");
            System.err.println(xmlSchema);
            throw e;
        }
    }

    public static final String toHex(byte b) {
        char[] c = new char[2];
        int v = b & 0xFF;
        c[0] = hexArray[v >>> 4];
        c[1] = hexArray[v & 0xF];
        return new String(c);
    }

    private static final String sortXml(String xml) throws Exception {
        xml = xml.replaceAll("\\w+\\:", "").replaceAll(">\\s+<", "><");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(xml)));
        SortedNode n = new SortedNode(doc.getDocumentElement());
        return n.toString();
    }

    private static StringBuilder indent(int depth, StringBuilder sb) {
        for (int i = 0; i < depth; ++i) {
            sb.append("\t");
        }
        return sb;
    }

    public static final void assertXmlEquals(String expected, String actual) throws Exception {
        Assert.assertEquals((Object)TestUtils.sortXml(expected), (Object)TestUtils.sortXml(actual));
    }

    public static final void assertObjectEquals(String s, Object o) {
        TestUtils.assertObjectEquals(s, o, (WriterSerializer)js2);
    }

    public static final void assertSortedObjectEquals(String s, Object o) {
        TestUtils.assertObjectEquals(s, o, (WriterSerializer)js3);
    }

    public static final void assertObjectEquals(String s, Object o, WriterSerializer ws) {
        if ("xxx".equals(s)) {
            System.err.println(ws.toString(o).replaceAll("\\\\", "\\\\\\\\"));
        }
        Assert.assertEquals((Object)s, (Object)ws.toString(o));
    }

    public static final void assertObjectMatches(String s, Object o) {
        TestUtils.assertObjectMatches(s, o, (WriterSerializer)js2);
    }

    public static final void assertObjectMatches(String s, Object o, WriterSerializer ws) {
        if ("xxx".equals(s)) {
            System.err.println(ws.toString(o).replaceAll("\\\\", "\\\\\\\\"));
        }
        String o2 = ws.toString(o);
        if (!StringUtils.getMatchPattern((String)s).matcher(o2).matches()) {
            throw new ComparisonFailure(null, s, o2);
        }
    }

    public static final void assertTextEquals(String s, Object o) {
        String s2 = o.toString().replaceAll("\\r?\\n", "|");
        Assert.assertEquals((Object)s, (Object)s2);
    }

    public static final String toReadableBytes(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : b) {
            sb.append(b2 < 32 || b2 > 122 ? String.format("[%02X]", b2) : (char)b2 + "   ");
        }
        sb.append("\n");
        for (byte b2 : b) {
            sb.append(String.format("[%02X]", b2));
        }
        return sb.toString();
    }

    public static final String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof byte[]) {
            return new String((byte[])o, IOUtils.UTF8);
        }
        return o.toString();
    }

    public static final synchronized void setTimeZone(String name) {
        systemTimeZone.set(TimeZone.getDefault());
        TimeZone.setDefault(TimeZone.getTimeZone(name));
    }

    public static final synchronized void unsetTimeZone() {
        TimeZone.setDefault(systemTimeZone.get());
    }

    public static final void setLocale(Locale locale) {
        systemLocale.set(Locale.getDefault());
        Locale.setDefault(locale);
    }

    public static final void unsetLocale() {
        Locale.setDefault(systemLocale.get());
    }

    public static final void assertEqualsAfterSort(String expected, String actual, String msg, Object ... args) {
        Object[] a;
        Object[] e = expected.trim().split("[\r\n]+");
        if (e.length != (a = actual.trim().split("[\r\n]+")).length) {
            throw new ComparisonFailure(StringUtils.format((String)msg, (Object[])args), expected, actual);
        }
        Arrays.sort(e);
        Arrays.sort(a);
        for (int i = 0; i < e.length; ++i) {
            if (((String)e[i]).equals(a[i])) continue;
            throw new ComparisonFailure(StringUtils.format((String)msg, (Object[])args), expected, actual);
        }
    }

    public static final void assertEquals(Object expected, Object actual, String msg, Object ... args) {
        if ("xxx".equals(expected)) {
            System.err.println("actual=[" + actual + "]");
        }
        if (!TestUtils.isEquals(expected, actual)) {
            throw new ComparisonFailure(StringUtils.format((String)msg, (Object[])args), TestUtils.toString(expected), TestUtils.toString(actual));
        }
    }

    public static final void assertContains(Object value, String ... substrings) {
        for (String substring : substrings) {
            if (StringUtils.contains((String)TestUtils.toString(value), (CharSequence)substring)) continue;
            System.err.println("Text did not contain expected substring: '" + TestUtils.toString(substring) + "'");
            System.err.println("=== TEXT ===");
            System.err.println(TestUtils.toString(value));
            System.err.println("============");
            throw new ComparisonFailure("Text did not contain expected substring.", TestUtils.toString(substring), TestUtils.toString(value));
        }
    }

    public static final void assertContains(Exception e, String ... substrings) {
        for (String substring : substrings) {
            boolean found;
            Throwable e2 = e;
            for (found = false; e2 != null && !found; found |= StringUtils.contains((String)e2.getMessage(), (CharSequence)substring), e2 = e2.getCause()) {
            }
            if (found) continue;
            e.printStackTrace();
            throw new ComparisonFailure("Exception message did not contain expected substring.", TestUtils.toString(substring), StringUtils.getStackTrace((Throwable)e));
        }
    }

    public static final Type getType(Type type, Type ... args) {
        return beanSession.getClassMeta(type, args);
    }

    public static final void assertInstanceOf(Class<?> type, Object o) {
        if (type.isInstance(o)) {
            return;
        }
        throw new AssertionError(new StringMessage("Expected type {0} but was {1}", new Object[]{type, o == null ? null : o.getClass()}));
    }

    public static final void assertClass(Class<?> c, Object o) {
        Assert.assertEquals(c, o == null ? null : o.getClass());
    }

    private static boolean isEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private static class SortedNode
    implements Comparable<SortedNode> {
        public String name;
        public String text = "";
        public String attrs = "";
        public List<SortedNode> children = new LinkedList<SortedNode>();

        SortedNode(Element e) {
            this.name = e.getNodeName();
            NamedNodeMap attrs = e.getAttributes();
            if (attrs != null) {
                StringBuilder sb = new StringBuilder();
                TreeSet<String> attrNames = new TreeSet<String>();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    attrNames.add(attrs.item(i).getNodeName());
                }
                for (String n : attrNames) {
                    Node node = attrs.getNamedItem(n);
                    sb.append(" ").append(n).append("='").append(node.getNodeValue()).append("'");
                }
                this.attrs = sb.toString();
            }
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    this.children.add(new SortedNode((Element)nl.item(i)));
                }
                if (!(n instanceof Text)) continue;
                this.text = this.text + ((Text)n).getNodeValue();
            }
            Collections.sort(this.children);
        }

        @Override
        public int compareTo(SortedNode n) {
            int i = this.name.compareTo(n.name);
            if (i != 0) {
                return i;
            }
            i = this.attrs.compareTo(n.attrs);
            if (i != 0) {
                return i;
            }
            i = this.text.compareTo(n.text);
            if (i != 0) {
                return i;
            }
            return 0;
        }

        public String toString() {
            return this.toString(0, new StringBuilder()).toString();
        }

        public StringBuilder toString(int depth, StringBuilder sb) {
            TestUtils.indent(depth, sb).append("<").append(this.name).append(this.attrs);
            if (this.children.isEmpty() && this.text.isEmpty()) {
                sb.append("/>\n");
                return sb;
            }
            sb.append(">\n");
            if (!this.text.isEmpty()) {
                TestUtils.indent(depth + 1, sb).append(this.text).append("\n");
            }
            for (SortedNode c : this.children) {
                c.toString(depth + 1, sb);
            }
            TestUtils.indent(depth, sb).append("</").append(this.name).append(">\n");
            return sb;
        }
    }
}

