/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.juneau.svl.SimpleVar;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class RestrictedVarsTest {
    @Test
    public void testNoNest() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{NoNestVar.class}).build();
        this.test(vr, "$NoNest{foo}", "foo");
        this.test(vr, "$NoNest{$NoNest{foo}}", "$NoNest{foo}");
        this.test(vr, "$NoNest{foo $NoNest{foo} bar}", "foo $NoNest{foo} bar");
    }

    @Test
    public void testNoRecurse() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{XVar.class, NoRecurseVar.class}).build();
        this.test(vr, "$NoRecurse{foo}", "$X{foo}");
        this.test(vr, "$NoRecurse{$NoRecurse{foo}}", "$X{$X{foo}}");
        this.test(vr, "$NoRecurse{foo $NoRecurse{foo} bar}", "$X{foo $X{foo} bar}");
    }

    @Test
    public void testNoNestOrRecurse() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{XVar.class, NoEitherVar.class}).build();
        this.test(vr, "$NoEither{foo}", "$X{foo}");
        this.test(vr, "$NoEither{$NoEither{foo}}", "$X{$NoEither{foo}}");
        this.test(vr, "$NoEither{foo $NoEither{foo} bar}", "$X{foo $NoEither{foo} bar}");
    }

    private void test(VarResolver vr, String s, String expected) throws IOException {
        StringWriter sw = new StringWriter();
        vr.resolveTo(s, (Writer)sw);
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        Assert.assertEquals((Object)expected, (Object)vr.resolve(s));
    }

    public static class NoEitherVar
    extends SimpleVar {
        public NoEitherVar() {
            super("NoEither");
        }

        public String resolve(VarResolverSession session, String arg) throws Exception {
            return "$X{" + arg + "}";
        }

        protected boolean allowNested() {
            return false;
        }

        protected boolean allowRecurse() {
            return false;
        }
    }

    public static class NoRecurseVar
    extends SimpleVar {
        public NoRecurseVar() {
            super("NoRecurse");
        }

        public String resolve(VarResolverSession session, String arg) throws Exception {
            return "$X{" + arg + "}";
        }

        protected boolean allowRecurse() {
            return false;
        }
    }

    public static class NoNestVar
    extends SimpleVar {
        public NoNestVar() {
            super("NoNest");
        }

        public String resolve(VarResolverSession session, String arg) throws Exception {
            return arg.replaceAll("\\$", "\\\\\\$");
        }

        protected boolean allowNested() {
            return false;
        }
    }

    public static class XVar
    extends SimpleVar {
        public XVar() {
            super("X");
        }

        public String resolve(VarResolverSession session, String arg) throws Exception {
            return 'x' + arg + 'x';
        }
    }
}

