/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.vars.PatternReplaceVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;
import org.junit.Assert;
import org.junit.Test;

public class PatternReplaceVarTest {
    @Test
    public void test() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{PatternReplaceVar.class, SystemPropertiesVar.class}).build();
        System.setProperty("PatternReplaceVarTest.test", "foo bar");
        System.setProperty("PatternReplaceVarTest.test2", "size=23;display=none;");
        Assert.assertEquals((Object)"bar bar", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test},foo,bar}"));
        Assert.assertEquals((Object)"coo bar", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test},^f?,co}"));
        Assert.assertEquals((Object)"fine", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test},oo*,ine}"));
        Assert.assertEquals((Object)"FOO FOO", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test},([a-z]+),FOO}"));
        Assert.assertEquals((Object)"size=23px;display=none;", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test2},(size=([\\d]+)),\\$1px}"));
        Assert.assertEquals((Object)"size=??px;display=none;", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test2},[\\d]+,??px}"));
        Assert.assertEquals((Object)"size=23;display=none", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test2},;\\$,}"));
        Assert.assertEquals((Object)"size=23;none=display;", (Object)vr.resolve("$PR{$S{PatternReplaceVarTest.test2},;(*)=(*[^;]),;\\$2=\\$1}"));
    }
}

