/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.vars.IfVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;
import org.junit.Assert;
import org.junit.Test;

public class IfVarTest {
    @Test
    public void test() throws Exception {
        VarResolver vr = new VarResolverBuilder().vars(new Class[]{IfVar.class, SystemPropertiesVar.class}).build();
        for (String test : new String[]{"", "0", "false", "FALSE", "f", "F", "foobar"}) {
            System.setProperty("IfVarTest.test", test);
            Assert.assertEquals((Object)"NO", (Object)vr.resolve("$IF{$S{IfVarTest.test},YES,NO}"));
            Assert.assertEquals((Object)"x NO x", (Object)vr.resolve("x $IF{ $S{ IfVarTest.test } , YES , NO } x"));
            Assert.assertEquals((Object)"", (Object)vr.resolve("$IF{$S{IfVarTest.test},YES}"));
            Assert.assertEquals((Object)"x  x", (Object)vr.resolve("x $IF{ $S{ IfVarTest.test } , YES } x"));
        }
        for (String test : new String[]{"1", "true", "TRUE", "t", "T"}) {
            System.setProperty("IfVarTest.test", test);
            Assert.assertEquals((Object)"YES", (Object)vr.resolve("$IF{$S{IfVarTest.test},YES,NO}"));
            Assert.assertEquals((Object)"YES", (Object)vr.resolve("$IF{$S{IfVarTest.test},YES}"));
            Assert.assertEquals((Object)"x YES x", (Object)vr.resolve("x $IF{ $S{ IfVarTest.test } , YES , NO } x"));
            Assert.assertEquals((Object)"x YES x", (Object)vr.resolve("x $IF{ $S{ IfVarTest.test } , YES } x"));
        }
    }
}

