/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.svl.MapVar;
import org.apache.juneau.svl.ResolvingObjectMap;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class ResolvingObjectMapTest {
    @Test
    public void testBasic() throws Exception {
        VarResolver vr = new VarResolverBuilder().defaultVars().vars(new Class[]{XVar.class}).build();
        ResolvingObjectMap m = new ResolvingObjectMap(vr.createSession());
        m.put((Object)"foo", (Object)"$X{a}");
        Assert.assertEquals((Object)m.get((Object)"foo"), (Object)"1");
        m.put((Object)"foo", (Object)new String[]{"$X{a}"});
        TestUtils.assertObjectEquals("['1']", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new AList().append((Object)"$X{a}"));
        TestUtils.assertObjectEquals("['1']", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new AMap().append((Object)"k1", (Object)"$X{a}"));
        TestUtils.assertObjectEquals("{k1:'1'}", m.get((Object)"foo"));
    }

    @Test
    public void testNulls() throws Exception {
        VarResolver vr = new VarResolverBuilder().defaultVars().vars(new Class[]{XVar.class}).build();
        ResolvingObjectMap m = new ResolvingObjectMap(vr.createSession());
        m.put((Object)"foo", null);
        Assert.assertNull((Object)m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new String[]{null});
        TestUtils.assertObjectEquals("[null]", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new AList().append(null));
        TestUtils.assertObjectEquals("[null]", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new AMap().append((Object)"k1", null));
        TestUtils.assertObjectEquals("{k1:null}", m.get((Object)"foo"));
    }

    @Test
    public void testNonStrings() throws Exception {
        VarResolver vr = new VarResolverBuilder().defaultVars().vars(new Class[]{XVar.class}).build();
        ResolvingObjectMap m = new ResolvingObjectMap(vr.createSession());
        m.put((Object)"foo", (Object)FooEnum.ONE);
        TestUtils.assertObjectEquals("'ONE'", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new Object[]{FooEnum.ONE});
        TestUtils.assertObjectEquals("['ONE']", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new AList().append((Object)FooEnum.ONE));
        TestUtils.assertObjectEquals("['ONE']", m.get((Object)"foo"));
        m.put((Object)"foo", (Object)new AMap().append((Object)FooEnum.ONE, (Object)FooEnum.ONE));
        TestUtils.assertObjectEquals("{ONE:'ONE'}", m.get((Object)"foo"));
    }

    @Test
    public void testInner() throws Exception {
        VarResolver vr = new VarResolverBuilder().defaultVars().vars(new Class[]{XVar.class}).build();
        ResolvingObjectMap m = new ResolvingObjectMap(vr.createSession());
        ObjectMap m2 = new ObjectMap();
        ObjectMap m3 = new ObjectMap();
        m.setInner((Map)m2);
        m2.setInner((Map)m3);
        m3.put((Object)"foo", (Object)"$X{a}");
        Assert.assertEquals((Object)m.get((Object)"foo"), (Object)"1");
        m3.put((Object)"foo", (Object)new String[]{"$X{a}"});
        TestUtils.assertObjectEquals("['1']", m.get((Object)"foo"));
        m3.put((Object)"foo", (Object)new AList().append((Object)"$X{a}"));
        TestUtils.assertObjectEquals("['1']", m.get((Object)"foo"));
        m3.put((Object)"foo", (Object)new AMap().append((Object)"k1", (Object)"$X{a}"));
        TestUtils.assertObjectEquals("{k1:'1'}", m.get((Object)"foo"));
    }

    public static enum FooEnum {
        ONE;

    }

    public static class XVar
    extends MapVar {
        public XVar() {
            super("X", (Map)new ObjectMap().append("a", (Object)1).append("b", (Object)2).append("c", (Object)3));
        }
    }
}

