/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.soap.SoapXmlSerializer;
import org.apache.juneau.soap.SoapXmlSerializerSession;
import org.apache.juneau.soap.annotation.SoapXmlConfig;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class SoapXmlConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basic() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        SoapXmlSerializerSession x = SoapXmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        SoapXmlConfigAnnotationTest.check("foo", x.getSoapAction());
    }

    @Test
    public void noValues() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        SoapXmlSerializerSession x = SoapXmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        SoapXmlConfigAnnotationTest.check("http://www.w3.org/2003/05/soap-envelope", x.getSoapAction());
    }

    @Test
    public void noAnnotation() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        SoapXmlSerializerSession x = SoapXmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        SoapXmlConfigAnnotationTest.check("http://www.w3.org/2003/05/soap-envelope", x.getSoapAction());
    }

    static class C {
        C() {
        }
    }

    @SoapXmlConfig
    static class B {
        B() {
        }
    }

    @SoapXmlConfig(soapAction="$X{foo}")
    static class A {
        A() {
        }
    }
}

