/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class SerializerGroupTest {
    @Test
    public void testSerializerGroupMatching() throws Exception {
        SerializerGroup sg = SerializerGroup.create().append(new Class[]{SA1.class, SA2.class, SA3.class}).build();
        TestUtils.assertInstanceOf(SA1.class, sg.getSerializer("text/foo"));
        TestUtils.assertInstanceOf(SA1.class, sg.getSerializer("text/foo_a"));
        TestUtils.assertInstanceOf(SA1.class, sg.getSerializer("text/xxx+foo_a"));
        TestUtils.assertInstanceOf(SA1.class, sg.getSerializer("text/foo_a+xxx"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/foo+bar"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/foo+bar_a"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/bar+foo"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/bar_a+foo"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/bar+foo+xxx"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/bar_a+foo+xxx"));
        TestUtils.assertInstanceOf(SA3.class, sg.getSerializer("text/baz"));
        TestUtils.assertInstanceOf(SA3.class, sg.getSerializer("text/baz_a"));
        TestUtils.assertInstanceOf(SA3.class, sg.getSerializer("text/baz+yyy"));
        TestUtils.assertInstanceOf(SA3.class, sg.getSerializer("text/baz_a+yyy"));
        TestUtils.assertInstanceOf(SA3.class, sg.getSerializer("text/yyy+baz"));
        TestUtils.assertInstanceOf(SA3.class, sg.getSerializer("text/yyy+baz_a"));
        TestUtils.assertInstanceOf(SA1.class, sg.getSerializer("text/foo;q=0.9,text/foo+bar;q=0.8"));
        TestUtils.assertInstanceOf(SA2.class, sg.getSerializer("text/foo;q=0.8,text/foo+bar;q=0.9"));
    }

    @Test
    public void testInheritence() throws Exception {
        SerializerGroupBuilder gb = null;
        SerializerGroup g = null;
        gb = SerializerGroup.create().append(new Class[]{SB1.class, SB2.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['text/1','text/2','text/2a']", g.getSupportedMediaTypes());
        gb = g.builder().append(new Class[]{SB3.class, SB4.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['text/3','text/4','text/4a','text/1','text/2','text/2a']", g.getSupportedMediaTypes());
        gb = g.builder().append(new Class[]{SB5.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['text/5','text/3','text/4','text/4a','text/1','text/2','text/2a']", g.getSupportedMediaTypes());
    }

    @Test
    public void testMediaTypesWithMetaCharacters() throws Exception {
        SerializerGroupBuilder gb = null;
        SerializerGroup g = null;
        gb = SerializerGroup.create().append(new Class[]{SC1.class, SC2.class, SC3.class});
        g = gb.build();
        TestUtils.assertInstanceOf(SC1.class, g.getSerializer("text/foo"));
        TestUtils.assertInstanceOf(SC2.class, g.getSerializer("foo/json"));
        TestUtils.assertInstanceOf(SC3.class, g.getSerializer("foo/foo"));
    }

    public static class SC3
    extends JsonSerializer {
        public SC3(PropertyStore ps) {
            super(ps, "application/json", "*/*");
        }
    }

    public static class SC2
    extends JsonSerializer {
        public SC2(PropertyStore ps) {
            super(ps, "application/json", "*/json");
        }
    }

    public static class SC1
    extends JsonSerializer {
        public SC1(PropertyStore ps) {
            super(ps, "application/json", "text/*");
        }
    }

    public static class SB5
    extends JsonSerializer {
        public SB5(PropertyStore ps) {
            super(ps, "application/json", "text/5");
        }
    }

    public static class SB4
    extends JsonSerializer {
        public SB4(PropertyStore ps) {
            super(ps, "application/json", "text/4,text/4a");
        }
    }

    public static class SB3
    extends JsonSerializer {
        public SB3(PropertyStore ps) {
            super(ps, "application/json", "text/3");
        }
    }

    public static class SB2
    extends JsonSerializer {
        public SB2(PropertyStore ps) {
            super(ps, "application/json", "text/2,text/2a");
        }
    }

    public static class SB1
    extends JsonSerializer {
        public SB1(PropertyStore ps) {
            super(ps, "application/json", "text/1");
        }
    }

    public static class SA3
    extends JsonSerializer {
        public SA3(PropertyStore ps) {
            super(ps, "application/json", "text/baz+*,text/baz_a+*");
        }
    }

    public static class SA2
    extends JsonSerializer {
        public SA2(PropertyStore ps) {
            super(ps, "application/json", "text/foo+bar+*,text/foo+bar_a+*");
        }
    }

    public static class SA1
    extends JsonSerializer {
        public SA1(PropertyStore ps) {
            super(ps, "application/json", "text/foo+*,text/foo_a+*");
        }
    }
}

