/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.msgpack.MsgPackSerializerSession;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.annotation.SerializerConfig;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class SerializerConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof AA) {
                return "AA";
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicWriterSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        JsonSerializerSession x = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        SerializerConfigAnnotationTest.check("true", x.isAddBeanTypes());
        SerializerConfigAnnotationTest.check("true", x.isAddRootType());
        SerializerConfigAnnotationTest.check("AA", x.getListener());
        SerializerConfigAnnotationTest.check("1", x.getMaxIndent());
        SerializerConfigAnnotationTest.check("'", Character.valueOf(x.getQuoteChar()));
        SerializerConfigAnnotationTest.check("true", x.isSortCollections());
        SerializerConfigAnnotationTest.check("true", x.isSortMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimEmptyCollections());
        SerializerConfigAnnotationTest.check("true", x.isTrimEmptyMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimNullProperties());
        SerializerConfigAnnotationTest.check("true", x.isTrimStrings());
        SerializerConfigAnnotationTest.check("{absoluteAuthority:'/',absoluteContextRoot:'/',absolutePathInfo:'/',absolutePathInfoParent:'/',absoluteServletPath:'/',absoluteServletPathParent:'/',rootRelativeContextRoot:'/',rootRelativePathInfo:'/',rootRelativePathInfoParent:'/',rootRelativeServletPath:'/',rootRelativeServletPathParent:'/'}", x.getUriContext());
        SerializerConfigAnnotationTest.check("RESOURCE", x.getUriRelativity());
        SerializerConfigAnnotationTest.check("ABSOLUTE", x.getUriResolution());
        SerializerConfigAnnotationTest.check("true", x.isUseWhitespace());
    }

    @Test
    public void basicOutputStreamSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        MsgPackSerializerSession x = MsgPackSerializer.create().applyAnnotations(al, sr).build().createSession();
        SerializerConfigAnnotationTest.check("true", x.isAddBeanTypes());
        SerializerConfigAnnotationTest.check("true", x.isAddRootType());
        SerializerConfigAnnotationTest.check("HEX", x.getBinaryFormat());
        SerializerConfigAnnotationTest.check("AA", x.getListener());
        SerializerConfigAnnotationTest.check("true", x.isSortCollections());
        SerializerConfigAnnotationTest.check("true", x.isSortMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimEmptyCollections());
        SerializerConfigAnnotationTest.check("true", x.isTrimEmptyMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimNullProperties());
        SerializerConfigAnnotationTest.check("true", x.isTrimStrings());
        SerializerConfigAnnotationTest.check("{absoluteAuthority:'/',absoluteContextRoot:'/',absolutePathInfo:'/',absolutePathInfoParent:'/',absoluteServletPath:'/',absoluteServletPathParent:'/',rootRelativeContextRoot:'/',rootRelativePathInfo:'/',rootRelativePathInfoParent:'/',rootRelativeServletPath:'/',rootRelativeServletPathParent:'/'}", x.getUriContext());
        SerializerConfigAnnotationTest.check("RESOURCE", x.getUriRelativity());
        SerializerConfigAnnotationTest.check("ABSOLUTE", x.getUriResolution());
    }

    @Test
    public void noValuesWriterSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        JsonSerializerSession x = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        SerializerConfigAnnotationTest.check("false", x.isAddBeanTypes());
        SerializerConfigAnnotationTest.check("false", x.isAddRootType());
        SerializerConfigAnnotationTest.check(null, x.getListener());
        SerializerConfigAnnotationTest.check("100", x.getMaxIndent());
        SerializerConfigAnnotationTest.check("\"", Character.valueOf(x.getQuoteChar()));
        SerializerConfigAnnotationTest.check("false", x.isSortCollections());
        SerializerConfigAnnotationTest.check("false", x.isSortMaps());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyCollections());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimNullProperties());
        SerializerConfigAnnotationTest.check("false", x.isTrimStrings());
        SerializerConfigAnnotationTest.check("{absoluteAuthority:'/',absoluteContextRoot:'/',absolutePathInfo:'/',absolutePathInfoParent:'/',absoluteServletPath:'/',absoluteServletPathParent:'/',rootRelativeContextRoot:'/',rootRelativePathInfo:'/',rootRelativePathInfoParent:'/',rootRelativeServletPath:'/',rootRelativeServletPathParent:'/'}", x.getUriContext());
        SerializerConfigAnnotationTest.check("RESOURCE", x.getUriRelativity());
        SerializerConfigAnnotationTest.check("NONE", x.getUriResolution());
        SerializerConfigAnnotationTest.check("false", x.isUseWhitespace());
    }

    @Test
    public void noValuesOutputStreamSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        MsgPackSerializerSession x = MsgPackSerializer.create().applyAnnotations(al, sr).build().createSession();
        SerializerConfigAnnotationTest.check("false", x.isAddBeanTypes());
        SerializerConfigAnnotationTest.check("false", x.isAddRootType());
        SerializerConfigAnnotationTest.check("HEX", x.getBinaryFormat());
        SerializerConfigAnnotationTest.check(null, x.getListener());
        SerializerConfigAnnotationTest.check("false", x.isSortCollections());
        SerializerConfigAnnotationTest.check("false", x.isSortMaps());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyCollections());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimNullProperties());
        SerializerConfigAnnotationTest.check("false", x.isTrimStrings());
        SerializerConfigAnnotationTest.check("{absoluteAuthority:'/',absoluteContextRoot:'/',absolutePathInfo:'/',absolutePathInfoParent:'/',absoluteServletPath:'/',absoluteServletPathParent:'/',rootRelativeContextRoot:'/',rootRelativePathInfo:'/',rootRelativePathInfoParent:'/',rootRelativeServletPath:'/',rootRelativeServletPathParent:'/'}", x.getUriContext());
        SerializerConfigAnnotationTest.check("RESOURCE", x.getUriRelativity());
        SerializerConfigAnnotationTest.check("NONE", x.getUriResolution());
    }

    @Test
    public void noAnnotationWriterSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        JsonSerializerSession x = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        SerializerConfigAnnotationTest.check("false", x.isAddBeanTypes());
        SerializerConfigAnnotationTest.check("false", x.isAddRootType());
        SerializerConfigAnnotationTest.check(null, x.getListener());
        SerializerConfigAnnotationTest.check("100", x.getMaxIndent());
        SerializerConfigAnnotationTest.check("\"", Character.valueOf(x.getQuoteChar()));
        SerializerConfigAnnotationTest.check("false", x.isSortCollections());
        SerializerConfigAnnotationTest.check("false", x.isSortMaps());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyCollections());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimNullProperties());
        SerializerConfigAnnotationTest.check("false", x.isTrimStrings());
        SerializerConfigAnnotationTest.check("{absoluteAuthority:'/',absoluteContextRoot:'/',absolutePathInfo:'/',absolutePathInfoParent:'/',absoluteServletPath:'/',absoluteServletPathParent:'/',rootRelativeContextRoot:'/',rootRelativePathInfo:'/',rootRelativePathInfoParent:'/',rootRelativeServletPath:'/',rootRelativeServletPathParent:'/'}", x.getUriContext());
        SerializerConfigAnnotationTest.check("RESOURCE", x.getUriRelativity());
        SerializerConfigAnnotationTest.check("NONE", x.getUriResolution());
        SerializerConfigAnnotationTest.check("false", x.isUseWhitespace());
    }

    @Test
    public void noAnnotationOutputStreamSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        MsgPackSerializerSession x = MsgPackSerializer.create().applyAnnotations(al, sr).build().createSession();
        SerializerConfigAnnotationTest.check("false", x.isAddBeanTypes());
        SerializerConfigAnnotationTest.check("false", x.isAddRootType());
        SerializerConfigAnnotationTest.check("HEX", x.getBinaryFormat());
        SerializerConfigAnnotationTest.check(null, x.getListener());
        SerializerConfigAnnotationTest.check("false", x.isSortCollections());
        SerializerConfigAnnotationTest.check("false", x.isSortMaps());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyCollections());
        SerializerConfigAnnotationTest.check("false", x.isTrimEmptyMaps());
        SerializerConfigAnnotationTest.check("true", x.isTrimNullProperties());
        SerializerConfigAnnotationTest.check("false", x.isTrimStrings());
        SerializerConfigAnnotationTest.check("{absoluteAuthority:'/',absoluteContextRoot:'/',absolutePathInfo:'/',absolutePathInfoParent:'/',absoluteServletPath:'/',absoluteServletPathParent:'/',rootRelativeContextRoot:'/',rootRelativePathInfo:'/',rootRelativePathInfoParent:'/',rootRelativeServletPath:'/',rootRelativeServletPathParent:'/'}", x.getUriContext());
        SerializerConfigAnnotationTest.check("RESOURCE", x.getUriRelativity());
        SerializerConfigAnnotationTest.check("NONE", x.getUriResolution());
    }

    static class C {
        C() {
        }
    }

    @SerializerConfig
    static class B {
        B() {
        }
    }

    @SerializerConfig(addBeanTypes="$X{true}", addRootType="$X{true}", binaryFormat="$X{HEX}", listener=AA.class, maxIndent="$X{1}", quoteChar="$X{'}", sortCollections="$X{true}", sortMaps="$X{true}", trimEmptyCollections="$X{true}", trimEmptyMaps="$X{true}", trimNullProperties="$X{true}", trimStrings="$X{true}", uriContext="{}", uriRelativity="$X{RESOURCE}", uriResolution="$X{ABSOLUTE}", useWhitespace="$X{true}")
    static class A {
        A() {
        }
    }

    public static class AA
    extends SerializerListener {
    }
}

