/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.junit.Assert;
import org.junit.Test;

public class ParamInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof List) {
                return ((List)t).stream().map(this).collect(Collectors.joining(","));
            }
            if (t.getClass().isArray()) {
                return StreamSupport.stream(ArrayUtils.toList((Object)t, Object.class).spliterator(), false).map(this).collect(Collectors.joining(","));
            }
            if (t instanceof MethodInfo) {
                return ((MethodInfo)t).getDeclaringClass().getSimpleName() + '.' + ((MethodInfo)t).getShortName();
            }
            if (t instanceof CA) {
                return "@CA(" + ((CA)t).value() + ")";
            }
            if (t instanceof DA) {
                return "@DA(" + ((DA)t).value() + ")";
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            return t.toString();
        }
    };
    static ClassInfo b = ClassInfo.of(B.class);
    static ParamInfo b_b_a = b.getPublicConstructor(new Class[]{Integer.TYPE, String.class}).getParam(0);
    static ParamInfo b_b_b = b.getPublicConstructor(new Class[]{Integer.TYPE, String.class}).getParam(1);
    static ParamInfo b_a1_a = b.getMethod("a1", new Class[]{Integer.TYPE, String.class}).getParam(0);
    static ParamInfo b_a1_b = b.getMethod("a1", new Class[]{Integer.TYPE, String.class}).getParam(1);
    static ParamInfo b_a2_a = b.getMethod("a2", new Class[]{Integer.TYPE, String.class}).getParam(0);
    static ParamInfo b_a2_b = b.getMethod("a2", new Class[]{Integer.TYPE, String.class}).getParam(1);
    static ClassInfo cb = ClassInfo.of(CB.class);
    static ClassInfo cc = ClassInfo.of(CC.class);
    static ParamInfo cc_cc = cc.getPublicConstructor(new Class[]{C1.class}).getParam(0);
    static ParamInfo cb_a1 = cb.getMethod("a1", new Class[]{C1.class}).getParam(0);
    static ParamInfo cb_a2 = cb.getMethod("a2", new Class[]{C1.class}).getParam(0);
    static ParamInfo cc_a1 = cc.getMethod("a1", new Class[]{C1.class}).getParam(0);
    static ParamInfo cc_a2 = cc.getMethod("a2", new Class[]{C1.class}).getParam(0);
    static ClassInfo db = ClassInfo.of(DB.class);
    static ClassInfo dc = ClassInfo.of(DC.class);
    static ParamInfo db_a1 = db.getMethod("a1", new Class[]{D1.class}).getParam(0);
    static ParamInfo dc_a1 = dc.getMethod("a1", new Class[]{D1.class}).getParam(0);
    static ClassInfo e = ClassInfo.of(E.class);
    static ParamInfo e_a1_a = e.getMethod("a1", new Class[]{Integer.TYPE, Integer.TYPE}).getParam(0);
    static ParamInfo e_a1_b = e.getMethod("a1", new Class[]{Integer.TYPE, Integer.TYPE}).getParam(1);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void getIndex() {
        Assert.assertEquals((long)0L, (long)b_b_a.getIndex());
        Assert.assertEquals((long)1L, (long)b_b_b.getIndex());
        Assert.assertEquals((long)0L, (long)b_a1_a.getIndex());
        Assert.assertEquals((long)1L, (long)b_a1_b.getIndex());
        Assert.assertEquals((long)0L, (long)b_a2_a.getIndex());
        Assert.assertEquals((long)1L, (long)b_a2_b.getIndex());
    }

    @Test
    public void getMethod() {
        ParamInfoTest.check("B.a1(int,String)", b_a1_a.getMethod());
        ParamInfoTest.check("B.a1(int,String)", b_a1_b.getMethod());
        ParamInfoTest.check("B.a2(int,String)", b_a2_a.getMethod());
        ParamInfoTest.check("B.a2(int,String)", b_a2_b.getMethod());
    }

    @Test
    public void getMethod_onConstrutor() {
        ParamInfoTest.check(null, b_b_a.getMethod());
        ParamInfoTest.check(null, b_b_b.getMethod());
    }

    @Test
    public void getConstructor() {
        ParamInfoTest.check("B(int,String)", b_b_a.getConstructor());
        ParamInfoTest.check("B(int,String)", b_b_b.getConstructor());
    }

    @Test
    public void getConstructor_onMethod() {
        ParamInfoTest.check(null, b_a1_a.getConstructor());
        ParamInfoTest.check(null, b_a1_b.getConstructor());
        ParamInfoTest.check(null, b_a2_a.getConstructor());
        ParamInfoTest.check(null, b_a2_b.getConstructor());
    }

    @Test
    public void getParameterType() {
        ParamInfoTest.check("int", b_b_a.getParameterType());
        ParamInfoTest.check("String", b_b_b.getParameterType());
        ParamInfoTest.check("int", b_a1_a.getParameterType());
        ParamInfoTest.check("String", b_a1_b.getParameterType());
        ParamInfoTest.check("int", b_a2_a.getParameterType());
        ParamInfoTest.check("String", b_a2_b.getParameterType());
    }

    @Test
    public void getDeclaredAnnotations() throws Exception {
        ParamInfoTest.check("@CA(5)", cb_a1.getDeclaredAnnotations());
        ParamInfoTest.check("@CA(5)", cb_a2.getDeclaredAnnotations());
        ParamInfoTest.check("", cc_a1.getDeclaredAnnotations());
        ParamInfoTest.check("@CA(6)", cc_a2.getDeclaredAnnotations());
    }

    @Test
    public void getDeclaredAnnotations_constructor() throws Exception {
        ParamInfoTest.check("@CA(9)", cc_cc.getDeclaredAnnotations());
    }

    @Test
    public void getDeclaredAnnotation() throws Exception {
        ParamInfoTest.check("@CA(5)", cb_a1.getDeclaredAnnotation(CA.class));
        ParamInfoTest.check("@CA(5)", cb_a2.getDeclaredAnnotation(CA.class));
        ParamInfoTest.check(null, cc_a1.getDeclaredAnnotation(CA.class));
        ParamInfoTest.check("@CA(6)", cc_a2.getDeclaredAnnotation(CA.class));
    }

    @Test
    public void getDeclaredAnnotation_constructor() throws Exception {
        ParamInfoTest.check("@CA(9)", cc_cc.getDeclaredAnnotation(CA.class));
    }

    @Test
    public void getDeclaredAnnotation_notFound() throws Exception {
        ParamInfoTest.check(null, cb_a1.getDeclaredAnnotation(DA.class));
    }

    @Test
    public void getDeclaredAnnotation_notFound_constructor() throws Exception {
        ParamInfoTest.check(null, cc_cc.getDeclaredAnnotation(DA.class));
    }

    @Test
    public void getDeclaredAnnotation_null() throws Exception {
        ParamInfoTest.check(null, cb_a1.getDeclaredAnnotation(null));
    }

    @Test
    public void getDeclaredAnnotation_null_constructor() throws Exception {
        ParamInfoTest.check(null, cc_cc.getDeclaredAnnotation(null));
    }

    @Test
    public void getAnnotations() throws Exception {
        ParamInfoTest.check("@CA(5),@CA(1),@CA(2),@CA(3),@CA(4)", cb_a1.getAnnotations(CA.class));
        ParamInfoTest.check("@CA(5),@CA(1),@CA(2),@CA(3),@CA(4)", cb_a2.getAnnotations(CA.class));
        ParamInfoTest.check("@CA(5),@CA(1),@CA(2),@CA(3),@CA(4)", cc_a1.getAnnotations(CA.class));
        ParamInfoTest.check("@CA(6),@CA(5),@CA(1),@CA(2),@CA(3),@CA(4)", cc_a2.getAnnotations(CA.class));
    }

    @Test
    public void getAnnotations_notFound() throws Exception {
        ParamInfoTest.check("", cb_a1.getAnnotations(DA.class));
    }

    @Test
    public void getAnnotations_constructor() throws Exception {
        ParamInfoTest.check("@CA(9),@CA(1),@CA(2),@CA(3),@CA(4)", cc_cc.getAnnotations(CA.class));
    }

    @Test
    public void getAnnotations_notFound_constructor() throws Exception {
        ParamInfoTest.check("", cc_cc.getAnnotations(DA.class));
    }

    @Test
    public void getAnnotationsParentFirst() throws Exception {
        ParamInfoTest.check("@CA(4),@CA(3),@CA(2),@CA(1),@CA(5)", cb_a1.getAnnotationsParentFirst(CA.class));
        ParamInfoTest.check("@CA(4),@CA(3),@CA(2),@CA(1),@CA(5)", cb_a2.getAnnotationsParentFirst(CA.class));
        ParamInfoTest.check("@CA(4),@CA(3),@CA(2),@CA(1),@CA(5)", cc_a1.getAnnotationsParentFirst(CA.class));
        ParamInfoTest.check("@CA(4),@CA(3),@CA(2),@CA(1),@CA(5),@CA(6)", cc_a2.getAnnotationsParentFirst(CA.class));
    }

    @Test
    public void getAnnotationsParentFirst_notFound() throws Exception {
        ParamInfoTest.check("", cb_a1.getAnnotationsParentFirst(DA.class));
    }

    @Test
    public void getAnnotationsParentFirst_constructor() throws Exception {
        ParamInfoTest.check("@CA(4),@CA(3),@CA(2),@CA(1),@CA(9)", cc_cc.getAnnotationsParentFirst(CA.class));
    }

    @Test
    public void getAnnotationsParentFirst_notFound_constructor() throws Exception {
        ParamInfoTest.check("", cc_cc.getAnnotationsParentFirst(DA.class));
    }

    @Test
    public void getAnnotation() throws Exception {
        ParamInfoTest.check("@CA(5)", cb_a1.getAnnotation(CA.class));
        ParamInfoTest.check("@CA(5)", cb_a2.getAnnotation(CA.class));
        ParamInfoTest.check("@CA(5)", cc_a1.getAnnotation(CA.class));
        ParamInfoTest.check("@CA(6)", cc_a2.getAnnotation(CA.class));
    }

    @Test
    public void getAnnotation_notFound() throws Exception {
        ParamInfoTest.check(null, cb_a1.getAnnotation(DA.class));
    }

    @Test
    public void getAnnotation_constructor() throws Exception {
        ParamInfoTest.check("@CA(9)", cc_cc.getAnnotation(CA.class));
    }

    @Test
    public void getAnnotation_notFound_constructor() throws Exception {
        ParamInfoTest.check(null, cc_cc.getAnnotation(DA.class));
    }

    @Test
    public void getAnnotation_twice() throws Exception {
        ParamInfoTest.check("@CA(5)", cb_a1.getAnnotation(CA.class));
        ParamInfoTest.check("@CA(5)", cb_a1.getAnnotation(CA.class));
    }

    @Test
    public void getAnnotation_twice_constructor() throws Exception {
        ParamInfoTest.check("@CA(9)", cc_cc.getAnnotation(CA.class));
        ParamInfoTest.check("@CA(9)", cc_cc.getAnnotation(CA.class));
    }

    @Test
    public void hasAnnotation() throws Exception {
        Assert.assertTrue((boolean)cb_a1.hasAnnotation(CA.class));
        Assert.assertTrue((boolean)cb_a2.hasAnnotation(CA.class));
        Assert.assertTrue((boolean)cc_a1.hasAnnotation(CA.class));
        Assert.assertTrue((boolean)cc_a2.hasAnnotation(CA.class));
        Assert.assertFalse((boolean)cb_a1.hasAnnotation(DA.class));
    }

    @Test
    public void hasAnnotation_constructor() throws Exception {
        Assert.assertTrue((boolean)cc_cc.hasAnnotation(CA.class));
        Assert.assertFalse((boolean)cc_cc.hasAnnotation(DA.class));
    }

    @Test
    public void getAnnotations_inherited() throws Exception {
        ParamInfoTest.check("@DA(0),@DA(1),@DA(2),@DA(3),@DA(4)", db_a1.getAnnotations(DA.class));
        ParamInfoTest.check("@DA(5),@DA(0),@DA(1),@DA(2),@DA(3),@DA(4)", dc_a1.getAnnotations(DA.class));
    }

    @Test
    public void getAnnotations_inherited_notFound() throws Exception {
        ParamInfoTest.check("", db_a1.getAnnotations(CA.class));
    }

    @Test
    public void getAnnotationsParentFirst_inherited() throws Exception {
        ParamInfoTest.check("@DA(4),@DA(3),@DA(2),@DA(1),@DA(0)", db_a1.getAnnotationsParentFirst(DA.class));
        ParamInfoTest.check("@DA(4),@DA(3),@DA(2),@DA(1),@DA(0),@DA(5)", dc_a1.getAnnotationsParentFirst(DA.class));
    }

    @Test
    public void getAnnotationsParentFirst_inherited_notFound() throws Exception {
        ParamInfoTest.check("", db_a1.getAnnotationsParentFirst(CA.class));
    }

    @Test
    public void getAnnotation_inherited() throws Exception {
        ParamInfoTest.check("@DA(0)", db_a1.getAnnotation(DA.class));
        ParamInfoTest.check("@DA(5)", dc_a1.getAnnotation(DA.class));
    }

    @Test
    public void getAnnotation_inherited_notFound() throws Exception {
        ParamInfoTest.check(null, db_a1.getAnnotation(CA.class));
    }

    @Test
    public void hasName() {
        e_a1_a.hasName();
        Assert.assertTrue((boolean)e_a1_b.hasName());
    }

    @Test
    public void getName() {
        e_a1_a.getName();
        Assert.assertEquals((Object)"b", (Object)e_a1_b.getName());
    }

    @Test
    public void toString2() {
        Assert.assertEquals((Object)"a1[1]", (Object)e_a1_b.toString());
    }

    static class E {
        E() {
        }

        public void a1(int a, @Name(value="b") int b) {
        }
    }

    public static class DC
    implements DB {
        @Override
        public void a1(@DA(value="5") D1 x) {
        }
    }

    public static interface DB {
        public void a1(@DA(value="0") D1 var1);
    }

    @DA(value="4")
    public static interface D4 {
    }

    @DA(value="3")
    public static interface D3 {
    }

    @DA(value="2")
    public static class D2
    implements D3,
    D4 {
    }

    @DA(value="1")
    public static class D1
    extends D2 {
    }

    @Target(value={ElementType.PARAMETER, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface DA {
        public String value();
    }

    public static class CC
    implements CB {
        public CC(@CA(value="9") C1 x) {
        }

        @Override
        public void a1(C1 x) {
        }

        @Override
        public void a2(@CA(value="6") C1 x) {
        }
    }

    public static interface CB {
        public void a1(@CA(value="5") C1 var1);

        public void a2(@CA(value="5") C1 var1);
    }

    @CA(value="4")
    public static interface C4 {
    }

    @CA(value="3")
    public static interface C3 {
    }

    @CA(value="2")
    public static class C2
    implements C3,
    C4 {
    }

    @CA(value="1")
    public static class C1
    extends C2 {
    }

    @Target(value={ElementType.PARAMETER, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CA {
        public String value();
    }

    static class B {
        public B(int a, String b) {
        }

        public void a1(int a, String b) {
        }

        void a2(int a, String b) {
        }
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface AX {
        public String value();
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface A {
        public String value();
    }
}

