/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.annotation.PropertyStoreApply;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflection.PA;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class MethodInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof MethodInfo) {
                return ((MethodInfo)t).getDeclaringClass().getSimpleName() + '.' + ((MethodInfo)t).getShortName();
            }
            if (t instanceof Method) {
                return ((Method)t).getDeclaringClass().getSimpleName() + '.' + MethodInfo.of((Method)((Method)t)).getShortName();
            }
            if (t instanceof List) {
                return ((List)t).stream().map(this).collect(Collectors.joining(","));
            }
            if (t instanceof AnnotationInfo) {
                return this.apply(((AnnotationInfo)t).getAnnotation());
            }
            if (t instanceof A) {
                return "@A(" + ((A)t).value() + ")";
            }
            if (t instanceof PA) {
                return "@PA(" + ((PA)t).value() + ")";
            }
            if (t instanceof AConfig) {
                return "@AConfig(" + ((AConfig)t).value() + ")";
            }
            if (t instanceof AnnotationList) {
                AnnotationList al = (AnnotationList)t;
                return al.toString();
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            return t.toString();
        }
    };
    static MethodInfo a_m = MethodInfoTest.ofm(A1.class, "m", new Class[0]);
    static MethodInfo c_a1 = MethodInfoTest.ofm(C3.class, "a1", new Class[0]);
    static MethodInfo c_a2 = MethodInfoTest.ofm(C3.class, "a2", new Class[0]);
    static MethodInfo c_a3 = MethodInfoTest.ofm(C3.class, "a3", CharSequence.class);
    static MethodInfo c_a4 = MethodInfoTest.ofm(C3.class, "a4", new Class[0]);
    static MethodInfo c_a5 = MethodInfoTest.ofm(C3.class, "a5", new Class[0]);
    static MethodInfo cb_a1 = MethodInfoTest.ofm(CB3.class, "a1", new Class[0]);
    static MethodInfo cb_a2 = MethodInfoTest.ofm(CB3.class, "a2", new Class[0]);
    static MethodInfo cb_a3 = MethodInfoTest.ofm(CB3.class, "a3", CharSequence.class);
    static MethodInfo cb_a4 = MethodInfoTest.ofm(CB3.class, "a4", new Class[0]);
    static MethodInfo cb_a5 = MethodInfoTest.ofm(CB3.class, "a5", new Class[0]);
    static MethodInfo d_a1 = MethodInfoTest.ofm(D.class, "a1", new Class[0]);
    static MethodInfo d_a2 = MethodInfoTest.ofm(D.class, "a2", new Class[0]);
    static MethodInfo e_a1 = MethodInfoTest.ofm(E.class, "a1", CharSequence.class);
    static MethodInfo e_a2 = MethodInfoTest.ofm(E.class, "a2", Integer.TYPE, Integer.TYPE);
    static MethodInfo e_a3 = MethodInfoTest.ofm(E.class, "a3", new Class[0]);
    static MethodInfo f_isA = MethodInfoTest.ofm(F.class, "isA", new Class[0]);
    static MethodInfo f_is = MethodInfoTest.ofm(F.class, "is", new Class[0]);
    static MethodInfo f_getA = MethodInfoTest.ofm(F.class, "getA", new Class[0]);
    static MethodInfo f_get = MethodInfoTest.ofm(F.class, "get", new Class[0]);
    static MethodInfo f_setA = MethodInfoTest.ofm(F.class, "setA", new Class[0]);
    static MethodInfo f_set = MethodInfoTest.ofm(F.class, "set", new Class[0]);
    static MethodInfo f_foo = MethodInfoTest.ofm(F.class, "foo", new Class[0]);
    static MethodInfo g_a1a = MethodInfoTest.ofm(G.class, "a1", new Class[0]);
    static MethodInfo g_a1b = MethodInfoTest.ofm(G.class, "a1", Integer.TYPE);
    static MethodInfo g_a1c = MethodInfoTest.ofm(G.class, "a1", Integer.TYPE, Integer.TYPE);
    static MethodInfo g_a1d = MethodInfoTest.ofm(G.class, "a1", String.class);
    static MethodInfo g_a2 = MethodInfoTest.ofm(G.class, "a2", new Class[0]);
    static MethodInfo g_a3 = MethodInfoTest.ofm(G.class, "a3", new Class[0]);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    private static MethodInfo ofm(Class<?> c, String name, Class<?> ... pt) {
        try {
            return MethodInfo.of((Method)c.getDeclaredMethod(name, pt));
        }
        catch (NoSuchMethodException | SecurityException e) {
            Assert.fail((String)e.getLocalizedMessage());
            return null;
        }
    }

    @Test
    public void of_withDeclaringClass() {
        MethodInfoTest.check("A1.m()", a_m);
        MethodInfoTest.check("A1.m()", MethodInfo.of((ClassInfo)ClassInfo.of(A1.class), (Method)a_m.inner(), null));
    }

    @Test
    public void of_withoutDeclaringClass() {
        MethodInfo mi = MethodInfo.of((Method)a_m.inner());
        MethodInfoTest.check("A1.m()", mi);
    }

    @Test
    public void of_null() {
        MethodInfoTest.check(null, MethodInfo.of(null));
        MethodInfoTest.check(null, MethodInfo.of((ClassInfo)null, null, null));
    }

    @Test
    public void findMatchingMethods() throws Exception {
        MethodInfo mi = MethodInfo.of((Method)B3.class.getMethod("foo", Integer.TYPE));
        MethodInfoTest.check("B3.foo(int),B2.foo(int),B1.foo(int)", mi.getMatching());
    }

    @Test
    public void getAnnotations() {
        MethodInfoTest.check("@A(a1),@A(C3),@A(C2),@A(C1)", c_a1.getAnnotations(A.class));
        MethodInfoTest.check("@A(a2b),@A(a2a),@A(C3),@A(C2),@A(C1)", c_a2.getAnnotations(A.class));
        MethodInfoTest.check("@A(a3),@A(C3),@A(C2),@A(C1)", c_a3.getAnnotations(A.class));
        MethodInfoTest.check("@A(a4),@A(C3),@A(C2),@A(C1)", c_a4.getAnnotations(A.class));
        MethodInfoTest.check("@A(C3),@A(C2),@A(C1)", c_a5.getAnnotations(A.class));
    }

    @Test
    public void getAnnotations_notExistent() {
        MethodInfoTest.check("", c_a1.getAnnotations(AX.class));
        MethodInfoTest.check("", c_a2.getAnnotations(AX.class));
        MethodInfoTest.check("", c_a3.getAnnotations(AX.class));
        MethodInfoTest.check("", c_a4.getAnnotations(AX.class));
        MethodInfoTest.check("", c_a5.getAnnotations(AX.class));
    }

    @Test
    public void getAnnotationsParentFirst() {
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a1)", c_a1.getAnnotationsParentFirst(A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a2a),@A(a2b)", c_a2.getAnnotationsParentFirst(A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a3)", c_a3.getAnnotationsParentFirst(A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a4)", c_a4.getAnnotationsParentFirst(A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3)", c_a5.getAnnotationsParentFirst(A.class));
    }

    @Test
    public void appendAnnotations() {
        MethodInfoTest.check("@A(a1),@A(C3),@A(C2),@A(C1)", c_a1.appendAnnotations(new ArrayList(), A.class));
        MethodInfoTest.check("@A(a2b),@A(a2a),@A(C3),@A(C2),@A(C1)", c_a2.appendAnnotations(new ArrayList(), A.class));
        MethodInfoTest.check("@A(a3),@A(C3),@A(C2),@A(C1)", c_a3.appendAnnotations(new ArrayList(), A.class));
        MethodInfoTest.check("@A(a4),@A(C3),@A(C2),@A(C1)", c_a4.appendAnnotations(new ArrayList(), A.class));
        MethodInfoTest.check("@A(C3),@A(C2),@A(C1)", c_a5.appendAnnotations(new ArrayList(), A.class));
    }

    @Test
    public void appendAnnotationsParentFirst() {
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a1)", c_a1.appendAnnotationsParentFirst(new ArrayList(), A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a2a),@A(a2b)", c_a2.appendAnnotationsParentFirst(new ArrayList(), A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a3)", c_a3.appendAnnotationsParentFirst(new ArrayList(), A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3),@A(a4)", c_a4.appendAnnotationsParentFirst(new ArrayList(), A.class));
        MethodInfoTest.check("@A(C1),@A(C2),@A(C3)", c_a5.appendAnnotationsParentFirst(new ArrayList(), A.class));
    }

    @Test
    public void getAnnotation() {
        MethodInfoTest.check("@A(a1)", c_a1.getAnnotation(A.class));
        MethodInfoTest.check("@A(a2b)", c_a2.getAnnotation(A.class));
        MethodInfoTest.check("@A(a3)", c_a3.getAnnotation(A.class));
        MethodInfoTest.check("@A(a4)", c_a4.getAnnotation(A.class));
        MethodInfoTest.check(null, c_a5.getAnnotation(A.class));
    }

    @Test
    public void getAnnotationAny() {
        MethodInfoTest.check("@A(a1)", c_a1.getAnyAnnotation(new Class[]{AX.class, A.class}));
        MethodInfoTest.check("@A(a2b)", c_a2.getAnyAnnotation(new Class[]{AX.class, A.class}));
        MethodInfoTest.check("@A(a3)", c_a3.getAnyAnnotation(new Class[]{AX.class, A.class}));
        MethodInfoTest.check("@A(a4)", c_a4.getAnyAnnotation(new Class[]{AX.class, A.class}));
        MethodInfoTest.check(null, c_a5.getAnyAnnotation(new Class[]{AX.class, A.class}));
    }

    @Test
    public void getAnnotationsMap() {
        MethodInfoTest.check("@A(C3),@A(C2),@A(a1),@A(C1),@PA(10)", c_a1.getAnnotationList(null));
        MethodInfoTest.check("@A(C3),@A(a2b),@A(C2),@A(a2a),@A(C1),@PA(10)", c_a2.getAnnotationList(null));
        MethodInfoTest.check("@A(C3),@A(C2),@A(a3),@A(C1),@PA(10)", c_a3.getAnnotationList(null));
        MethodInfoTest.check("@A(a4),@A(C3),@A(C2),@A(C1),@PA(10)", c_a4.getAnnotationList(null));
        MethodInfoTest.check("@A(C3),@A(C2),@A(C1),@PA(10)", c_a5.getAnnotationList(null));
    }

    @Test
    public void getAnnotationsMapParentFirst() {
        MethodInfoTest.check("@PA(10),@A(C1),@A(a1),@A(C2),@A(C3)", c_a1.getAnnotationListParentFirst(null));
        MethodInfoTest.check("@PA(10),@A(C1),@A(a2a),@A(C2),@A(a2b),@A(C3)", c_a2.getAnnotationListParentFirst(null));
        MethodInfoTest.check("@PA(10),@A(C1),@A(a3),@A(C2),@A(C3)", c_a3.getAnnotationListParentFirst(null));
        MethodInfoTest.check("@PA(10),@A(C1),@A(C2),@A(C3),@A(a4)", c_a4.getAnnotationListParentFirst(null));
        MethodInfoTest.check("@PA(10),@A(C1),@A(C2),@A(C3)", c_a5.getAnnotationListParentFirst(null));
    }

    @Test
    public void getConfigAnnotationsMap() {
        MethodInfoTest.check("@AConfig(C3),@AConfig(C2),@AConfig(a1),@AConfig(C1)", cb_a1.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C3),@AConfig(a2b),@AConfig(C2),@AConfig(a2a),@AConfig(C1)", cb_a2.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C3),@AConfig(C2),@AConfig(a3),@AConfig(C1)", cb_a3.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(a4),@AConfig(C3),@AConfig(C2),@AConfig(C1)", cb_a4.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C3),@AConfig(C2),@AConfig(C1)", cb_a5.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
    }

    @Test
    public void getConfigAnnotationsMapParentFirst() {
        MethodInfoTest.check("@AConfig(C1),@AConfig(a1),@AConfig(C2),@AConfig(C3)", cb_a1.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C1),@AConfig(a2a),@AConfig(C2),@AConfig(a2b),@AConfig(C3)", cb_a2.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C1),@AConfig(a3),@AConfig(C2),@AConfig(C3)", cb_a3.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C1),@AConfig(C2),@AConfig(C3),@AConfig(a4)", cb_a4.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
        MethodInfoTest.check("@AConfig(C1),@AConfig(C2),@AConfig(C3)", cb_a5.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
    }

    @Test
    public void getReturnType() {
        MethodInfoTest.check("void", d_a1.getReturnType());
        MethodInfoTest.check("Integer", d_a2.getReturnType());
    }

    @Test
    public void hasReturnType() {
        Assert.assertTrue((boolean)d_a1.hasReturnType(Void.TYPE));
        Assert.assertFalse((boolean)d_a1.hasReturnType(Integer.class));
        Assert.assertTrue((boolean)d_a2.hasReturnType(Integer.class));
        Assert.assertFalse((boolean)d_a2.hasReturnType(Number.class));
    }

    @Test
    public void hasReturnTypeParent() {
        Assert.assertTrue((boolean)d_a1.hasReturnTypeParent(Void.TYPE));
        Assert.assertFalse((boolean)d_a1.hasReturnTypeParent(Integer.class));
        Assert.assertTrue((boolean)d_a2.hasReturnTypeParent(Integer.class));
        Assert.assertTrue((boolean)d_a2.hasReturnTypeParent(Number.class));
    }

    @Test
    public void invoke() {
        try {
            E e = new E();
            e_a1.invoke((Object)e, new Object[]{"foo"});
            Assert.assertEquals((Object)"foo", (Object)e.f);
            e_a1.invoke((Object)e, new Object[]{null});
            Assert.assertNull((Object)e.f);
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void invokeFuzzy() {
        try {
            E e = new E();
            e_a1.invokeFuzzy((Object)e, new Object[]{"foo", 123});
            Assert.assertEquals((Object)"foo", (Object)e.f);
            e_a1.invokeFuzzy((Object)e, new Object[]{123, "bar"});
            Assert.assertEquals((Object)"bar", (Object)e.f);
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void getSignature() {
        Assert.assertEquals((Object)"a1(java.lang.CharSequence)", (Object)e_a1.getSignature());
        Assert.assertEquals((Object)"a2(int,int)", (Object)e_a2.getSignature());
        Assert.assertEquals((Object)"a3", (Object)e_a3.getSignature());
    }

    @Test
    public void argsOnlyOfType() {
        Assert.assertTrue((boolean)e_a1.argsOnlyOfType(new Class[]{CharSequence.class}));
        Assert.assertTrue((boolean)e_a1.argsOnlyOfType(new Class[]{CharSequence.class, Map.class}));
        Assert.assertFalse((boolean)e_a1.argsOnlyOfType(new Class[0]));
    }

    @Test
    public void getPropertyName() {
        Assert.assertEquals((Object)"a", (Object)f_isA.getPropertyName());
        Assert.assertEquals((Object)"is", (Object)f_is.getPropertyName());
        Assert.assertEquals((Object)"a", (Object)f_getA.getPropertyName());
        Assert.assertEquals((Object)"get", (Object)f_get.getPropertyName());
        Assert.assertEquals((Object)"a", (Object)f_setA.getPropertyName());
        Assert.assertEquals((Object)"set", (Object)f_set.getPropertyName());
        Assert.assertEquals((Object)"foo", (Object)f_foo.getPropertyName());
    }

    @Test
    public void isBridge() {
        Assert.assertFalse((boolean)f_foo.isBridge());
    }

    @Test
    public void compareTo() {
        TreeSet<MethodInfo> s = new TreeSet<MethodInfo>(Arrays.asList(g_a1a, g_a1b, g_a1c, g_a1d, g_a2, g_a3));
        MethodInfoTest.check("[a1(), a1(int), a1(String), a1(int,int), a2(), a3()]", s);
    }

    public static class G {
        public void a1() {
        }

        public void a1(int a1) {
        }

        public void a1(int a1, int a2) {
        }

        public void a1(String a1) {
        }

        public void a2() {
        }

        public void a3() {
        }
    }

    public static class F {
        public void isA() {
        }

        public void is() {
        }

        public void getA() {
        }

        public void get() {
        }

        public void setA() {
        }

        public void set() {
        }

        public void foo() {
        }
    }

    public static class E {
        private String f;

        public void a1(CharSequence foo) {
            this.f = foo == null ? null : foo.toString();
        }

        public void a2(int f1, int f2) {
        }

        public void a3() {
        }
    }

    public static class D {
        public void a1() {
        }

        public Integer a2() {
            return null;
        }
    }

    @A(value="C3")
    @AConfig(value="C3")
    public static class CB3
    extends CB2 {
        @Override
        public void a1() {
        }

        @Override
        public void a2() {
        }

        @Override
        public void a3(CharSequence foo) {
        }

        @Override
        @A(value="a4")
        @AConfig(value="a4")
        public void a4() {
        }

        @Override
        public void a5() {
        }
    }

    @A(value="C2")
    @AConfig(value="C2")
    public static class CB2
    implements CB1 {
        @Override
        public void a1() {
        }

        @Override
        @A(value="a2b")
        @AConfig(value="a2b")
        public void a2() {
        }

        @Override
        public void a3(CharSequence s) {
        }

        @Override
        public void a4() {
        }

        @Override
        public void a5() {
        }
    }

    @A(value="C1")
    @AConfig(value="C1")
    public static interface CB1 {
        @A(value="a1")
        @AConfig(value="a1")
        public void a1();

        @A(value="a2a")
        @AConfig(value="a2a")
        public void a2();

        @A(value="a3")
        @AConfig(value="a3")
        public void a3(CharSequence var1);

        public void a4();

        public void a5();
    }

    @A(value="C3")
    public static class C3
    extends C2 {
        @Override
        public void a1() {
        }

        @Override
        public void a2() {
        }

        @Override
        public void a3(CharSequence foo) {
        }

        @Override
        @A(value="a4")
        public void a4() {
        }

        @Override
        public void a5() {
        }
    }

    @A(value="C2")
    public static class C2
    implements C1 {
        @Override
        public void a1() {
        }

        @Override
        @A(value="a2b")
        public void a2() {
        }

        @Override
        public void a3(CharSequence s) {
        }

        @Override
        public void a4() {
        }

        @Override
        public void a5() {
        }
    }

    @A(value="C1")
    public static interface C1 {
        @A(value="a1")
        public void a1();

        @A(value="a2a")
        public void a2();

        @A(value="a3")
        public void a3(CharSequence var1);

        public void a4();

        public void a5();
    }

    public static class B3
    extends B2
    implements B1 {
        @Override
        public int foo(int x) {
            return 0;
        }

        @Override
        public int foo(String x) {
            return 0;
        }

        @Override
        public int foo() {
            return 0;
        }
    }

    public static class B2 {
        public int foo(int x) {
            return 0;
        }

        public int foo(String x) {
            return 0;
        }

        public int foo() {
            return 0;
        }
    }

    public static interface B1 {
        public int foo(int var1);

        public int foo(String var1);

        public int foo();
    }

    public static class A1 {
        public void m() {
        }
    }

    public static class AConfigApply
    extends ConfigApply<AConfig> {
        protected AConfigApply(Class<AConfig> c, VarResolverSession r) {
            super(c, r);
        }

        public void apply(AnnotationInfo<AConfig> a, PropertyStoreBuilder ps) {
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @PropertyStoreApply(value=AConfigApply.class)
    public static @interface AConfig {
        public String value();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface AX {
        public String value();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface A {
        public String value();
    }
}

