/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.apache.juneau.Visibility;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.ReflectFlags;
import org.junit.Assert;
import org.junit.Test;

public class FieldInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof A) {
                return "@A(" + ((A)t).value() + ")";
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            if (t instanceof FieldInfo) {
                return ((FieldInfo)t).getName();
            }
            if (t instanceof Field) {
                return ((Field)t).getName();
            }
            return t.toString();
        }
    };
    FieldInfo a1_f1 = FieldInfoTest.off(A1.class, "f1");
    FieldInfo b_a1 = FieldInfoTest.off(B.class, "a1");
    FieldInfo b_a2 = FieldInfoTest.off(B.class, "a2");
    static ClassInfo c = ClassInfo.of(C.class);
    static FieldInfo c_deprecated = c.getPublicField("deprecated");
    static FieldInfo c_notDeprecated = c.getPublicField("notDeprecated");
    static FieldInfo c_isPublic = c.getPublicField("isPublic");
    static FieldInfo c_isNotPublic = c.getDeclaredField("isNotPublic");
    static FieldInfo c_isStatic = c.getPublicField("isStatic");
    static FieldInfo c_isNotStatic = c.getPublicField("isNotStatic");
    static FieldInfo c_isTransient = c.getPublicField("isTransient");
    static FieldInfo c_isNotTransient = c.getPublicField("isNotTransient");
    static ClassInfo d = ClassInfo.of(D.class);
    static FieldInfo d_isPublic = d.getPublicField("isPublic");
    static FieldInfo d_isProtected = d.getDeclaredField("isProtected");
    static FieldInfo d_isPrivate = d.getDeclaredField("isPrivate");
    static FieldInfo d_isDefault = d.getDeclaredField("isDefault");
    static ClassInfo e = ClassInfo.of(E.class);
    static FieldInfo e_a1 = e.getPublicField("a1");
    static FieldInfo e_a2 = e.getDeclaredField("a2");

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    private static FieldInfo off(Class<?> c, String name) {
        try {
            return FieldInfo.of((Field)c.getDeclaredField(name));
        }
        catch (NoSuchFieldException | SecurityException e) {
            Assert.fail((String)e.getLocalizedMessage());
            return null;
        }
    }

    @Test
    public void of_withClass() {
        FieldInfoTest.check("f1", FieldInfo.of((ClassInfo)ClassInfo.of(A1.class), (Field)this.a1_f1.inner()));
    }

    @Test
    public void of_withoutClass() {
        FieldInfoTest.check("f1", FieldInfo.of((Field)this.a1_f1.inner()));
    }

    @Test
    public void of_null() {
        FieldInfoTest.check(null, FieldInfo.of(null));
        FieldInfoTest.check(null, FieldInfo.of(null, null));
    }

    @Test
    public void getDeclaringClass() {
        FieldInfoTest.check("A1", this.a1_f1.getDeclaringClass());
        FieldInfoTest.check("A1", this.a1_f1.getDeclaringClass());
    }

    @Test
    public void inner() {
        FieldInfoTest.check("f1", this.a1_f1.inner());
    }

    @Test
    public void getAnnotation() {
        FieldInfoTest.check("@A(a1)", this.b_a1.getAnnotation(A.class));
        FieldInfoTest.check(null, this.b_a2.getAnnotation(A.class));
    }

    @Test
    public void getAnnotation_null() {
        FieldInfoTest.check(null, this.b_a1.getAnnotation(null));
    }

    @Test
    public void hasAnnotation_true() {
        Assert.assertTrue((boolean)this.b_a1.hasAnnotation(A.class));
    }

    @Test
    public void hasAnnotation_false() {
        Assert.assertFalse((boolean)this.b_a2.hasAnnotation(A.class));
    }

    @Test
    public void isAll() {
        Assert.assertTrue((boolean)c_deprecated.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertTrue((boolean)c_notDeprecated.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)c_isPublic.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertTrue((boolean)c_isNotPublic.isAll(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)c_isStatic.isAll(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertTrue((boolean)c_isNotStatic.isAll(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertTrue((boolean)c_isTransient.isAll(new ReflectFlags[]{ReflectFlags.TRANSIENT}));
        Assert.assertTrue((boolean)c_isNotTransient.isAll(new ReflectFlags[]{ReflectFlags.NOT_TRANSIENT}));
        Assert.assertFalse((boolean)c_deprecated.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertFalse((boolean)c_notDeprecated.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertFalse((boolean)c_isPublic.isAll(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertFalse((boolean)c_isNotPublic.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertFalse((boolean)c_isStatic.isAll(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertFalse((boolean)c_isNotStatic.isAll(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertFalse((boolean)c_isTransient.isAll(new ReflectFlags[]{ReflectFlags.NOT_TRANSIENT}));
        Assert.assertFalse((boolean)c_isNotTransient.isAll(new ReflectFlags[]{ReflectFlags.TRANSIENT}));
    }

    @Test
    public void isAll_invalidFlag() {
        try {
            c_deprecated.isAll(new ReflectFlags[]{ReflectFlags.HAS_PARAMS});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid flag for field: HAS_PARAMS", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void isAny() {
        Assert.assertTrue((boolean)c_deprecated.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertTrue((boolean)c_notDeprecated.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)c_isPublic.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertTrue((boolean)c_isNotPublic.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)c_isStatic.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertTrue((boolean)c_isNotStatic.isAny(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertTrue((boolean)c_isTransient.isAny(new ReflectFlags[]{ReflectFlags.TRANSIENT}));
        Assert.assertTrue((boolean)c_isNotTransient.isAny(new ReflectFlags[]{ReflectFlags.NOT_TRANSIENT}));
        Assert.assertFalse((boolean)c_deprecated.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertFalse((boolean)c_notDeprecated.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertFalse((boolean)c_isPublic.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertFalse((boolean)c_isNotPublic.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertFalse((boolean)c_isStatic.isAny(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertFalse((boolean)c_isNotStatic.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertFalse((boolean)c_isTransient.isAny(new ReflectFlags[]{ReflectFlags.NOT_TRANSIENT}));
        Assert.assertFalse((boolean)c_isNotTransient.isAny(new ReflectFlags[]{ReflectFlags.TRANSIENT}));
    }

    @Test
    public void isAny_invalidFlag() {
        try {
            c_deprecated.isAny(new ReflectFlags[]{ReflectFlags.HAS_PARAMS});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid flag for field: HAS_PARAMS", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void isDeprecated() {
        Assert.assertTrue((boolean)c_deprecated.isDeprecated());
        Assert.assertFalse((boolean)c_notDeprecated.isDeprecated());
    }

    @Test
    public void isNotDeprecated() {
        Assert.assertFalse((boolean)c_deprecated.isNotDeprecated());
        Assert.assertTrue((boolean)c_notDeprecated.isNotDeprecated());
    }

    @Test
    public void isTransient() {
        Assert.assertTrue((boolean)c_isTransient.isTransient());
        Assert.assertFalse((boolean)c_isNotTransient.isTransient());
    }

    @Test
    public void isNotTransient() {
        Assert.assertFalse((boolean)c_isTransient.isNotTransient());
        Assert.assertTrue((boolean)c_isNotTransient.isNotTransient());
    }

    @Test
    public void isPublic() {
        Assert.assertTrue((boolean)c_isPublic.isPublic());
        Assert.assertFalse((boolean)c_isNotPublic.isPublic());
    }

    @Test
    public void isNotPublic() {
        Assert.assertFalse((boolean)c_isPublic.isNotPublic());
        Assert.assertTrue((boolean)c_isNotPublic.isNotPublic());
    }

    @Test
    public void isStatic() {
        Assert.assertTrue((boolean)c_isStatic.isStatic());
        Assert.assertFalse((boolean)c_isNotStatic.isStatic());
    }

    @Test
    public void isNotStatic() {
        Assert.assertFalse((boolean)c_isStatic.isNotStatic());
        Assert.assertTrue((boolean)c_isNotStatic.isNotStatic());
    }

    @Test
    public void hasName() {
        Assert.assertTrue((boolean)this.b_a1.hasName("a1"));
        Assert.assertFalse((boolean)this.b_a1.hasName("a2"));
    }

    @Test
    public void hasName_null() {
        Assert.assertFalse((boolean)this.b_a1.hasName(null));
    }

    @Test
    public void setAccessible() {
        d_isPublic.setAccessible();
        d_isProtected.setAccessible();
        d_isPrivate.setAccessible();
        d_isDefault.setAccessible();
    }

    @Test
    public void isVisible() {
        Assert.assertTrue((boolean)d_isPublic.isVisible(Visibility.PUBLIC));
        Assert.assertTrue((boolean)d_isPublic.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)d_isPublic.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)d_isPublic.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)d_isProtected.isVisible(Visibility.PUBLIC));
        Assert.assertTrue((boolean)d_isProtected.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)d_isProtected.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)d_isProtected.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)d_isPrivate.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)d_isPrivate.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)d_isPrivate.isVisible(Visibility.PRIVATE));
        Assert.assertFalse((boolean)d_isPrivate.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)d_isDefault.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)d_isDefault.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)d_isDefault.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)d_isDefault.isVisible(Visibility.DEFAULT));
    }

    @Test
    public void getType() {
        FieldInfoTest.check("int", e_a1.getType());
        FieldInfoTest.check("int", e_a2.getType());
    }

    @Test
    public void getType_twice() {
        FieldInfoTest.check("int", e_a1.getType());
        FieldInfoTest.check("int", e_a1.getType());
    }

    @Test
    public void toString2() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.FieldInfoTest$E.a1", (Object)e_a1.toString());
    }

    static class E {
        public int a1;
        int a2;

        E() {
        }
    }

    static abstract class D {
        public int isPublic;
        protected int isProtected;
        private int isPrivate;
        int isDefault;

        D() {
        }
    }

    static abstract class C {
        @Deprecated
        public int deprecated;
        public int notDeprecated;
        public int isPublic;
        protected int isNotPublic;
        public static int isStatic;
        public int isNotStatic;
        public transient int isTransient;
        public int isNotTransient;

        C() {
        }
    }

    public static class B {
        @A(value="a1")
        public int a1;
        public int a2;
    }

    static class A1 {
        public int f1;

        A1() {
        }
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface AX {
        public String value();
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface A {
        public String value();
    }
}

