/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.reflect.ReflectFlags;
import org.junit.Assert;
import org.junit.Test;

public class ExecutableInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof List) {
                return ((List)t).stream().map(this).collect(Collectors.joining(","));
            }
            if (t.getClass().isArray()) {
                return StreamSupport.stream(ArrayUtils.toList((Object)t, Object.class).spliterator(), false).map(this).collect(Collectors.joining(","));
            }
            if (t instanceof Annotation) {
                return t.toString().replaceAll("\\@[^\\$]*\\$(.*)", "@$1");
            }
            if (t instanceof Class) {
                return ((Class)t).getSimpleName();
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            if (t instanceof ConstructorInfo) {
                return ((ConstructorInfo)t).getShortName();
            }
            if (t instanceof ParamInfo) {
                return this.apply(((ParamInfo)t).toString());
            }
            return t.toString();
        }
    };
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ExecutableInfo b_c1 = b.getPublicConstructor(new Class[0]);
    static ExecutableInfo b_c2 = b.getPublicConstructor(new Class[]{String.class});
    static ExecutableInfo b_m1 = b.getPublicMethod("m", new Class[0]);
    static ExecutableInfo b_m2 = b.getPublicMethod("m", new Class[]{String.class});
    static ClassInfo c = ClassInfo.of(C.class);
    static ConstructorInfo c_c1 = c.getPublicConstructor(new Class[0]);
    static ConstructorInfo c_c2 = c.getPublicConstructor(new Class[]{String.class});
    static ConstructorInfo c_c3 = c.getPublicConstructor(new Class[]{Integer.TYPE});
    static MethodInfo c_m1 = c.getPublicMethod("m", new Class[0]);
    static MethodInfo c_m2 = c.getPublicMethod("m", new Class[]{String.class});
    static MethodInfo c_m3 = c.getPublicMethod("m", new Class[]{Integer.TYPE});
    static ClassInfo d = ClassInfo.of(D.class);
    static ExecutableInfo d_c = d.getPublicConstructor(new Class[0]);
    static ExecutableInfo d_m = d.getPublicMethod("m", new Class[0]);
    static ClassInfo e = ClassInfo.of(E.class);
    static ExecutableInfo e_deprecated = e.getPublicMethod("deprecated", new Class[0]);
    static ExecutableInfo e_notDeprecated = e.getPublicMethod("notDeprecated", new Class[0]);
    static ExecutableInfo e_hasParams = e.getPublicMethod("hasParams", new Class[]{Integer.TYPE});
    static ExecutableInfo e_hasStringParam = e.getPublicMethod("hasStringParam", new Class[]{String.class});
    static ExecutableInfo e_hasNoParams = e.getPublicMethod("hasNoParams", new Class[0]);
    static ExecutableInfo e_isPublic = e.getPublicMethod("isPublic", new Class[0]);
    static ExecutableInfo e_isNotPublic = e.getMethod("isNotPublic", new Class[0]);
    static ExecutableInfo e_isStatic = e.getPublicMethod("isStatic", new Class[0]);
    static ExecutableInfo e_isNotStatic = e.getPublicMethod("isNotStatic", new Class[0]);
    static ExecutableInfo e_isAbstract = e.getPublicMethod("isAbstract", new Class[0]);
    static ExecutableInfo e_isNotAbstract = e.getPublicMethod("isNotAbstract", new Class[0]);
    static ClassInfo f = ClassInfo.of(F.class);
    static ExecutableInfo f_isPublic = f.getPublicMethod("isPublic", new Class[0]);
    static ExecutableInfo f_isProtected = f.getMethod("isProtected", new Class[0]);
    static ExecutableInfo f_isPrivate = f.getMethod("isPrivate", new Class[0]);
    static ExecutableInfo f_isDefault = f.getMethod("isDefault", new Class[0]);
    static ClassInfo x = ClassInfo.of(X.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void isConstructor() {
        Assert.assertTrue((boolean)a.getPublicConstructor(new Class[0]).isConstructor());
        Assert.assertFalse((boolean)a.getPublicMethod("foo", new Class[0]).isConstructor());
    }

    @Test
    public void getDeclaringClass() {
        ExecutableInfoTest.check("A", a.getPublicConstructor(new Class[0]).getDeclaringClass());
        ExecutableInfoTest.check("A", a.getPublicMethod("foo", new Class[0]).getDeclaringClass());
    }

    @Test
    public void getParamCount() {
        Assert.assertEquals((long)0L, (long)b_c1.getParamCount());
        Assert.assertEquals((long)1L, (long)b_c2.getParamCount());
        Assert.assertEquals((long)0L, (long)b_m1.getParamCount());
        Assert.assertEquals((long)1L, (long)b_m2.getParamCount());
    }

    @Test
    public void hasParams() {
        Assert.assertEquals((Object)false, (Object)b_c1.hasParams());
        Assert.assertEquals((Object)true, (Object)b_c2.hasParams());
        Assert.assertEquals((Object)false, (Object)b_m1.hasParams());
        Assert.assertEquals((Object)true, (Object)b_m2.hasParams());
    }

    @Test
    public void hasNoParams() {
        Assert.assertEquals((Object)true, (Object)b_c1.hasNoParams());
        Assert.assertEquals((Object)false, (Object)b_c2.hasNoParams());
        Assert.assertEquals((Object)true, (Object)b_m1.hasNoParams());
        Assert.assertEquals((Object)false, (Object)b_m2.hasNoParams());
    }

    @Test
    public void hasNumParams() {
        Assert.assertEquals((Object)false, (Object)b_c1.hasNumParams(1));
        Assert.assertEquals((Object)true, (Object)b_c2.hasNumParams(1));
        Assert.assertEquals((Object)false, (Object)b_m1.hasNumParams(1));
        Assert.assertEquals((Object)true, (Object)b_m2.hasNumParams(1));
    }

    @Test
    public void getParams() {
        ExecutableInfoTest.check("", b_c1.getParams());
        ExecutableInfoTest.check("B[0]", b_c2.getParams());
        ExecutableInfoTest.check("", b_m1.getParams());
        ExecutableInfoTest.check("m[0]", b_m2.getParams());
    }

    @Test
    public void getParams_twice() {
        ExecutableInfoTest.check("", b_c1.getParams());
        ExecutableInfoTest.check("", b_c1.getParams());
    }

    @Test
    public void getParam() {
        ExecutableInfoTest.check("B[0]", b_c2.getParam(0));
        ExecutableInfoTest.check("m[0]", b_m2.getParam(0));
    }

    @Test
    public void getParam_nocache() {
        ClassInfo b = ClassInfo.of(B.class);
        ExecutableInfoTest.check("B[0]", b.getPublicConstructor(new Class[]{String.class}).getParam(0));
        ExecutableInfoTest.check("m[0]", b.getPublicMethod("m", new Class[]{String.class}).getParam(0));
    }

    @Test
    public void getParam_indexOutOfBounds() {
        try {
            b_c1.getParam(0);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Invalid index '0'.  No parameters.", (Object)e.getLocalizedMessage());
        }
        try {
            b_c2.getParam(-1);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Invalid index '-1'.  Parameter count: 1", (Object)e.getLocalizedMessage());
        }
        try {
            b_c2.getParam(1);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Invalid index '1'.  Parameter count: 1", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void getParam_indexOutOfBounds_noCache() {
        ClassInfo b = ClassInfo.of(B.class);
        try {
            b.getPublicConstructor(new Class[0]).getParam(0);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Invalid index '0'.  No parameters.", (Object)e.getLocalizedMessage());
        }
        try {
            b.getPublicConstructor(new Class[]{String.class}).getParam(-1);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Invalid index '-1'.  Parameter count: 1", (Object)e.getLocalizedMessage());
        }
        try {
            b.getPublicConstructor(new Class[]{String.class}).getParam(1);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((Object)"Invalid index '1'.  Parameter count: 1", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void getParamTypes() {
        ExecutableInfoTest.check("", b_c1.getParamTypes());
        ExecutableInfoTest.check("String", b_c2.getParamTypes());
        ExecutableInfoTest.check("", b_m1.getParamTypes());
        ExecutableInfoTest.check("String", b_m2.getParamTypes());
    }

    @Test
    public void getParamTypes_twice() {
        ExecutableInfoTest.check("", b_c1.getParamTypes());
        ExecutableInfoTest.check("", b_c1.getParamTypes());
    }

    @Test
    public void getParamTypes_enum() {
        ClassInfo b1 = ClassInfo.of(B1.class);
        ExecutableInfoTest.check("B1(String,int)", b1.getDeclaredConstructors());
        ExecutableInfoTest.check("String,int", ((ConstructorInfo)b1.getDeclaredConstructors().get(0)).getParamTypes());
    }

    @Test
    public void getParamType() {
        ExecutableInfoTest.check("String", b_c2.getParamType(0));
        ExecutableInfoTest.check("String", b_m2.getParamType(0));
    }

    @Test
    public void getRawParamTypes() {
        ExecutableInfoTest.check("", b_c1.getRawParamTypes());
        ExecutableInfoTest.check("String", b_c2.getRawParamTypes());
        ExecutableInfoTest.check("", b_m1.getRawParamTypes());
        ExecutableInfoTest.check("String", b_m2.getRawParamTypes());
    }

    @Test
    public void getRawParamType() {
        ExecutableInfoTest.check("String", b_c2.getRawParamType(0));
        ExecutableInfoTest.check("String", b_m2.getRawParamType(0));
    }

    @Test
    public void getRawGenericParamType() {
        ExecutableInfoTest.check("String", b_c2.getRawGenericParamType(0));
        ExecutableInfoTest.check("String", b_m2.getRawGenericParamType(0));
    }

    @Test
    public void getRawGenericParamTypes() {
        ExecutableInfoTest.check("", b_c1.getRawGenericParamTypes());
        ExecutableInfoTest.check("String", b_c2.getRawGenericParamTypes());
        ExecutableInfoTest.check("", b_m1.getRawGenericParamTypes());
        ExecutableInfoTest.check("String", b_m2.getRawGenericParamTypes());
    }

    @Test
    public void getRawParameters() {
        ExecutableInfoTest.check("", b_c1.getRawParameters());
        Assert.assertTrue((boolean)b_c2.getRawParameters()[0].toString().startsWith("java.lang.String "));
        ExecutableInfoTest.check("", b_m1.getRawParameters());
        Assert.assertTrue((boolean)b_m2.getRawParameters()[0].toString().startsWith("java.lang.String "));
    }

    @Test
    public void getRawParameter() {
        Assert.assertTrue((boolean)b_c2.getRawParameter(0).toString().startsWith("java.lang.String "));
        Assert.assertTrue((boolean)b_m2.getRawParameter(0).toString().startsWith("java.lang.String "));
    }

    @Test
    public void getParameterAnnotations() {
        ExecutableInfoTest.check("", c_c1.getParameterAnnotations());
        ExecutableInfoTest.check("@CA()", c_c2.getParameterAnnotations());
        ExecutableInfoTest.check("", c_c3.getParameterAnnotations());
        ExecutableInfoTest.check("", c_m1.getParameterAnnotations());
        ExecutableInfoTest.check("@CA()", c_m2.getParameterAnnotations());
        ExecutableInfoTest.check("", c_m3.getParameterAnnotations());
    }

    @Test
    public void getParameterAnnotations_atIndex() {
        ExecutableInfoTest.check("@CA()", c_c2.getParameterAnnotations(0));
        ExecutableInfoTest.check("@CA()", c_m2.getParameterAnnotations(0));
    }

    @Test
    public void hasAnnotation() {
        Assert.assertFalse((boolean)c_c1.hasAnnotation(CA.class));
        Assert.assertFalse((boolean)c_c2.hasAnnotation(CA.class));
        Assert.assertTrue((boolean)c_c3.hasAnnotation(CA.class));
        Assert.assertFalse((boolean)c_m1.hasAnnotation(CA.class));
        Assert.assertFalse((boolean)c_m2.hasAnnotation(CA.class));
        Assert.assertTrue((boolean)c_m3.hasAnnotation(CA.class));
    }

    @Test
    public void getAnnotation() {
        ExecutableInfoTest.check(null, c_c1.getAnnotation(CA.class));
        ExecutableInfoTest.check(null, c_c2.getAnnotation(CA.class));
        ExecutableInfoTest.check("@CA()", c_c3.getAnnotation(CA.class));
        ExecutableInfoTest.check(null, c_m1.getAnnotation(CA.class));
        ExecutableInfoTest.check(null, c_m2.getAnnotation(CA.class));
        ExecutableInfoTest.check("@CA()", c_m3.getAnnotation(CA.class));
    }

    @Test
    public void getAnnotation_nullArg() {
        ExecutableInfoTest.check(null, c_c3.getAnnotation(null));
    }

    @Test
    public void getExceptionTypes() {
        ExecutableInfoTest.check("IOException", d_c.getExceptionTypes());
        ExecutableInfoTest.check("IOException", d_m.getExceptionTypes());
    }

    @Test
    public void getExceptionTypes_twice() {
        ExecutableInfoTest.check("IOException", d_c.getExceptionTypes());
        ExecutableInfoTest.check("IOException", d_c.getExceptionTypes());
    }

    @Test
    public void getRawExceptionTypes() {
        ExecutableInfoTest.check("IOException", d_c.getRawExceptionTypes());
        ExecutableInfoTest.check("IOException", d_m.getRawExceptionTypes());
    }

    @Test
    public void isAll() {
        Assert.assertTrue((boolean)e_deprecated.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertTrue((boolean)e_notDeprecated.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)e_hasParams.isAll(new ReflectFlags[]{ReflectFlags.HAS_PARAMS}));
        Assert.assertTrue((boolean)e_hasNoParams.isAll(new ReflectFlags[]{ReflectFlags.HAS_NO_PARAMS}));
        Assert.assertTrue((boolean)e_isPublic.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertTrue((boolean)e_isNotPublic.isAll(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)e_isStatic.isAll(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertTrue((boolean)e_isNotStatic.isAll(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertTrue((boolean)e_isAbstract.isAll(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertTrue((boolean)e_isNotAbstract.isAll(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertFalse((boolean)e_deprecated.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertFalse((boolean)e_notDeprecated.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertFalse((boolean)e_hasParams.isAll(new ReflectFlags[]{ReflectFlags.HAS_NO_PARAMS}));
        Assert.assertFalse((boolean)e_hasNoParams.isAll(new ReflectFlags[]{ReflectFlags.HAS_PARAMS}));
        Assert.assertFalse((boolean)e_isPublic.isAll(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertFalse((boolean)e_isNotPublic.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertFalse((boolean)e_isStatic.isAll(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertFalse((boolean)e_isNotStatic.isAll(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertFalse((boolean)e_isAbstract.isAll(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertFalse((boolean)e_isNotAbstract.isAll(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
    }

    @Test
    public void isAll_invalidFlag() {
        try {
            e_deprecated.isAll(new ReflectFlags[]{ReflectFlags.TRANSIENT});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid flag for executable: TRANSIENT", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void isAny() {
        Assert.assertTrue((boolean)e_deprecated.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertTrue((boolean)e_notDeprecated.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)e_hasParams.isAny(new ReflectFlags[]{ReflectFlags.HAS_PARAMS}));
        Assert.assertTrue((boolean)e_hasNoParams.isAny(new ReflectFlags[]{ReflectFlags.HAS_NO_PARAMS}));
        Assert.assertTrue((boolean)e_isPublic.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertTrue((boolean)e_isNotPublic.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)e_isStatic.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertTrue((boolean)e_isNotStatic.isAny(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertTrue((boolean)e_isAbstract.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertTrue((boolean)e_isNotAbstract.isAny(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertFalse((boolean)e_deprecated.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertFalse((boolean)e_notDeprecated.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertFalse((boolean)e_hasParams.isAny(new ReflectFlags[]{ReflectFlags.HAS_NO_PARAMS}));
        Assert.assertFalse((boolean)e_hasNoParams.isAny(new ReflectFlags[]{ReflectFlags.HAS_PARAMS}));
        Assert.assertFalse((boolean)e_isPublic.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertFalse((boolean)e_isNotPublic.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertFalse((boolean)e_isStatic.isAny(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertFalse((boolean)e_isNotStatic.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertFalse((boolean)e_isAbstract.isAny(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertFalse((boolean)e_isNotAbstract.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
    }

    @Test
    public void isAny_invalidFlag() {
        try {
            e_deprecated.isAny(new ReflectFlags[]{ReflectFlags.TRANSIENT});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Invalid flag for executable: TRANSIENT", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void hasArgs() {
        Assert.assertTrue((boolean)e_hasParams.hasParamTypes(new Class[]{Integer.TYPE}));
        Assert.assertFalse((boolean)e_hasParams.hasParamTypes(new Class[0]));
        Assert.assertFalse((boolean)e_hasParams.hasParamTypes(new Class[]{Long.TYPE}));
        Assert.assertTrue((boolean)e_hasNoParams.hasParamTypes(new Class[0]));
        Assert.assertFalse((boolean)e_hasNoParams.hasParamTypes(new Class[]{Long.TYPE}));
    }

    @Test
    public void hasArgParents() {
        Assert.assertTrue((boolean)e_hasStringParam.hasParamTypeParents(new Class[]{String.class}));
        Assert.assertTrue((boolean)e_hasStringParam.hasParamTypeParents(new Class[]{CharSequence.class}));
        Assert.assertFalse((boolean)e_hasStringParam.hasParamTypeParents(new Class[]{StringBuilder.class}));
        Assert.assertFalse((boolean)e_hasStringParam.hasParamTypeParents(new Class[0]));
        Assert.assertFalse((boolean)e_hasStringParam.hasParamTypeParents(new Class[]{String.class, String.class}));
        Assert.assertFalse((boolean)e_hasStringParam.hasParamTypeParents(new Class[]{Long.TYPE}));
    }

    @Test
    public void hasFuzzyArgs() {
        Assert.assertTrue((boolean)e_hasParams.hasFuzzyParamTypes(new Class[]{Integer.TYPE}));
        Assert.assertTrue((boolean)e_hasParams.hasFuzzyParamTypes(new Class[]{Integer.TYPE, Long.TYPE}));
        Assert.assertFalse((boolean)e_hasParams.hasFuzzyParamTypes(new Class[]{Long.TYPE}));
        Assert.assertTrue((boolean)e_hasNoParams.hasFuzzyParamTypes(new Class[0]));
        Assert.assertTrue((boolean)e_hasNoParams.hasFuzzyParamTypes(new Class[]{Long.TYPE}));
    }

    @Test
    public void isDeprecated() {
        Assert.assertTrue((boolean)e_deprecated.isDeprecated());
        Assert.assertFalse((boolean)e_notDeprecated.isDeprecated());
    }

    @Test
    public void isNotDeprecated() {
        Assert.assertFalse((boolean)e_deprecated.isNotDeprecated());
        Assert.assertTrue((boolean)e_notDeprecated.isNotDeprecated());
    }

    @Test
    public void isAbstract() {
        Assert.assertTrue((boolean)e_isAbstract.isAbstract());
        Assert.assertFalse((boolean)e_isNotAbstract.isAbstract());
    }

    @Test
    public void isNotAbstract() {
        Assert.assertFalse((boolean)e_isAbstract.isNotAbstract());
        Assert.assertTrue((boolean)e_isNotAbstract.isNotAbstract());
    }

    @Test
    public void isPublic() {
        Assert.assertTrue((boolean)e_isPublic.isPublic());
        Assert.assertFalse((boolean)e_isNotPublic.isPublic());
    }

    @Test
    public void isNotPublic() {
        Assert.assertFalse((boolean)e_isPublic.isNotPublic());
        Assert.assertTrue((boolean)e_isNotPublic.isNotPublic());
    }

    @Test
    public void isStatic() {
        Assert.assertTrue((boolean)e_isStatic.isStatic());
        Assert.assertFalse((boolean)e_isNotStatic.isStatic());
    }

    @Test
    public void isNotStatic() {
        Assert.assertFalse((boolean)e_isStatic.isNotStatic());
        Assert.assertTrue((boolean)e_isNotStatic.isNotStatic());
    }

    @Test
    public void setAccessible() {
        f_isPublic.setAccessible();
        f_isProtected.setAccessible();
        f_isPrivate.setAccessible();
        f_isDefault.setAccessible();
    }

    @Test
    public void isVisible() {
        Assert.assertTrue((boolean)f_isPublic.isVisible(Visibility.PUBLIC));
        Assert.assertTrue((boolean)f_isPublic.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)f_isPublic.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)f_isPublic.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)f_isProtected.isVisible(Visibility.PUBLIC));
        Assert.assertTrue((boolean)f_isProtected.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)f_isProtected.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)f_isProtected.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)f_isPrivate.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)f_isPrivate.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)f_isPrivate.isVisible(Visibility.PRIVATE));
        Assert.assertFalse((boolean)f_isPrivate.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)f_isDefault.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)f_isDefault.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)f_isDefault.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)f_isDefault.isVisible(Visibility.DEFAULT));
    }

    @Test
    public void getFullName_method() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ExecutableInfoTest$X.foo()", (Object)x.getPublicMethod("foo", new Class[0]).getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ExecutableInfoTest$X.foo(java.lang.String)", (Object)x.getPublicMethod("foo", new Class[]{String.class}).getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ExecutableInfoTest$X.foo(java.util.Map<java.lang.String,java.lang.Object>)", (Object)x.getPublicMethod("foo", new Class[]{Map.class}).getFullName());
    }

    @Test
    public void getFullName_constructor() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ExecutableInfoTest$X()", (Object)x.getPublicConstructor(new Class[0]).getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ExecutableInfoTest$X(java.lang.String)", (Object)x.getPublicConstructor(new Class[]{String.class}).getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ExecutableInfoTest$X(java.util.Map<java.lang.String,java.lang.Object>)", (Object)x.getPublicConstructor(new Class[]{Map.class}).getFullName());
    }

    @Test
    public void getShortName_method() {
        Assert.assertEquals((Object)"foo()", (Object)x.getPublicMethod("foo", new Class[0]).getShortName());
        Assert.assertEquals((Object)"foo(String)", (Object)x.getPublicMethod("foo", new Class[]{String.class}).getShortName());
        Assert.assertEquals((Object)"foo(Map)", (Object)x.getPublicMethod("foo", new Class[]{Map.class}).getShortName());
    }

    @Test
    public void getShortName_constructor() {
        Assert.assertEquals((Object)"X()", (Object)x.getPublicConstructor(new Class[0]).getShortName());
        Assert.assertEquals((Object)"X(String)", (Object)x.getPublicConstructor(new Class[]{String.class}).getShortName());
        Assert.assertEquals((Object)"X(Map)", (Object)x.getPublicConstructor(new Class[]{Map.class}).getShortName());
    }

    @Test
    public void getSimpleName_method() {
        Assert.assertEquals((Object)"foo", (Object)x.getPublicMethod("foo", new Class[0]).getSimpleName());
        Assert.assertEquals((Object)"foo", (Object)x.getPublicMethod("foo", new Class[]{String.class}).getSimpleName());
        Assert.assertEquals((Object)"foo", (Object)x.getPublicMethod("foo", new Class[]{Map.class}).getSimpleName());
    }

    @Test
    public void getSimpleName_constructor() {
        Assert.assertEquals((Object)"X", (Object)x.getPublicConstructor(new Class[0]).getSimpleName());
        Assert.assertEquals((Object)"X", (Object)x.getPublicConstructor(new Class[]{String.class}).getSimpleName());
        Assert.assertEquals((Object)"X", (Object)x.getPublicConstructor(new Class[]{Map.class}).getSimpleName());
    }

    static class X {
        public X() {
        }

        public X(String foo) {
        }

        public X(Map<String, Object> foo) {
        }

        public void foo() {
        }

        public void foo(String foo) {
        }

        public void foo(Map<String, Object> foo) {
        }
    }

    static abstract class F {
        F() {
        }

        public void isPublic() {
        }

        protected void isProtected() {
        }

        private void isPrivate() {
        }

        void isDefault() {
        }
    }

    static abstract class E {
        E() {
        }

        @Deprecated
        public void deprecated() {
        }

        public void notDeprecated() {
        }

        public void hasParams(int foo) {
        }

        public void hasStringParam(String foo) {
        }

        public void hasNoParams() {
        }

        public void isPublic() {
        }

        protected void isNotPublic() {
        }

        public static void isStatic() {
        }

        public void isNotStatic() {
        }

        public abstract void isAbstract();

        public void isNotAbstract() {
        }
    }

    static class D {
        public void m() throws IOException {
        }
    }

    static class C {
        public C() {
        }

        public C(@CA String foo) {
        }

        @CA
        public C(int bar) {
        }

        public void m() {
        }

        public void m(@CA String foo) {
        }

        @CA
        public void m(int bar) {
        }
    }

    @Documented
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.CONSTRUCTOR})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface CA {
    }

    static enum B1 {
        FOO;

    }

    static class B {
        public B() {
        }

        public B(String s) {
        }

        public void m() {
        }

        public int m(String s) {
            return 0;
        }
    }

    static class A {
        public void foo() {
        }
    }
}

