/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.juneau.Visibility;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.junit.Assert;
import org.junit.Test;

public class ConstructorInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof Iterable) {
                return StreamSupport.stream(((Iterable)t).spliterator(), false).map(this).collect(Collectors.joining(","));
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            if (t instanceof ConstructorInfo) {
                return ((ConstructorInfo)t).getShortName();
            }
            if (t instanceof Constructor) {
                return ConstructorInfo.of((Constructor)((Constructor)t)).getShortName();
            }
            return t.toString();
        }
    };
    static ConstructorInfo a = ConstructorInfoTest.ofc(A.class, new Class[0]);
    static ClassInfo b = ClassInfo.of(B.class);
    static ConstructorInfo b_c1 = b.getPublicConstructor(new Class[0]);
    static ConstructorInfo b_c2 = b.getPublicConstructor(new Class[]{String.class});
    static ConstructorInfo b_c3 = b.getDeclaredConstructor(new Class[]{Integer.TYPE});
    static ConstructorInfo b_c4 = b.getPublicConstructor(new Class[]{String.class, String.class});

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    private static ConstructorInfo ofc(Class<?> c, Class<?> ... pt) {
        try {
            return ConstructorInfo.of(c.getConstructor(pt));
        }
        catch (NoSuchMethodException | SecurityException e) {
            Assert.fail((String)e.getLocalizedMessage());
            return null;
        }
    }

    @Test
    public void of_withDeclaringClass() throws Exception {
        ConstructorInfoTest.check("A()", ConstructorInfo.of((ClassInfo)ClassInfo.of(A.class), (Constructor)a.inner(), null));
    }

    @Test
    public void of_noDeclaringClass() throws Exception {
        ConstructorInfoTest.check("A()", a.inner());
    }

    @Test
    public void getDeclaringClass() throws Exception {
        ConstructorInfoTest.check("A", a.getDeclaringClass());
    }

    @Test
    public void of_null() throws Exception {
        ConstructorInfoTest.check(null, ConstructorInfo.of(null));
        ConstructorInfoTest.check(null, ConstructorInfo.of(null, null, null));
    }

    @Test
    public void invoke() {
        try {
            Assert.assertEquals(null, (Object)b_c1.invoke(new Object[0]).toString());
            Assert.assertEquals((Object)"foo", (Object)b_c2.invoke(new Object[]{"foo"}).toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void makeAccessible() {
        b_c3.makeAccessible(Visibility.PROTECTED);
        try {
            Assert.assertEquals(null, (Object)b_c3.invoke(new Object[]{123}).toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void compareTo() {
        TreeSet<ConstructorInfo> s = new TreeSet<ConstructorInfo>(Arrays.asList(b_c1, b_c2, b_c3, b_c4, a));
        ConstructorInfoTest.check("A(),B(),B(int),B(String),B(String,String)", s);
    }

    public static class B {
        private String f;

        public B() {
        }

        public B(String f) {
            this.f = f;
        }

        public B(String f, String f2) {
            this.f = f;
        }

        protected B(int f) {
        }

        public String toString() {
            return this.f;
        }
    }

    static class A {
    }
}

