/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.PropertyStoreApply;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ReflectFlags;
import org.apache.juneau.reflection.AClass;
import org.apache.juneau.reflection.AInterface;
import org.apache.juneau.reflection.PA;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.Test;

public class ClassInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof Class) {
                return ((Class)t).getSimpleName();
            }
            if (t instanceof Package) {
                return ((Package)t).getName();
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            if (t instanceof MethodInfo) {
                return ((MethodInfo)t).getDeclaringClass().getSimpleName() + '.' + ((MethodInfo)t).getShortName();
            }
            if (t instanceof ConstructorInfo) {
                return ((ConstructorInfo)t).getShortName();
            }
            if (t instanceof FieldInfo) {
                return ((FieldInfo)t).getDeclaringClass().getSimpleName() + '.' + ((FieldInfo)t).getName();
            }
            if (t instanceof A) {
                return "@A(" + ((A)t).value() + ")";
            }
            if (t instanceof PA) {
                return "@PA(" + ((PA)t).value() + ")";
            }
            if (t instanceof AConfig) {
                return "@AConfig(" + ((AConfig)t).value() + ")";
            }
            if (t instanceof AnnotationInfo) {
                return this.apply(((AnnotationInfo)t).getAnnotation());
            }
            if (t instanceof AnnotationList) {
                AnnotationList al = (AnnotationList)t;
                return al.toString();
            }
            return t.toString();
        }
    };
    public static Type aType = ((ParameterizedType)A2.class.getGenericSuperclass()).getActualTypeArguments()[0];
    public static Type pType = ((ParameterizedType)A3.class.getGenericSuperclass()).getActualTypeArguments()[0];
    public static Type pTypeDimensional = ((ParameterizedType)A4.class.getGenericSuperclass()).getActualTypeArguments()[0];
    public static Type pTypeGeneric;
    public static Type pTypeGenericArg;
    static ClassInfo aTypeInfo;
    static ClassInfo pTypeInfo;
    static ClassInfo pTypeDimensionalInfo;
    static ClassInfo pTypeGenericInfo;
    static ClassInfo pTypeGenericArgInfo;
    static ClassInfo aClass;
    static ClassInfo aInterface;
    static ClassInfo bi1;
    static ClassInfo bi2;
    static ClassInfo bi3;
    static ClassInfo bi4;
    static ClassInfo bc1;
    static ClassInfo bc2;
    static ClassInfo bc3;
    static ClassInfo object;
    static ClassInfo cc3;
    static ClassInfo ci2;
    static ClassInfo c2;
    static ClassInfo da1;
    static ClassInfo da2;
    static ClassInfo da3;
    static ClassInfo da4;
    static ClassInfo da5;
    static ClassInfo da6;
    static ClassInfo da7;
    static ClassInfo da8;
    static ClassInfo db1;
    static ClassInfo db2;
    static ClassInfo db3;
    static ClassInfo db4;
    static ClassInfo db5;
    static ClassInfo db6;
    static ClassInfo db7;
    static ClassInfo db8;
    static ClassInfo db9;
    static ClassInfo db10;
    static ClassInfo db11;
    static ClassInfo dc1;
    static ClassInfo dc2;
    static ClassInfo dc3;
    static ClassInfo dc4;
    static ClassInfo dc5;
    static ClassInfo dd1;
    static ClassInfo dd2;
    static ClassInfo dd3;
    static ClassInfo dd4;
    static ClassInfo dd5;
    static ClassInfo e1;
    static ClassInfo e2;
    static ClassInfo e3;
    static ClassInfo e4;
    static ClassInfo e5;
    static ClassInfo e6;
    static ClassInfo f1;
    static ClassInfo f2;
    static ClassInfo f3;
    static ClassInfo g3;
    static ClassInfo g4;
    static ClassInfo g5;
    static ClassInfo gb3;
    static ClassInfo gb4;
    static ClassInfo gb5;
    static ClassInfo hPublic;
    static ClassInfo hPackage;
    static ClassInfo hProtected;
    static ClassInfo hPrivate;
    static ClassInfo hPublicMember;
    static ClassInfo hAbstractPublic;
    static ClassInfo hPublicDeprecated;
    static ClassInfo h2a;
    static ClassInfo h2b;
    static ClassInfo h2Deprecated;
    static ClassInfo h2NotDeprecated;
    static ClassInfo h2Public;
    static ClassInfo h2NotPublic;
    static ClassInfo h2Static;
    static ClassInfo h2NotStatic;
    static ClassInfo h2Member;
    static ClassInfo h2StaticMember;
    static ClassInfo h2Abstract;
    static ClassInfo h2NotAbstract;
    static List<Class<?>> primitives;
    static List<Class<?>> primitiveWrappers;
    static List<Object> primitiveDefaults;
    static ClassInfo j1;
    static ClassInfo j2;
    static ClassInfo j1_3d;
    static ClassInfo j2_3d;
    static ClassInfo ka;
    static ClassInfo kb;
    static ClassInfo kc;
    static ClassInfo la;
    static ClassInfo ma;
    static ClassInfo mb;
    static ClassInfo mc;
    static ClassInfo md;
    static ClassInfo me;
    static ClassInfo mf;
    static ClassInfo mg;
    static ClassInfo mh;
    static ClassInfo mi;
    static ClassInfo mj;
    static ClassInfo ml;
    static ClassInfo mn;

    private static void check(String expected, Object o) {
        if (o instanceof List) {
            List l = (List)o;
            String actual = l.stream().map(TO_STRING).collect(Collectors.joining(","));
            Assert.assertEquals((Object)expected, (Object)actual);
        } else if (o instanceof Iterable) {
            String actual = StreamSupport.stream(((Iterable)o).spliterator(), false).map(TO_STRING).collect(Collectors.joining(","));
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
        }
    }

    @Test
    public void ofType() {
        ClassInfoTest.check("A1", ClassInfo.of(A1.class));
        ClassInfoTest.check("A1", ClassInfo.of((Type)aType));
        ClassInfoTest.check("Map", pTypeInfo);
        ClassInfoTest.check("Map", pTypeDimensionalInfo);
        ClassInfoTest.check("AbstractMap", pTypeGenericInfo);
        ClassInfoTest.check("V", pTypeGenericArgInfo);
    }

    @Test
    public void ofTypeOnObject() {
        ClassInfoTest.check("A1", ClassInfo.of((Object)new A1()));
    }

    @Test
    public void ofTypeOnNulls() {
        ClassInfoTest.check(null, ClassInfo.of((Class)null));
        ClassInfoTest.check(null, ClassInfo.of((Type)null));
        ClassInfoTest.check(null, ClassInfo.of(null));
    }

    @Test
    public void inner() {
        Assert.assertTrue((boolean)(ClassInfo.of(A1.class).inner() instanceof Class));
        Assert.assertTrue((boolean)(ClassInfo.of(A1.class).innerType() instanceof Class));
    }

    @Test
    public void resolved() {
        ClassInfoTest.check("A1", ClassInfo.of(A1.class).resolved());
        ClassInfoTest.check("A1", ClassInfo.of(A2.class).resolved());
    }

    @Test
    public void getDeclaredInterfaces() {
        ClassInfoTest.check("", bi4.getDeclaredInterfaces());
        ClassInfoTest.check("BI1,BI2", bc1.getDeclaredInterfaces());
        ClassInfoTest.check("BI3", bc2.getDeclaredInterfaces());
        ClassInfoTest.check("", bc3.getDeclaredInterfaces());
    }

    @Test
    public void getDeclaredInterfaces_onType() {
        ClassInfoTest.check("", aTypeInfo.getDeclaredInterfaces());
        ClassInfoTest.check("", pTypeInfo.getDeclaredInterfaces());
        ClassInfoTest.check("", pTypeDimensionalInfo.getDeclaredInterfaces());
        ClassInfoTest.check("Map", pTypeGenericInfo.getDeclaredInterfaces());
        ClassInfoTest.check("", pTypeGenericArgInfo.getDeclaredInterfaces());
    }

    @Test
    public void getDeclaredInterfaces_twice() {
        ClassInfoTest.check("BI1,BI2", bc1.getDeclaredInterfaces());
        ClassInfoTest.check("BI1,BI2", bc1.getDeclaredInterfaces());
    }

    @Test
    public void getInterfaces() {
        ClassInfoTest.check("", bi4.getInterfaces());
        ClassInfoTest.check("BI1,BI2", bc1.getInterfaces());
        ClassInfoTest.check("BI3,BI1,BI2", bc2.getInterfaces());
        ClassInfoTest.check("BI3,BI1,BI2", bc3.getInterfaces());
    }

    @Test
    public void getInterfaces_tiwce() {
        ClassInfoTest.check("BI3,BI1,BI2", bc2.getInterfaces());
        ClassInfoTest.check("BI3,BI1,BI2", bc2.getInterfaces());
    }

    @Test
    public void getParents() {
        ClassInfoTest.check("BC3,BC2,BC1", bc3.getParents());
        ClassInfoTest.check("", object.getParents());
        ClassInfoTest.check("BI1", bi1.getParents());
    }

    @Test
    public void getParentsParentFirst() {
        ClassInfoTest.check("BC1,BC2,BC3", bc3.getParentsParentFirst());
        ClassInfoTest.check("", object.getParentsParentFirst());
        ClassInfoTest.check("BI1", bi1.getParentsParentFirst());
    }

    @Test
    public void getAllParents() {
        ClassInfoTest.check("BC3,BC2,BC1,BI3,BI1,BI2", bc3.getAllParents());
        ClassInfoTest.check("", object.getAllParents());
        ClassInfoTest.check("BI1", bi1.getAllParents());
    }

    @Test
    public void getAllParents_twice() {
        ClassInfoTest.check("BC3,BC2,BC1,BI3,BI1,BI2", bc3.getAllParents());
        ClassInfoTest.check("BC3,BC2,BC1,BI3,BI1,BI2", bc3.getAllParents());
    }

    @Test
    public void getAllParentsParentFirst() {
        ClassInfoTest.check("BI2,BI1,BI3,BC1,BC2,BC3", bc3.getAllParentsParentFirst());
        ClassInfoTest.check("", object.getAllParentsParentFirst());
        ClassInfoTest.check("BI1", bi1.getAllParentsParentFirst());
    }

    @Test
    public void getParent() {
        ClassInfoTest.check("BC2", bc3.getParent());
        ClassInfoTest.check("BC1", bc2.getParent());
        ClassInfoTest.check("Object", bc1.getParent());
        ClassInfoTest.check(null, object.getParent());
        ClassInfoTest.check(null, bi2.getParent());
        ClassInfoTest.check(null, bi1.getParent());
    }

    @Test
    public void getParent_onType() {
        ClassInfoTest.check("Object", aTypeInfo.getParent());
        ClassInfoTest.check(null, pTypeInfo.getParent());
        ClassInfoTest.check(null, pTypeDimensionalInfo.getParent());
        ClassInfoTest.check("Object", pTypeGenericInfo.getParent());
        ClassInfoTest.check(null, pTypeGenericArgInfo.getParent());
    }

    @Test
    public void getPublicMethods() throws Exception {
        ClassInfoTest.check("CC3.c1a(),CC3.c2b(),CC3.c3a(),CC3.i1a(),CC3.i1b(),CC3.i2a(),CC3.i2b()", cc3.getPublicMethods());
        ClassInfoTest.check("CI2.i1a(),CI2.i1b(),CI2.i2a(),CI2.i2b()", ci2.getPublicMethods());
    }

    @Test
    public void getPublicMethods_twice() throws Exception {
        ClassInfoTest.check("CI2.i1a(),CI2.i1b(),CI2.i2a(),CI2.i2b()", ci2.getPublicMethods());
        ClassInfoTest.check("CI2.i1a(),CI2.i1b(),CI2.i2a(),CI2.i2b()", ci2.getPublicMethods());
    }

    @Test
    public void getPublicMethods_onType() throws Exception {
        ClassInfoTest.check("", aTypeInfo.getPublicMethods());
        ClassInfoTest.check("", pTypeGenericArgInfo.getPublicMethods());
    }

    @Test
    public void getAllMethods() throws Exception {
        ClassInfoTest.check("CC3.c3a(),CC3.c3b(),CC3.i2b(),CC2.c2a(),CC2.c2b(),CC2.i1b(),CC2.i2a(),CC2.i2b(),CC1.c1a(),CC1.c1b(),CC1.i1a(),CI1.i1a(),CI1.i1b(),CI2.i2a(),CI2.i2b()", cc3.getAllMethods());
    }

    @Test
    public void getAllMethods_twice() throws Exception {
        ClassInfoTest.check("CC3.c3a(),CC3.c3b(),CC3.i2b(),CC2.c2a(),CC2.c2b(),CC2.i1b(),CC2.i2a(),CC2.i2b(),CC1.c1a(),CC1.c1b(),CC1.i1a(),CI1.i1a(),CI1.i1b(),CI2.i2a(),CI2.i2b()", cc3.getAllMethods());
        ClassInfoTest.check("CC3.c3a(),CC3.c3b(),CC3.i2b(),CC2.c2a(),CC2.c2b(),CC2.i1b(),CC2.i2a(),CC2.i2b(),CC1.c1a(),CC1.c1b(),CC1.i1a(),CI1.i1a(),CI1.i1b(),CI2.i2a(),CI2.i2b()", cc3.getAllMethods());
    }

    @Test
    public void getAllMethodsParentFirst() throws Exception {
        ClassInfoTest.check("CI2.i2a(),CI2.i2b(),CI1.i1a(),CI1.i1b(),CC1.c1a(),CC1.c1b(),CC1.i1a(),CC2.c2a(),CC2.c2b(),CC2.i1b(),CC2.i2a(),CC2.i2b(),CC3.c3a(),CC3.c3b(),CC3.i2b()", cc3.getAllMethodsParentFirst());
    }

    @Test
    public void getAllMethodsParentFirst_twice() throws Exception {
        ClassInfoTest.check("CI2.i2a(),CI2.i2b(),CI1.i1a(),CI1.i1b(),CC1.c1a(),CC1.c1b(),CC1.i1a(),CC2.c2a(),CC2.c2b(),CC2.i1b(),CC2.i2a(),CC2.i2b(),CC3.c3a(),CC3.c3b(),CC3.i2b()", cc3.getAllMethodsParentFirst());
        ClassInfoTest.check("CI2.i2a(),CI2.i2b(),CI1.i1a(),CI1.i1b(),CC1.c1a(),CC1.c1b(),CC1.i1a(),CC2.c2a(),CC2.c2b(),CC2.i1b(),CC2.i2a(),CC2.i2b(),CC3.c3a(),CC3.c3b(),CC3.i2b()", cc3.getAllMethodsParentFirst());
    }

    @Test
    public void getDeclaredMethods() throws Exception {
        ClassInfoTest.check("CC3.c3a(),CC3.c3b(),CC3.i2b()", cc3.getDeclaredMethods());
        ClassInfoTest.check("CI2.i2a(),CI2.i2b()", ci2.getDeclaredMethods());
        ClassInfoTest.check("CI2.i2a(),CI2.i2b()", ci2.getDeclaredMethods());
    }

    @Test
    public void getDeclaredMethods_twice() throws Exception {
        ClassInfoTest.check("CI2.i2a(),CI2.i2b()", ci2.getDeclaredMethods());
        ClassInfoTest.check("CI2.i2a(),CI2.i2b()", ci2.getDeclaredMethods());
    }

    @Test
    public void getDeclaredMethods_onType() throws Exception {
        ClassInfoTest.check("", aTypeInfo.getDeclaredMethods());
        ClassInfoTest.check("", pTypeGenericArgInfo.getDeclaredMethods());
    }

    @Test
    public void getPublicMethod_noArgs() {
        ClassInfoTest.check("C2.a1()", c2.getPublicMethod("a1", new Class[0]));
        ClassInfoTest.check(null, c2.getPublicMethod("a2", new Class[0]));
        ClassInfoTest.check(null, c2.getPublicMethod("b1", new Class[0]));
        ClassInfoTest.check(null, c2.getPublicMethod("b2", new Class[0]));
    }

    @Test
    public void getPublicMethod_withArgs() {
        ClassInfoTest.check(null, c2.getPublicMethod("a1", new Class[]{Integer.TYPE}));
        ClassInfoTest.check("C2.a2(int)", c2.getPublicMethod("a2", new Class[]{Integer.TYPE}));
        ClassInfoTest.check(null, c2.getPublicMethod("b1", new Class[]{Integer.TYPE}));
        ClassInfoTest.check(null, c2.getPublicMethod("b2", new Class[]{Integer.TYPE}));
    }

    @Test
    public void getMethod_noArgs() {
        ClassInfoTest.check("C2.a1()", c2.getMethod("a1", new Class[0]));
        ClassInfoTest.check(null, c2.getMethod("a2", new Class[0]));
        ClassInfoTest.check("C2.b1()", c2.getMethod("b1", new Class[0]));
        ClassInfoTest.check(null, c2.getMethod("b2", new Class[0]));
    }

    @Test
    public void getMethod_withArgs() {
        ClassInfoTest.check(null, c2.getMethod("a1", new Class[]{Integer.TYPE}));
        ClassInfoTest.check("C2.a2(int)", c2.getMethod("a2", new Class[]{Integer.TYPE}));
        ClassInfoTest.check(null, c2.getMethod("b1", new Class[]{Integer.TYPE}));
        ClassInfoTest.check("C2.b2(int)", c2.getMethod("b2", new Class[]{Integer.TYPE}));
    }

    @Test
    public void getFromStringMethod() throws Exception {
        ClassInfoTest.check("DA1.create(String)", da1.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da2.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da3.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da4.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da5.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da6.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da7.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, da8.getStaticCreateMethod(String.class, new String[0]));
    }

    @Test
    public void getFromStringMethod_onType() throws Exception {
        ClassInfoTest.check(null, aTypeInfo.getStaticCreateMethod(String.class, new String[0]));
        ClassInfoTest.check(null, pTypeGenericArgInfo.getStaticCreateMethod(String.class, new String[0]));
    }

    @Test
    public void getStaticCreateMethod() throws Exception {
        ClassInfoTest.check("DB1.create(DBx)", db1.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check("DB2.fromDBx(DBx)", db2.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check("DB3.from(DBx)", db3.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db4.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db5.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db6.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db7.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db8.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db9.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db10.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, db11.getStaticCreateMethod(DBx.class, new String[0]));
    }

    @Test
    public void getStaticCreateMethod_onType() throws Exception {
        ClassInfoTest.check(null, aTypeInfo.getStaticCreateMethod(DBx.class, new String[0]));
        ClassInfoTest.check(null, pTypeGenericArgInfo.getStaticCreateMethod(DBx.class, new String[0]));
    }

    @Test
    public void getBuilderCreateMethod() throws Exception {
        ClassInfoTest.check("DC1.create()", dc1.getBuilderCreateMethod());
        ClassInfoTest.check(null, dc2.getBuilderCreateMethod());
        ClassInfoTest.check(null, dc3.getBuilderCreateMethod());
        ClassInfoTest.check(null, dc4.getBuilderCreateMethod());
        ClassInfoTest.check(null, dc5.getBuilderCreateMethod());
    }

    @Test
    public void getBuilderBuildMethod() throws Exception {
        ClassInfoTest.check("DD1.build()", dd1.getBuilderBuildMethod());
        ClassInfoTest.check(null, dd2.getBuilderBuildMethod());
        ClassInfoTest.check(null, dd3.getBuilderBuildMethod());
        ClassInfoTest.check(null, dd4.getBuilderBuildMethod());
        ClassInfoTest.check(null, dd5.getBuilderBuildMethod());
    }

    @Test
    public void getPublicConstructors() {
        ClassInfoTest.check("E1(),E1(Writer),E1(String),E1(String,Writer)", e1.getPublicConstructors());
    }

    @Test
    public void getPublicConstructors_twice() {
        ClassInfoTest.check("E1(),E1(Writer),E1(String),E1(String,Writer)", e1.getPublicConstructors());
        ClassInfoTest.check("E1(),E1(Writer),E1(String),E1(String,Writer)", e1.getPublicConstructors());
    }

    @Test
    public void getPublicConstructors_onType() {
        ClassInfoTest.check("A1(ClassInfoTest)", aTypeInfo.getPublicConstructors());
        ClassInfoTest.check("", pTypeInfo.getPublicConstructors());
        ClassInfoTest.check("", pTypeDimensionalInfo.getPublicConstructors());
        ClassInfoTest.check("", pTypeGenericInfo.getPublicConstructors());
        ClassInfoTest.check("", pTypeGenericArgInfo.getPublicConstructors());
    }

    @Test
    public void getDeclaredConstructors() {
        ClassInfoTest.check("E1(),E1(float),E1(int),E1(Writer),E1(String),E1(String,Writer)", e1.getDeclaredConstructors());
    }

    @Test
    public void getDeclaredConstructors_twice() {
        ClassInfoTest.check("E1(),E1(float),E1(int),E1(Writer),E1(String),E1(String,Writer)", e1.getDeclaredConstructors());
        ClassInfoTest.check("E1(),E1(float),E1(int),E1(Writer),E1(String),E1(String,Writer)", e1.getDeclaredConstructors());
    }

    @Test
    public void getDeclaredConstructors_onType() {
        ClassInfoTest.check("A1(ClassInfoTest)", aTypeInfo.getDeclaredConstructors());
        ClassInfoTest.check("", pTypeInfo.getDeclaredConstructors());
        ClassInfoTest.check("", pTypeDimensionalInfo.getDeclaredConstructors());
        ClassInfoTest.check("AbstractMap()", pTypeGenericInfo.getDeclaredConstructors());
        ClassInfoTest.check("", pTypeGenericArgInfo.getDeclaredConstructors());
    }

    @Test
    public void getPublicConstructor_classArgs() {
        ClassInfoTest.check("E1(String)", e1.getPublicConstructor(new Class[]{String.class}));
        ClassInfoTest.check("E1(Writer)", e1.getAvailablePublicConstructor(new Class[]{StringWriter.class}));
    }

    @Test
    public void getPublicConstructor_objectArgs() {
        ClassInfoTest.check("E1(String)", e1.getPublicConstructor(new Object[]{"foo"}));
    }

    @Test
    public void getPublicConstructorFuzzy() {
        ClassInfoTest.check("E1(String)", e1.getPublicConstructorFuzzy(new Object[]{"foo", new HashMap()}));
        ClassInfoTest.check("E1()", e1.getPublicConstructorFuzzy(new Object[]{new HashMap()}));
    }

    @Test
    public void getNoArgConstructor() {
        ClassInfoTest.check("E2()", e2.getNoArgConstructor(Visibility.PRIVATE));
        ClassInfoTest.check("E2()", e2.getNoArgConstructor(Visibility.PROTECTED));
        ClassInfoTest.check("E2()", e2.getNoArgConstructor(Visibility.DEFAULT));
        ClassInfoTest.check(null, e2.getNoArgConstructor(Visibility.PUBLIC));
    }

    @Test
    public void getNoArgConstructor_abstractClass() {
        ClassInfoTest.check(null, e3.getNoArgConstructor(Visibility.PUBLIC));
    }

    @Test
    public void getNoArgConstructor_innerClass() {
        ClassInfoTest.check("E4(ClassInfoTest)", e4.getNoArgConstructor(Visibility.PUBLIC));
    }

    @Test
    public void getNoArgConstructor_noConstructor() {
        ClassInfoTest.check(null, e6.getNoArgConstructor(Visibility.PUBLIC));
    }

    @Test
    public void getPublicNoArgConstructor() {
        ClassInfoTest.check("E1()", e1.getPublicConstructor(new Class[0]));
    }

    @Test
    public void getConstructor() {
        ClassInfoTest.check("E1(int)", e1.getConstructor(Visibility.PROTECTED, new Class[]{Integer.TYPE}));
        ClassInfoTest.check("E1(int)", e1.getConstructor(Visibility.PRIVATE, new Class[]{Integer.TYPE}));
        ClassInfoTest.check(null, e1.getConstructor(Visibility.PUBLIC, new Class[]{Integer.TYPE}));
        ClassInfoTest.check("E3()", e3.getConstructor(Visibility.PUBLIC, new Class[0]));
        ClassInfoTest.check("E4(ClassInfoTest)", e4.getConstructor(Visibility.PUBLIC, new Class[0]));
        ClassInfoTest.check("E5()", e5.getConstructor(Visibility.PUBLIC, new Class[0]));
    }

    @Test
    public void getDeclaredConstructor() {
        ClassInfoTest.check("E1()", e1.getDeclaredConstructor(new Class[0]));
        ClassInfoTest.check("E1(int)", e1.getDeclaredConstructor(new Class[]{Integer.TYPE}));
        ClassInfoTest.check(null, e1.getDeclaredConstructor(new Class[]{Object.class}));
    }

    @Test
    public void getPublicFields() {
        ClassInfoTest.check("F2.f1a,F1.f1b,F2.f2b", f2.getPublicFields());
    }

    @Test
    public void getPublicFields_twice() {
        ClassInfoTest.check("F2.f1a,F1.f1b,F2.f2b", f2.getPublicFields());
        ClassInfoTest.check("F2.f1a,F1.f1b,F2.f2b", f2.getPublicFields());
    }

    @Test
    public void getPublicFields_onType() {
        ClassInfoTest.check("", aTypeInfo.getPublicFields());
    }

    @Test
    public void getDeclaredFields() {
        ClassInfoTest.check("F2.f1a,F2.f2b,F2.f2c,F2.f2d", f2.getDeclaredFields());
    }

    @Test
    public void getDeclaredFields_twice() {
        ClassInfoTest.check("F2.f1a,F2.f2b,F2.f2c,F2.f2d", f2.getDeclaredFields());
        ClassInfoTest.check("F2.f1a,F2.f2b,F2.f2c,F2.f2d", f2.getDeclaredFields());
    }

    @Test
    public void getDeclaredFields_onType() {
        ClassInfoTest.check("A1.this$0", aTypeInfo.getDeclaredFields());
        ClassInfoTest.check("", pTypeInfo.getDeclaredFields());
        ClassInfoTest.check("", pTypeDimensionalInfo.getDeclaredFields());
        ClassInfoTest.check("AbstractMap.keySet,AbstractMap.values", pTypeGenericInfo.getDeclaredFields());
        ClassInfoTest.check("", pTypeGenericArgInfo.getDeclaredFields());
    }

    @Test
    public void getAllFields() {
        ClassInfoTest.check("F2.f1a,F2.f2b,F2.f2c,F2.f2d,F1.f1a,F1.f1b", f2.getAllFields());
    }

    @Test
    public void getAllFields_twice() {
        ClassInfoTest.check("F2.f1a,F2.f2b,F2.f2c,F2.f2d,F1.f1a,F1.f1b", f2.getAllFields());
        ClassInfoTest.check("F2.f1a,F2.f2b,F2.f2c,F2.f2d,F1.f1a,F1.f1b", f2.getAllFields());
    }

    @Test
    public void getAllFields_onType() {
        ClassInfoTest.check("A1.this$0", aTypeInfo.getAllFields());
        ClassInfoTest.check("", pTypeInfo.getAllFields());
        ClassInfoTest.check("", pTypeDimensionalInfo.getAllFields());
        ClassInfoTest.check("AbstractMap.keySet,AbstractMap.values", pTypeGenericInfo.getAllFields());
        ClassInfoTest.check("", pTypeGenericArgInfo.getAllFields());
    }

    @Test
    public void getAllFieldsParentFirst() {
        ClassInfoTest.check("F1.f1a,F1.f1b,F2.f1a,F2.f2b,F2.f2c,F2.f2d", f2.getAllFieldsParentFirst());
    }

    @Test
    public void getAllFieldsParentFirst_twice() {
        ClassInfoTest.check("F1.f1a,F1.f1b,F2.f1a,F2.f2b,F2.f2c,F2.f2d", f2.getAllFieldsParentFirst());
        ClassInfoTest.check("F1.f1a,F1.f1b,F2.f1a,F2.f2b,F2.f2c,F2.f2d", f2.getAllFieldsParentFirst());
    }

    @Test
    public void getPublicField() {
        ClassInfoTest.check("F3.a1", f3.getPublicField("a1"));
        ClassInfoTest.check(null, f3.getPublicField("a2"));
        ClassInfoTest.check(null, f3.getPublicField("a3"));
    }

    @Test
    public void getDeclaredField() {
        ClassInfoTest.check("F3.a1", f3.getDeclaredField("a1"));
        ClassInfoTest.check("F3.a2", f3.getDeclaredField("a2"));
        ClassInfoTest.check(null, f3.getDeclaredField("a3"));
    }

    @Test
    public void getAnnotation() {
        ClassInfoTest.check("@A(7)", g3.getAnnotation(A.class));
        ClassInfoTest.check(null, g3.getAnnotation(B.class));
        ClassInfoTest.check(null, g3.getAnnotation(null));
    }

    @Test
    public void getAnnotation_twice() {
        ClassInfoTest.check("@A(7)", g3.getAnnotation(A.class));
        ClassInfoTest.check("@A(7)", g3.getAnnotation(A.class));
    }

    @Test
    public void getAnnotation_onParent() {
        ClassInfoTest.check("@A(7)", g4.getAnnotation(A.class));
        ClassInfoTest.check(null, g4.getAnnotation(B.class));
        ClassInfoTest.check(null, g4.getAnnotation(null));
    }

    @Test
    public void getAnnotation_onInterface() {
        ClassInfoTest.check("@A(3)", g5.getAnnotation(A.class));
        ClassInfoTest.check(null, g5.getAnnotation(B.class));
        ClassInfoTest.check(null, g5.getAnnotation(null));
    }

    @Test
    public void hasAnnotation() {
        Assert.assertTrue((boolean)g3.hasAnnotation(A.class));
        Assert.assertFalse((boolean)g3.hasAnnotation(B.class));
        Assert.assertFalse((boolean)g3.hasAnnotation(null));
    }

    @Test
    public void getAnnotations() {
        ClassInfoTest.check("@A(7),@A(6),@A(5),@A(3),@A(1),@A(2)", g3.getAnnotations(A.class));
    }

    @Test
    public void getAnnotationsParentFirst() {
        ClassInfoTest.check("@A(2),@A(1),@A(3),@A(5),@A(6),@A(7)", g3.getAnnotationsParentFirst(A.class));
    }

    @Test
    public void getDeclaredAnnotation() {
        ClassInfoTest.check("@A(7)", g3.getDeclaredAnnotation(A.class));
        ClassInfoTest.check(null, g3.getDeclaredAnnotation(B.class));
    }

    @Test
    public void getDeclaredAnnotation_null() {
        ClassInfoTest.check(null, g3.getDeclaredAnnotation(null));
    }

    @Test
    public void getDeclaredAnnotation_twice() {
        ClassInfoTest.check("@A(7)", g3.getDeclaredAnnotation(A.class));
        ClassInfoTest.check("@A(7)", g3.getDeclaredAnnotation(A.class));
    }

    @Test
    public void getDeclaredAnnotation_onType() {
        ClassInfoTest.check(null, aTypeInfo.getDeclaredAnnotation(A.class));
    }

    @Test
    public void getDeclaredAnnotationInfo() {
        ClassInfoTest.check("@A(7)", g3.getDeclaredAnnotationInfo(A.class));
        ClassInfoTest.check(null, g3.getDeclaredAnnotationInfo(B.class));
    }

    @Test
    public void getDeclaredAnnotationInfo_twice() {
        ClassInfoTest.check("@A(7)", g3.getDeclaredAnnotationInfo(A.class));
        ClassInfoTest.check("@A(7)", g3.getDeclaredAnnotationInfo(A.class));
    }

    @Test
    public void getAnnotationInfos() {
        ClassInfoTest.check("@A(7),@A(6),@A(5),@A(3),@A(1),@A(2)", g3.getAnnotationInfos(A.class));
    }

    @Test
    public void getAnnotationInfosParentFirst() {
        ClassInfoTest.check("@A(2),@A(1),@A(3),@A(5),@A(6),@A(7)", g3.getAnnotationInfosParentFirst(A.class));
    }

    @Test
    public void getPackageAnnotation() {
        ClassInfoTest.check("@PA(10)", g3.getPackageAnnotation(PA.class));
    }

    @Test
    public void getPackageAnnotation_onType() {
        ClassInfoTest.check("@PA(10)", aTypeInfo.getPackageAnnotation(PA.class));
        ClassInfoTest.check(null, pTypeInfo.getPackageAnnotation(PA.class));
        ClassInfoTest.check(null, pTypeDimensionalInfo.getPackageAnnotation(PA.class));
        ClassInfoTest.check(null, pTypeGenericInfo.getPackageAnnotation(PA.class));
        ClassInfoTest.check(null, pTypeGenericArgInfo.getPackageAnnotation(PA.class));
    }

    @Test
    public void getPackageAnnotationInfo() {
        ClassInfoTest.check("@PA(10)", g3.getPackageAnnotationInfo(PA.class));
    }

    @Test
    public void getAnnotationsMap() {
        ClassInfoTest.check("@A(7),@A(6),@A(5),@A(3),@A(1),@A(2),@PA(10)", g3.getAnnotationList(null));
        ClassInfoTest.check("@A(7),@A(6),@A(5),@A(3),@A(1),@A(2),@PA(10)", g4.getAnnotationList(null));
        ClassInfoTest.check("@A(3),@PA(10)", g5.getAnnotationList(null));
    }

    @Test
    public void getAnnotationsMapParentFirst() {
        ClassInfoTest.check("@PA(10),@A(2),@A(1),@A(3),@A(5),@A(6),@A(7)", g3.getAnnotationListParentFirst(null));
        ClassInfoTest.check("@PA(10),@A(2),@A(1),@A(3),@A(5),@A(6),@A(7)", g4.getAnnotationListParentFirst(null));
        ClassInfoTest.check("@PA(10),@A(3)", g5.getAnnotationListParentFirst(null));
    }

    @Test
    public void getConfigAnnotationsMap() {
        ClassInfoTest.check("@AConfig(7),@AConfig(6),@AConfig(5),@AConfig(3),@AConfig(1),@AConfig(2)", gb3.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
        ClassInfoTest.check("@AConfig(7),@AConfig(6),@AConfig(5),@AConfig(3),@AConfig(1),@AConfig(2)", gb4.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
        ClassInfoTest.check("@AConfig(3)", gb5.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE));
    }

    @Test
    public void getConfigAnnotationsMapParentFirst() {
        ClassInfoTest.check("@AConfig(2),@AConfig(1),@AConfig(3),@AConfig(5),@AConfig(6),@AConfig(7)", gb3.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
        ClassInfoTest.check("@AConfig(2),@AConfig(1),@AConfig(3),@AConfig(5),@AConfig(6),@AConfig(7)", gb4.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
        ClassInfoTest.check("@AConfig(3)", gb5.getAnnotationListParentFirst((Predicate)ConfigAnnotationFilter.INSTANCE));
    }

    @Test
    public void isDeprecated() {
        Assert.assertFalse((boolean)hPublic.isDeprecated());
        Assert.assertTrue((boolean)hPublicDeprecated.isDeprecated());
    }

    @Test
    public void isDeprecated_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isDeprecated());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isDeprecated());
    }

    @Test
    public void isNotDeprecated() {
        Assert.assertTrue((boolean)hPublic.isNotDeprecated());
        Assert.assertFalse((boolean)hPublicDeprecated.isNotDeprecated());
    }

    @Test
    public void isNotDeprecated_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isNotDeprecated());
        Assert.assertTrue((boolean)pTypeInfo.isNotDeprecated());
        Assert.assertTrue((boolean)pTypeDimensionalInfo.isNotDeprecated());
        Assert.assertTrue((boolean)pTypeGenericInfo.isNotDeprecated());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotDeprecated());
    }

    @Test
    public void isPublic() {
        Assert.assertTrue((boolean)hPublic.isPublic());
        Assert.assertFalse((boolean)hProtected.isPublic());
        Assert.assertFalse((boolean)hPackage.isPublic());
        Assert.assertFalse((boolean)hPrivate.isPublic());
    }

    @Test
    public void isPublic_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isPublic());
        Assert.assertTrue((boolean)pTypeInfo.isPublic());
        Assert.assertTrue((boolean)pTypeDimensionalInfo.isPublic());
        Assert.assertTrue((boolean)pTypeGenericInfo.isPublic());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isPublic());
    }

    @Test
    public void isNotPublic() {
        Assert.assertFalse((boolean)hPublic.isNotPublic());
        Assert.assertTrue((boolean)hProtected.isNotPublic());
        Assert.assertTrue((boolean)hPackage.isNotPublic());
        Assert.assertTrue((boolean)hPrivate.isNotPublic());
    }

    @Test
    public void isNotPublic_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isNotPublic());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotPublic());
    }

    @Test
    public void isStatic() {
        Assert.assertTrue((boolean)hPublic.isStatic());
        Assert.assertFalse((boolean)hPublicMember.isStatic());
    }

    @Test
    public void isStatic_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isStatic());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isStatic());
    }

    @Test
    public void isNotStatic() {
        Assert.assertFalse((boolean)hPublic.isNotStatic());
        Assert.assertTrue((boolean)hPublicMember.isNotStatic());
    }

    @Test
    public void isNotStatic_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isNotStatic());
        Assert.assertTrue((boolean)pTypeInfo.isNotStatic());
        Assert.assertTrue((boolean)pTypeDimensionalInfo.isNotStatic());
        Assert.assertTrue((boolean)pTypeGenericInfo.isNotStatic());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotStatic());
    }

    @Test
    public void isAbstract() {
        Assert.assertTrue((boolean)hAbstractPublic.isAbstract());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isAbstract());
    }

    @Test
    public void isAbstract_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isAbstract());
        Assert.assertFalse((boolean)aTypeInfo.isAbstract());
    }

    @Test
    public void isNotAbstract() {
        Assert.assertFalse((boolean)hAbstractPublic.isNotAbstract());
        Assert.assertTrue((boolean)hPublic.isNotAbstract());
    }

    @Test
    public void isNotAbstract_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isNotAbstract());
        Assert.assertFalse((boolean)pTypeInfo.isNotAbstract());
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isNotAbstract());
        Assert.assertFalse((boolean)pTypeGenericInfo.isNotAbstract());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotAbstract());
    }

    @Test
    public void isMemberClass() {
        Assert.assertTrue((boolean)hPublic.isMemberClass());
        Assert.assertTrue((boolean)hPublicMember.isMemberClass());
        Assert.assertFalse((boolean)aClass.isMemberClass());
        Assert.assertFalse((boolean)aInterface.isMemberClass());
    }

    @Test
    public void isMemberClass_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isMemberClass());
        Assert.assertFalse((boolean)pTypeInfo.isMemberClass());
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isMemberClass());
        Assert.assertFalse((boolean)pTypeGenericInfo.isMemberClass());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isMemberClass());
    }

    @Test
    public void isNotMemberClass() {
        Assert.assertFalse((boolean)hPublic.isNotMemberClass());
        Assert.assertFalse((boolean)hPublicMember.isNotMemberClass());
        Assert.assertTrue((boolean)aClass.isNotMemberClass());
        Assert.assertTrue((boolean)aInterface.isNotMemberClass());
    }

    @Test
    public void isNotMemberClass_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isNotMemberClass());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotMemberClass());
    }

    @Test
    public void isNonStaticMemberClass() {
        Assert.assertFalse((boolean)hPublic.isNonStaticMemberClass());
        Assert.assertTrue((boolean)hPublicMember.isNonStaticMemberClass());
        Assert.assertFalse((boolean)aClass.isNonStaticMemberClass());
        Assert.assertFalse((boolean)aInterface.isNonStaticMemberClass());
    }

    @Test
    public void isNonStaticMemberClass_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isNonStaticMemberClass());
        Assert.assertFalse((boolean)pTypeInfo.isNonStaticMemberClass());
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isNonStaticMemberClass());
        Assert.assertFalse((boolean)pTypeGenericInfo.isNonStaticMemberClass());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isNonStaticMemberClass());
    }

    @Test
    public void isLocalClass() {
        Assert.assertFalse((boolean)aClass.isLocalClass());
        class F
        implements Function<Object, String> {
            F() {
            }

            @Override
            public String apply(Object t) {
                return null;
            }
        }
        Assert.assertTrue((boolean)ClassInfo.of(F.class).isLocalClass());
    }

    @Test
    public void isLocalClass_type() {
        Assert.assertFalse((boolean)aTypeInfo.isLocalClass());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isLocalClass());
    }

    @Test
    public void isNotLocalClass() {
        Assert.assertTrue((boolean)aClass.isNotLocalClass());
        class F
        implements Function<Object, String> {
            F() {
            }

            @Override
            public String apply(Object t) {
                return null;
            }
        }
        Assert.assertFalse((boolean)ClassInfo.of(F.class).isNotLocalClass());
    }

    @Test
    public void isNotLocalClass_type() {
        Assert.assertTrue((boolean)aTypeInfo.isNotLocalClass());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotLocalClass());
    }

    @Test
    public void isVisible_public() {
        Assert.assertTrue((boolean)hPublic.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)hProtected.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)hPackage.isVisible(Visibility.PUBLIC));
        Assert.assertFalse((boolean)hPrivate.isVisible(Visibility.PUBLIC));
    }

    @Test
    public void isVisible_protected() {
        Assert.assertTrue((boolean)hPublic.isVisible(Visibility.PROTECTED));
        Assert.assertTrue((boolean)hProtected.isVisible(Visibility.PROTECTED));
        Assert.assertFalse((boolean)hPackage.isVisible(Visibility.PROTECTED));
        Assert.assertFalse((boolean)hPrivate.isVisible(Visibility.PROTECTED));
    }

    @Test
    public void isVisible_package() {
        Assert.assertTrue((boolean)hPublic.isVisible(Visibility.DEFAULT));
        Assert.assertTrue((boolean)hProtected.isVisible(Visibility.DEFAULT));
        Assert.assertTrue((boolean)hPackage.isVisible(Visibility.DEFAULT));
        Assert.assertFalse((boolean)hPrivate.isVisible(Visibility.DEFAULT));
    }

    @Test
    public void isVisible_private() {
        Assert.assertTrue((boolean)hPublic.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)hProtected.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)hPackage.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)hPrivate.isVisible(Visibility.PRIVATE));
    }

    @Test
    public void isVisible_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)pTypeInfo.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)pTypeDimensionalInfo.isVisible(Visibility.PRIVATE));
        Assert.assertTrue((boolean)pTypeGenericInfo.isVisible(Visibility.PRIVATE));
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isVisible(Visibility.PRIVATE));
    }

    @Test
    public void isPrimitive() {
        Assert.assertTrue((boolean)ClassInfo.of(Integer.TYPE).isPrimitive());
        Assert.assertFalse((boolean)ClassInfo.of(Integer.class).isPrimitive());
    }

    @Test
    public void isPrimitive_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isPrimitive());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isPrimitive());
    }

    @Test
    public void isNotPrimitive() {
        Assert.assertFalse((boolean)ClassInfo.of(Integer.TYPE).isNotPrimitive());
        Assert.assertTrue((boolean)ClassInfo.of(Integer.class).isNotPrimitive());
    }

    @Test
    public void isNotPrimitive_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isNotPrimitive());
        Assert.assertTrue((boolean)pTypeInfo.isNotPrimitive());
        Assert.assertTrue((boolean)pTypeDimensionalInfo.isNotPrimitive());
        Assert.assertTrue((boolean)pTypeGenericInfo.isNotPrimitive());
        Assert.assertTrue((boolean)pTypeGenericArgInfo.isNotPrimitive());
    }

    @Test
    public void isInterface() {
        Assert.assertTrue((boolean)aInterface.isInterface());
        Assert.assertFalse((boolean)aClass.isInterface());
    }

    @Test
    public void isInterface_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isInterface());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isInterface());
    }

    @Test
    public void isClass() {
        Assert.assertTrue((boolean)aClass.isClass());
        Assert.assertFalse((boolean)aInterface.isClass());
    }

    @Test
    public void isClass_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isClass());
        Assert.assertFalse((boolean)pTypeInfo.isClass());
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isClass());
        Assert.assertTrue((boolean)pTypeGenericInfo.isClass());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isClass());
    }

    @Test
    public void isAll() {
        Assert.assertTrue((boolean)h2a.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED, ReflectFlags.PUBLIC, ReflectFlags.STATIC, ReflectFlags.MEMBER, ReflectFlags.ABSTRACT, ReflectFlags.CLASS}));
        Assert.assertTrue((boolean)h2b.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED, ReflectFlags.NOT_PUBLIC, ReflectFlags.STATIC, ReflectFlags.ABSTRACT, ReflectFlags.INTERFACE}));
    }

    @Test
    public void isAll_onType() {
        Assert.assertTrue((boolean)aTypeInfo.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC, ReflectFlags.MEMBER, ReflectFlags.CLASS}));
        Assert.assertFalse((boolean)pTypeInfo.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC, ReflectFlags.MEMBER, ReflectFlags.CLASS}));
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC, ReflectFlags.MEMBER, ReflectFlags.CLASS}));
        Assert.assertFalse((boolean)pTypeGenericInfo.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC, ReflectFlags.MEMBER, ReflectFlags.CLASS}));
    }

    @Test
    public void isAll_deprecated() {
        Assert.assertTrue((boolean)h2Deprecated.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertFalse((boolean)h2NotDeprecated.isAll(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
    }

    @Test
    public void isAll_notDeprecated() {
        Assert.assertFalse((boolean)h2Deprecated.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)h2NotDeprecated.isAll(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
    }

    @Test
    public void isAll_public() {
        Assert.assertTrue((boolean)ClassInfo.of(H2_Public.class).isAll(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertFalse((boolean)h2NotPublic.isAll(new ReflectFlags[]{ReflectFlags.PUBLIC}));
    }

    @Test
    public void isAll_notPublic() {
        Assert.assertFalse((boolean)ClassInfo.of(H2_Public.class).isAll(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)h2NotPublic.isAll(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
    }

    @Test
    public void isAll_static() {
        Assert.assertTrue((boolean)ClassInfo.of(H2_Static.class).isAll(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertFalse((boolean)h2NotStatic.isAll(new ReflectFlags[]{ReflectFlags.STATIC}));
    }

    @Test
    public void isAll_notStatic() {
        Assert.assertFalse((boolean)ClassInfo.of(H2_Static.class).isAll(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertTrue((boolean)h2NotStatic.isAll(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
    }

    @Test
    public void isAll_member() {
        Assert.assertTrue((boolean)h2Member.isAll(new ReflectFlags[]{ReflectFlags.MEMBER}));
        Assert.assertTrue((boolean)h2StaticMember.isAll(new ReflectFlags[]{ReflectFlags.MEMBER}));
        Assert.assertFalse((boolean)aClass.isAll(new ReflectFlags[]{ReflectFlags.MEMBER}));
    }

    @Test
    public void isAll_notMember() {
        Assert.assertFalse((boolean)h2Member.isAll(new ReflectFlags[]{ReflectFlags.NOT_MEMBER}));
        Assert.assertFalse((boolean)h2StaticMember.isAll(new ReflectFlags[]{ReflectFlags.NOT_MEMBER}));
        Assert.assertTrue((boolean)aClass.isAll(new ReflectFlags[]{ReflectFlags.NOT_MEMBER}));
    }

    @Test
    public void isAll_abstract() {
        Assert.assertTrue((boolean)ClassInfo.of(H2_Abstract.class).isAll(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertFalse((boolean)h2NotAbstract.isAll(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertTrue((boolean)aInterface.isAll(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
    }

    @Test
    public void isAll_notAbstract() {
        Assert.assertFalse((boolean)ClassInfo.of(H2_Abstract.class).isAll(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertTrue((boolean)h2NotAbstract.isAll(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertFalse((boolean)aInterface.isAll(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
    }

    @Test
    public void isAll_interface() {
        Assert.assertTrue((boolean)aInterface.isAll(new ReflectFlags[]{ReflectFlags.INTERFACE}));
        Assert.assertFalse((boolean)aClass.isAll(new ReflectFlags[]{ReflectFlags.INTERFACE}));
    }

    @Test
    public void isAll_class() {
        Assert.assertFalse((boolean)aInterface.isAll(new ReflectFlags[]{ReflectFlags.CLASS}));
        Assert.assertTrue((boolean)aClass.isAll(new ReflectFlags[]{ReflectFlags.CLASS}));
    }

    @Test
    public void isAll_invalid() {
        ClassInfo a = aClass;
        try {
            a.isAll(new ReflectFlags[]{ReflectFlags.HAS_PARAMS});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a.isAll(new ReflectFlags[]{ReflectFlags.HAS_NO_PARAMS});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a.isAll(new ReflectFlags[]{ReflectFlags.TRANSIENT});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a.isAll(new ReflectFlags[]{ReflectFlags.NOT_TRANSIENT});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void isAny() {
        Assert.assertTrue((boolean)h2a.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertTrue((boolean)h2a.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertTrue((boolean)h2a.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertTrue((boolean)h2a.isAny(new ReflectFlags[]{ReflectFlags.MEMBER}));
        Assert.assertTrue((boolean)h2a.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertTrue((boolean)h2a.isAny(new ReflectFlags[]{ReflectFlags.CLASS}));
        Assert.assertTrue((boolean)h2b.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)h2b.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)h2b.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertTrue((boolean)h2b.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertTrue((boolean)h2b.isAny(new ReflectFlags[]{ReflectFlags.INTERFACE}));
    }

    @Test
    public void isAny_onType() {
        Assert.assertFalse((boolean)aTypeInfo.isAny(new ReflectFlags[0]));
    }

    @Test
    public void isAny_deprecated() {
        Assert.assertTrue((boolean)h2Deprecated.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
        Assert.assertFalse((boolean)h2NotDeprecated.isAny(new ReflectFlags[]{ReflectFlags.DEPRECATED}));
    }

    @Test
    public void isAny_notDeprecated() {
        Assert.assertFalse((boolean)h2Deprecated.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
        Assert.assertTrue((boolean)h2NotDeprecated.isAny(new ReflectFlags[]{ReflectFlags.NOT_DEPRECATED}));
    }

    @Test
    public void isAny_public() {
        Assert.assertTrue((boolean)h2Public.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
        Assert.assertFalse((boolean)h2NotPublic.isAny(new ReflectFlags[]{ReflectFlags.PUBLIC}));
    }

    @Test
    public void isAny_notPublic() {
        Assert.assertFalse((boolean)h2Public.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
        Assert.assertTrue((boolean)h2NotPublic.isAny(new ReflectFlags[]{ReflectFlags.NOT_PUBLIC}));
    }

    @Test
    public void isAny_static() {
        Assert.assertTrue((boolean)h2Static.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
        Assert.assertFalse((boolean)h2NotStatic.isAny(new ReflectFlags[]{ReflectFlags.STATIC}));
    }

    @Test
    public void isAny_notStatic() {
        Assert.assertFalse((boolean)h2Static.isAny(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
        Assert.assertTrue((boolean)h2NotStatic.isAny(new ReflectFlags[]{ReflectFlags.NOT_STATIC}));
    }

    @Test
    public void isAny_member() {
        Assert.assertTrue((boolean)h2Member.isAny(new ReflectFlags[]{ReflectFlags.MEMBER}));
        Assert.assertTrue((boolean)h2StaticMember.isAny(new ReflectFlags[]{ReflectFlags.MEMBER}));
        Assert.assertFalse((boolean)aClass.isAny(new ReflectFlags[]{ReflectFlags.MEMBER}));
    }

    @Test
    public void isAny_notMember() {
        Assert.assertFalse((boolean)h2Member.isAny(new ReflectFlags[]{ReflectFlags.NOT_MEMBER}));
        Assert.assertFalse((boolean)h2StaticMember.isAny(new ReflectFlags[]{ReflectFlags.NOT_MEMBER}));
        Assert.assertTrue((boolean)aClass.isAny(new ReflectFlags[]{ReflectFlags.NOT_MEMBER}));
    }

    @Test
    public void isAny_abstract() {
        Assert.assertTrue((boolean)h2Abstract.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertFalse((boolean)h2NotAbstract.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
        Assert.assertTrue((boolean)aInterface.isAny(new ReflectFlags[]{ReflectFlags.ABSTRACT}));
    }

    @Test
    public void isAny_notAbstract() {
        Assert.assertFalse((boolean)h2Abstract.isAny(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertTrue((boolean)h2NotAbstract.isAny(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
        Assert.assertFalse((boolean)aInterface.isAny(new ReflectFlags[]{ReflectFlags.NOT_ABSTRACT}));
    }

    @Test
    public void isAny_interface() {
        Assert.assertTrue((boolean)aInterface.isAny(new ReflectFlags[]{ReflectFlags.INTERFACE}));
        Assert.assertFalse((boolean)aClass.isAny(new ReflectFlags[]{ReflectFlags.INTERFACE}));
    }

    @Test
    public void isAny_class() {
        Assert.assertFalse((boolean)aInterface.isAny(new ReflectFlags[]{ReflectFlags.CLASS}));
        Assert.assertTrue((boolean)aClass.isAny(new ReflectFlags[]{ReflectFlags.CLASS}));
    }

    @Test
    public void isAny_invalid() {
        ClassInfo a = aClass;
        try {
            a.isAny(new ReflectFlags[]{ReflectFlags.HAS_PARAMS});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a.isAny(new ReflectFlags[]{ReflectFlags.HAS_NO_PARAMS});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a.isAny(new ReflectFlags[]{ReflectFlags.TRANSIENT});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a.isAny(new ReflectFlags[]{ReflectFlags.NOT_TRANSIENT});
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void hasPrimitiveWrapper() {
        for (Class<?> c : primitives) {
            Assert.assertTrue((boolean)ClassInfo.of(c).hasPrimitiveWrapper());
        }
        for (Class<?> c : primitiveWrappers) {
            Assert.assertFalse((boolean)ClassInfo.of(c).hasPrimitiveWrapper());
        }
    }

    @Test
    public void hasPrimitiveWrapper_onType() {
        Assert.assertFalse((boolean)aTypeInfo.hasPrimitiveWrapper());
    }

    @Test
    public void getPrimitiveWrapper() {
        for (int i = 0; i < primitives.size(); ++i) {
            Assert.assertEquals((Object)ClassInfo.of(primitives.get(i)).getPrimitiveWrapper(), primitiveWrappers.get(i));
        }
        Assert.assertNull((Object)ClassInfo.of(String.class).getPrimitiveWrapper());
    }

    @Test
    public void getPrimitiveWrapper_onType() {
        Assert.assertNull((Object)aTypeInfo.getPrimitiveWrapper());
    }

    @Test
    public void getPrimitiveForWrapper() {
        for (int i = 0; i < primitives.size(); ++i) {
            Assert.assertEquals((Object)ClassInfo.of(primitiveWrappers.get(i)).getPrimitiveForWrapper(), primitives.get(i));
        }
        Assert.assertNull((Object)ClassInfo.of(String.class).getPrimitiveForWrapper());
    }

    @Test
    public void getPrimitiveForWrapper_onType() {
        Assert.assertNull((Object)aTypeInfo.getPrimitiveForWrapper());
    }

    @Test
    public void getWrapperIfPrimitive() {
        for (int i = 0; i < primitives.size(); ++i) {
            Assert.assertEquals((Object)ClassInfo.of(primitives.get(i)).getWrapperIfPrimitive(), primitiveWrappers.get(i));
        }
        Assert.assertEquals((Object)ClassInfo.of(String.class).getWrapperIfPrimitive(), String.class);
    }

    @Test
    public void getWrapperIfPrimitive_onType() {
        Assert.assertEquals((Object)"class org.apache.juneau.reflection.ClassInfoTest$A1", (Object)aTypeInfo.getWrapperIfPrimitive().toString());
        Assert.assertEquals((Object)"interface java.util.Map", (Object)pTypeInfo.getWrapperIfPrimitive().toString());
        Assert.assertEquals((Object)"interface java.util.Map", (Object)pTypeDimensionalInfo.getWrapperIfPrimitive().toString());
        Assert.assertEquals((Object)"class java.util.AbstractMap", (Object)pTypeGenericInfo.getWrapperIfPrimitive().toString());
        Assert.assertEquals(null, (Object)pTypeGenericArgInfo.getWrapperIfPrimitive());
    }

    @Test
    public void getWrapperInfoIfPrimitive() {
        for (int i = 0; i < primitives.size(); ++i) {
            Assert.assertEquals((Object)ClassInfo.of(primitives.get(i)).getWrapperInfoIfPrimitive().inner(), primitiveWrappers.get(i));
        }
        Assert.assertEquals((Object)ClassInfo.of(String.class).getWrapperInfoIfPrimitive().inner(), String.class);
    }

    @Test
    public void getWrapperInfoIfPrimitive_onType() {
        Assert.assertEquals((Object)aTypeInfo.getWrapperInfoIfPrimitive().innerType(), (Object)aType);
        ClassInfoTest.check("V", pTypeGenericArgInfo.getWrapperInfoIfPrimitive());
    }

    @Test
    public void getPrimitiveDefault() {
        for (int i = 0; i < primitives.size(); ++i) {
            Assert.assertEquals((Object)ClassInfo.of(primitives.get(i)).getPrimitiveDefault(), (Object)primitiveDefaults.get(i));
        }
        Assert.assertNull((Object)ClassInfo.of(String.class).getPrimitiveDefault());
    }

    @Test
    public void getPrimitiveDefault_onType() {
        Assert.assertNull((Object)aTypeInfo.getPrimitiveDefault());
    }

    @Test
    public void getFullName_simple() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.AClass", (Object)aClass.getFullName());
    }

    @Test
    public void getFullName_simpleTwice() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.AClass", (Object)aClass.getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.AClass", (Object)aClass.getFullName());
    }

    @Test
    public void getFullName_simpleArray() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.AClass[][]", (Object)ClassInfo.of(AClass[][].class).getFullName());
    }

    @Test
    public void getFullName_inner() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ClassInfoTest$J1", (Object)j1.getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ClassInfoTest$J2", (Object)j2.getFullName());
    }

    @Test
    public void getFullName_innerArray() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ClassInfoTest$J1[][]", (Object)j1_3d.getFullName());
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ClassInfoTest$J2[][]", (Object)j2_3d.getFullName());
    }

    @Test
    public void getFullName_primitive() {
        Assert.assertEquals((Object)"int", (Object)ClassInfo.of(Integer.TYPE).getFullName());
    }

    @Test
    public void getFullName_primitiveArray() {
        Assert.assertEquals((Object)"int[][]", (Object)ClassInfo.of(int[][].class).getFullName());
    }

    @Test
    public void getFullName_simpleType() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ClassInfoTest$A1", (Object)aTypeInfo.getFullName());
    }

    @Test
    public void getFullName_complexType() {
        Assert.assertEquals((Object)"java.util.Map<java.lang.String,java.util.List<java.lang.String>>", (Object)pTypeInfo.getFullName());
    }

    @Test
    public void getFullName_dimensionalType() {
        Assert.assertEquals((Object)"java.util.Map<java.lang.String,java.lang.String[][]>", (Object)pTypeDimensionalInfo.getFullName());
    }

    @Test
    public void getFullName_genericType() {
        Assert.assertEquals((Object)"java.util.AbstractMap<K,V>", (Object)pTypeGenericInfo.getFullName());
    }

    @Test
    public void getFullName_genericTypeArg() {
        Assert.assertEquals((Object)"V", (Object)pTypeGenericArgInfo.getFullName());
    }

    @Test
    public void getFullName_localClass() {
        class LocalClass
        implements Serializable {
            LocalClass() {
            }
        }
        Assert.assertEquals((Object)"org.apache.juneau.reflection.ClassInfoTest$1LocalClass", (Object)ClassInfo.of(LocalClass.class).getFullName());
    }

    @Test
    public void getShortName_simple() {
        Assert.assertEquals((Object)"AClass", (Object)aClass.getShortName());
    }

    @Test
    public void getShortName_simpleTwice() {
        Assert.assertEquals((Object)"AClass", (Object)aClass.getShortName());
        Assert.assertEquals((Object)"AClass", (Object)aClass.getShortName());
    }

    @Test
    public void getShortName_simpleArray() {
        Assert.assertEquals((Object)"AClass[][]", (Object)ClassInfo.of(AClass[][].class).getShortName());
    }

    @Test
    public void getShortName_inner() {
        Assert.assertEquals((Object)"ClassInfoTest$J1", (Object)j1.getShortName());
        Assert.assertEquals((Object)"ClassInfoTest$J2", (Object)j2.getShortName());
    }

    @Test
    public void getShortName_innerArray() {
        Assert.assertEquals((Object)"ClassInfoTest$J1[][]", (Object)j1_3d.getShortName());
        Assert.assertEquals((Object)"ClassInfoTest$J2[][]", (Object)j2_3d.getShortName());
    }

    @Test
    public void getShortName_primitive() {
        Assert.assertEquals((Object)"int", (Object)ClassInfo.of(Integer.TYPE).getShortName());
    }

    @Test
    public void getShortName_primitiveArray() {
        Assert.assertEquals((Object)"int[][]", (Object)ClassInfo.of(int[][].class).getShortName());
    }

    @Test
    public void getShortName_simpleType() {
        Assert.assertEquals((Object)"ClassInfoTest$A1", (Object)aTypeInfo.getShortName());
    }

    @Test
    public void getShortName_complexType() {
        Assert.assertEquals((Object)"Map<String,List<String>>", (Object)pTypeInfo.getShortName());
    }

    @Test
    public void getShortName_dimensionalType() {
        Assert.assertEquals((Object)"Map<String,String[][]>", (Object)pTypeDimensionalInfo.getShortName());
    }

    @Test
    public void getShortName_genericType() {
        Assert.assertEquals((Object)"AbstractMap<K,V>", (Object)pTypeGenericInfo.getShortName());
    }

    @Test
    public void getShortName_genericTypeArg() {
        Assert.assertEquals((Object)"V", (Object)pTypeGenericArgInfo.getShortName());
    }

    @Test
    public void getShortName_localClass() {
        class LocalClass
        implements Serializable {
            LocalClass() {
            }
        }
        Assert.assertEquals((Object)"ClassInfoTest$LocalClass", (Object)ClassInfo.of(LocalClass.class).getShortName());
    }

    @Test
    public void getSimpleName_simple() {
        Assert.assertEquals((Object)"AClass", (Object)aClass.getSimpleName());
    }

    @Test
    public void getSimpleName_simpleTwice() {
        Assert.assertEquals((Object)"AClass", (Object)aClass.getSimpleName());
        Assert.assertEquals((Object)"AClass", (Object)aClass.getSimpleName());
    }

    @Test
    public void getSimpleName_simpleArray() {
        Assert.assertEquals((Object)"AClass[][]", (Object)ClassInfo.of(AClass[][].class).getSimpleName());
    }

    @Test
    public void getSimpleName_inner() {
        Assert.assertEquals((Object)"J1", (Object)j1.getSimpleName());
        Assert.assertEquals((Object)"J2", (Object)j2.getSimpleName());
    }

    @Test
    public void getSimpleName_innerArray() {
        Assert.assertEquals((Object)"J1[][]", (Object)j1_3d.getSimpleName());
        Assert.assertEquals((Object)"J2[][]", (Object)j2_3d.getSimpleName());
    }

    @Test
    public void getSimpleName_primitive() {
        Assert.assertEquals((Object)"int", (Object)ClassInfo.of(Integer.TYPE).getSimpleName());
    }

    @Test
    public void getSimpleName_primitiveArray() {
        Assert.assertEquals((Object)"int[][]", (Object)ClassInfo.of(int[][].class).getSimpleName());
    }

    @Test
    public void getSimpleName_simpleType() {
        Assert.assertEquals((Object)"A1", (Object)aTypeInfo.getSimpleName());
    }

    @Test
    public void getSimpleName_complexType() {
        Assert.assertEquals((Object)"Map", (Object)pTypeInfo.getSimpleName());
    }

    @Test
    public void getSimpleName_dimensionalType() {
        Assert.assertEquals((Object)"Map", (Object)pTypeDimensionalInfo.getSimpleName());
    }

    @Test
    public void getSimpleName_genericType() {
        Assert.assertEquals((Object)"AbstractMap", (Object)pTypeGenericInfo.getSimpleName());
    }

    @Test
    public void getSimpleName_genericTypeArg() {
        Assert.assertEquals((Object)"V", (Object)pTypeGenericArgInfo.getSimpleName());
    }

    @Test
    public void getSimpleName_localClass() {
        class LocalClass
        implements Serializable {
            LocalClass() {
            }
        }
        Assert.assertEquals((Object)"LocalClass", (Object)ClassInfo.of(LocalClass.class).getSimpleName());
    }

    @Test
    public void getName() {
        Assert.assertEquals((Object)"org.apache.juneau.reflection.AClass", (Object)aClass.getName());
        Assert.assertEquals((Object)"java.util.AbstractMap", (Object)pTypeGenericInfo.getName());
        Assert.assertEquals((Object)"V", (Object)pTypeGenericArgInfo.getName());
    }

    @Test
    public void isParentOf() {
        Assert.assertTrue((boolean)ka.isParentOf(KA.class));
        Assert.assertTrue((boolean)ka.isParentOf(KB.class));
        Assert.assertTrue((boolean)ka.isParentOf(KC.class));
        Assert.assertFalse((boolean)kb.isParentOf(KA.class));
        Assert.assertTrue((boolean)kb.isParentOf(KB.class));
        Assert.assertTrue((boolean)kb.isParentOf(KC.class));
        Assert.assertFalse((boolean)kc.isParentOf(KA.class));
        Assert.assertFalse((boolean)kc.isParentOf(KB.class));
        Assert.assertTrue((boolean)kc.isParentOf(KC.class));
    }

    @Test
    public void isParentOf_null() {
        Assert.assertFalse((boolean)ka.isParentOf(null));
    }

    @Test
    public void isParentOf_type() {
        Assert.assertFalse((boolean)ka.isParentOf(aType));
        Assert.assertFalse((boolean)ka.isParentOf(pType));
        Assert.assertFalse((boolean)ka.isParentOf(pTypeDimensional));
        Assert.assertFalse((boolean)ka.isParentOf(pTypeGeneric));
        Assert.assertFalse((boolean)ka.isParentOf(pTypeGenericArg));
        Assert.assertFalse((boolean)aTypeInfo.isParentOf(KA.class));
        Assert.assertFalse((boolean)pTypeInfo.isParentOf(KA.class));
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isParentOf(KA.class));
        Assert.assertFalse((boolean)pTypeGenericInfo.isParentOf(KA.class));
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isParentOf(KA.class));
    }

    @Test
    public void isChildOf() {
        Assert.assertTrue((boolean)ka.isChildOf(KA.class));
        Assert.assertFalse((boolean)ka.isChildOf(KB.class));
        Assert.assertFalse((boolean)ka.isChildOf(KC.class));
        Assert.assertTrue((boolean)kb.isChildOf(KA.class));
        Assert.assertTrue((boolean)kb.isChildOf(KB.class));
        Assert.assertFalse((boolean)kb.isChildOf(KC.class));
        Assert.assertTrue((boolean)kc.isChildOf(KA.class));
        Assert.assertTrue((boolean)kc.isChildOf(KB.class));
        Assert.assertTrue((boolean)kc.isChildOf(KC.class));
    }

    @Test
    public void isChildOf_null() {
        Assert.assertFalse((boolean)ka.isChildOf((Class)null));
    }

    @Test
    public void isChildOf_type() {
        Assert.assertFalse((boolean)ka.isChildOf(aType));
        Assert.assertFalse((boolean)ka.isChildOf(pType));
        Assert.assertFalse((boolean)ka.isChildOf(pTypeDimensional));
        Assert.assertFalse((boolean)ka.isChildOf(pTypeGeneric));
        Assert.assertFalse((boolean)ka.isChildOf(pTypeGenericArg));
        Assert.assertFalse((boolean)aTypeInfo.isChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeInfo.isChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeGenericInfo.isChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isChildOf(KA.class));
    }

    @Test
    public void isStrictChildOf() {
        Assert.assertFalse((boolean)ka.isStrictChildOf(KA.class));
        Assert.assertFalse((boolean)ka.isStrictChildOf(KB.class));
        Assert.assertFalse((boolean)ka.isStrictChildOf(KC.class));
        Assert.assertTrue((boolean)kb.isStrictChildOf(KA.class));
        Assert.assertFalse((boolean)kb.isStrictChildOf(KB.class));
        Assert.assertFalse((boolean)kb.isStrictChildOf(KC.class));
        Assert.assertTrue((boolean)kc.isStrictChildOf(KA.class));
        Assert.assertTrue((boolean)kc.isStrictChildOf(KB.class));
        Assert.assertFalse((boolean)kc.isStrictChildOf(KC.class));
    }

    @Test
    public void isStrictChildOf_null() {
        Assert.assertFalse((boolean)ka.isStrictChildOf(null));
    }

    @Test
    public void isStrictChildOf_type() {
        Assert.assertFalse((boolean)aTypeInfo.isStrictChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeInfo.isStrictChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isStrictChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeGenericInfo.isStrictChildOf(KA.class));
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isStrictChildOf(KA.class));
    }

    @Test
    public void isChildOfAny() {
        Assert.assertTrue((boolean)ka.isChildOfAny(new Class[]{KA.class}));
        Assert.assertFalse((boolean)ka.isChildOfAny(new Class[]{KB.class}));
        Assert.assertFalse((boolean)ka.isChildOfAny(new Class[]{KC.class}));
        Assert.assertTrue((boolean)kb.isChildOfAny(new Class[]{KA.class}));
        Assert.assertTrue((boolean)kb.isChildOfAny(new Class[]{KB.class}));
        Assert.assertFalse((boolean)kb.isChildOfAny(new Class[]{KC.class}));
        Assert.assertTrue((boolean)kc.isChildOfAny(new Class[]{KA.class}));
        Assert.assertTrue((boolean)kc.isChildOfAny(new Class[]{KB.class}));
        Assert.assertTrue((boolean)kc.isChildOfAny(new Class[]{KC.class}));
    }

    @Test
    public void isChildOfAny_type() {
        Assert.assertFalse((boolean)aTypeInfo.isChildOfAny(new Class[]{KA.class}));
        Assert.assertFalse((boolean)pTypeInfo.isChildOfAny(new Class[]{KA.class}));
        Assert.assertFalse((boolean)pTypeDimensionalInfo.isChildOfAny(new Class[]{KA.class}));
        Assert.assertFalse((boolean)pTypeGenericInfo.isChildOfAny(new Class[]{KA.class}));
        Assert.assertFalse((boolean)pTypeGenericArgInfo.isChildOfAny(new Class[]{KA.class}));
    }

    @Test
    public void is() {
        Assert.assertTrue((boolean)ka.is(KA.class));
        Assert.assertFalse((boolean)ka.is(KB.class));
        Assert.assertFalse((boolean)ka.is(KC.class));
        Assert.assertFalse((boolean)kb.is(KA.class));
        Assert.assertTrue((boolean)kb.is(KB.class));
        Assert.assertFalse((boolean)kb.is(KC.class));
        Assert.assertFalse((boolean)kc.is(KA.class));
        Assert.assertFalse((boolean)kc.is(KB.class));
        Assert.assertTrue((boolean)kc.is(KC.class));
    }

    @Test
    public void is_ClassInfo() {
        Assert.assertTrue((boolean)ka.is(ClassInfo.of(KA.class)));
        Assert.assertFalse((boolean)ka.is(ClassInfo.of(KB.class)));
        Assert.assertFalse((boolean)ka.is(ClassInfo.of(KC.class)));
        Assert.assertFalse((boolean)kb.is(ClassInfo.of(KA.class)));
        Assert.assertTrue((boolean)kb.is(ClassInfo.of(KB.class)));
        Assert.assertFalse((boolean)kb.is(ClassInfo.of(KC.class)));
        Assert.assertFalse((boolean)kc.is(ClassInfo.of(KA.class)));
        Assert.assertFalse((boolean)kc.is(ClassInfo.of(KB.class)));
        Assert.assertTrue((boolean)kc.is(ClassInfo.of(KC.class)));
    }

    @Test
    public void is_ClassInfo_genType() {
        Assert.assertFalse((boolean)pTypeGenericArgInfo.is(ClassInfo.of(KA.class)));
    }

    @Test
    public void isAnyType() {
        Assert.assertTrue((boolean)ka.isAny(new Class[]{KA.class}));
        Assert.assertTrue((boolean)ka.isAny(new Class[]{KA.class, KB.class}));
        Assert.assertFalse((boolean)ka.isAny(new Class[]{KB.class}));
        Assert.assertFalse((boolean)ka.isAny(new Class[]{KC.class}));
        Assert.assertFalse((boolean)kb.isAny(new Class[]{KA.class}));
        Assert.assertTrue((boolean)kb.isAny(new Class[]{KB.class}));
        Assert.assertFalse((boolean)kb.isAny(new Class[]{KC.class}));
        Assert.assertFalse((boolean)kc.isAny(new Class[]{KA.class}));
        Assert.assertFalse((boolean)kc.isAny(new Class[]{KB.class}));
        Assert.assertTrue((boolean)kc.isAny(new Class[]{KC.class}));
    }

    @Test
    public void is_type() {
        Assert.assertFalse((boolean)aTypeInfo.is(KA.class));
        Assert.assertFalse((boolean)pTypeInfo.is(KA.class));
        Assert.assertFalse((boolean)pTypeDimensionalInfo.is(KA.class));
        Assert.assertFalse((boolean)pTypeGenericInfo.is(KA.class));
        Assert.assertFalse((boolean)pTypeGenericArgInfo.is(KA.class));
    }

    @Test
    public void getPackage() {
        ClassInfoTest.check("org.apache.juneau.reflection", ka.getPackage().getName());
    }

    @Test
    public void getPackage_type() {
        ClassInfoTest.check("org.apache.juneau.reflection", aTypeInfo.getPackage());
        ClassInfoTest.check("java.util", pTypeInfo.getPackage());
        ClassInfoTest.check("java.util", pTypeDimensionalInfo.getPackage());
        ClassInfoTest.check("java.util", pTypeGenericInfo.getPackage());
        ClassInfoTest.check(null, pTypeGenericArgInfo.getPackage());
    }

    @Test
    public void hasPackage() {
        Assert.assertTrue((boolean)ka.hasPackage());
    }

    @Test
    public void hasPackage_type() {
        Assert.assertTrue((boolean)aTypeInfo.hasPackage());
        Assert.assertTrue((boolean)pTypeInfo.hasPackage());
        Assert.assertTrue((boolean)pTypeDimensionalInfo.hasPackage());
        Assert.assertTrue((boolean)pTypeGenericInfo.hasPackage());
        Assert.assertFalse((boolean)pTypeGenericArgInfo.hasPackage());
    }

    @Test
    public void getDimensions() {
        Assert.assertEquals((long)0L, (long)ka.getDimensions());
        Assert.assertEquals((long)2L, (long)ClassInfo.of(KA[][].class).getDimensions());
    }

    @Test
    public void getDimensions_type() {
        Assert.assertEquals((long)0L, (long)aTypeInfo.getDimensions());
        Assert.assertEquals((long)0L, (long)pTypeInfo.getDimensions());
        Assert.assertEquals((long)0L, (long)pTypeDimensionalInfo.getDimensions());
        Assert.assertEquals((long)0L, (long)pTypeGenericInfo.getDimensions());
        Assert.assertEquals((long)0L, (long)pTypeGenericArgInfo.getDimensions());
    }

    @Test
    public void getComponentType() {
        ClassInfoTest.check("KA", ka.getComponentType());
        ClassInfoTest.check("KA", ClassInfo.of(KA[][].class).getComponentType());
    }

    @Test
    public void getComponentType_twice() {
        ClassInfoTest.check("KA", ka.getComponentType());
        ClassInfoTest.check("KA", ka.getComponentType());
    }

    @Test
    public void getComponentType_type() {
        ClassInfoTest.check("A1", aTypeInfo.getComponentType());
        ClassInfoTest.check("Map", pTypeInfo.getComponentType());
        ClassInfoTest.check("Map", pTypeDimensionalInfo.getComponentType());
        ClassInfoTest.check("AbstractMap", pTypeGenericInfo.getComponentType());
        ClassInfoTest.check("V", pTypeGenericArgInfo.getComponentType());
    }

    @Test
    public void newInstance() {
        try {
            Assert.assertNotNull((Object)la.newInstance());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void newInstance_type() {
        try {
            aTypeInfo.newInstance();
            Assert.fail();
        }
        catch (ExecutableException executableException) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            pTypeInfo.newInstance();
            Assert.fail();
        }
        catch (ExecutableException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            pTypeDimensionalInfo.newInstance();
            Assert.fail();
        }
        catch (ExecutableException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            pTypeGenericInfo.newInstance();
            Assert.fail();
        }
        catch (ExecutableException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            pTypeGenericArgInfo.newInstance();
            Assert.fail();
        }
        catch (ExecutableException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getParameterType_simpleMap() {
        ClassInfoTest.check("String", ma.getParameterType(0, HashMap.class));
        ClassInfoTest.check("Integer", ma.getParameterType(1, HashMap.class));
        ClassInfoTest.check("String", mb.getParameterType(0, HashMap.class));
        ClassInfoTest.check("Integer", mb.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_outOfBounds() {
        try {
            ma.getParameterType(2, HashMap.class);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid type index. index=2, argsLength=2", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_notASubclass() {
        try {
            aClass.getParameterType(2, HashMap.class);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Class 'AClass' is not a subclass of parameterized type 'HashMap'", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_nullParameterizedType() {
        try {
            aClass.getParameterType(2, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Parameterized type cannot be null", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_notParamerizedType() {
        try {
            mb.getParameterType(2, MA.class);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Class 'MA' is not a parameterized type", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_unresolvedTypes() {
        try {
            mc.getParameterType(1, HashMap.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Could not resolve variable 'E' to a type.", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_resolvedTypes() {
        ClassInfoTest.check("Integer", md.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_parameterizedTypeVariable() {
        ClassInfoTest.check("HashMap", me.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_arrayParameterType() {
        ClassInfoTest.check("String[]", mf.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_genericArrayTypeParameter() {
        ClassInfoTest.check("HashMap[]", mg.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_genericArrayTypeParameterWithoutTypes() {
        ClassInfoTest.check("LinkedList[]", mh.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_unresolvedGenericArrayType() {
        try {
            mi.getParameterType(1, HashMap.class);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Could not resolve variable 'X[]' to a type.", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_wildcardType() {
        try {
            mj.getParameterType(1, HashMap.class);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Could not resolve variable 'X' to a type.", (Object)e.getMessage());
        }
    }

    @Test
    public void getParameterType_innerType() {
        ClassInfoTest.check("MK", ml.getParameterType(1, HashMap.class));
    }

    @Test
    public void getParameterType_nestedType() {
        ClassInfoTest.check("MM", mn.getParameterType(1, HashMap.class));
    }

    @Test
    public void xToString() {
        Assert.assertEquals((Object)"class org.apache.juneau.reflection.AClass", (Object)aClass.toString());
        Assert.assertEquals((Object)"interface org.apache.juneau.reflection.AInterface", (Object)aInterface.toString());
        Assert.assertEquals((Object)"class org.apache.juneau.reflection.ClassInfoTest$A1", (Object)aType.toString());
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, java.util.List<java.lang.String>>", (Object)pType.toString());
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, java.lang.String[][]>", (Object)pTypeDimensional.toString());
        Assert.assertEquals((Object)"java.util.AbstractMap<K, V>", (Object)pTypeGeneric.toString());
        Assert.assertEquals((Object)"V", (Object)pTypeGenericArg.toString());
    }

    static {
        HashMap m = new HashMap();
        pTypeGeneric = m.getClass().getGenericSuperclass();
        pTypeGenericArg = ((ParameterizedType)pTypeGeneric).getActualTypeArguments()[1];
        aTypeInfo = ClassInfo.of((Type)aType);
        pTypeInfo = ClassInfo.of((Type)pType);
        pTypeDimensionalInfo = ClassInfo.of((Type)pTypeDimensional);
        pTypeGenericInfo = ClassInfo.of((Type)pTypeGeneric);
        pTypeGenericArgInfo = ClassInfo.of((Type)pTypeGenericArg);
        aClass = ClassInfo.of(AClass.class);
        aInterface = ClassInfo.of(AInterface.class);
        bi1 = ClassInfo.of(BI1.class);
        bi2 = ClassInfo.of(BI2.class);
        bi3 = ClassInfo.of(BI3.class);
        bi4 = ClassInfo.of(BI4.class);
        bc1 = ClassInfo.of(BC1.class);
        bc2 = ClassInfo.of(BC2.class);
        bc3 = ClassInfo.of(BC3.class);
        object = ClassInfo.of(Object.class);
        cc3 = ClassInfo.of(CC3.class);
        ci2 = ClassInfo.of(CI2.class);
        c2 = ClassInfo.of(C2.class);
        da1 = ClassInfo.of(DA1.class);
        da2 = ClassInfo.of(DA2.class);
        da3 = ClassInfo.of(DA3.class);
        da4 = ClassInfo.of(DA4.class);
        da5 = ClassInfo.of(DA5.class);
        da6 = ClassInfo.of(DA6.class);
        da7 = ClassInfo.of(DA7.class);
        da8 = ClassInfo.of(DA8.class);
        db1 = ClassInfo.of(DB1.class);
        db2 = ClassInfo.of(DB2.class);
        db3 = ClassInfo.of(DB3.class);
        db4 = ClassInfo.of(DB4.class);
        db5 = ClassInfo.of(DB5.class);
        db6 = ClassInfo.of(DB6.class);
        db7 = ClassInfo.of(DB7.class);
        db8 = ClassInfo.of(DB8.class);
        db9 = ClassInfo.of(DB9.class);
        db10 = ClassInfo.of(DB10.class);
        db11 = ClassInfo.of(DB11.class);
        dc1 = ClassInfo.of(DC1.class);
        dc2 = ClassInfo.of(DC2.class);
        dc3 = ClassInfo.of(DC3.class);
        dc4 = ClassInfo.of(DC4.class);
        dc5 = ClassInfo.of(DC5.class);
        dd1 = ClassInfo.of(DD1.class);
        dd2 = ClassInfo.of(DD2.class);
        dd3 = ClassInfo.of(DD3.class);
        dd4 = ClassInfo.of(DD4.class);
        dd5 = ClassInfo.of(DD5.class);
        e1 = ClassInfo.of(E1.class);
        e2 = ClassInfo.of(E2.class);
        e3 = ClassInfo.of(E3.class);
        e4 = ClassInfo.of(E4.class);
        e5 = ClassInfo.of(E5.class);
        e6 = ClassInfo.of(E6.class);
        f1 = ClassInfo.of(F1.class);
        f2 = ClassInfo.of(F2.class);
        f3 = ClassInfo.of(F3.class);
        g3 = ClassInfo.of(G3.class);
        g4 = ClassInfo.of(G4.class);
        g5 = ClassInfo.of(G5.class);
        gb3 = ClassInfo.of(GB3.class);
        gb4 = ClassInfo.of(GB4.class);
        gb5 = ClassInfo.of(GB5.class);
        hPublic = ClassInfo.of(H_Public.class);
        hPackage = ClassInfo.of(H_Package.class);
        hProtected = ClassInfo.of(H_Protected.class);
        hPrivate = ClassInfo.of(H_Private.class);
        hPublicMember = ClassInfo.of(H_PublicMember.class);
        hAbstractPublic = ClassInfo.of(H_AbstractPublic.class);
        hPublicDeprecated = ClassInfo.of(H_PublicDeprecated.class);
        h2a = ClassInfo.of(H2a.class);
        h2b = ClassInfo.of(H2b.class);
        h2Deprecated = ClassInfo.of(H2_Deprecated.class);
        h2NotDeprecated = ClassInfo.of(H2_NotDeprecated.class);
        h2Public = ClassInfo.of(H2_Public.class);
        h2NotPublic = ClassInfo.of(H2_NotPublic.class);
        h2Static = ClassInfo.of(H2_Static.class);
        h2NotStatic = ClassInfo.of(H2_NotStatic.class);
        h2Member = ClassInfo.of(H2_Member.class);
        h2StaticMember = ClassInfo.of(H2_StaticMember.class);
        h2Abstract = ClassInfo.of(H2_Abstract.class);
        h2NotAbstract = ClassInfo.of(H2_NotAbstract.class);
        primitives = AList.create((Object[])new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        primitiveWrappers = AList.create((Object[])new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class});
        primitiveDefaults = AList.create((Object[])new Object[]{false, (byte)0, (short)0, Character.valueOf('\u0000'), 0, 0L, Float.valueOf(0.0f), 0.0});
        j1 = ClassInfo.of(J1.class);
        j2 = ClassInfo.of(J2.class);
        j1_3d = ClassInfo.of(J1[][].class);
        j2_3d = ClassInfo.of(J2[][].class);
        ka = ClassInfo.of(KA.class);
        kb = ClassInfo.of(KB.class);
        kc = ClassInfo.of(KC.class);
        la = ClassInfo.of(LA.class);
        ma = ClassInfo.of(MA.class);
        mb = ClassInfo.of(MB.class);
        mc = ClassInfo.of(MC.class);
        md = ClassInfo.of(MD.class);
        me = ClassInfo.of(ME.class);
        mf = ClassInfo.of(MF.class);
        mg = ClassInfo.of(MG.class);
        mh = ClassInfo.of(MH.class);
        mi = ClassInfo.of(MI.class);
        mj = ClassInfo.of(MJ.class);
        ml = ClassInfo.of(ML.class);
        mn = ClassInfo.of(MM.MN.class);
    }

    public static class MM {

        public class MN
        extends HashMap<String, MM> {
        }
    }

    public class ML
    extends HashMap<String, MK> {
    }

    public class MK {
    }

    public static class MJ<X extends Number>
    extends HashMap<String, X> {
    }

    public static class MI<X>
    extends HashMap<String, X[]> {
    }

    public static class MH
    extends HashMap<String, LinkedList[]> {
    }

    public static class MG
    extends HashMap<String, HashMap<String, Integer>[]> {
    }

    public static class MF
    extends HashMap<String, String[]> {
    }

    public static class ME
    extends HashMap<String, HashMap<String, Integer>> {
    }

    public static class MD
    extends MC<String, Integer> {
    }

    public static class MC<K, E>
    extends HashMap<K, E> {
    }

    public static class MB
    extends MA {
    }

    public static class MA
    extends HashMap<String, Integer> {
    }

    public static class LA {
    }

    public static class KC
    extends KB {
    }

    public static class KB
    implements KA {
    }

    public static interface KA {
    }

    public static class J2 {
    }

    public class J1 {
    }

    class H2_NotAbstract {
        H2_NotAbstract() {
        }
    }

    abstract class H2_Abstract {
        H2_Abstract() {
        }
    }

    static class H2_StaticMember {
        H2_StaticMember() {
        }
    }

    class H2_Member {
        H2_Member() {
        }
    }

    class H2_NotStatic {
        H2_NotStatic() {
        }
    }

    public static class H2_Static {
    }

    class H2_NotPublic {
        H2_NotPublic() {
        }
    }

    public class H2_Public {
    }

    class H2_NotDeprecated {
        H2_NotDeprecated() {
        }
    }

    @Deprecated
    class H2_Deprecated {
        H2_Deprecated() {
        }
    }

    private static interface H2b {
    }

    @Deprecated
    public static abstract class H2a {
    }

    @Deprecated
    public class H_PublicDeprecated {
    }

    public abstract class H_AbstractPublic {
    }

    public class H_PublicMember {
    }

    private static class H_Private {
        private H_Private() {
        }
    }

    protected static class H_Protected {
        protected H_Protected() {
        }
    }

    static class H_Package {
        H_Package() {
        }
    }

    public static class H_Public {
    }

    static class GB5
    implements GBI3 {
        GB5() {
        }
    }

    static class GB4
    extends GB3 {
        GB4() {
        }
    }

    @A(value=7)
    @AConfig(value=7)
    static class GB3
    extends GB2 {
        GB3() {
        }
    }

    @A(value=6)
    @AConfig(value=6)
    static class GB2
    extends GB1
    implements GBI3 {
        GB2() {
        }
    }

    @A(value=5)
    @AConfig(value=5)
    static class GB1
    implements GBI1,
    GBI2 {
        GB1() {
        }
    }

    @A(value=4)
    @AConfig(value=4)
    static interface GBI4 {
    }

    @A(value=3)
    @AConfig(value=3)
    static interface GBI3 {
    }

    @A(value=2)
    @AConfig(value=2)
    static interface GBI2
    extends GBI1 {
    }

    @A(value=1)
    @AConfig(value=1)
    static interface GBI1 {
    }

    static class G5
    implements GI3 {
        G5() {
        }
    }

    static class G4
    extends G3 {
        G4() {
        }
    }

    @A(value=7)
    static class G3
    extends G2 {
        G3() {
        }
    }

    @A(value=6)
    static class G2
    extends G1
    implements GI3 {
        G2() {
        }
    }

    @A(value=5)
    static class G1
    implements GI1,
    GI2 {
        G1() {
        }
    }

    @A(value=4)
    static interface GI4 {
    }

    @A(value=3)
    static interface GI3 {
    }

    @A(value=2)
    static interface GI2
    extends GI1 {
    }

    @A(value=1)
    static interface GI1 {
    }

    static class F3 {
        public int a1;
        int a2;

        F3() {
        }
    }

    static class F2
    extends F1 {
        public int f1a;
        public int f2b;
        @Deprecated
        int f2c;
        protected int f2d;

        F2() {
        }
    }

    static abstract class F1 {
        public int f1a;
        public int f1b;

        F1() {
        }
    }

    class E6 {
        public E6(String a) {
        }
    }

    static class E5 {
        @Deprecated
        public E5() {
        }
    }

    class E4 {
    }

    static abstract class E3 {
    }

    static class E2 {
        protected E2() {
        }
    }

    static class E1 {
        public E1() {
        }

        public E1(String a) {
        }

        public E1(Writer a) {
        }

        public E1(String a, Writer b) {
        }

        protected E1(int a) {
        }

        E1(float a) {
        }
    }

    static class DD5 {
        DD5() {
        }

        public DDx build(String x) {
            return null;
        }
    }

    static class DD4 {
        DD4() {
        }

        public DDx build2() {
            return null;
        }
    }

    static class DD3 {
        DD3() {
        }

        public static DDx build() {
            return null;
        }
    }

    static class DD2 {
        DD2() {
        }

        public void build() {
        }
    }

    static class DD1 {
        DD1() {
        }

        public DDx build() {
            return null;
        }
    }

    static class DDx {
        DDx() {
        }
    }

    static class DC5 {
        DC5() {
        }

        public static DCx createFoo() {
            return null;
        }
    }

    static class DC4 {
        DC4() {
        }

        public static void create() {
        }
    }

    static class DC3 {
        DC3() {
        }

        public DCx create() {
            return null;
        }
    }

    static class DC2 {
        DC2() {
        }

        protected static DCx create() {
            return null;
        }
    }

    static class DC1 {
        DC1() {
        }

        public static DCx create() {
            return null;
        }
    }

    static class DCx {
        DCx() {
        }
    }

    static class DB11 {
        DB11() {
        }

        public static DB11 fromFoo(DBx x) {
            return null;
        }
    }

    static class DB10 {
        DB10() {
        }

        public static DB10 foo(DBx x) {
            return null;
        }
    }

    static class DB9 {
        DB9() {
        }

        public static DB9 create(DB1 x) {
            return null;
        }
    }

    static class DB8 {
        DB8() {
        }

        @Deprecated
        public static DB8 create(DBx x) {
            return null;
        }
    }

    static class DB7 {
        DB7() {
        }

        protected static DB7 from(DBx x) {
            return null;
        }
    }

    static class DB6 {
        DB6() {
        }

        protected static DB6 fromDBx(DBx x) {
            return null;
        }
    }

    static class DB5 {
        DB5() {
        }

        public DB5 fromDBx(DBx x) {
            return null;
        }
    }

    static class DB4 {
        DB4() {
        }

        public static DBx fromDBx(DBx x) {
            return null;
        }
    }

    static class DB3 {
        DB3() {
        }

        public static DB3 from(DBx x) {
            return null;
        }
    }

    static class DB2 {
        DB2() {
        }

        public static DB2 fromDBx(DBx x) {
            return null;
        }
    }

    static class DB1 {
        DB1() {
        }

        public static DB1 create(DBx x) {
            return null;
        }
    }

    static class DBx {
        DBx() {
        }
    }

    static class DA8 {
        DA8() {
        }

        public static DA8 create2(String s1) {
            return null;
        }
    }

    static class DA7 {
        DA7() {
        }

        static DA7 create(String s1) {
            return null;
        }
    }

    static class DA6 {
        DA6() {
        }

        public DA6 create(String s1) {
            return null;
        }
    }

    static class DA5 {
        DA5() {
        }

        public static DA5 create(String s1, String s2) {
            return null;
        }
    }

    static class DA4 {
        DA4() {
        }

        public static DA1 create(String s) {
            return null;
        }
    }

    static class DA3 {
        DA3() {
        }

        @Deprecated
        public static DA3 create(String s) {
            return null;
        }
    }

    static class DA2 {
        DA2() {
        }

        public static DA2 create(Object o) {
            return null;
        }
    }

    static class DA1 {
        DA1() {
        }

        public static DA1 create(String s) {
            return null;
        }
    }

    static class C2 {
        C2() {
        }

        public void a1() {
        }

        public void a2(int x) {
        }

        void b1() {
        }

        void b2(int x) {
        }
    }

    static class CC3
    extends CC2 {
        CC3() {
        }

        @Override
        public void i2b() {
        }

        public void c3a() {
        }

        protected void c3b() {
        }
    }

    static class CC2
    extends CC1
    implements CI3 {
        CC2() {
        }

        public void c2b() {
        }

        @Override
        public void i1b() {
        }

        @Override
        public void i2b() {
        }

        @Override
        public void i2a() {
        }

        protected void c2a() {
        }
    }

    static abstract class CC1
    implements CI1,
    CI2 {
        CC1() {
        }

        @Override
        public void i1a() {
        }

        protected void c1b() {
        }

        public void c1a() {
        }
    }

    static interface CI4 {
    }

    static interface CI3 {
    }

    static interface CI2
    extends CI1 {
        public void i2b();

        public void i2a();
    }

    static interface CI1 {
        public void i1a();

        public void i1b();
    }

    static class BC3
    extends BC2 {
        BC3() {
        }
    }

    static class BC2
    extends BC1
    implements BI3 {
        BC2() {
        }
    }

    static class BC1
    implements BI1,
    BI2 {
        BC1() {
        }
    }

    static interface BI4 {
    }

    static interface BI3 {
    }

    static interface BI2
    extends BI1 {
    }

    static interface BI1 {
    }

    public class A4
    extends Value<Map<String, String[][]>> {
    }

    public class A3
    extends Value<Map<String, List<String>>> {
    }

    public class A2
    extends Value<A1> {
    }

    public class A1 {
    }

    public static class AConfigApply
    extends ConfigApply<AConfig> {
        protected AConfigApply(Class<AConfig> c, VarResolverSession r) {
            super(c, r);
        }

        public void apply(AnnotationInfo<AConfig> a, PropertyStoreBuilder ps) {
        }
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @PropertyStoreApply(value=AConfigApply.class)
    static @interface AConfig {
        public int value();
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface B {
        public int value();
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface A {
        public int value();
    }
}

