/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflection;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ClassInfo;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationInfoTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t instanceof A) {
                return "@A(" + ((A)t).value() + ")";
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            return t.toString();
        }
    };
    static ClassInfo b = AnnotationInfoTest.of(B.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    private static ClassInfo of(Class<?> c) {
        try {
            return ClassInfo.of(c);
        }
        catch (SecurityException e) {
            Assert.fail((String)e.getLocalizedMessage());
            return null;
        }
    }

    @Test
    public void getClassOn() {
        AnnotationInfoTest.check("B", ((AnnotationInfo)b.getAnnotationInfos(A.class).get(0)).getClassOn());
    }

    @Test
    public void getAnnotation() {
        AnnotationInfoTest.check("@A(1)", ((AnnotationInfo)b.getAnnotationInfos(A.class).get(0)).getAnnotation());
    }

    @A(value=1)
    static class B {
        B() {
        }
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface A {
        public int value();
    }
}

