/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.pojotools.PojoViewer;
import org.apache.juneau.pojotools.ViewArgs;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class PojoViewerTest {
    PojoViewer p = new PojoViewer();
    BeanSession bs = BeanContext.DEFAULT.createBeanSession();

    @Test
    public void nullInput() {
        Assert.assertNull((Object)this.p.run(this.bs, null, null));
    }

    @Test
    public void simpleBean() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        A in = A.create("x1", "x2");
        TestUtils.assertObjectEquals("{f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleBean_reverseColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f2", "f1"});
        A in = A.create("x1", "x2");
        TestUtils.assertObjectEquals("{f2:'x2',f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleBean_dupColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", "f1"});
        A in = A.create("x1", "x2");
        TestUtils.assertObjectEquals("{f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleBean_nonExistentColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"fx"});
        A in = A.create("x1", "x2");
        TestUtils.assertObjectEquals("{}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleBean_nullColumn() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", null});
        A in = A.create("x1", "x2");
        TestUtils.assertObjectEquals("{f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleBean_emptyArgs() {
        ViewArgs sa = new ViewArgs(new String[0]);
        A in = A.create("x1", "x2");
        TestUtils.assertObjectEquals("{}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleBeanMap() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        BeanMap in = this.bs.toBeanMap((Object)A.create("x1", "x2"));
        TestUtils.assertObjectEquals("{f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleMap() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        AMap in = AMap.create().append((Object)"f1", (Object)"x1").append((Object)"f2", (Object)"x2");
        TestUtils.assertObjectEquals("{f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleMap_reverseColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f2", "f1"});
        AMap in = AMap.create().append((Object)"f1", (Object)"x1").append((Object)"f2", (Object)"x2");
        TestUtils.assertObjectEquals("{f2:'x2',f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleMap_nonExistentColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"fx"});
        AMap in = AMap.create().append((Object)"f1", (Object)"x1").append((Object)"f2", (Object)"x2");
        TestUtils.assertObjectEquals("{}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleMap_nullColumn() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", null});
        AMap in = AMap.create().append((Object)"f1", (Object)"x1").append((Object)"f2", (Object)"x2");
        TestUtils.assertObjectEquals("{f1:'x1'}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void simpleMap_emptyView() {
        ViewArgs sa = new ViewArgs(new String[0]);
        AMap in = AMap.create().append((Object)"f1", (Object)"x1").append((Object)"f2", (Object)"x2");
        TestUtils.assertObjectEquals("{}", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        A[] in = new A[]{A.create("x1", "x2")};
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_reverseColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f2", "f1"});
        A[] in = new A[]{A.create("x1", "x2")};
        TestUtils.assertObjectEquals("[{f2:'x2',f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_dupColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", "f1"});
        A[] in = new A[]{A.create("x1", "x2")};
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_nonExistentColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"fx"});
        A[] in = new A[]{A.create("x1", "x2")};
        TestUtils.assertObjectEquals("[{}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_nullColumn() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", null});
        A[] in = new A[]{A.create("x1", "x2")};
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_emptyArgs() {
        ViewArgs sa = new ViewArgs(new String[0]);
        A[] in = new A[]{A.create("x1", "x2")};
        TestUtils.assertObjectEquals("[{}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_withNull() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        A[] in = new A[]{A.create("x1", "x2"), null};
        TestUtils.assertObjectEquals("[{f1:'x1'},null]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_reverseColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f2", "f1"});
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f2:'x2',f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_dupColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", "f1"});
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_nonExistentColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"fx"});
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_nullColumn() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", null});
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_emptyArgs() {
        ViewArgs sa = new ViewArgs(new String[0]);
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_withNull() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        AList in = AList.create((Object[])new A[]{A.create("x1", "x2"), null});
        TestUtils.assertObjectEquals("[{f1:'x1'},null]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet_reverseColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f2", "f1"});
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f2:'x2',f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet_dupColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", "f1"});
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet_nonExistentColumns() {
        ViewArgs sa = new ViewArgs(new String[]{"fx"});
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet_nullColumn() {
        ViewArgs sa = new ViewArgs(new String[]{"f1", null});
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet_emptyArgs() {
        ViewArgs sa = new ViewArgs(new String[0]);
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2")});
        TestUtils.assertObjectEquals("[{}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet_withNull() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        ASet in = ASet.create((Object[])new A[]{A.create("x1", "x2"), null});
        TestUtils.assertObjectEquals("[{f1:'x1'},null]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void otherObject() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        String in = "foobar";
        TestUtils.assertObjectEquals("'foobar'", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void mapList() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        AList in = AList.create((Object[])new AMap[]{AMap.create().append((Object)"f1", (Object)"x1").append((Object)"f2", (Object)"x2")});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanMapList() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        AList in = AList.create((Object[])new BeanMap[]{this.bs.toBeanMap((Object)A.create("x1", "x2"))});
        TestUtils.assertObjectEquals("[{f1:'x1'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void otherObjectList() {
        ViewArgs sa = new ViewArgs(new String[]{"f1"});
        AList in = AList.create((Object[])new String[]{"foobar"});
        TestUtils.assertObjectEquals("['foobar']", this.p.run(this.bs, (Object)in, sa));
    }

    public static class A {
        public String f1;
        public String f2;

        public static A create(String f1, String f2) {
            A a = new A();
            a.f1 = f1;
            a.f2 = f2;
            return a;
        }
    }
}

