/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.pojotools.PojoSorter;
import org.apache.juneau.pojotools.SortArgs;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class PojoSorterTest {
    PojoSorter p = new PojoSorter();
    BeanSession bs = BeanContext.DEFAULT.createBeanSession();

    @Test
    public void nullInput() {
        Assert.assertNull((Object)this.p.run(this.bs, null, null));
    }

    @Test
    public void beanArray() {
        A[] in = new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")};
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[{f:'a'},{f:'b'},{f:'c'},{f:'d'},{f:'e'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArray_reverse() {
        A[] in = new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")};
        SortArgs sa = new SortArgs(new String[]{"f-"});
        TestUtils.assertObjectEquals("[{f:'e'},{f:'d'},{f:'c'},{f:'b'},{f:'a'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArrayContainingNulls() {
        A[] in = new A[]{A.create("c"), A.create("a"), null, null, A.create("b")};
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[null,null,{f:'a'},{f:'b'},{f:'c'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanArrayContainingDups() {
        A[] in = new A[]{A.create("c"), A.create("a"), null, A.create("a"), A.create("b")};
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[null,{f:'a'},{f:'a'},{f:'b'},{f:'c'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList() {
        AList in = AList.create((Object[])new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[{f:'a'},{f:'b'},{f:'c'},{f:'d'},{f:'e'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanList_reverse() {
        AList in = AList.create((Object[])new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")});
        SortArgs sa = new SortArgs(new String[]{"f-"});
        TestUtils.assertObjectEquals("[{f:'e'},{f:'d'},{f:'c'},{f:'b'},{f:'a'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanListContainingNull() {
        AList in = AList.create((Object[])new A[]{A.create("c"), A.create("a"), null, null, A.create("b")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[null,null,{f:'a'},{f:'b'},{f:'c'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanListContainingDups() {
        AList in = AList.create((Object[])new A[]{A.create("c"), A.create("a"), null, A.create("a"), A.create("b")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[null,{f:'a'},{f:'a'},{f:'b'},{f:'c'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSet() {
        ASet in = ASet.create((Object[])new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[{f:'a'},{f:'b'},{f:'c'},{f:'d'},{f:'e'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void betSet_reverse() {
        ASet in = ASet.create((Object[])new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")});
        SortArgs sa = new SortArgs(new String[]{"f-"});
        TestUtils.assertObjectEquals("[{f:'e'},{f:'d'},{f:'c'},{f:'b'},{f:'a'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSetContainingNull() {
        ASet in = ASet.create((Object[])new A[]{A.create("c"), A.create("a"), null, null, A.create("b")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[null,{f:'a'},{f:'b'},{f:'c'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void beanSetContainingDups() {
        ASet in = ASet.create((Object[])new A[]{A.create("c"), A.create("a"), null, A.create("a"), A.create("b")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[null,{f:'a'},{f:'a'},{f:'b'},{f:'c'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void emptySort() {
        ASet in = ASet.create((Object[])new A[]{A.create("c"), A.create("a"), A.create("b")});
        SortArgs sa = new SortArgs(new String[0]);
        TestUtils.assertObjectEquals("[{f:'c'},{f:'a'},{f:'b'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void invalidDataType() {
        Object in = AMap.create((Object)"a", (Object)"b");
        SortArgs sa = new SortArgs(new String[]{"x"});
        in = this.p.run(this.bs, in, sa);
        TestUtils.assertObjectEquals("{a:'b'}", in);
    }

    @Test
    public void listOfMaps() {
        AList in = AList.create((Object[])new AMap[]{AMap.create((Object)"f", (Object)"c"), AMap.create((Object)"f", (Object)"a"), AMap.create((Object)"f", (Object)"b"), AMap.create((Object)"f", (Object)"e"), AMap.create((Object)"f", (Object)"d")});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[{f:'a'},{f:'b'},{f:'c'},{f:'d'},{f:'e'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void listOfMaps_reverse() {
        AList in = AList.create((Object[])new AMap[]{AMap.create((Object)"f", (Object)"c"), AMap.create((Object)"f", (Object)"a"), AMap.create((Object)"f", (Object)"b"), AMap.create((Object)"f", (Object)"e"), AMap.create((Object)"f", (Object)"d")});
        SortArgs sa = new SortArgs(new String[]{"f-"});
        TestUtils.assertObjectEquals("[{f:'e'},{f:'d'},{f:'c'},{f:'b'},{f:'a'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void listOfOther() {
        AList in = AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"c"}), AList.create((Object[])new String[]{"a"}), AList.create((Object[])new String[]{"b"})});
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[['c'],['a'],['b']]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void listOfOther_reverse() {
        AList in = AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"c"}), AList.create((Object[])new String[]{"a"}), AList.create((Object[])new String[]{"b"})});
        SortArgs sa = new SortArgs(new String[]{"f-"});
        TestUtils.assertObjectEquals("[['c'],['a'],['b']]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void nonExistentField() {
        A[] in = new A[]{A.create("c"), A.create("a"), A.create("b"), A.create("e"), A.create("d")};
        SortArgs sa = new SortArgs(new String[]{"fx"});
        TestUtils.assertObjectEquals("[{f:'c'},{f:'a'},{f:'b'},{f:'e'},{f:'d'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void mixtureOfTypes() {
        B[] in = new B[]{B.create(1), B.create(true), B.create("a")};
        SortArgs sa = new SortArgs(new String[]{"f"});
        TestUtils.assertObjectEquals("[{f:1},{f:true},{f:'a'}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void sortMultipleColumns() {
        C[] in = new C[]{C.create(1, 1.0f), C.create(3, 2.0f), C.create(3, 1.0f), C.create(2, 1.0f), C.create(2, 2.0f)};
        SortArgs sa = new SortArgs(new String[]{"f1", "f2"});
        TestUtils.assertObjectEquals("[{f1:1,f2:1.0},{f1:2,f2:1.0},{f1:2,f2:2.0},{f1:3,f2:1.0},{f1:3,f2:2.0}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void sortMultipleColumns_descending() {
        C[] in = new C[]{C.create(1, 1.0f), C.create(3, 2.0f), C.create(3, 1.0f), C.create(2, 1.0f), C.create(2, 2.0f)};
        SortArgs sa = new SortArgs(new String[]{"f1-", "f2-"});
        TestUtils.assertObjectEquals("[{f1:3,f2:2.0},{f1:3,f2:1.0},{f1:2,f2:2.0},{f1:2,f2:1.0},{f1:1,f2:1.0}]", this.p.run(this.bs, (Object)in, sa));
    }

    @Test
    public void sortMultipleColumns_ascendingAndDescending() {
        C[] in = new C[]{C.create(1, 1.0f), C.create(3, 2.0f), C.create(3, 1.0f), C.create(2, 1.0f), C.create(2, 2.0f)};
        SortArgs sa = new SortArgs(new String[]{"f1-", "f2+"});
        TestUtils.assertObjectEquals("[{f1:3,f2:1.0},{f1:3,f2:2.0},{f1:2,f2:1.0},{f1:2,f2:2.0},{f1:1,f2:1.0}]", this.p.run(this.bs, (Object)in, sa));
    }

    public static class C {
        public int f1;
        public float f2;

        public static C create(int f1, float f2) {
            C c = new C();
            c.f1 = f1;
            c.f2 = f2;
            return c;
        }
    }

    public static class B {
        public Object f;

        public static B create(Object f) {
            B b = new B();
            b.f = f;
            return b;
        }
    }

    public static class A {
        public String f;

        public static A create(String f) {
            A a = new A();
            a.f = f;
            return a;
        }
    }
}

