/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.pojotools.PatternException;
import org.apache.juneau.pojotools.PojoSearcher;
import org.apache.juneau.pojotools.SearchArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class PojoSearcherTest {
    private static BeanSession bs = BeanContext.DEFAULT.createSession();
    private static PojoSearcher ps = PojoSearcher.DEFAULT;
    private static WriterSerializer ws = JsonSerializer.create().ssq().pojoSwaps(new Class[]{TemporalCalendarSwap.IsoLocalDateTime.class}).build();
    public static List<A> A_LIST = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz"), A.create("q ux"), A.create("qu'ux"), null, A.create(null)});
    public static Set<A> A_SET = ASet.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz"), A.create("q ux"), A.create("qu'ux"), null, A.create(null)});
    public static A[] A_ARRAY = new A[]{A.create("foo"), A.create("bar"), A.create("baz"), A.create("q ux"), A.create("qu'ux"), null, A.create(null)};
    C[] INT_BEAN_ARRAY = new C[]{C.create(-2), C.create(-1), C.create(0), C.create(1), C.create(2), C.create(3)};

    static SearchArgs[] create(String ... search) {
        SearchArgs[] sa = new SearchArgs[search.length];
        for (int i = 0; i < search.length; ++i) {
            sa[i] = new SearchArgs(search[i]);
        }
        return sa;
    }

    static SearchArgs create(String search) {
        return new SearchArgs(search);
    }

    static Object run(Object in, String search) {
        return ps.run(bs, in, PojoSearcherTest.create(search));
    }

    static Object run(Object in, SearchArgs sa) {
        return ps.run(bs, in, sa);
    }

    static String[] a(String ... s) {
        return s;
    }

    @Test
    public void stringSearch_singleWord() throws Exception {
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run(A_LIST, "f=foo"));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run(A_SET, "f=foo"));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=foo"));
    }

    @Test
    public void stringSearch_pattern1() throws Exception {
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run(A_LIST, "f=fo*"));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run(A_SET, "f=fo*"));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=fo*"));
    }

    @Test
    public void stringSearch_pattern2() throws Exception {
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run(A_LIST, "f=*ar"));
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run(A_SET, "f=*ar"));
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=*ar"));
    }

    @Test
    public void stringSearch_pattern3() throws Exception {
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run(A_LIST, "f=?ar"));
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run(A_SET, "f=?ar"));
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=?ar"));
    }

    @Test
    public void stringSearch_multiple() throws Exception {
        TestUtils.assertObjectEquals("[{f:'foo'},{f:'bar'}]", PojoSearcherTest.run(A_LIST, "f=foo bar q ux"));
        TestUtils.assertObjectEquals("[{f:'foo'},{f:'bar'}]", PojoSearcherTest.run(A_SET, "f=foo bar q ux"));
        TestUtils.assertObjectEquals("[{f:'foo'},{f:'bar'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=foo bar q ux"));
    }

    @Test
    public void stringSearch_quoted() throws Exception {
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run(A_LIST, "f='q ux'"));
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run(A_SET, "f='q ux'"));
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run((Object)A_ARRAY, "f='q ux'"));
    }

    @Test
    public void stringSearch_quotedWithPattern() throws Exception {
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run(A_LIST, "f='q *x'"));
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run(A_SET, "f='q *x'"));
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run((Object)A_ARRAY, "f='q *x'"));
    }

    @Test
    public void stringSearch_unquotedContainingQuote() throws Exception {
        TestUtils.assertObjectEquals("[{f:'qu\\'ux'}]", PojoSearcherTest.run(A_LIST, "f=qu'ux"));
        TestUtils.assertObjectEquals("[{f:'qu\\'ux'}]", PojoSearcherTest.run(A_SET, "f=qu'ux"));
        TestUtils.assertObjectEquals("[{f:'qu\\'ux'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=qu'ux"));
    }

    @Test
    public void stringSearch_quotedContainingQuote() throws Exception {
        TestUtils.assertObjectEquals("[{f:'qu\\'ux'}]", PojoSearcherTest.run(A_LIST, "f='qu\\'ux'"));
        TestUtils.assertObjectEquals("[{f:'qu\\'ux'}]", PojoSearcherTest.run(A_SET, "f='qu\\'ux'"));
        TestUtils.assertObjectEquals("[{f:'qu\\'ux'}]", PojoSearcherTest.run((Object)A_ARRAY, "f='qu\\'ux'"));
    }

    @Test
    public void stringSearch_regExp() throws Exception {
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run(A_LIST, "f=/q\\sux/"));
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run(A_SET, "f=/q\\sux/"));
        TestUtils.assertObjectEquals("[{f:'q ux'}]", PojoSearcherTest.run((Object)A_ARRAY, "f=/q\\sux/"));
    }

    @Test
    public void stringSearch_regExp_noEndSlash() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("/foo"), A.create("bar")});
        for (String s : PojoSearcherTest.a("f=/foo", "f='/foo'")) {
            TestUtils.assertObjectEquals("[{f:'/foo'}]", PojoSearcherTest.run((Object)in, s));
        }
    }

    @Test
    public void stringSearch_regExp_onlySlash() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("/"), A.create("bar")});
        for (String s : PojoSearcherTest.a("f=/", "f='/'")) {
            TestUtils.assertObjectEquals("[{f:'/'}]", PojoSearcherTest.run((Object)in, s));
        }
    }

    @Test
    public void stringSearch_or_pattern() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'foo'},{f:'bar'}]", PojoSearcherTest.run((Object)in, "f=f* *r"));
        TestUtils.assertObjectEquals("[]", PojoSearcherTest.run((Object)in, "f='f* *r'"));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f='f*oo'"));
    }

    @Test
    public void stringSearch_explicit_or_pattern() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'foo'},{f:'bar'}]", PojoSearcherTest.run((Object)in, "f=^f* ^*r"));
        TestUtils.assertObjectEquals("[]", PojoSearcherTest.run((Object)in, "f=^'f* *r'"));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=^'f*oo'"));
    }

    @Test
    public void stringSearch_and_pattern() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run((Object)in, "f=+b* +*r"));
        TestUtils.assertObjectEquals("[{f:'bar'}]", PojoSearcherTest.run((Object)in, "f=+'b*' +'*r'"));
    }

    @Test
    public void stringSearch_not_pattern() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'baz'}]", PojoSearcherTest.run((Object)in, "f=b* -*r"));
        TestUtils.assertObjectEquals("[{f:'baz'}]", PojoSearcherTest.run((Object)in, "f=+'b*' -'*r'"));
    }

    @Test
    public void stringSearch_caseSensitive() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[]", PojoSearcherTest.run((Object)in, "f=F*"));
        TestUtils.assertObjectEquals("[]", PojoSearcherTest.run((Object)in, "f=\"F*\""));
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f='F*'"));
    }

    @Test
    public void stringSearch_malformedQuotes() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("'foo"), A.create("\"bar"), A.create("baz")});
        try {
            PojoSearcherTest.run((Object)in, "f='*");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Unmatched string quotes"));
        }
        try {
            PojoSearcherTest.run((Object)in, "f=\"*");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Unmatched string quotes"));
        }
        TestUtils.assertObjectEquals("[{f:'\\'foo'}]", PojoSearcherTest.run((Object)in, "f='\\'*'"));
        TestUtils.assertObjectEquals("[{f:'\"bar'}]", PojoSearcherTest.run((Object)in, "f='\"*'"));
        TestUtils.assertObjectEquals("[{f:'\"bar'}]", PojoSearcherTest.run((Object)in, "f=\"\\\"*\""));
    }

    @Test
    public void stringSearch_regexChars() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("+\\[]{}()^$."), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'+\\\\[]{}()^$.'}]", PojoSearcherTest.run((Object)in, "f=*+*"));
        TestUtils.assertObjectEquals("[{f:'+\\\\[]{}()^$.'}]", PojoSearcherTest.run((Object)in, "f='+\\\\[]{}()^$.'"));
        TestUtils.assertObjectEquals("[{f:'+\\\\[]{}()^$.'}]", PojoSearcherTest.run((Object)in, "f=++\\\\[]{}()^$."));
    }

    @Test
    public void stringSearch_metaChars() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("*?\\'\""), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'*?\\\\\\'\"'}]", PojoSearcherTest.run((Object)in, "f='\\*\\?\\\\\\'\"'"));
    }

    @Test
    public void stringSearch_metaChars_escapedQuotes() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("'"), A.create("\""), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'\\''}]", PojoSearcherTest.run((Object)in, "f=\\'"));
        TestUtils.assertObjectEquals("[{f:'\"'}]", PojoSearcherTest.run((Object)in, "f=\\\""));
    }

    @Test
    public void stringSearch_metaChars_falseEscape() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), A.create("baz")});
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=\\f\\o\\o"));
    }

    @Test
    public void intSearch_oneNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f=1", "f = 1")) {
            TestUtils.assertObjectEquals("[{f:1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_twoNumbers() throws Exception {
        for (String s : PojoSearcherTest.a("f=1 2", "f = 1  2 ")) {
            TestUtils.assertObjectEquals("[{f:1},{f:2}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_oneNegativeNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f=-1", "f = -1 ")) {
            TestUtils.assertObjectEquals("[{f:-1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_twoNegativeNumbers() throws Exception {
        TestUtils.assertObjectEquals("[{f:-2},{f:-1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f=-1 -2"));
    }

    @Test
    public void intSearch_simpleRange() throws Exception {
        for (String s : PojoSearcherTest.a("f=1-2", "f = 1 - 2 ", "f = 1- 2 ")) {
            TestUtils.assertObjectEquals("[{f:1},{f:2}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_simpleRange_invalid() throws Exception {
        TestUtils.assertObjectEquals("[]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f=2-1"));
    }

    @Test
    public void intSearch_twoNumbersThatLookLikeRange() throws Exception {
        TestUtils.assertObjectEquals("[{f:-2},{f:1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = 1 -2 "));
    }

    @Test
    public void intSearch_rangeWithNegativeNumbers() throws Exception {
        TestUtils.assertObjectEquals("[{f:-2},{f:-1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = -2--1 "));
    }

    @Test
    public void intSearch_rangeWithNegativeNumbers_invalidRange() throws Exception {
        TestUtils.assertObjectEquals("[]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = -1--2 "));
    }

    @Test
    public void intSearch_multipleRanges() throws Exception {
        TestUtils.assertObjectEquals("[{f:0},{f:1},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = 0-1 3-4"));
    }

    @Test
    public void intSearch_overlappingRanges() throws Exception {
        TestUtils.assertObjectEquals("[{f:0},{f:2}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = 0-0 2-2"));
    }

    @Test
    public void intSearch_LT() throws Exception {
        for (String s : PojoSearcherTest.a("f = <0", "f<0", "f = < 0 ", "f < 0 ")) {
            TestUtils.assertObjectEquals("[{f:-2},{f:-1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_LT_negativeNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f = <-1", "f<-1", "f = < -1 ", "f < -1 ")) {
            TestUtils.assertObjectEquals("[{f:-2}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_GT() throws Exception {
        for (String s : PojoSearcherTest.a("f = >1", "f>1", "f = > 1 ", "f > 1 ")) {
            TestUtils.assertObjectEquals("[{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_GT_negativeNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f = >-1", "f>-1", "f = > -1 ", "f > -1 ", "f =  >  -1  ", "f >  -1  ")) {
            TestUtils.assertObjectEquals("[{f:0},{f:1},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_LTE() throws Exception {
        for (String s : PojoSearcherTest.a("f = <=0", "f<=0", "f = <= 0 ", "f <= 0 ", "f =  <=  0  ")) {
            TestUtils.assertObjectEquals("[{f:-2},{f:-1},{f:0}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_LTE_negativeNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f = <=-1", "f <=-1", "f = <= -1 ", "f =  <=  -1  ", "f <=  -1  ")) {
            TestUtils.assertObjectEquals("[{f:-2},{f:-1}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_GTE() throws Exception {
        for (String s : PojoSearcherTest.a("f = >=1", "f >=1", "f = >= 1 ", "f >= 1 ", "f =  >=  1  ")) {
            TestUtils.assertObjectEquals("[{f:1},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_GTE_negativeNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f = >=-1", "f >=-1", "f = >= -1 ", "f >= -1 ", "f =  >=  -1  ")) {
            TestUtils.assertObjectEquals("[{f:-1},{f:0},{f:1},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_not_singleNumber() throws Exception {
        for (String s : PojoSearcherTest.a("f = !1", "f = ! 1 ", "f =  !  1  ")) {
            TestUtils.assertObjectEquals("[{f:-2},{f:-1},{f:0},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_not_range() throws Exception {
        TestUtils.assertObjectEquals("[{f:-2},{f:-1},{f:0},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = !1-2"));
    }

    @Test
    public void intSearch_not_range_negativeNumbers() throws Exception {
        for (String s : PojoSearcherTest.a("f = !-2--1", "f = ! -2 - -1", "f =  !  -2  -  -1 ")) {
            TestUtils.assertObjectEquals("[{f:0},{f:1},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_not_looksLikeRange() throws Exception {
        TestUtils.assertObjectEquals("[{f:-2},{f:-1},{f:0},{f:1},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, "f = ! -2 -2"));
    }

    @Test
    public void intSearch_empty() throws Exception {
        for (String s : PojoSearcherTest.a("f=", "f = ", "f =  ")) {
            TestUtils.assertObjectEquals("[{f:-2},{f:-1},{f:0},{f:1},{f:2},{f:3}]", PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, s));
        }
    }

    @Test
    public void intSearch_badSearches() throws Exception {
        String[] ss = new String[]{"f=x", "(S01)", "f=>x", "(S02)", "f=<x", "(S03)", "f=>=x", "(S04)", "f=>= x", "(S05)", "f=1x", "(S06)", "f=1 x", "(S07)", "f=1-x", "(S08)", "f=1 -x", "(S09)", "f=1 - x", "(S10)", "f=1 - 1x", "(S11)", "f=>", "(ES02)", "f=<", "(ES03)", "f=>=", "(ES04)", "f=123-", "(ES08)", "f=123 -", "(ES09)"};
        for (int i = 0; i < ss.length; i += 2) {
            try {
                PojoSearcherTest.run((Object)this.INT_BEAN_ARRAY, ss[i]);
                Assert.fail((String)("i=" + i));
                continue;
            }
            catch (PatternException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().contains(ss[i + 1]));
            }
        }
    }

    @Test
    public void dateSearch_singleDate_y() throws Exception {
        B[] in = B.create("2010-01-01", "2011-01-01", "2011-01-31", "2012-01-01");
        for (String s : PojoSearcherTest.a("f=2011", "f = 2011 ", "f = '2011' ", "f = \"2011\" ")) {
            TestUtils.assertObjectEquals("[{f:'2011-01-01T00:00:00'},{f:'2011-01-31T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_singleDate_ym() throws Exception {
        B[] in = B.create("2010-01-01", "2011-01-01", "2011-01-31", "2012-01-01");
        for (String s : PojoSearcherTest.a("f=2011-01", "f = 2011-01 ", "f='2011-01'", "f=\"2011-01\"")) {
            TestUtils.assertObjectEquals("[{f:'2011-01-01T00:00:00'},{f:'2011-01-31T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_singleDate_ymd() throws Exception {
        B[] in = B.create("2010-01-01", "2011-01-01", "2011-01-31", "2012-01-01");
        TestUtils.assertObjectEquals("[{f:'2011-01-01T00:00:00'}]", PojoSearcherTest.run((Object)in, "f=2011-01-01"), ws);
    }

    @Test
    public void dateSearch_singleDate_ymdh() throws Exception {
        B[] in = B.create("2011-01-01T11:15:59", "2011-01-01T12:00:00", "2011-01-01T12:59:59", "2011-01-01T13:00:00");
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:00:00'},{f:'2011-01-01T12:59:59'}]", PojoSearcherTest.run((Object)in, "f=2011-01-01T12"), ws);
    }

    @Test
    public void dateSearch_singleDate_ymdhm() throws Exception {
        B[] in = B.create("2011-01-01T12:29:59", "2011-01-01T12:30:00", "2011-01-01T12:30:59", "2011-01-01T12:31:00");
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:30:00'},{f:'2011-01-01T12:30:59'}]", PojoSearcherTest.run((Object)in, "f=2011-01-01T12:30"), ws);
    }

    @Test
    public void dateSearch_singleDate_ymdhms() throws Exception {
        B[] in = B.create("2011-01-01T12:30:29", "2011-01-01T12:30:30", "2011-01-01T12:30:31");
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:30:30'}]", PojoSearcherTest.run((Object)in, "f=2011-01-01T12:30:30"), ws);
    }

    @Test
    public void dateSearch_openEndedRanges_y() throws Exception {
        B[] in = B.create("2000-12-31", "2001-01-01");
        for (String s : PojoSearcherTest.a("f>2000", "f > 2000 ", "f>'2000'", "f > '2000' ", "f>\"2000\"", "f > \"2000\" ", "f>=2001", "f >= 2001 ", "f>='2001'", "f >= '2001' ", "f>=\"2001\"", "f >= \"2001\" ")) {
            TestUtils.assertObjectEquals("[{f:'2001-01-01T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
        for (String s : PojoSearcherTest.a("f<2001", "f < 2001 ", "f<'2001'", "f < '2001'", "f<\"2001\"", "f < \"2001\" ", "f<=2000", "f <= 2000 ", "f<='2000'", "f <= '2000'", "f<=\"2000\"", "f <= \"2000\" ")) {
            TestUtils.assertObjectEquals("[{f:'2000-12-31T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_openEndedRanges_toMinute() throws Exception {
        B[] in = B.create("2011-01-01T12:29:59", "2011-01-01T12:30:00");
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:30:00'}]", PojoSearcherTest.run((Object)in, "f>=2011-01-01T12:30"), ws);
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:29:59'}]", PojoSearcherTest.run((Object)in, "f<2011-01-01T12:30"), ws);
    }

    @Test
    public void dateSearch_openEndedRanges_toSecond() throws Exception {
        B[] in = B.create("2011-01-01T12:30:59", "2011-01-01T12:31:00");
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:31:00'}]", PojoSearcherTest.run((Object)in, "f>2011-01-01T12:30"), ws);
        TestUtils.assertObjectEquals("[{f:'2011-01-01T12:30:59'}]", PojoSearcherTest.run((Object)in, "f<=2011-01-01T12:30"), ws);
    }

    @Test
    public void dateSearch_closedRanges() throws Exception {
        B[] in = B.create("2000-12-31T23:59:59", "2001-01-01T00:00:00", "2003-06-30T23:59:59", "2003-07-01T00:00:00");
        for (String s : PojoSearcherTest.a("f= 2001 - 2003-06-30 ", "f= 2001 - 2003-06-30", "f='2001'-'2003-06-30'", "f= '2001' - '2003-06-30' ", "f=\"2001\"-\"2003-06-30\"", "f= \"2001\" - \"2003-06-30\" ", "f=2001 -'2003-06-30'", "f= 2001 - '2003-06-30' ", "f=2001 -\"2003-06-30\"", "f= 2001 - \"2003-06-30\" ")) {
            TestUtils.assertObjectEquals("[{f:'2001-01-01T00:00:00'},{f:'2003-06-30T23:59:59'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
        for (String s : PojoSearcherTest.a("f= 2001 - 2003-06-30 2000", "f= 2001 - 2003-06-30 '2000'", "f= 2001 - 2003-06-30 \"2000\"", "f='2001'-'2003-06-30' 2000", "f='2001'-'2003-06-30' '2000'", "f='2001'-'2003-06-30' \"2000\"", "f= '2001' - '2003-06-30'  2000", "f= '2001' - '2003-06-30'  '2000'", "f= '2001' - '2003-06-30'  \"2000\"", "f=\"2001\"-\"2003-06-30\" 2000", "f=\"2001\"-\"2003-06-30\" '2000'", "f=\"2001\"-\"2003-06-30\" \"2000\"", "f= \"2001\" - \"2003-06-30\"  2000", "f= \"2001\" - \"2003-06-30\"  '2000'", "f= \"2001\" - \"2003-06-30\"  \"2000\"", "f= 2001 - '2003-06-30'  2000", "f= 2001 - '2003-06-30'  '2000'", "f= 2001 - '2003-06-30'  \"2000\"", "f= 2001 - \"2003-06-30\"  2000", "f= 2001 - \"2003-06-30\"  '2000'", "f= 2001 - \"2003-06-30\"  \"2000\"")) {
            TestUtils.assertObjectEquals("[{f:'2000-12-31T23:59:59'},{f:'2001-01-01T00:00:00'},{f:'2003-06-30T23:59:59'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_or1() throws Exception {
        B[] in = B.create("2000-12-31", "2001-01-01", "2001-12-31", "2002-01-01");
        for (String s : PojoSearcherTest.a("f=2001 2003 2005", "f= 2001  2003  2005 ", "f='2001' '2003' '2005'", "f= '2001'  '2003'  '2005' ", "f=\"2001\" \"2003\" \"2005\"", "f= \"2001\"  \"2003\"  \"2005\" ")) {
            TestUtils.assertObjectEquals("[{f:'2001-01-01T00:00:00'},{f:'2001-12-31T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_or2() throws Exception {
        B[] in = B.create("2002-12-31", "2003-01-01", "2003-12-31", "2004-01-01");
        for (String s : PojoSearcherTest.a("f=2001 2003 2005", "f= 2001  2003  2005 ", "f='2001' '2003' '2005'", "f= '2001'  '2003'  '2005' ", "f=\"2001\" \"2003\" \"2005\"", "f= \"2001\"  \"2003\"  \"2005\" ")) {
            TestUtils.assertObjectEquals("[{f:'2003-01-01T00:00:00'},{f:'2003-12-31T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_or3() throws Exception {
        B[] in = B.create("2004-12-31", "2005-01-01", "2005-12-31", "2006-01-01");
        for (String s : PojoSearcherTest.a("f=2001 2003 2005", "f= 2001  2003  2005 ", "f='2001' '2003' '2005'", "f= '2001'  '2003'  '2005' ", "f=\"2001\" \"2003\" \"2005\"", "f= \"2001\"  \"2003\"  \"2005\" ")) {
            TestUtils.assertObjectEquals("[{f:'2005-01-01T00:00:00'},{f:'2005-12-31T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_or_singleAndRange() throws Exception {
        B[] in = B.create("2000-12-31", "2001-01-01", "2002-12-31", "2003-01-01");
        for (String s : PojoSearcherTest.a("f=2001 >2002", "f= 2001   >2002 ", "f='2001' >'2002'", "f= '2001'  >'2002' ", "f=\"2001\" >\"2002\"", "f= \"2001\"  >\"2002\" ", "f=>2002 2001", "f= >2002  2001 ", "f=>'2002' '2001'", "f= >'2002'  '2001' ", "f=>\"2002\" \"2001\"", "f= >\"2002\"  \"2001\" ", "f=2001 >=2003", "f= 2001  >=2003 ", "f='2001' >='2003'", "f= '2001'  >='2003' ", "f=\"2001\" >=\"2003\"", "f= \"2001\"  >=\"2003\" ", "f=>=2003 2001", "f= >=2003  2001 ", "f=>='2003' '2001'", "f= >='2003'  '2001' ", "f=>=\"2003\" \"2001\"", "f= >=\"2003\"  \"2001\" ")) {
            TestUtils.assertObjectEquals("[{f:'2001-01-01T00:00:00'},{f:'2003-01-01T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
        for (String s : PojoSearcherTest.a("f=<2001 2003", "f= <2001  2003 ", "f=<'2001' '2003'", "f= <'2001'  '2003' ", "f=<\"2001\" \"2003\"", "f= <\"2001\"  \"2003\" ", "f=2003 <2001", "f= 2003  <2001 ", "f='2003' <'2001'", "f= '2003'  <'2001' ", "f=\"2003\" <\"2001\"", "f= \"2003\"  <\"2001\" ", "f=<=2000 2003", "f= <=2000  2003 ", "f=<='2000' '2003'", "f= <='2000'  '2003' ", "f=<=\"2000\" \"2003\"", "f= <=\"2000\"  \"2003\" ", "f=2003 <=2000", "f= 2003  <=2000 ", "f='2003' <='2000'", "f= '2003'  <='2000' ", "f=\"2003\" <=\"2000\"", "f= \"2003\"  <=\"2000\" ")) {
            TestUtils.assertObjectEquals("[{f:'2000-12-31T00:00:00'},{f:'2003-01-01T00:00:00'}]", PojoSearcherTest.run((Object)in, s), ws);
        }
    }

    @Test
    public void dateSearch_badSearches() throws Exception {
        B[] in = B.create("2000-12-31");
        String[] ss = new String[]{"f=X", "(S01)", "f=>X", "(S02)", "f=<X", "(S03)", "f=>=X", "(S04)", "f='1'X", "(S07)", "f=2000 X", "(S09)", "f=2000-X", "(S10)", "f=>", "(ES02)", "f=<", "(ES03)", "f=>=", "(ES04)", "f='", "(ES05)", "f=\"", "(ES06)", "f=2000-", "(ES10)", "f=2000-'", "(ES11)", "f=2000-\"", "(ES12)"};
        for (int i = 0; i < ss.length; i += 2) {
            try {
                PojoSearcherTest.run((Object)in, ss[i]);
                continue;
            }
            catch (PatternException e) {
                Assert.assertTrue((String)("[" + e.getLocalizedMessage() + "]!=[" + ss[i] + "]"), (boolean)e.getLocalizedMessage().contains(ss[i + 1]));
            }
        }
    }

    @Test
    public void d2ListOfMaps() throws Exception {
        AList in = AList.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"foo"), AMap.create((Object)"f", (Object)"bar"), null, AMap.create(null, (Object)"qux"), AMap.create((Object)"quux", null), AMap.create(null, null)});
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2SetOfMaps() throws Exception {
        ASet in = ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"foo"), AMap.create((Object)"f", (Object)"bar"), null, AMap.create(null, (Object)"qux"), AMap.create((Object)"quux", null), AMap.create(null, null)});
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2ArrayOfMaps() throws Exception {
        Map[] in = new Map[]{AMap.create((Object)"f", (Object)"foo"), AMap.create((Object)"f", (Object)"bar"), null, AMap.create(null, (Object)"qux"), AMap.create((Object)"quux", null), AMap.create(null, null)};
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2ListOfObjects() throws Exception {
        AList in = AList.create((Object[])new Object[]{AMap.create((Object)"f", (Object)"foo"), AMap.create((Object)"f", (Object)"bar"), null, AMap.create(null, (Object)"qux"), AMap.create((Object)"quux", null), AMap.create(null, null), "xxx", 123});
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2SetOfObjects() throws Exception {
        ASet in = ASet.create((Object[])new Object[]{AMap.create((Object)"f", (Object)"foo"), AMap.create((Object)"f", (Object)"bar"), null, AMap.create(null, (Object)"qux"), AMap.create((Object)"quux", null), AMap.create(null, null), "xxx", 123});
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2ArrayOfObjects() throws Exception {
        Object[] in = new Object[]{AMap.create((Object)"f", (Object)"foo"), AMap.create((Object)"f", (Object)"bar"), null, AMap.create(null, (Object)"qux"), AMap.create((Object)"quux", null), AMap.create(null, null), "xxx", 123};
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2ListOfMapsWithLists() throws Exception {
        AList in = AList.create((Object[])new Map[]{AMap.create((Object)"f", (Object)AList.create((Object[])new String[]{"foo"})), AMap.create((Object)"f", (Object)AList.create((Object[])new String[]{"bar"})), null, AMap.create(null, (Object)AList.create((Object[])new String[]{"qux"})), AMap.create((Object)"quux", (Object)AList.create((Object[])new Object[]{null})), AMap.create(null, (Object)AList.create((Object[])new Object[]{null}))});
        TestUtils.assertObjectEquals("[{f:['foo']}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2SetOfMapsWithSets() throws Exception {
        ASet in = ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)ASet.create((Object[])new String[]{"foo"})), AMap.create((Object)"f", (Object)ASet.create((Object[])new String[]{"bar"})), null, AMap.create(null, (Object)ASet.create((Object[])new String[]{"qux"})), AMap.create((Object)"quux", (Object)ASet.create((Object[])new Object[]{null})), AMap.create(null, (Object)ASet.create((Object[])new Object[]{null}))});
        TestUtils.assertObjectEquals("[{f:['foo']}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2ArrayOfMapsWithArrays() throws Exception {
        Map[] in = new Map[]{AMap.create((Object)"f", (Object)new Object[]{"foo"}), AMap.create((Object)"f", (Object)new Object[]{"bar"}), null, AMap.create(null, (Object)new Object[]{"qux"}), AMap.create((Object)"quux", (Object)new Object[]{null}), AMap.create(null, (Object)new Object[]{null})};
        TestUtils.assertObjectEquals("[{f:['foo']}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d2ListOfBeans() throws Exception {
        AList in = AList.create((Object[])new A[]{A.create("foo"), A.create("bar"), null, A.create(null)});
        TestUtils.assertObjectEquals("[{f:'foo'}]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ListOfListOfMaps() throws Exception {
        AList in = AList.create((Object[])new List[]{AList.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"foo")}), AList.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"bar")}), AList.create((Object[])new Map[]{null}), AList.create((Object[])new Map[]{AMap.create(null, (Object)"qux")}), AList.create((Object[])new Map[]{AMap.create((Object)"quux", null)}), AList.create((Object[])new Map[]{AMap.create(null, null)}), null});
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3SetOfSetOfMaps() throws Exception {
        ASet in = ASet.create((Object[])new Set[]{ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"foo")}), ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"bar")}), ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)"baz")}), ASet.create((Object[])new Map[]{null}), ASet.create((Object[])new Map[]{AMap.create(null, (Object)"qux")}), ASet.create((Object[])new Map[]{AMap.create((Object)"quux", null)}), ASet.create((Object[])new Map[]{AMap.create(null, null)}), null});
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ArrayOfArrayOfMaps() throws Exception {
        Map[][] in = new Map[][]{{AMap.create((Object)"f", (Object)"foo")}, {AMap.create((Object)"f", (Object)"bar")}, {AMap.create((Object)"f", (Object)"baz")}, {null}, {AMap.create(null, (Object)"qux")}, {AMap.create((Object)"quux", null)}, {AMap.create(null, null)}, null};
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ListOfListOfObjects() throws Exception {
        AList in = AList.create((Object[])new List[]{AList.create((Object[])new Object[]{AMap.create((Object)"f", (Object)"foo")}), AList.create((Object[])new Object[]{AMap.create((Object)"f", (Object)"bar")}), AList.create((Object[])new Object[]{null}), AList.create((Object[])new Object[]{AMap.create(null, (Object)"qux")}), AList.create((Object[])new Object[]{AMap.create((Object)"quux", null)}), AList.create((Object[])new Object[]{AMap.create(null, null)}), AList.create((Object[])new Object[]{"xxx"}), AList.create((Object[])new Object[]{123}), null});
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3SetOfSetOfObjects() throws Exception {
        ASet in = ASet.create((Object[])new Set[]{ASet.create((Object[])new Object[]{AMap.create((Object)"f", (Object)"foo")}), ASet.create((Object[])new Object[]{AMap.create((Object)"f", (Object)"bar")}), ASet.create((Object[])new Object[]{null}), ASet.create((Object[])new Object[]{AMap.create(null, (Object)"qux")}), ASet.create((Object[])new Object[]{AMap.create((Object)"quux", null)}), ASet.create((Object[])new Object[]{AMap.create(null, null)}), ASet.create((Object[])new Object[]{"xxx"}), ASet.create((Object[])new Object[]{123}), null});
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ArrayOfArrayOfObjects() throws Exception {
        Object[][] in = new Object[][]{{AMap.create((Object)"f", (Object)"foo")}, {AMap.create((Object)"f", (Object)"bar")}, {null}, {AMap.create(null, (Object)"qux")}, {AMap.create((Object)"quux", null)}, {AMap.create(null, null)}, {"xxx"}, {123}, null};
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ListOfListOfMapsWithCollections() throws Exception {
        AList in = AList.create((Object[])new List[]{AList.create((Object[])new Map[]{AMap.create((Object)"f", (Object)AList.create((Object[])new String[]{"foo"}))}), AList.create((Object[])new Map[]{AMap.create((Object)"f", (Object)AList.create((Object[])new String[]{"bar"}))}), AList.create((Object[])new Map[]{null}), AList.create((Object[])new Map[]{AMap.create(null, (Object)AList.create((Object[])new String[]{"qux"}))}), AList.create((Object[])new Map[]{AMap.create((Object)"quux", (Object)AList.create((Object[])new Object[]{null}))}), AList.create((Object[])new Map[]{AMap.create(null, (Object)AList.create((Object[])new Object[]{null}))}), null});
        TestUtils.assertObjectEquals("[[{f:['foo']}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3SetOfSetOfMapsWithCollections() throws Exception {
        ASet in = ASet.create((Object[])new Set[]{ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)ASet.create((Object[])new String[]{"foo"}))}), ASet.create((Object[])new Map[]{AMap.create((Object)"f", (Object)ASet.create((Object[])new String[]{"bar"}))}), ASet.create((Object[])new Map[]{null}), ASet.create((Object[])new Map[]{AMap.create(null, (Object)ASet.create((Object[])new String[]{"qux"}))}), ASet.create((Object[])new Map[]{AMap.create((Object)"quux", (Object)ASet.create((Object[])new Object[]{null}))}), ASet.create((Object[])new Map[]{AMap.create(null, (Object)ASet.create((Object[])new Object[]{null}))}), null});
        TestUtils.assertObjectEquals("[[{f:['foo']}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ArrayOfArrayOfMapsWithCollections() throws Exception {
        Map[][] in = new Map[][]{{AMap.create((Object)"f", (Object)new Object[]{"foo"})}, {AMap.create((Object)"f", (Object)new Object[]{"bar"})}, {null}, {AMap.create(null, (Object)new Object[]{"qux"})}, {AMap.create((Object)"quux", (Object)new Object[]{null})}, {AMap.create(null, (Object)new Object[]{null})}, null};
        TestUtils.assertObjectEquals("[[{f:['foo']}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    @Test
    public void d3ArrayOfArrayOfBeans() throws Exception {
        A[][] in = new A[][]{{A.create("foo")}, {A.create("bar")}, {null}, {A.create(null)}, null};
        TestUtils.assertObjectEquals("[[{f:'foo'}]]", PojoSearcherTest.run((Object)in, "f=foo"));
    }

    public static class B {
        public Calendar f;

        static B[] create(String ... dates) {
            B[] bb = new B[dates.length];
            for (int i = 0; i < dates.length; ++i) {
                bb[i] = new B();
                bb[i].f = DateUtils.parseISO8601Calendar((String)dates[i]);
            }
            return bb;
        }
    }

    public static class C {
        public int f;

        static C create(int f) {
            C c = new C();
            c.f = f;
            return c;
        }
    }

    public static class A {
        public String f;

        public static A create(String f) {
            A a = new A();
            a.f = f;
            return a;
        }
    }
}

