/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class ParserGroupTest {
    @Test
    public void testParserGroupMatching() throws Exception {
        ParserGroup g = ParserGroup.create().append(new Class[]{Parser1.class, Parser2.class, Parser3.class}).build();
        TestUtils.assertInstanceOf(Parser1.class, g.getParser("text/foo"));
        TestUtils.assertInstanceOf(Parser1.class, g.getParser("text/foo_a"));
        TestUtils.assertInstanceOf(Parser1.class, g.getParser("text/foo_a+xxx"));
        TestUtils.assertInstanceOf(Parser1.class, g.getParser("text/xxx+foo_a"));
        TestUtils.assertInstanceOf(Parser2.class, g.getParser("text/foo+bar"));
        TestUtils.assertInstanceOf(Parser2.class, g.getParser("text/foo+bar_a"));
        TestUtils.assertInstanceOf(Parser2.class, g.getParser("text/bar+foo"));
        TestUtils.assertInstanceOf(Parser2.class, g.getParser("text/bar+foo+xxx"));
        TestUtils.assertInstanceOf(Parser3.class, g.getParser("text/baz"));
        TestUtils.assertInstanceOf(Parser3.class, g.getParser("text/baz_a"));
        TestUtils.assertInstanceOf(Parser3.class, g.getParser("text/baz+yyy"));
        TestUtils.assertInstanceOf(Parser3.class, g.getParser("text/baz_a+yyy"));
        TestUtils.assertInstanceOf(Parser3.class, g.getParser("text/yyy+baz"));
        TestUtils.assertInstanceOf(Parser3.class, g.getParser("text/yyy+baz_a"));
    }

    @Test
    public void testInheritence() throws Exception {
        ParserGroupBuilder gb = null;
        ParserGroup g = null;
        gb = ParserGroup.create().append(new Class[]{P1.class, P2.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['text/1','text/2','text/2a']", g.getSupportedMediaTypes());
        gb = g.builder().append(new Class[]{P3.class, P4.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['text/3','text/4','text/4a','text/1','text/2','text/2a']", g.getSupportedMediaTypes());
        gb = g.builder().append(new Class[]{P5.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['text/5','text/3','text/4','text/4a','text/1','text/2','text/2a']", g.getSupportedMediaTypes());
    }

    public static class P5
    extends JsonParser {
        public P5(PropertyStore ps) {
            super(ps, new String[]{"text/5"});
        }
    }

    public static class P4
    extends JsonParser {
        public P4(PropertyStore ps) {
            super(ps, new String[]{"text/4", "text/4a"});
        }
    }

    public static class P3
    extends JsonParser {
        public P3(PropertyStore ps) {
            super(ps, new String[]{"text/3"});
        }
    }

    public static class P2
    extends JsonParser {
        public P2(PropertyStore ps) {
            super(ps, new String[]{"text/2", "text/2a"});
        }
    }

    public static class P1
    extends JsonParser {
        public P1(PropertyStore ps) {
            super(ps, new String[]{"text/1"});
        }
    }

    public static class Parser3
    extends JsonParser {
        public Parser3(PropertyStore ps) {
            super(ps, new String[]{"text/baz", "text/baz_a"});
        }
    }

    public static class Parser2
    extends JsonParser {
        public Parser2(PropertyStore ps) {
            super(ps, new String[]{"text/foo+bar", "text/foo+bar_a"});
        }
    }

    public static class Parser1
    extends JsonParser {
        public Parser1(PropertyStore ps) {
            super(ps, new String[]{"text/foo", "text/foo_a"});
        }
    }
}

