/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.nio.charset.Charset;
import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackParserSession;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.annotation.ParserConfig;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class ParserConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof AA) {
                return "AA";
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicReaderParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        JsonParserSession x = JsonParser.create().applyAnnotations(al, sr).build().createSession();
        ParserConfigAnnotationTest.check("true", x.isAutoCloseStreams());
        ParserConfigAnnotationTest.check("1", x.getDebugOutputLines());
        ParserConfigAnnotationTest.check("US-ASCII", x.getFileCharset());
        ParserConfigAnnotationTest.check("US-ASCII", x.getStreamCharset());
        ParserConfigAnnotationTest.check("AA", x.getListener());
        ParserConfigAnnotationTest.check("true", x.isStrict());
        ParserConfigAnnotationTest.check("true", x.isTrimStrings());
        ParserConfigAnnotationTest.check("true", x.isUnbuffered());
    }

    @Test
    public void basicInputStreamParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        MsgPackParserSession x = MsgPackParser.create().applyAnnotations(al, sr).build().createSession();
        ParserConfigAnnotationTest.check("true", x.isAutoCloseStreams());
        ParserConfigAnnotationTest.check("HEX", x.getBinaryFormat());
        ParserConfigAnnotationTest.check("1", x.getDebugOutputLines());
        ParserConfigAnnotationTest.check("AA", x.getListener());
        ParserConfigAnnotationTest.check("true", x.isStrict());
        ParserConfigAnnotationTest.check("true", x.isTrimStrings());
        ParserConfigAnnotationTest.check("true", x.isUnbuffered());
    }

    @Test
    public void noValuesReaderParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        JsonParserSession x = JsonParser.create().applyAnnotations(al, sr).build().createSession();
        ParserConfigAnnotationTest.check("false", x.isAutoCloseStreams());
        ParserConfigAnnotationTest.check("5", x.getDebugOutputLines());
        ParserConfigAnnotationTest.check(Charset.defaultCharset().toString(), x.getFileCharset());
        ParserConfigAnnotationTest.check("UTF-8", x.getStreamCharset());
        ParserConfigAnnotationTest.check(null, x.getListener());
        ParserConfigAnnotationTest.check("false", x.isStrict());
        ParserConfigAnnotationTest.check("false", x.isTrimStrings());
        ParserConfigAnnotationTest.check("false", x.isUnbuffered());
    }

    @Test
    public void noValuesInputStreamParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        MsgPackParserSession x = MsgPackParser.create().applyAnnotations(al, sr).build().createSession();
        ParserConfigAnnotationTest.check("false", x.isAutoCloseStreams());
        ParserConfigAnnotationTest.check("HEX", x.getBinaryFormat());
        ParserConfigAnnotationTest.check("5", x.getDebugOutputLines());
        ParserConfigAnnotationTest.check(null, x.getListener());
        ParserConfigAnnotationTest.check("false", x.isStrict());
        ParserConfigAnnotationTest.check("false", x.isTrimStrings());
        ParserConfigAnnotationTest.check("false", x.isUnbuffered());
    }

    @Test
    public void noAnnotationReaderParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        JsonParserSession x = JsonParser.create().applyAnnotations(al, sr).build().createSession();
        ParserConfigAnnotationTest.check("false", x.isAutoCloseStreams());
        ParserConfigAnnotationTest.check("5", x.getDebugOutputLines());
        ParserConfigAnnotationTest.check(Charset.defaultCharset().toString(), x.getFileCharset());
        ParserConfigAnnotationTest.check("UTF-8", x.getStreamCharset());
        ParserConfigAnnotationTest.check(null, x.getListener());
        ParserConfigAnnotationTest.check("false", x.isStrict());
        ParserConfigAnnotationTest.check("false", x.isTrimStrings());
        ParserConfigAnnotationTest.check("false", x.isUnbuffered());
    }

    @Test
    public void noAnnotationInputStreamParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        MsgPackParserSession x = MsgPackParser.create().applyAnnotations(al, sr).build().createSession();
        ParserConfigAnnotationTest.check("false", x.isAutoCloseStreams());
        ParserConfigAnnotationTest.check("HEX", x.getBinaryFormat());
        ParserConfigAnnotationTest.check("5", x.getDebugOutputLines());
        ParserConfigAnnotationTest.check(null, x.getListener());
        ParserConfigAnnotationTest.check("false", x.isStrict());
        ParserConfigAnnotationTest.check("false", x.isTrimStrings());
        ParserConfigAnnotationTest.check("false", x.isUnbuffered());
    }

    static class C {
        C() {
        }
    }

    @ParserConfig
    static class B {
        B() {
        }
    }

    @ParserConfig(autoCloseStreams="$X{true}", binaryFormat="$X{HEX}", debugOutputLines="$X{1}", fileCharset="$X{US-ASCII}", streamCharset="$X{US-ASCII}", listener=AA.class, strict="$X{true}", trimStrings="$X{true}", unbuffered="$X{true}")
    static class A {
        A() {
        }
    }

    public static class AA
    extends ParserListener {
    }
}

