/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.junit.Assert;
import org.junit.Test;

public class MsgPackSerializerTest {
    @Test
    public void testBasic() throws Exception {
        this.test(null, "C0");
        this.test(false, "C2");
        this.test(true, "C3");
        this.test(0, "00");
        this.test(127, "7F");
        this.test(128, "D1 00 80");
        this.test(256, "D1 01 00");
        this.test(Short.MAX_VALUE, "D1 7F FF");
        this.test(32768, "D2 00 00 80 00");
        this.test(65535, "D2 00 00 FF FF");
        this.test(65536, "D2 00 01 00 00");
        this.test((long)Long.decode("0x000000007FFFFFFF"), "D2 7F FF FF FF");
        this.test((long)Long.decode("0x0000000080000000"), "D3 00 00 00 00 80 00 00 00");
        this.test((long)Long.decode("0x0000000100000000"), "D3 00 00 00 01 00 00 00 00");
        this.test((long)Long.decode("0x7FFFFFFFFFFFFFFF"), "D3 7F FF FF FF FF FF FF FF");
        this.test(-Long.decode("0x7FFFFFFFFFFFFFFF").longValue(), "D3 80 00 00 00 00 00 00 01");
        this.test(-1, "E1");
        this.test(-63, "FF");
        this.test(-64, "D0 C0");
        this.test(-127, "D0 81");
        this.test(-128, "D1 FF 80");
        this.test(-256, "D1 FF 00");
        this.test(-32767, "D1 80 01");
        this.test(Short.MIN_VALUE, "D2 FF FF 80 00");
        this.test(-65535, "D2 FF FF 00 01");
        this.test(-65536, "D2 FF FF 00 00");
        this.test(-Long.decode("0x000000007FFFFFFF").longValue(), "D2 80 00 00 01");
        this.test(-Long.decode("0x0000000080000000").longValue(), "D3 FF FF FF FF 80 00 00 00");
        this.test(-Long.decode("0x0000000100000000").longValue(), "D3 FF FF FF FF 00 00 00 00");
        this.test(-Long.decode("0x7FFFFFFFFFFFFFFF").longValue(), "D3 80 00 00 00 00 00 00 01");
        this.test(Float.valueOf(0.0f), "CA 00 00 00 00");
        this.test(Float.valueOf(1.0f), "CA 3F 80 00 00");
        this.test(Float.valueOf(-1.0f), "CA BF 80 00 00");
        this.test(1.0, "CB 3F F0 00 00 00 00 00 00");
        this.test(-1.0, "CB BF F0 00 00 00 00 00 00");
        this.test("", "A0");
        this.test("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "BF 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61");
        this.test("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "D9 20 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61");
        this.test(new int[0], "90");
        this.test(new int[]{1}, "91 01");
        this.test(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, "9F 01 01 01 01 01 01 01 01 01 01 01 01 01 01 01");
        this.test(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, "DC 00 10 01 01 01 01 01 01 01 01 01 01 01 01 01 01 01 01");
        this.test(new ObjectMap((CharSequence)"{}"), "80");
        this.test(new ObjectMap((CharSequence)"{1:1}"), "81 A1 31 01");
        this.test(new ObjectMap((CharSequence)"{1:1,2:1,3:1,4:1,5:1,6:1,7:1,8:1,9:1,a:1,b:1,c:1,d:1,e:1,f:1}"), "8F A1 31 01 A1 32 01 A1 33 01 A1 34 01 A1 35 01 A1 36 01 A1 37 01 A1 38 01 A1 39 01 A1 61 01 A1 62 01 A1 63 01 A1 64 01 A1 65 01 A1 66 01");
        this.test(new ObjectMap((CharSequence)"{1:1,2:1,3:1,4:1,5:1,6:1,7:1,8:1,9:1,a:1,b:1,c:1,d:1,e:1,f:1,g:1}"), "DE 00 10 A1 31 01 A1 32 01 A1 33 01 A1 34 01 A1 35 01 A1 36 01 A1 37 01 A1 38 01 A1 39 01 A1 61 01 A1 62 01 A1 63 01 A1 64 01 A1 65 01 A1 66 01 A1 67 01");
    }

    private void test(Object input, String expected) throws Exception {
        byte[] b = MsgPackSerializer.DEFAULT.serialize(input);
        Assert.assertEquals((Object)expected, (Object)StringUtils.toSpacedHex((byte[])b));
    }

    public static class Person {
        public String name = "John Smith";
        public int age = 21;
    }
}

