/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.InputStream;
import org.apache.juneau.CloseableByteArrayInputStream;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MsgPackParserTest {
    @Test
    public void testStreamsAutoClose() throws Exception {
        MsgPackParser p = MsgPackParser.DEFAULT.builder().autoCloseStreams().build();
        InputStream is = this.is("00 01");
        Object r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("0", r);
        try {
            r = p.parse((Object)is, Object.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Stream is closed"));
        }
    }

    @Test
    public void testMultipleObjectsInStream() throws Exception {
        MsgPackParser p = MsgPackParser.DEFAULT;
        InputStream is = this.is("00 01");
        Object r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("0", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("1", r);
        is = this.is("D1 00 80 D1 00 81");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("128", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("129", r);
        is = this.is("D2 00 00 80 00 D2 00 00 80 01");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("32768", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("32769", r);
        is = this.is("CA 00 00 00 00 CA 3F 80 00 00");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("0.0", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("1.0", r);
        is = this.is("CB 3F F0 00 00 00 00 00 00 CB BF F0 00 00 00 00 00 00");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("1.0", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("-1.0", r);
        is = this.is("A0 A0");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("''", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("''", r);
        is = this.is("BF 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 BF 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("'bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb'", r);
        is = this.is("D9 20 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 D9 20 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62 62");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("'bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb'", r);
        is = this.is("90 90");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("[]", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("[]", r);
        is = this.is("91 01 91 02");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("[1]", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("[2]", r);
        is = this.is("80 80");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("{}", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("{}", r);
        is = this.is("81 A1 31 01 81 A1 31 02");
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("{'1':1}", r);
        r = p.parse((Object)is, Object.class);
        TestUtils.assertObjectEquals("{'1':2}", r);
    }

    private InputStream is(String spacedHex) throws Exception {
        return new CloseableByteArrayInputStream(StringUtils.fromSpacedHex((String)spacedHex));
    }
}

