/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.msgpack.MsgPackSerializerSession;
import org.apache.juneau.msgpack.annotation.MsgPackConfig;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class MsgPackConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        MsgPackSerializerSession x = MsgPackSerializer.create().applyAnnotations(al, sr).build().createSession();
        MsgPackConfigAnnotationTest.check("true", x.isAddBeanTypes());
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        MsgPackParser.create().applyAnnotations(al, sr).build().createSession();
    }

    @Test
    public void noValuesSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        MsgPackSerializerSession x = MsgPackSerializer.create().applyAnnotations(al, sr).build().createSession();
        MsgPackConfigAnnotationTest.check("false", x.isAddBeanTypes());
    }

    @Test
    public void noValuesParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        MsgPackParser.create().applyAnnotations(al, sr).build().createSession();
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        MsgPackSerializerSession x = MsgPackSerializer.create().applyAnnotations(al, sr).build().createSession();
        MsgPackConfigAnnotationTest.check("false", x.isAddBeanTypes());
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        MsgPackParser.create().applyAnnotations(al, sr).build().createSession();
    }

    static class C {
        C() {
        }
    }

    @MsgPackConfig
    static class B {
        B() {
        }
    }

    @MsgPackConfig(addBeanTypes="$X{true}")
    static class A {
        A() {
        }
    }
}

