/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Example;
import org.apache.juneau.jsonschema.BasicBeanDefMapper;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.JsonSchemaConfig;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.testutils.pojos.TestEnumToString;
import org.apache.juneau.transform.PojoSwap;
import org.junit.Test;

public class JsonSchemaGeneratorTest {
    @Test
    public void simpleObjects() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'integer',format:'int16'}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16'}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32'}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32'}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64'}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64'}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float'}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float'}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double'}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double'}", s.getSchema(Double.class));
        TestUtils.assertObjectEquals("{type:'boolean'}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'boolean'}", s.getSchema(Boolean.class));
        TestUtils.assertObjectEquals("{type:'string'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string'}", s.getSchema(Character.TYPE));
        TestUtils.assertObjectEquals("{type:'string'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three']}", s.getSchema(TestEnumToString.class));
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}}}", s.getSchema(SimpleBean.class));
    }

    @Test
    public void arrays1d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int16'}}", s.getSchema(short[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int16'}}", s.getSchema(Short[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int32'}}", s.getSchema(int[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int32'}}", s.getSchema(Integer[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int64'}}", s.getSchema(long[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int64'}}", s.getSchema(Long[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'number',format:'float'}}", s.getSchema(float[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'number',format:'float'}}", s.getSchema(Float[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'number',format:'double'}}", s.getSchema(double[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'number',format:'double'}}", s.getSchema(Double[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'boolean'}}", s.getSchema(boolean[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'boolean'}}", s.getSchema(Boolean[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'string'}}", s.getSchema(String[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'string'}}", s.getSchema(StringBuilder[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'string'}}", s.getSchema(char[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'string'}}", s.getSchema(Character[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'string','enum':['one','two','three']}}", s.getSchema(TestEnumToString[].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(SimpleBean[].class));
    }

    @Test
    public void arrays2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int16'}}}", s.getSchema(short[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int16'}}}", s.getSchema(Short[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32'}}}", s.getSchema(int[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32'}}}", s.getSchema(Integer[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int64'}}}", s.getSchema(long[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int64'}}}", s.getSchema(Long[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'float'}}}", s.getSchema(float[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'float'}}}", s.getSchema(Float[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'double'}}}", s.getSchema(double[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'double'}}}", s.getSchema(Double[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'boolean'}}}", s.getSchema(boolean[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'boolean'}}}", s.getSchema(Boolean[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string'}}}", s.getSchema(String[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string'}}}", s.getSchema(StringBuilder[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string'}}}", s.getSchema(char[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string'}}}", s.getSchema(Character[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','enum':['one','two','three']}}}", s.getSchema(TestEnumToString[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}}", s.getSchema(SimpleBean[][].class));
    }

    @Test
    public void simpleList() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int32'}}", s.getSchema(SimpleList.class));
    }

    @Test
    public void simpleList2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32'}}}", s.getSchema(Simple2dList.class));
    }

    @Test
    public void beanList() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(BeanList.class));
    }

    @Test
    public void beanList2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}}", s.getSchema(BeanList2d.class));
    }

    @Test
    public void beanMap() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(BeanMap.class));
    }

    @Test
    public void beanMap2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}}}}", s.getSchema(BeanMap2d.class));
    }

    @Test
    public void useBeanDefs() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        TestUtils.assertObjectEquals("{'$ref':'#/definitions/SimpleBean'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{SimpleBean:{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void useBeanDefs_beanList() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{'$ref':'#/definitions/SimpleBean'}}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{SimpleBean:{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void useBeanDefs_beanList2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{'$ref':'#/definitions/SimpleBean'}}}", s.getSchema(BeanList2d.class));
        TestUtils.assertObjectEquals("{SimpleBean:{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void useBeanDefs_beanArray2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{'$ref':'#/definitions/SimpleBean'}}}", s.getSchema(SimpleBean[][].class));
        TestUtils.assertObjectEquals("{SimpleBean:{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void beanDefsPreloaded() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        s.addBeanDef("SimpleBean", new ObjectMap().append("test", (Object)123));
        TestUtils.assertObjectEquals("{'$ref':'#/definitions/SimpleBean'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{SimpleBean:{test:123}}", s.getBeanDefs());
    }

    @Test
    public void useBeanDefsPreloaded_beanList() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        s.addBeanDef("SimpleBean", new ObjectMap().append("test", (Object)123));
        TestUtils.assertObjectEquals("{type:'array',items:{'$ref':'#/definitions/SimpleBean'}}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{SimpleBean:{test:123}}", s.getBeanDefs());
    }

    @Test
    public void useBeanDefsPreloaded_beanList2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        s.addBeanDef("SimpleBean", new ObjectMap().append("test", (Object)123));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{'$ref':'#/definitions/SimpleBean'}}}", s.getSchema(BeanList2d.class));
        TestUtils.assertObjectEquals("{SimpleBean:{test:123}}", s.getBeanDefs());
    }

    @Test
    public void useBeanDefsPreloaded_beanArray2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().build().createSession();
        s.addBeanDef("SimpleBean", new ObjectMap().append("test", (Object)123));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{'$ref':'#/definitions/SimpleBean'}}}", s.getSchema(SimpleBean[][].class));
        TestUtils.assertObjectEquals("{SimpleBean:{test:123}}", s.getBeanDefs());
    }

    @Test
    public void customBeanDefMapper() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().beanDefMapper(CustomBeanDefMapper.class).build().createSession();
        TestUtils.assertObjectEquals("{'$ref':'#/definitions/org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean':{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void customBeanDefMapperInstance() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().beanDefMapper((BeanDefMapper)new CustomBeanDefMapper()).build().createSession();
        TestUtils.assertObjectEquals("{'$ref':'#/definitions/org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean':{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void customBeanDefMapper_customURI() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useBeanDefs().beanDefMapper(CustomBeanDefMapper2.class).build().createSession();
        TestUtils.assertObjectEquals("{'$ref':'/foo/bar/org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean':{type:'object',properties:{f1:{type:'string'}}}}", s.getBeanDefs());
    }

    @Test
    public void addExample_BEAN_noBeanExample() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}}}", s.getSchema(SimpleBean.class));
    }

    @Test
    public void addExample_BEAN_exampleMethod() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(B1.class));
    }

    @Test
    public void addExample_BEAN_exampleMethod_wDefault() throws Exception {
        B1 b = new B1();
        b.f1 = "baz";
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").example(B1.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'baz'}}", s.getSchema(B1.class));
    }

    @Test
    public void addExample_BEAN_exampleMethod_array2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B1[][].class));
    }

    @Test
    public void addExample_BEAN_exampleMethod_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(B1c.class));
    }

    @Test
    public void addExample_BEAN_exampleMethod_wDefault_usingConfig() throws Exception {
        B1c b = new B1c();
        b.f1 = "baz";
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B1c.class}).example(B1c.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'baz'}}", s.getSchema(B1c.class));
    }

    @Test
    public void addExample_BEAN_exampleMethod_array2d_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B1c[][].class));
    }

    @Test
    public void addExample_BEAN_exampleMethodOverridden_wDefault() throws Exception {
        B2 b = new B2();
        b.f1 = "baz";
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").example(B2.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'baz'}}", s.getSchema(B2.class));
    }

    @Test
    public void addExample_BEAN_exampleMethodOverridden_array2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B2[][].class));
    }

    @Test
    public void addExample_BEAN_exampleMethodOverridden_wDefault_usingConfig() throws Exception {
        B2c b = new B2c();
        b.f1 = "baz";
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B2c.class}).example(B2c.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'baz'}}", s.getSchema(B2c.class));
    }

    @Test
    public void addExample_BEAN_exampleMethodOverridden_array2d_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B2c[][].class));
    }

    @Test
    public void addExample_BEAN_exampleField() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(B3.class));
    }

    @Test
    public void addExample_BEAN_exampleField_array2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B3[][].class));
    }

    @Test
    public void addExample_BEAN_exampleField_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B3c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(B3c.class));
    }

    @Test
    public void addExample_BEAN_exampleField_array2d_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B3c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B3c[][].class));
    }

    @Test
    public void addExample_BEAN_exampleBeanAnnotation() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(B4.class));
    }

    @Test
    public void addExample_BEAN_exampleBeanAnnotation_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B4[][].class));
    }

    @Test
    public void addExample_BEAN_exampleBeanAnnotation_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B4c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(B4c.class));
    }

    @Test
    public void addExample_BEAN_exampleBeanAnnotation_2darray_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").applyAnnotations(new Class[]{B4c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(B4c[][].class));
    }

    @Test
    public void addExample_BEAN_exampleBeanProperty() throws Exception {
        SimpleBean b = new SimpleBean();
        b.f1 = "foobar";
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").example(SimpleBean.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}", s.getSchema(SimpleBean.class));
    }

    @Test
    public void addExample_BEAN_exampleBeanProperty_2darray() throws Exception {
        SimpleBean b = new SimpleBean();
        b.f1 = "foobar";
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("bean").example(SimpleBean.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},'x-example':{f1:'foobar'}}}}", s.getSchema(SimpleBean[][].class));
    }

    @Test
    public void addExample_MAP_noExample() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(BeanMap.class));
    }

    @Test
    public void addExample_MAP_exampleMethod() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}", s.getSchema(C1.class));
    }

    @Test
    public void addExample_MAP_exampleMethod_wDefault() throws Exception {
        C1 b = new C1();
        b.put(456, B1.example());
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").example(C1.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'456':{f1:'foobar'}}}", s.getSchema(C1.class));
    }

    @Test
    public void addExample_MAP_exampleMethod_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").applyAnnotations(new Class[]{C1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}", s.getSchema(C1c.class));
    }

    @Test
    public void addExample_MAP_exampleMethod_wDefault_usingConfig() throws Exception {
        C1c b = new C1c();
        b.put(456, B1.example());
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").applyAnnotations(new Class[]{C1c.class}).example(C1c.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'456':{f1:'foobar'}}}", s.getSchema(C1c.class));
    }

    @Test
    public void addExample_MAP_exampleField() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}", s.getSchema(C2.class));
    }

    @Test
    public void addExample_MAP_exampleField_array2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}}}", s.getSchema(C2[][].class));
    }

    @Test
    public void addExample_MAP_exampleField_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").applyAnnotations(new Class[]{C2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}", s.getSchema(C2c.class));
    }

    @Test
    public void addExample_MAP_exampleField_array2d_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").applyAnnotations(new Class[]{C2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}}}", s.getSchema(C2c[][].class));
    }

    @Test
    public void addExample_MAP_exampleBeanAnnotation() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'baz'}}}", s.getSchema(C3.class));
    }

    @Test
    public void addExample_MAP_exampleBeanAnnotation_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'baz'}}}}}", s.getSchema(C3[][].class));
    }

    @Test
    public void addExample_MAP_exampleBeanAnnotation_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").applyAnnotations(new Class[]{C3c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'baz'}}}", s.getSchema(C3c.class));
    }

    @Test
    public void addExample_MAP_exampleBeanAnnotation_2darray_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").applyAnnotations(new Class[]{C3c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'baz'}}}}}", s.getSchema(C3c[][].class));
    }

    @Test
    public void addExample_MAP_exampleBeanProperty() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").example(BeanMap.class, (Object)C1.example()).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}", s.getSchema(BeanMap.class));
    }

    @Test
    public void addExample_MAP_exampleBeanProperty_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("map").example(BeanMap.class, (Object)C1.example()).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}}}", s.getSchema(BeanMap[][].class));
    }

    @Test
    public void addExample_COLLECTION_noExample() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(BeanList.class));
    }

    @Test
    public void addExample_COLLECTION_exampleMethod() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'foobar'}]}", s.getSchema(D1.class));
    }

    @Test
    public void addExample_COLLECTION_exampleMethod_wDefault() throws Exception {
        D1 b = new D1();
        SimpleBean sb = new SimpleBean();
        sb.f1 = "baz";
        b.add(sb);
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").example(D1.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'baz'}]}", s.getSchema(D1.class));
    }

    @Test
    public void addExample_COLLECTION_exampleMethod_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").applyAnnotations(new Class[]{D1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'foobar'}]}", s.getSchema(D1c.class));
    }

    @Test
    public void addExample_COLLECTION_exampleMethod_wDefault_usingConfig() throws Exception {
        D1c b = new D1c();
        SimpleBean sb = new SimpleBean();
        sb.f1 = "baz";
        b.add(sb);
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").applyAnnotations(new Class[]{D1c.class}).example(D1c.class, (Object)b).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'baz'}]}", s.getSchema(D1c.class));
    }

    @Test
    public void addExample_COLLECTION_exampleField() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'foobar'}]}", s.getSchema(D2.class));
    }

    @Test
    public void addExample_ARRAY_exampleField_array2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("array").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},'x-example':[[[{f1:'foobar'}]]]}", s.getSchema(D2[][].class));
    }

    @Test
    public void addExample_COLLECTION_exampleField_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").applyAnnotations(new Class[]{D2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'foobar'}]}", s.getSchema(D2c.class));
    }

    @Test
    public void addExample_ARRAY_exampleField_array2d_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("array").applyAnnotations(new Class[]{D2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},'x-example':[[[{f1:'foobar'}]]]}", s.getSchema(D2c[][].class));
    }

    @Test
    public void addExample_COLLECTION_exampleBeanAnnotation() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'baz'}]}", s.getSchema(D3.class));
    }

    @Test
    public void addExample_ARRAY_exampleBeanAnnotation_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("array").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},'x-example':[[[{f1:'baz'}]]]}", s.getSchema(D3[][].class));
    }

    @Test
    public void addExample_COLLECTION_exampleBeanAnnotation_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").applyAnnotations(new Class[]{D3c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'baz'}]}", s.getSchema(D3c.class));
    }

    @Test
    public void addExample_ARRAY_exampleBeanAnnotation_2darray_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("array").applyAnnotations(new Class[]{D3c.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},'x-example':[[[{f1:'baz'}]]]}", s.getSchema(D3c[][].class));
    }

    @Test
    public void addExample_COLLECTION_exampleBeanProperty() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("collection").example(BeanList.class, (Object)D1.example()).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'foobar'}]}", s.getSchema(BeanList.class));
    }

    @Test
    public void addExample_ARRAY_exampleBeanProperty_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("array").example(BeanList.class, (Object)D1.example()).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},'x-example':[[[{f1:'foobar'}]]]}", s.getSchema(BeanList[][].class));
    }

    @Test
    public void addExample_BOOLEAN() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("boolean").build().createSession();
        TestUtils.assertObjectEquals("{type:'boolean','x-example':true}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'boolean','x-example':true}", s.getSchema(Boolean.class));
    }

    @Test
    public void addExample_BOOLEAN_wDefault() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("boolean").example(Boolean.TYPE, (Object)false).example(Boolean.class, (Object)false).build().createSession();
        TestUtils.assertObjectEquals("{type:'boolean','x-example':false}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'boolean','x-example':false}", s.getSchema(Boolean.class));
    }

    @Test
    public void addExample_BOOLEAN_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("boolean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'boolean','x-example':true}}}", s.getSchema(boolean[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'boolean','x-example':true}}}", s.getSchema(Boolean[][].class));
    }

    @Test
    public void addExample_NUMBER() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("number").build().createSession();
        TestUtils.assertObjectEquals("{type:'integer',format:'int16','x-example':1}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16','x-example':1}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32','x-example':1}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32','x-example':1}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64','x-example':1}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64','x-example':1}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float','x-example':1.0}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float','x-example':1.0}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double','x-example':1.0}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double','x-example':1.0}", s.getSchema(Double.class));
    }

    @Test
    public void addExample_NUMBER_wDefault() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("number").example(Short.TYPE, (Object)2).example(Short.class, (Object)3).example(Integer.TYPE, (Object)4).example(Integer.class, (Object)5).example(Long.TYPE, (Object)6L).example(Long.class, (Object)7L).example(Float.TYPE, (Object)Float.valueOf(8.0f)).example(Float.class, (Object)Float.valueOf(9.0f)).example(Double.TYPE, (Object)10.0).example(Double.class, (Object)11.0).build().createSession();
        TestUtils.assertObjectEquals("{type:'integer',format:'int16','x-example':2}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16','x-example':3}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32','x-example':4}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32','x-example':5}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64','x-example':6}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64','x-example':7}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float','x-example':8.0}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float','x-example':9.0}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double','x-example':10.0}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double','x-example':11.0}", s.getSchema(Double.class));
    }

    @Test
    public void addExample_NUMBER_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("number").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int16','x-example':1}}}", s.getSchema(short[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int16','x-example':1}}}", s.getSchema(Short[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32','x-example':1}}}", s.getSchema(int[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32','x-example':1}}}", s.getSchema(Integer[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int64','x-example':1}}}", s.getSchema(long[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int64','x-example':1}}}", s.getSchema(Long[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'float','x-example':1.0}}}", s.getSchema(float[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'float','x-example':1.0}}}", s.getSchema(Float[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'double','x-example':1.0}}}", s.getSchema(double[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'double','x-example':1.0}}}", s.getSchema(Double[][].class));
    }

    @Test
    public void addExample_STRING() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("string").build().createSession();
        TestUtils.assertObjectEquals("{type:'string','x-example':'foo'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'foo'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'a'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'a'}", s.getSchema(Character.TYPE));
    }

    @Test
    public void addExample_STRING_wDefault() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("string").exampleJson(String.class, "bar1").example(StringBuilder.class, (Object)new StringBuilder("bar2")).example(Character.class, (Object)Character.valueOf('b')).example(Character.TYPE, (Object)Character.valueOf('c')).build().createSession();
        TestUtils.assertObjectEquals("{type:'string','x-example':'bar1'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'bar2'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'b'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'c'}", s.getSchema(Character.TYPE));
    }

    @Test
    public void addExample_STRING_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("string").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'foo'}}}", s.getSchema(String[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'foo'}}}", s.getSchema(StringBuilder[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'a'}}}", s.getSchema(Character[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'a'}}}", s.getSchema(char[][].class));
    }

    @Test
    public void addExample_STRING_2darray_wDefault() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("string").exampleJson(String.class, "bar1").example(StringBuilder.class, (Object)new StringBuilder("bar2")).example(Character.class, (Object)Character.valueOf('b')).example(Character.TYPE, (Object)Character.valueOf('c')).build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'bar1'}}}", s.getSchema(String[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'bar2'}}}", s.getSchema(StringBuilder[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'b'}}}", s.getSchema(Character[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','x-example':'c'}}}", s.getSchema(char[][].class));
    }

    @Test
    public void addExample_ENUM() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("enum").build().createSession();
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three'],'x-example':'one'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void addExample_ENUM_wDefault() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("enum").example(TestEnumToString.class, (Object)TestEnumToString.TWO).build().createSession();
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three'],'x-example':'two'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void addExample_ENUM_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("enum").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','enum':['one','two','three'],'x-example':'one'}}}", s.getSchema(TestEnumToString[][].class));
    }

    @Test
    public void addExample_ENUM_useEnumNames() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useEnumNames().addExamplesTo("enum").build().createSession();
        TestUtils.assertObjectEquals("{type:'string','enum':['ONE','TWO','THREE'],'x-example':'ONE'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void addExample_ENUM_wDefault_useEnumNames() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useEnumNames().addExamplesTo("enum").example(TestEnumToString.class, (Object)TestEnumToString.TWO).build().createSession();
        TestUtils.assertObjectEquals("{type:'string','enum':['ONE','TWO','THREE'],'x-example':'TWO'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void addExample_ENUM_2darray_useEnumNames() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().useEnumNames().addExamplesTo("enum").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','enum':['ONE','TWO','THREE'],'x-example':'ONE'}}}", s.getSchema(TestEnumToString[][].class));
    }

    @Test
    public void addExample_ANY() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addExamplesTo("any").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string','x-example':'foo'}}}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},'x-example':{'123':{f1:'foobar'}}}", s.getSchema(C1.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},'x-example':[{f1:'foobar'}]}", s.getSchema(D1.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},'x-example':[[[{f1:'foobar'}]]]}", s.getSchema(D2[][].class));
        TestUtils.assertObjectEquals("{type:'boolean','x-example':true}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16','x-example':1}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16','x-example':1}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32','x-example':1}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32','x-example':1}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64','x-example':1}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64','x-example':1}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float','x-example':1.0}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float','x-example':1.0}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double','x-example':1.0}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double','x-example':1.0}", s.getSchema(Double.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'foo'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'foo'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'a'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string','x-example':'a'}", s.getSchema(Character.TYPE));
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three'],'x-example':'one'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void addDescription_BEAN() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'}", s.getSchema(SimpleBean.class));
    }

    @Test
    public void addDescription_BEAN_array2d() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'}}}", s.getSchema(SimpleBean[][].class));
    }

    @Test
    public void addDescription_MAP() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanMap<java.lang.Integer,org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}", s.getSchema(BeanMap.class));
    }

    @Test
    public void addDescription_MAP_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("map").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanMap<java.lang.Integer,org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}}}", s.getSchema(BeanMap[][].class));
    }

    @Test
    public void addDescription_COLLECTION() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("collection").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}", s.getSchema(BeanList.class));
    }

    @Test
    public void addDescription_COLLECTION_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("collection").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}}}", s.getSchema(BeanList[][].class));
    }

    @Test
    public void addDescription_ARRAY() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("array").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>[][]'}", s.getSchema(BeanList[][].class));
    }

    @Test
    public void addDescription_BOOLEAN() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("boolean").build().createSession();
        TestUtils.assertObjectEquals("{type:'boolean',description:'boolean'}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'boolean',description:'java.lang.Boolean'}", s.getSchema(Boolean.class));
    }

    @Test
    public void addDescription_BOOLEAN_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("boolean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'boolean',description:'boolean'}}}", s.getSchema(boolean[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'boolean',description:'java.lang.Boolean'}}}", s.getSchema(Boolean[][].class));
    }

    @Test
    public void addDescription_NUMBER() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("number").build().createSession();
        TestUtils.assertObjectEquals("{type:'integer',format:'int16',description:'short'}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16',description:'java.lang.Short'}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32',description:'int'}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32',description:'java.lang.Integer'}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64',description:'long'}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64',description:'java.lang.Long'}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float',description:'float'}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float',description:'java.lang.Float'}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double',description:'double'}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double',description:'java.lang.Double'}", s.getSchema(Double.class));
    }

    @Test
    public void addDescription_NUMBER_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("number").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int16',description:'short'}}}", s.getSchema(short[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int16',description:'java.lang.Short'}}}", s.getSchema(Short[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32',description:'int'}}}", s.getSchema(int[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32',description:'java.lang.Integer'}}}", s.getSchema(Integer[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int64',description:'long'}}}", s.getSchema(long[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int64',description:'java.lang.Long'}}}", s.getSchema(Long[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'float',description:'float'}}}", s.getSchema(float[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'float',description:'java.lang.Float'}}}", s.getSchema(Float[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'double',description:'double'}}}", s.getSchema(double[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'number',format:'double',description:'java.lang.Double'}}}", s.getSchema(Double[][].class));
    }

    @Test
    public void addDescription_STRING() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("string").build().createSession();
        TestUtils.assertObjectEquals("{type:'string',description:'java.lang.String'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string',description:'java.lang.StringBuilder'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string',description:'java.lang.Character'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string',description:'char'}", s.getSchema(Character.TYPE));
    }

    @Test
    public void addDescription_STRING_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("string").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string',description:'java.lang.String'}}}", s.getSchema(String[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string',description:'java.lang.StringBuilder'}}}", s.getSchema(StringBuilder[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string',description:'java.lang.Character'}}}", s.getSchema(Character[][].class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string',description:'char'}}}", s.getSchema(char[][].class));
    }

    @Test
    public void addDescription_ENUM() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("enum").build().createSession();
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three'],description:'org.apache.juneau.testutils.pojos.TestEnumToString'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void addDescription_ENUM_2darray() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("enum").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'string','enum':['one','two','three'],description:'org.apache.juneau.testutils.pojos.TestEnumToString'}}}", s.getSchema(TestEnumToString[][].class));
    }

    @Test
    public void addDescription_ANY() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("any").build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string'}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanMap<java.lang.Integer,org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}", s.getSchema(BeanMap.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>[][]'}", s.getSchema(BeanList[][].class));
        TestUtils.assertObjectEquals("{type:'boolean',description:'boolean'}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'boolean',description:'java.lang.Boolean'}", s.getSchema(Boolean.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16',description:'short'}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16',description:'java.lang.Short'}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32',description:'int'}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32',description:'java.lang.Integer'}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64',description:'long'}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64',description:'java.lang.Long'}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float',description:'float'}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float',description:'java.lang.Float'}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double',description:'double'}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double',description:'java.lang.Double'}", s.getSchema(Double.class));
        TestUtils.assertObjectEquals("{type:'string',description:'java.lang.String'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string',description:'java.lang.StringBuilder'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string',description:'java.lang.Character'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string',description:'char'}", s.getSchema(Character.TYPE));
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three'],description:'org.apache.juneau.testutils.pojos.TestEnumToString'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void defaultSchemas() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().defaultSchema(SimpleBean.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(BeanMap.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(BeanList.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(BeanList[][].class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Boolean.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Boolean.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Short.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Short.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Integer.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Integer.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Long.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Long.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Float.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Float.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Double.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Double.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(String.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(StringBuilder.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Character.class, new ObjectMap().append("type", (Object)"bar")).defaultSchema(Character.TYPE, new ObjectMap().append("type", (Object)"bar")).defaultSchema(TestEnumToString.class, new ObjectMap().append("type", (Object)"bar")).build().createSession();
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(BeanMap.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(BeanList[][].class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Boolean.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Double.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(Character.TYPE));
        TestUtils.assertObjectEquals("{type:'bar'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void defaultSchemasNoType() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().defaultSchema(SimpleBean.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(BeanMap.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(BeanList.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(BeanList[][].class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Boolean.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Boolean.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Short.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Short.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Integer.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Integer.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Long.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Long.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Float.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Float.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Double.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Double.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(String.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(StringBuilder.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Character.class, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(Character.TYPE, new ObjectMap().append("foo", (Object)"bar")).defaultSchema(TestEnumToString.class, new ObjectMap().append("foo", (Object)"bar")).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{type:'string',foo:'bar'}},foo:'bar'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'object',additionalProperties:{type:'object',properties:{f1:{type:'string',foo:'bar'}},foo:'bar'},foo:'bar'}", s.getSchema(BeanMap.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string',foo:'bar'}},foo:'bar'},foo:'bar'}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'array',items:{type:'object',properties:{f1:{type:'string',foo:'bar'}},foo:'bar'},foo:'bar'}},foo:'bar'}", s.getSchema(BeanList[][].class));
        TestUtils.assertObjectEquals("{type:'boolean',foo:'bar'}", s.getSchema(Boolean.TYPE));
        TestUtils.assertObjectEquals("{type:'boolean',foo:'bar'}", s.getSchema(Boolean.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16',foo:'bar'}", s.getSchema(Short.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int16',foo:'bar'}", s.getSchema(Short.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32',foo:'bar'}", s.getSchema(Integer.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int32',foo:'bar'}", s.getSchema(Integer.class));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64',foo:'bar'}", s.getSchema(Long.TYPE));
        TestUtils.assertObjectEquals("{type:'integer',format:'int64',foo:'bar'}", s.getSchema(Long.class));
        TestUtils.assertObjectEquals("{type:'number',format:'float',foo:'bar'}", s.getSchema(Float.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'float',foo:'bar'}", s.getSchema(Float.class));
        TestUtils.assertObjectEquals("{type:'number',format:'double',foo:'bar'}", s.getSchema(Double.TYPE));
        TestUtils.assertObjectEquals("{type:'number',format:'double',foo:'bar'}", s.getSchema(Double.class));
        TestUtils.assertObjectEquals("{type:'string',foo:'bar'}", s.getSchema(String.class));
        TestUtils.assertObjectEquals("{type:'string',foo:'bar'}", s.getSchema(StringBuilder.class));
        TestUtils.assertObjectEquals("{type:'string',foo:'bar'}", s.getSchema(Character.class));
        TestUtils.assertObjectEquals("{type:'string',foo:'bar'}", s.getSchema(Character.TYPE));
        TestUtils.assertObjectEquals("{type:'string','enum':['one','two','three'],foo:'bar'}", s.getSchema(TestEnumToString.class));
    }

    @Test
    public void allowNestedExamples_enabled() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().allowNestedExamples().example(BeanList.class, (Object)new BeanList()).example(SimpleBean.class, (Object)new SimpleBean()).addExamplesTo("collection,bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(BeanList.class));
    }

    @Test
    public void allowNestedExamples_disabled() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().example(BeanList.class, (Object)new BeanList()).example(SimpleBean.class, (Object)new SimpleBean()).addExamplesTo("collection,bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}}}", s.getSchema(BeanList.class));
    }

    @Test
    public void allowNestedDescriptions_enabled() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().allowNestedDescriptions().addDescriptionsTo("collection,bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean'},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}", s.getSchema(BeanList.class));
    }

    @Test
    public void allowNestedDescriptions_disabled() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().addDescriptionsTo("collection,bean").build().createSession();
        TestUtils.assertObjectEquals("{type:'array',items:{type:'object',properties:{f1:{type:'string'}}},description:'org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$BeanList<org.apache.juneau.jsonschema.JsonSchemaGeneratorTest$SimpleBean>'}", s.getSchema(BeanList.class));
    }

    @Test
    public void swaps_int() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().pojoSwaps(new Class[]{IntSwap.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'integer',format:'int32'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'integer',format:'int32'}}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{type:'integer',format:'int32'}}}", s.getSchema(SimpleBean[][].class));
    }

    @Test
    public void jsonSchema_onclass() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().build().createSession();
        TestUtils.assertObjectEquals("{description:'baz',format:'bar',type:'foo','x-example':'{f1:123}',properties:{f1:{type:'integer',format:'int32'}}}", s.getSchema(A1.class));
    }

    @Test
    public void jsonSchema_onclass_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().applyAnnotations(new Class[]{A1a.class}).build().createSession();
        TestUtils.assertObjectEquals("{description:'baz',format:'bar',type:'foo','x-example':'{f1:123}',properties:{f1:{type:'integer',format:'int32'}}}", s.getSchema(A1a.class));
    }

    @Test
    public void jsonSchema_onbeanfield() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(A2.class));
    }

    @Test
    public void jsonSchema_onbeanfield_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().applyAnnotations(new Class[]{A2a.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(A2a.class));
    }

    @Test
    public void jsonSchema_onbeangetter() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(A3.class));
    }

    @Test
    public void jsonSchema_onbeangetter_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().applyAnnotations(new Class[]{A3a.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(A3a.class));
    }

    @Test
    public void jsonSchema_onbeansetter() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(A4.class));
    }

    @Test
    public void jsonSchema_onbeansetter_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().applyAnnotations(new Class[]{A4a.class}).build().createSession();
        TestUtils.assertObjectEquals("{type:'object',properties:{f1:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(A4a.class));
    }

    @Test
    public void jsonschema_onpojoswap() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().pojoSwaps(new Class[]{SwapWithAnnotation.class}).build().createSession();
        TestUtils.assertObjectEquals("{description:'baz',format:'bar',type:'foo','x-example':'123'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'array',items:{description:'baz',format:'bar',type:'foo','x-example':'123'}}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(SimpleBean[][].class));
    }

    @Test
    public void jsonschema_onpojoswap_usingConfig() throws Exception {
        JsonSchemaGeneratorSession s = JsonSchemaGenerator.DEFAULT.builder().applyAnnotations(new Class[]{SwapWithAnnotation2.class}).pojoSwaps(new Class[]{SwapWithAnnotation2.class}).build().createSession();
        TestUtils.assertObjectEquals("{description:'baz',format:'bar',type:'foo','x-example':'123'}", s.getSchema(SimpleBean.class));
        TestUtils.assertObjectEquals("{type:'array',items:{description:'baz',format:'bar',type:'foo','x-example':'123'}}", s.getSchema(BeanList.class));
        TestUtils.assertObjectEquals("{type:'array',items:{type:'array',items:{description:'baz',format:'bar',type:'foo','x-example':'123'}}}", s.getSchema(SimpleBean[][].class));
    }

    @JsonSchemaConfig(applySchema={@Schema(on="SwapWithAnnotation2", type="foo", format="bar", description={"baz"}, example={"123"})})
    public static class SwapWithAnnotation2
    extends PojoSwap<SimpleBean, Integer> {
    }

    @Schema(type="foo", format="bar", description={"baz"}, example={"123"})
    public static class SwapWithAnnotation
    extends PojoSwap<SimpleBean, Integer> {
    }

    @JsonSchemaConfig(applySchema={@Schema(on="A4a.setF1", type="foo", format="bar", description={"baz"}, example={"123"})})
    public static class A4a {
        public int getF1() {
            return 123;
        }

        public void setF1(int f1) {
        }
    }

    public static class A4 {
        public int getF1() {
            return 123;
        }

        @Schema(type="foo", format="bar", description={"baz"}, example={"123"})
        public void setF1(int f1) {
        }
    }

    @JsonSchemaConfig(applySchema={@Schema(on="A3a.getF1", type="foo", format="bar", description={"baz"}, example={"123"})})
    public static class A3a {
        public int getF1() {
            return 123;
        }
    }

    public static class A3 {
        @Schema(type="foo", format="bar", description={"baz"}, example={"123"})
        public int getF1() {
            return 123;
        }
    }

    @JsonSchemaConfig(applySchema={@Schema(on="A2a.f1", type="foo", format="bar", description={"baz"}, example={"123"})})
    public static class A2a {
        public int f1;
    }

    public static class A2 {
        @Schema(type="foo", format="bar", description={"baz"}, example={"123"})
        public int f1;
    }

    @JsonSchemaConfig(applySchema={@Schema(on="A1a", type="foo", format="bar", description={"baz"}, example={"{f1:123}"})})
    public static class A1a {
        public int f1;
    }

    @Schema(type="foo", format="bar", description={"baz"}, example={"{f1:123}"})
    public static class A1 {
        public int f1;
    }

    public static class IntSwap
    extends PojoSwap<SimpleBean, Integer> {
    }

    @BeanConfig(applyExample={@Example(on="D3c", value="[{f1:'baz'}]")})
    public static class D3c
    extends BeanList {
    }

    @Example(value="[{f1:'baz'}]")
    public static class D3
    extends BeanList {
    }

    @BeanConfig(applyExample={@Example(on="D2c.EXAMPLE")})
    public static class D2c
    extends BeanList {
        public static D2c EXAMPLE = D2c.getExample();

        private static D2c getExample() {
            D2c ex = new D2c();
            ex.add(B1.example());
            return ex;
        }
    }

    public static class D2
    extends BeanList {
        @Example
        public static D2 EXAMPLE = D2.getExample();

        private static D2 getExample() {
            D2 ex = new D2();
            ex.add(B1.example());
            return ex;
        }
    }

    @BeanConfig(applyExample={@Example(on="D1c.example")})
    public static class D1c
    extends BeanList {
        public static D1c example() {
            D1c m = new D1c();
            m.add(B1.example());
            return m;
        }
    }

    public static class D1
    extends BeanList {
        @Example
        public static D1 example() {
            D1 m = new D1();
            m.add(B1.example());
            return m;
        }
    }

    @BeanConfig(applyExample={@Example(on="C3c", value="{'123':{f1:'baz'}}")})
    public static class C3c
    extends BeanMap {
    }

    @Example(value="{'123':{f1:'baz'}}")
    public static class C3
    extends BeanMap {
    }

    @BeanConfig(applyExample={@Example(on="C2c.EXAMPLE")})
    public static class C2c
    extends BeanMap {
        public static C2c EXAMPLE = C2c.getExample();

        private static C2c getExample() {
            C2c ex = new C2c();
            ex.put(123, B1.example());
            return ex;
        }
    }

    public static class C2
    extends BeanMap {
        @Example
        public static C2 EXAMPLE = C2.getExample();

        private static C2 getExample() {
            C2 ex = new C2();
            ex.put(123, B1.example());
            return ex;
        }
    }

    @BeanConfig(applyExample={@Example(on="C1c.example")})
    public static class C1c
    extends BeanMap {
        public static C1c example() {
            C1c m = new C1c();
            m.put(123, B1.example());
            return m;
        }
    }

    public static class C1
    extends BeanMap {
        @Example
        public static C1 example() {
            C1 m = new C1();
            m.put(123, B1.example());
            return m;
        }
    }

    @BeanConfig(applyExample={@Example(on="B4c", value="{f1:'foobar'}")})
    public static class B4c
    extends SimpleBean {
    }

    @Example(value="{f1:'foobar'}")
    public static class B4
    extends SimpleBean {
    }

    @BeanConfig(applyExample={@Example(on="B3c.EXAMPLE")})
    public static class B3c
    extends SimpleBean {
        public static B3c EXAMPLE = B3c.getExample();

        private static B3c getExample() {
            B3c ex = new B3c();
            ex.f1 = "foobar";
            return ex;
        }
    }

    public static class B3
    extends SimpleBean {
        @Example
        public static B3 EXAMPLE = B3.getExample();

        private static B3 getExample() {
            B3 ex = new B3();
            ex.f1 = "foobar";
            return ex;
        }
    }

    @BeanConfig(applyExample={@Example(on="B2c.example2")})
    public static class B2c
    extends B1c {
        public static B2c example2() {
            B2c ex = new B2c();
            ex.f1 = "foobar";
            return ex;
        }
    }

    public static class B2
    extends B1 {
        @Example
        public static B2 example2() {
            B2 ex = new B2();
            ex.f1 = "foobar";
            return ex;
        }
    }

    @BeanConfig(applyExample={@Example(on="B1c.example")})
    public static class B1c
    extends SimpleBean {
        public static B1c example() {
            B1c ex = new B1c();
            ex.f1 = "foobar";
            return ex;
        }
    }

    public static class B1
    extends SimpleBean {
        @Example
        public static B1 example() {
            B1 ex = new B1();
            ex.f1 = "foobar";
            return ex;
        }
    }

    public static class CustomBeanDefMapper2
    extends BasicBeanDefMapper {
        public CustomBeanDefMapper2() {
            super("/foo/bar/{0}");
        }

        public String getId(ClassMeta<?> cm) {
            return cm.getFullName();
        }
    }

    public static class CustomBeanDefMapper
    extends BasicBeanDefMapper {
        public String getId(ClassMeta<?> cm) {
            return cm.getFullName();
        }
    }

    public static class BeanMap2d
    extends LinkedHashMap<Integer, LinkedHashMap<Integer, SimpleBean>> {
    }

    public static class BeanMap
    extends LinkedHashMap<Integer, SimpleBean> {
    }

    public static class BeanList2d
    extends LinkedList<LinkedList<SimpleBean>> {
    }

    public static class BeanList
    extends LinkedList<SimpleBean> {
    }

    public static class Simple2dList
    extends LinkedList<LinkedList<Integer>> {
    }

    public static class SimpleList
    extends LinkedList<Integer> {
    }

    public static class SimpleBean {
        public String f1;
    }
}

