/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.juneau.XVar;
import org.apache.juneau.annotation.CS;
import org.apache.juneau.jsonschema.BasicBeanDefMapper;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.JsonSchemaConfig;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class JsonSchemaConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t instanceof Collection) {
                return ((Collection)t).stream().map(TO_STRING).collect(Collectors.joining(","));
            }
            if (t instanceof BeanDefMapper) {
                return ((BeanDefMapper)t).getClass().getSimpleName();
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basic() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        JsonSchemaGeneratorSession x = JsonSchemaGenerator.create().applyAnnotations(al, sr).build().createSession();
        JsonSchemaConfigAnnotationTest.check("BEAN", x.getAddDescriptionsTo());
        JsonSchemaConfigAnnotationTest.check("BEAN", x.getAddExamplesTo());
        JsonSchemaConfigAnnotationTest.check("true", x.isAllowNestedDescriptions());
        JsonSchemaConfigAnnotationTest.check("true", x.isAllowNestedExamples());
        JsonSchemaConfigAnnotationTest.check("BasicBeanDefMapper", x.getBeanDefMapper());
        JsonSchemaConfigAnnotationTest.check("{org.apache.juneau.jsonschema.JsonSchemaConfigAnnotationTest$A={foo:'bar'}}", x.getDefaultSchemas());
        JsonSchemaConfigAnnotationTest.check("foo", x.getIgnoreTypes());
        JsonSchemaConfigAnnotationTest.check("true", x.isUseBeanDefs());
    }

    @Test
    public void noValues() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        JsonSchemaGeneratorSession x = JsonSchemaGenerator.create().applyAnnotations(al, sr).build().createSession();
        JsonSchemaConfigAnnotationTest.check("", x.getAddDescriptionsTo());
        JsonSchemaConfigAnnotationTest.check("", x.getAddExamplesTo());
        JsonSchemaConfigAnnotationTest.check("false", x.isAllowNestedDescriptions());
        JsonSchemaConfigAnnotationTest.check("false", x.isAllowNestedExamples());
        JsonSchemaConfigAnnotationTest.check("BasicBeanDefMapper", x.getBeanDefMapper());
        JsonSchemaConfigAnnotationTest.check("{}", x.getDefaultSchemas());
        JsonSchemaConfigAnnotationTest.check("", x.getIgnoreTypes());
        JsonSchemaConfigAnnotationTest.check("false", x.isUseBeanDefs());
    }

    @Test
    public void noAnnotation() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        JsonSchemaGeneratorSession x = JsonSchemaGenerator.create().applyAnnotations(al, sr).build().createSession();
        JsonSchemaConfigAnnotationTest.check("", x.getAddDescriptionsTo());
        JsonSchemaConfigAnnotationTest.check("", x.getAddExamplesTo());
        JsonSchemaConfigAnnotationTest.check("false", x.isAllowNestedDescriptions());
        JsonSchemaConfigAnnotationTest.check("false", x.isAllowNestedExamples());
        JsonSchemaConfigAnnotationTest.check("BasicBeanDefMapper", x.getBeanDefMapper());
        JsonSchemaConfigAnnotationTest.check("{}", x.getDefaultSchemas());
        JsonSchemaConfigAnnotationTest.check("", x.getIgnoreTypes());
        JsonSchemaConfigAnnotationTest.check("false", x.isUseBeanDefs());
    }

    static class C {
        C() {
        }
    }

    @JsonSchemaConfig
    static class B {
        B() {
        }
    }

    @JsonSchemaConfig(addDescriptionsTo="$X{BEAN}", addExamplesTo="$X{BEAN}", allowNestedDescriptions="$X{true}", allowNestedExamples="$X{true}", beanDefMapper=BasicBeanDefMapper.class, defaultSchemas={@CS(k=A.class, v="{foo:'bar'}")}, ignoreTypes="$X{foo}", useBeanDefs="$X{true}")
    static class A {
        A() {
        }
    }
}

