/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.json.annotation.Json;
import org.apache.juneau.json.annotation.JsonConfig;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonTest {
    @Test
    public void testBasic() throws Exception {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        LinkedList<String> l = new LinkedList<String>();
        JsonSerializer s1 = JsonSerializer.create().ssq().trimNullProperties(false).build();
        JsonSerializer s2 = JsonSerializer.create().simple().trimNullProperties(false).build();
        m.clear();
        m.put(null, null);
        m.put("aaa", "bbb");
        Assert.assertEquals((String)"A1", (Object)"{null:null,aaa:'bbb'}", (Object)s1.serialize(m));
        m.clear();
        m.put("x", "[\"]");
        Assert.assertEquals((Object)"{x:\"[\\\"]\"}", (Object)s2.serialize(m));
        m.clear();
        m.put("x", "[\\\"]");
        Assert.assertEquals((Object)"{x:\"[\\\\\\\"]\"}", (Object)s2.serialize(m));
        m.clear();
        String r = "\\w[\\w\\-\\.]{3,}\\w";
        m.put("x", r);
        Assert.assertEquals((Object)"{x:\"\\\\w[\\\\w\\\\-\\\\.]{3,}\\\\w\"}", (Object)s2.serialize(m));
        Assert.assertEquals((Object)r, (Object)new ObjectMap((CharSequence)s2.serialize(m)).getString("x"));
        m.clear();
        m.put("x", "foo\\bar");
        Assert.assertEquals((Object)"{x:\"foo\\\\bar\"}", (Object)s2.serialize(m));
        m.clear();
        m.put("null", null);
        m.put("aaa", "bbb");
        Assert.assertEquals((String)"A2", (Object)"{'null':null,aaa:'bbb'}", (Object)s1.serialize(m));
        m.clear();
        m.put(null, "null");
        m.put("aaa", "bbb");
        Assert.assertEquals((String)"A3", (Object)"{null:'null',aaa:'bbb'}", (Object)s1.serialize(m));
        m.clear();
        l.clear();
        m.put("J", "f1");
        m.put("B", "b");
        m.put("C", "c");
        l.add("1");
        l.add("2");
        l.add("3");
        Object[] o = new Object[]{m, l};
        Object[] o2 = new Object[]{o, "foo", "bar", new Integer(1), new Boolean(false), new Float(1.2), null};
        Assert.assertEquals((String)"K1", (Object)"[[{J:'f1',B:'b',C:'c'},['1','2','3']],'foo','bar',1,false,1.2,null]", (Object)s1.serialize((Object)o2));
    }

    @Test
    public void testReservedKeywordAttributes() throws Exception {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        for (String attr : new String[]{"", "true", "false", "null", "try", "123", "1x", "-123", ".123"}) {
            m.clear();
            m.put(attr, 1);
            TestUtils.assertObjectEquals("{'" + attr + "':1}", m);
        }
    }

    @Test
    public void testBackslashesInStrings() throws Exception {
        JsonSerializer s = JsonSerializer.create().simple().trimNullProperties(false).build();
        String r = "\\";
        String r2 = s.serialize((Object)r);
        Assert.assertEquals((Object)r2, (Object)"\"\\\\\"");
        Assert.assertEquals((Object)JsonParser.DEFAULT.parse(r2, Object.class), (Object)r);
        r = "\b\f\n\t";
        r2 = s.serialize((Object)r);
        Assert.assertEquals((Object)"\"\\b\\f\\n\\t\"", (Object)r2);
        Assert.assertEquals((Object)r, (Object)JsonParser.DEFAULT.parse(r2, Object.class));
        Assert.assertEquals((Object)JsonParser.DEFAULT.parse("\"\\/\"", Object.class), (Object)"/");
        r = "\u1234\u1abc\u1abc";
        r2 = s.serialize((Object)r);
        Assert.assertEquals((Object)"\"\u1234\u1abc\u1abc\"", (Object)r2);
        Assert.assertEquals((Object)"\u1234", (Object)JsonParser.DEFAULT.parse("\"\\u1234\"", Object.class));
    }

    @Test
    public void testIndentation() throws Exception {
        ObjectMap m = new ObjectMap((CharSequence)"{J:{B:['c',{D:'e'},['f',{G:'h'},1,false]]},I:'j'}");
        String e = "{\n\tJ: {\n\t\tB: [\n\t\t\t'c',\n\t\t\t{\n\t\t\t\tD: 'e'\n\t\t\t},\n\t\t\t[\n\t\t\t\t'f',\n\t\t\t\t{\n\t\t\t\t\tG: 'h'\n\t\t\t\t},\n\t\t\t\t1,\n\t\t\t\tfalse\n\t\t\t]\n\t\t]\n\t},\n\tI: 'j'\n}";
        Assert.assertEquals((Object)e, (Object)SimpleJsonSerializer.DEFAULT_READABLE.serialize((Object)m));
    }

    @Test
    public void testEscapingDoubleQuotes() throws Exception {
        JsonSerializer s = JsonSerializer.DEFAULT;
        String r = s.serialize((Object)new ObjectMap().append("f1", (Object)"x'x\"x"));
        Assert.assertEquals((Object)"{\"f1\":\"x'x\\\"x\"}", (Object)r);
        JsonParser p = JsonParser.DEFAULT;
        Assert.assertEquals((Object)"x'x\"x", (Object)((ObjectMap)p.parse(r, ObjectMap.class)).getString("f1"));
    }

    @Test
    public void testEscapingSingleQuotes() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        String r = s.serialize((Object)new ObjectMap().append("f1", (Object)"x'x\"x"));
        Assert.assertEquals((Object)"{f1:'x\\'x\"x'}", (Object)r);
        JsonParser p = JsonParser.DEFAULT;
        Assert.assertEquals((Object)"x'x\"x", (Object)((ObjectMap)p.parse(r, ObjectMap.class)).getString("f1"));
    }

    @Test
    public void testWrapperAttrAnnotationOnBean() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        A t = A.create();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{foo:{f1:1}}", (Object)r);
        t = (A)p.parse(r, A.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Map m = new LinkedHashMap<String, A>();
        m.put("bar", A.create());
        r = s.serialize(m);
        Assert.assertEquals((Object)"{bar:{foo:{f1:1}}}", (Object)r);
        m = (Map)p.parse(r, LinkedHashMap.class, new Type[]{String.class, A.class});
        Assert.assertEquals((long)1L, (long)((A)m.get((Object)"bar")).f1);
    }

    @Test
    public void testWrapperAttrAnnotationOnBean_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{A2.class}).build();
        JsonParser p = JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{A2.class}).build();
        A2 t = A2.create();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{foo:{f1:1}}", (Object)r);
        t = (A2)p.parse(r, A2.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Map m = new LinkedHashMap<String, A2>();
        m.put("bar", A2.create());
        r = s.serialize(m);
        Assert.assertEquals((Object)"{bar:{foo:{f1:1}}}", (Object)r);
        m = (Map)p.parse(r, LinkedHashMap.class, new Type[]{String.class, A2.class});
        Assert.assertEquals((long)1L, (long)((A2)m.get((Object)"bar")).f1);
    }

    @Test
    public void testWrapperAttrAnnotationOnNonBean() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        B t = B.create();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{foo:'1'}", (Object)r);
        t = (B)p.parse(r, B.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Map m = new LinkedHashMap<String, B>();
        m.put("bar", B.create());
        r = s.serialize(m);
        Assert.assertEquals((Object)"{bar:{foo:'1'}}", (Object)r);
        m = (Map)p.parse(r, LinkedHashMap.class, new Type[]{String.class, B.class});
        Assert.assertEquals((long)1L, (long)((B)m.get((Object)"bar")).f1);
    }

    @Test
    public void testWrapperAttrAnnotationOnNonBean_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{B2.class}).build();
        JsonParser p = JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{B2.class}).build();
        B2 t = B2.create();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{foo:'1'}", (Object)r);
        t = (B2)p.parse(r, B2.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Map m = new LinkedHashMap<String, B2>();
        m.put("bar", B2.create());
        r = s.serialize(m);
        Assert.assertEquals((Object)"{bar:{foo:'1'}}", (Object)r);
        m = (Map)p.parse(r, LinkedHashMap.class, new Type[]{String.class, B2.class});
        Assert.assertEquals((long)1L, (long)((B2)m.get((Object)"bar")).f1);
    }

    @Test
    public void testSubclassedList() throws Exception {
        JsonSerializer s = JsonSerializer.DEFAULT;
        HashMap<String, C> o = new HashMap<String, C>();
        o.put("c", new C());
        Assert.assertEquals((Object)"{\"c\":[]}", (Object)s.serialize(o));
    }

    @Test
    public void testEscapeSolidus() throws Exception {
        JsonSerializer s = JsonSerializer.create().escapeSolidus(false).build();
        String r = s.serialize((Object)"foo/bar");
        Assert.assertEquals((Object)"\"foo/bar\"", (Object)r);
        r = (String)JsonParser.DEFAULT.parse(r, String.class);
        Assert.assertEquals((Object)"foo/bar", (Object)r);
        s = JsonSerializer.create().escapeSolidus(true).build();
        r = s.serialize((Object)"foo/bar");
        Assert.assertEquals((Object)"\"foo\\/bar\"", (Object)r);
        r = (String)JsonParser.DEFAULT.parse(r, String.class);
        Assert.assertEquals((Object)"foo/bar", (Object)r);
        s = JsonSerializer.create().escapeSolidus().build();
        r = s.serialize((Object)"foo/bar");
        Assert.assertEquals((Object)"\"foo\\/bar\"", (Object)r);
        r = (String)JsonParser.DEFAULT.parse(r, String.class);
        Assert.assertEquals((Object)"foo/bar", (Object)r);
    }

    public static class C
    extends LinkedList<String> {
    }

    @JsonConfig(applyJson={@Json(on="B2", wrapperAttr="foo")})
    public static class B2 {
        int f1;

        static B2 create() {
            B2 b = new B2();
            b.f1 = 1;
            return b;
        }

        public String toString() {
            return String.valueOf(this.f1);
        }

        public static B2 valueOf(String s) {
            B2 b = new B2();
            b.f1 = Integer.parseInt(s);
            return b;
        }
    }

    @Json(wrapperAttr="foo")
    public static class B {
        int f1;

        static B create() {
            B b = new B();
            b.f1 = 1;
            return b;
        }

        public String toString() {
            return String.valueOf(this.f1);
        }

        public static B valueOf(String s) {
            B b = new B();
            b.f1 = Integer.parseInt(s);
            return b;
        }
    }

    @JsonConfig(applyJson={@Json(on="A2", wrapperAttr="foo")})
    public static class A2 {
        public int f1;

        static A2 create() {
            A2 a = new A2();
            a.f1 = 1;
            return a;
        }
    }

    @Json(wrapperAttr="foo")
    public static class A {
        public int f1;

        static A create() {
            A a = new A();
            a.f1 = 1;
            return a;
        }
    }
}

