/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.testutils.pojos.TestEnumToString;
import org.junit.Assert;
import org.junit.Test;

public class JsonSchemaSerializerTest {
    @Test
    public void simpleObjects() throws Exception {
        JsonSchemaSerializer s = JsonSchemaSerializer.DEFAULT_SIMPLE;
        Assert.assertEquals((Object)"{type:'integer',format:'int16'}", (Object)s.serialize((Object)1));
        Assert.assertEquals((Object)"{type:'integer',format:'int32'}", (Object)s.serialize((Object)1));
        Assert.assertEquals((Object)"{type:'integer',format:'int64'}", (Object)s.serialize((Object)1L));
        Assert.assertEquals((Object)"{type:'number',format:'float'}", (Object)s.serialize((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"{type:'number',format:'double'}", (Object)s.serialize((Object)1.0));
        Assert.assertEquals((Object)"{type:'boolean'}", (Object)s.serialize((Object)true));
        Assert.assertEquals((Object)"{type:'string'}", (Object)s.serialize((Object)"foo"));
        Assert.assertEquals((Object)"{type:'string'}", (Object)s.serialize((Object)new StringBuilder("foo")));
        Assert.assertEquals((Object)"{type:'string'}", (Object)s.serialize((Object)Character.valueOf('c')));
        Assert.assertEquals((Object)"{type:'string','enum':['one','two','three']}", (Object)s.serialize((Object)TestEnumToString.ONE));
        Assert.assertEquals((Object)"{type:'object',properties:{f1:{type:'string'}}}", (Object)s.serialize((Object)new SimpleBean()));
    }

    public static class SimpleBean {
        public String f1;
    }
}

