/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.Reader;
import org.apache.juneau.CloseableStringReader;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonParserTest {
    private static final JsonParser p = JsonParser.DEFAULT;
    private static final JsonParser sp = JsonParser.DEFAULT_STRICT;

    @Test
    public void testInvalidJson() {
        try {
            p.parse("{\na:1,\nb:xxx\n}", Object.class);
            Assert.fail((String)"Exception expected.");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testNonExistentAttribute() throws Exception {
        String json = "{foo:,bar:}";
        ObjectMap m = (ObjectMap)p.parse(json, ObjectMap.class);
        Assert.assertEquals((Object)"{foo:null,bar:null}", (Object)m.toString());
    }

    @Test
    public void testNonStringAsString() throws Exception {
        String json = "123";
        try {
            sp.parse(json, String.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Did not find quote character"));
        }
        String s = (String)p.parse(json, String.class);
        Assert.assertEquals((Object)"123", (Object)s);
        json = " 123 ";
        try {
            sp.parse(json, String.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Did not find quote character"));
        }
        s = (String)p.parse(json, String.class);
        Assert.assertEquals((Object)"123", (Object)s);
        json = "{\"fa\":123}";
        try {
            sp.parse(json, A.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Did not find quote character"));
        }
        A a = (A)p.parse(json, A.class);
        Assert.assertEquals((Object)"123", (Object)a.fa);
        json = " { \"fa\" : 123 } ";
        try {
            sp.parse(json, A.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Did not find quote character"));
        }
        a = (A)p.parse(json, A.class);
        Assert.assertEquals((Object)"123", (Object)a.fa);
        json = "'123'";
        try {
            sp.parse(json, String.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid quote character"));
        }
    }

    @Test
    public void testStrictMode() throws Exception {
        JsonParser p = sp;
        String json = "{\"foo\":,\"bar\":}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Missing value detected."));
        }
        json = "{\"foo\":'bar'}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Invalid quote character"));
        }
        json = "{'foo':\"bar\"}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Invalid quote character"));
        }
        json = "{foo:\"bar\"}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Unquoted attribute detected."));
        }
        json = "{\"foo\":\"bar\"+\"baz\"}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("String concatenation detected."));
        }
        json = "{\"foo\":\"bar\" + \"baz\"}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("String concatenation detected."));
        }
        json = "{\"foo\":/*comment*/\"bar\"}";
        try {
            p.parse(json, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Javascript comment detected."));
        }
    }

    @Test
    public void testPrimitivesAsStrings() throws Exception {
        JsonParser p = JsonParser.DEFAULT;
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        String json = "{f01:'1',f02:'1',f03:'true',f04:'true',f05:'1',f06:'1',f07:'1',f08:'1',f09:'1',f10:'1'}";
        B b = (B)p.parse(json, B.class);
        Assert.assertEquals((Object)"{f01:1,f02:1,f03:true,f04:true,f05:1.0,f06:1.0,f07:1,f08:1,f09:1,f10:1}", (Object)s.toString((Object)b));
        json = "{f01:'',f02:'',f03:'',f04:'',f05:'',f06:'',f07:'',f08:'',f09:'',f10:''}";
        b = (B)p.parse(json, B.class);
        Assert.assertEquals((Object)"{f01:0,f02:0,f03:false,f04:false,f05:0.0,f06:0.0,f07:0,f08:0,f09:0,f10:0}", (Object)s.toString((Object)b));
    }

    @Test
    public void testInvalidJsonNumbers() throws Exception {
        JsonParser p1 = JsonParser.DEFAULT;
        JsonParser p2 = JsonParser.DEFAULT_STRICT;
        String s = "\"\"";
        Number r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)0L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        try {
            r = (Number)p2.parse(s, Number.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid JSON number"));
        }
        s = "0";
        r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)0L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        r = (Number)p2.parse(s, Number.class);
        Assert.assertEquals((long)0L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        s = "-0";
        r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)0L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        r = (Number)p2.parse(s, Number.class);
        Assert.assertEquals((long)0L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        s = "0123";
        r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)83L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        try {
            r = (Number)p2.parse(s, Number.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid JSON number"));
        }
        s = "-0123";
        r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)-83L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        try {
            r = (Number)p2.parse(s, Number.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid JSON number"));
        }
        s = "0x123";
        r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)291L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        try {
            r = (Number)p2.parse(s, Number.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid JSON number"));
        }
        s = "-0x123";
        r = (Number)p1.parse(s, Number.class);
        Assert.assertEquals((long)-291L, (long)r.intValue());
        Assert.assertTrue((boolean)(r instanceof Integer));
        try {
            r = (Number)p2.parse(s, Number.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid JSON number"));
        }
    }

    @Test
    public void testUnquotedStrings() throws Exception {
        JsonParser p1 = JsonParser.DEFAULT;
        JsonParser p2 = JsonParser.DEFAULT_STRICT;
        String s = "foobar";
        C c = (C)p1.parse(s, C.class);
        Assert.assertEquals((Object)"f=foobar", (Object)c.toString());
        try {
            p2.parse(s, C.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testStreamsAutoClose() throws Exception {
        JsonParser p = JsonParser.DEFAULT.builder().autoCloseStreams().build();
        Reader r = this.reader("{foo:'bar'}{baz:'qux'}");
        Object x = p.parse((Object)r, ObjectMap.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", x);
        try {
            x = p.parse((Object)r, ObjectMap.class);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Reader is closed"));
        }
    }

    @Test
    public void testMultipleObjectsInStream() throws Exception {
        JsonParser p = JsonParser.create().unbuffered().build();
        Reader r = this.reader("{foo:'bar'}{baz:'qux'}");
        Object x = p.parse((Object)r, ObjectMap.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", x);
        x = p.parse((Object)r, ObjectMap.class);
        TestUtils.assertObjectEquals("{baz:'qux'}", x);
        r = this.reader("[123][456]");
        x = p.parse((Object)r, ObjectList.class);
        TestUtils.assertObjectEquals("[123]", x);
        x = p.parse((Object)r, ObjectList.class);
        TestUtils.assertObjectEquals("[456]", x);
    }

    private Reader reader(String in) {
        return new CloseableStringReader(in);
    }

    public static class C {
        String f;

        public static C valueOf(String s) {
            C c = new C();
            c.f = s;
            return c;
        }

        public String toString() {
            return "f=" + this.f;
        }
    }

    public static class B {
        public int f01;
        public Integer f02;
        public boolean f03;
        public Boolean f04;
        public float f05;
        public Float f06;
        public long f07;
        public Long f08;
        public byte f09;
        public Byte f10;
    }

    public static class A {
        public String fa;
    }
}

