/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.json.annotation.JsonConfig;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class JsonConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        JsonSerializerSession x = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        JsonConfigAnnotationTest.check("true", x.isAddBeanTypes());
        JsonConfigAnnotationTest.check("true", x.isEscapeSolidus());
        JsonConfigAnnotationTest.check("true", x.isSimpleMode());
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        JsonParserSession x = JsonParser.create().applyAnnotations(al, sr).build().createSession();
        JsonConfigAnnotationTest.check("true", x.isValidateEnd());
    }

    @Test
    public void noValuesSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        JsonSerializerSession x = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        JsonConfigAnnotationTest.check("false", x.isAddBeanTypes());
        JsonConfigAnnotationTest.check("false", x.isEscapeSolidus());
        JsonConfigAnnotationTest.check("false", x.isSimpleMode());
    }

    @Test
    public void noValuesParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        JsonParserSession x = JsonParser.create().applyAnnotations(al, sr).build().createSession();
        JsonConfigAnnotationTest.check("false", x.isValidateEnd());
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        JsonSerializerSession x = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        JsonConfigAnnotationTest.check("false", x.isAddBeanTypes());
        JsonConfigAnnotationTest.check("false", x.isEscapeSolidus());
        JsonConfigAnnotationTest.check("false", x.isSimpleMode());
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        JsonParserSession x = JsonParser.create().applyAnnotations(al, sr).build().createSession();
        JsonConfigAnnotationTest.check("false", x.isValidateEnd());
    }

    static class C {
        C() {
        }
    }

    @JsonConfig
    static class B {
        B() {
        }
    }

    @JsonConfig(addBeanTypes="$X{true}", escapeSolidus="$X{true}", simpleMode="$X{true}", validateEnd="$X{true}")
    static class A {
        A() {
        }
    }
}

