/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class CommonTest {
    @Test
    public void testTrimNullsFromBeans() throws Exception {
        JsonSerializerBuilder s = JsonSerializer.create().ssq();
        JsonParser p = JsonParser.DEFAULT;
        A t1 = A.create();
        s.trimNullProperties(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{s1:null,s2:'s2'}", (Object)r);
        A t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimNullProperties(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{s2:'s2'}", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    @Test
    public void testTrimEmptyMaps() throws Exception {
        JsonSerializerBuilder s = JsonSerializer.create().ssq();
        JsonParser p = JsonParser.DEFAULT;
        B t1 = B.create();
        s.trimEmptyMaps(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f1:{},f2:{f2a:null,f2b:{s2:'s2'}}}", (Object)r);
        B t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyMaps(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f2:{f2a:null,f2b:{s2:'s2'}}}", (Object)r);
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyMaps();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f2:{f2a:null,f2b:{s2:'s2'}}}", (Object)r);
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyLists() throws Exception {
        JsonSerializerBuilder s = JsonSerializer.create().ssq();
        JsonParser p = JsonParser.DEFAULT;
        C t1 = C.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f1:[],f2:[null,{s2:'s2'}]}", (Object)r);
        C t2 = (C)p.parse(r, C.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f2:[null,{s2:'s2'}]}", (Object)r);
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f2:[null,{s2:'s2'}]}", (Object)r);
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyArrays() throws Exception {
        JsonSerializerBuilder s = JsonSerializer.create().ssq();
        JsonParser p = JsonParser.DEFAULT;
        D t1 = D.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f1:[],f2:[null,{s2:'s2'}]}", (Object)r);
        D t2 = (D)p.parse(r, D.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f2:[null,{s2:'s2'}]}", (Object)r);
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"{f2:[null,{s2:'s2'}]}", (Object)r);
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
    }

    @Test
    public void testBeanPropertyProperies() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        E1 t = new E1();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{x1:{f1:1},x2:{f1:1},x3:[{f1:1}],x4:[{f1:1}],x5:[{f1:1}],x6:[{f1:1}]}", (Object)r);
        r = s.getSchemaSerializer().serialize((Object)t);
        Assert.assertTrue((r.indexOf("f2") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testBeanPropertyProperiesOnListOfBeans() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        LinkedList<F> l = new LinkedList<F>();
        F t = new F();
        t.x1.add(new F());
        l.add(t);
        String json = s.serialize(l);
        Assert.assertEquals((Object)"[{x1:[{x2:2}],x2:2}]", (Object)json);
    }

    @Test
    public void testURIAttr() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        G t = new G();
        t.uri = new URI("http://uri");
        t.f1 = new URI("http://f1");
        t.f2 = new URL("http://f2");
        String json = s.serialize((Object)t);
        t = (G)p.parse(json, G.class);
        Assert.assertEquals((Object)"http://uri", (Object)t.uri.toString());
        Assert.assertEquals((Object)"http://f1", (Object)t.f1.toString());
        Assert.assertEquals((Object)"http://f2", (Object)t.f2.toString());
    }

    @Test
    public void testRecursion() throws Exception {
        String msg;
        JsonSerializerBuilder s = JsonSerializer.create().ssq();
        R1 r1 = new R1();
        R2 r2 = new R2();
        R3 r3 = new R3();
        r1.r2 = r2;
        r2.r3 = r3;
        r3.r1 = r1;
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            TestUtils.assertContains(msg, "It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.");
        }
        s.detectRecursions();
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            TestUtils.assertContains(msg, "[0] root:org.apache.juneau.json.CommonTest$R1", "->[1] r2:org.apache.juneau.json.CommonTest$R2", "->[2] r3:org.apache.juneau.json.CommonTest$R3", "->[3] r1:org.apache.juneau.json.CommonTest$R1");
        }
        s.ignoreRecursions();
        Assert.assertEquals((Object)"{name:'foo',r2:{name:'bar',r3:{name:'baz'}}}", (Object)s.build().serialize((Object)r1));
        s.build().getSchemaSerializer().serialize((Object)r1);
    }

    @Test
    public void testBasicBean() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().trimNullProperties(false).sortProperties().build();
        J a = new J();
        a.setF1("J");
        a.setF2(100);
        a.setF3(true);
        Assert.assertEquals((String)"C1", (Object)"{f1:'J',f2:100,f3:true}", (Object)s.serialize((Object)a));
    }

    public static class J {
        private String f1 = null;
        private int f2 = -1;
        private boolean f3 = false;

        public String getF1() {
            return this.f1;
        }

        public void setF1(String f1) {
            this.f1 = f1;
        }

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public boolean isF3() {
            return this.f3;
        }

        public void setF3(boolean f3) {
            this.f3 = f3;
        }

        public String toString() {
            return "J(f1: " + this.getF1() + ", f2: " + this.getF2() + ")";
        }
    }

    public static class R3 {
        public String name = "baz";
        public R1 r1;
    }

    public static class R2 {
        public String name = "bar";
        public R3 r3;
    }

    public static class R1 {
        public String name = "foo";
        public R2 r2;
    }

    public static class G {
        public URI uri;
        public URI f1;
        public URL f2;
    }

    public static class F {
        @Beanp(properties="x2")
        public List<F> x1 = new LinkedList<F>();
        public int x2 = 2;
    }

    public static class E2 {
        public int f1 = 1;
        public int f2 = 2;
    }

    public static class E1 {
        @Beanp(properties="f1")
        public E2 x1 = new E2();
        @Beanp(properties="f1")
        public Map<String, Integer> x2 = new AMap().append((Object)"f1", (Object)1).append((Object)"f2", (Object)2);
        @Beanp(properties="f1")
        public E2[] x3 = new E2[]{new E2()};
        @Beanp(properties="f1")
        public List<E2> x4 = new AList().append((Object)new E2());
        @Beanp(properties="f1")
        public ObjectMap[] x5 = new ObjectMap[]{new ObjectMap().append("f1", (Object)1).append("f2", (Object)2)};
        @Beanp(properties="f1")
        public List<ObjectMap> x6 = new AList().append((Object)new ObjectMap().append("f1", (Object)1).append("f2", (Object)2));
    }

    public static class D {
        public A[] f1;
        public A[] f2;

        public static D create() {
            D t = new D();
            t.f1 = new A[0];
            t.f2 = new A[]{null, A.create()};
            return t;
        }
    }

    public static class C {
        public List<A> f1;
        public List<A> f2;

        public static C create() {
            C t = new C();
            t.f1 = new AList();
            t.f2 = new AList().append(null).append((Object)A.create());
            return t;
        }
    }

    public static class B {
        public TreeMap<String, A> f1;
        public TreeMap<String, A> f2;

        public static B create() {
            B t = new B();
            t.f1 = new TreeMap();
            t.f2 = new TreeMap<String, A>(){
                {
                    this.put("f2a", null);
                    this.put("f2b", A.create());
                }
            };
            return t;
        }
    }

    public static class A {
        public String s1;
        public String s2;

        public static A create() {
            A t = new A();
            t.s2 = "s2";
            return t;
        }
    }
}

