/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.junit.Assert;
import org.junit.Test;

public class CommonParserTest {
    @Test
    public void testFromSerializer() throws Exception {
        JsonParser p = JsonParser.create().dictionary(new Class[]{A1.class}).build();
        Map m = null;
        m = (Map)p.parse("{a:1}", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        m = (Map)p.parse("{a:1,b:\"foo bar\"}", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        m = (Map)p.parse("{a:1,b:\"foo bar\",c:false}", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)false, m.get("c"));
        m = (Map)p.parse(" { a : 1 , b : 'foo' , c : false } ", Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo", m.get("b"));
        Assert.assertEquals((Object)false, m.get("c"));
        m = (Map)p.parse("{x:\"org.apache.juneau.test.Person\",addresses:[{x:\"org.apache.juneau.test.Address\",city:\"city A\",state:\"state A\",street:\"street A\",zip:12345}]}", Object.class);
        Assert.assertEquals((Object)"org.apache.juneau.test.Person", m.get("x"));
        List l = (List)m.get("addresses");
        Assert.assertNotNull((Object)l);
        m = (Map)l.get(0);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"org.apache.juneau.test.Address", m.get("x"));
        Assert.assertEquals((Object)"city A", m.get("city"));
        Assert.assertEquals((Object)"state A", m.get("state"));
        Assert.assertEquals((Object)"street A", m.get("street"));
        Assert.assertEquals((Object)12345, m.get("zip"));
        ObjectList jl = (ObjectList)p.parse("[{attribute:'value'},{attribute:'value'}]", Object.class);
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(1).getString("attribute"));
        Assert.assertNull((Object)p.parse((Object)null, Object.class));
        Assert.assertNull((Object)p.parse("", Object.class));
        Assert.assertNull((Object)p.parse("   ", Object.class));
        Assert.assertNull((Object)p.parse("   \t", Object.class));
        Assert.assertNull((Object)p.parse("   /*foo*/", Object.class));
        Assert.assertNull((Object)p.parse("   /*foo*/   ", Object.class));
        Assert.assertNull((Object)p.parse("   //foo   ", Object.class));
        try {
            jl = (ObjectList)p.parse("[{attribute:'value'},{attribute:'value'}]", Object.class);
            Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
            Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(1).getString("attribute"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        A1 b = new A1();
        A2 tl = new A2();
        tl.add(new A3("name0", "value0"));
        tl.add(new A3("name1", "value1"));
        b.list = tl;
        String json = JsonSerializer.create().addBeanTypes(true).addRootType().dictionary(new Class[]{A1.class}).build().serialize((Object)b);
        b = (A1)p.parse(json, Object.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)b.list.get((int)1)).value);
        json = JsonSerializer.DEFAULT.serialize((Object)b);
        b = (A1)p.parse(json, A1.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)b.list.get((int)1)).value);
    }

    @Test
    public void testCorrectHandlingOfUnknownProperties() throws Exception {
        JsonParser p = JsonParser.create().ignoreUnknownBeanProperties().build();
        String in = "{a:1,unknown:3,b:2}";
        B b = (B)p.parse(in, B.class);
        Assert.assertEquals((long)b.a, (long)1L);
        Assert.assertEquals((long)b.b, (long)2L);
        try {
            p = JsonParser.DEFAULT;
            p.parse(in, B.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testCollectionPropertiesWithNoSetters() throws Exception {
        JsonParser p = JsonParser.DEFAULT;
        String json = "{ints:[1,2,3],beans:[{a:1,b:2}]}";
        C t = (C)p.parse(json, C.class);
        Assert.assertEquals((long)t.getInts().size(), (long)3L);
        Assert.assertEquals((long)t.getBeans().get((int)0).b, (long)2L);
    }

    @Test
    public void testParserListeners() throws Exception {
        JsonParser p = JsonParser.create().ignoreUnknownBeanProperties().listener(MyParserListener.class).build();
        String json = "{a:1,unknownProperty:\"/foo\",b:2}";
        p.parse(json, B.class);
        Assert.assertEquals((long)1L, (long)MyParserListener.events.size());
        Assert.assertEquals((Object)"unknownProperty, line 1, column 5", (Object)MyParserListener.events.get(0));
    }

    public static class MyParserListener
    extends ParserListener {
        static final List<String> events = new LinkedList<String>();

        public <T> void onUnknownBeanProperty(ParserSession session, String propertyName, Class<T> beanClass, T bean) {
            events.add(propertyName + ", " + session.getPosition());
        }
    }

    public static class C {
        private Collection<Integer> ints = new LinkedList<Integer>();
        private List<B> beans = new LinkedList<B>();

        public Collection<Integer> getInts() {
            return this.ints;
        }

        public List<B> getBeans() {
            return this.beans;
        }
    }

    public static class B {
        public int a;
        public int b;
    }

    public static class A3 {
        public String name;
        public String value;

        public A3() {
        }

        public A3(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class A2
    extends LinkedList<A3> {
    }

    @Bean(typeName="A1")
    public static class A1 {
        public A2 list;
    }
}

