/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.jena.RdfXmlParser;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class RdfTest {
    @Test
    public void testCollectionFormatProperties() throws Exception {
        A a = new A().init();
        RdfSerializerBuilder s = RdfSerializer.create().xmlabbrev().set("RdfCommon.jena.rdfXml.tab.i", (Object)3).sq().addRootProperty();
        RdfParser p = RdfParser.create().xml().build();
        String expected = "<rdf:RDF a='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/a'>\n      <a:f2>\n         <rdf:Seq>\n            <rdf:li>f2a</rdf:li>\n            <rdf:li>f2b</rdf:li>\n         </rdf:Seq>\n      </a:f2>\n      <a:f3>\n         <rdf:Seq>\n            <rdf:li>1</rdf:li>\n            <rdf:li>2</rdf:li>\n         </rdf:Seq>\n      </a:f3>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        String rdfXml = s.build().serialize((Object)a);
        TestUtils.assertXmlEquals(expected, rdfXml);
        A a2 = (A)p.parse(rdfXml, A.class);
        TestUtils.assertEqualObjects(a, a2);
        s.collectionFormat(RdfCollectionFormat.SEQ);
        expected = "<rdf:RDF a='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/a'>\n      <a:f2>\n         <rdf:Seq>\n            <rdf:li>f2a</rdf:li>\n            <rdf:li>f2b</rdf:li>\n         </rdf:Seq>\n      </a:f2>\n      <a:f3>\n         <rdf:Seq>\n            <rdf:li>1</rdf:li>\n            <rdf:li>2</rdf:li>\n         </rdf:Seq>\n      </a:f3>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        rdfXml = s.build().serialize((Object)a);
        TestUtils.assertXmlEquals(expected, rdfXml);
        a2 = (A)p.parse(rdfXml, A.class);
        TestUtils.assertEqualObjects(a, a2);
        s.collectionFormat(RdfCollectionFormat.BAG);
        expected = "<rdf:RDF a='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/a'>\n      <a:f2>\n         <rdf:Bag>\n            <rdf:li>f2a</rdf:li>\n            <rdf:li>f2b</rdf:li>\n         </rdf:Bag>\n      </a:f2>\n      <a:f3>\n         <rdf:Bag>\n            <rdf:li>1</rdf:li>\n            <rdf:li>2</rdf:li>\n         </rdf:Bag>\n      </a:f3>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        rdfXml = s.build().serialize((Object)a);
        TestUtils.assertXmlEquals(expected, rdfXml);
        a2 = (A)p.parse(rdfXml, A.class);
        TestUtils.assertEqualObjects(a, a2);
        s.collectionFormat(RdfCollectionFormat.LIST);
        expected = "<rdf:RDF a='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/a'>\n      <a:f2 parseType='Resource'>\n         <rdf:first>f2a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f2b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </a:f2>\n      <a:f3 parseType='Resource'>\n         <rdf:first>1</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>2</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </a:f3>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        rdfXml = s.build().serialize((Object)a);
        TestUtils.assertXmlEquals(expected, rdfXml);
        a2 = (A)p.parse(rdfXml, A.class);
        TestUtils.assertEqualObjects(a, a2);
        s.collectionFormat(RdfCollectionFormat.MULTI_VALUED);
        expected = "<rdf:RDF a='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/a'>\n      <a:f2>f2a</a:f2>\n      <a:f2>f2b</a:f2>\n      <a:f3>1</a:f3>\n      <a:f3>2</a:f3>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        rdfXml = s.build().serialize((Object)a);
        TestUtils.assertXmlEquals(expected, rdfXml);
        p = RdfParser.create().xml().collectionFormat(RdfCollectionFormat.MULTI_VALUED).build();
        a2 = (A)p.parse(rdfXml, A.class);
        TestUtils.assertEqualObjects(a, a2);
    }

    @Test
    public void testCollectionFormatAnnotations() throws Exception {
        B b = new B().init();
        RdfSerializerBuilder s = RdfSerializer.create().xmlabbrev().set("RdfCommon.jena.rdfXml.tab.i", (Object)3).sq().addRootProperty();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        String expected = "<rdf:RDF b='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/b'>\n      <b:f2>\n         <rdf:Seq>\n            <rdf:li>f2a</rdf:li>\n            <rdf:li>f2b</rdf:li>\n         </rdf:Seq>\n      </b:f2>\n      <b:f3>\n         <rdf:Bag>\n            <rdf:li>f3a</rdf:li>\n            <rdf:li>f3b</rdf:li>\n         </rdf:Bag>\n      </b:f3>\n      <b:f4 parseType='Resource'>\n         <rdf:first>f4a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f4b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </b:f4>\n      <b:f5>f5a</b:f5>\n      <b:f5>f5b</b:f5>\n      <b:f6>\n         <rdf:Seq>\n            <rdf:li>f6a</rdf:li>\n            <rdf:li>f6b</rdf:li>\n         </rdf:Seq>\n      </b:f6>\n      <b:f7>\n         <rdf:Seq>\n            <rdf:li>f7a</rdf:li>\n            <rdf:li>f7b</rdf:li>\n         </rdf:Seq>\n      </b:f7>\n      <b:f8>\n         <rdf:Bag>\n            <rdf:li>f8a</rdf:li>\n            <rdf:li>f8b</rdf:li>\n         </rdf:Bag>\n      </b:f8>\n      <b:f9 parseType='Resource'>\n         <rdf:first>f9a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f9b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </b:f9>\n      <b:fa>faa</b:fa>\n      <b:fa>fab</b:fa>\n      <b:fb>\n         <rdf:Seq>\n            <rdf:li>fba</rdf:li>\n            <rdf:li>fbb</rdf:li>\n         </rdf:Seq>\n      </b:fb>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        String rdfXml = s.build().serialize((Object)b);
        TestUtils.assertXmlEquals(expected, rdfXml);
        B b2 = (B)p.parse(rdfXml, B.class);
        TestUtils.assertEqualObjects(b, b2, true);
        s.collectionFormat(RdfCollectionFormat.BAG);
        expected = "<rdf:RDF b='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/b'>\n      <b:f2>\n         <rdf:Seq>\n            <rdf:li>f2a</rdf:li>\n            <rdf:li>f2b</rdf:li>\n         </rdf:Seq>\n      </b:f2>\n      <b:f3>\n         <rdf:Bag>\n            <rdf:li>f3a</rdf:li>\n            <rdf:li>f3b</rdf:li>\n         </rdf:Bag>\n      </b:f3>\n      <b:f4 parseType='Resource'>\n         <rdf:first>f4a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f4b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </b:f4>\n      <b:f5>f5a</b:f5>\n      <b:f5>f5b</b:f5>\n      <b:f6>\n         <rdf:Bag>\n            <rdf:li>f6a</rdf:li>\n            <rdf:li>f6b</rdf:li>\n         </rdf:Bag>\n      </b:f6>\n      <b:f7>\n         <rdf:Seq>\n            <rdf:li>f7a</rdf:li>\n            <rdf:li>f7b</rdf:li>\n         </rdf:Seq>\n      </b:f7>\n      <b:f8>\n         <rdf:Bag>\n            <rdf:li>f8a</rdf:li>\n            <rdf:li>f8b</rdf:li>\n         </rdf:Bag>\n      </b:f8>\n      <b:f9 parseType='Resource'>\n         <rdf:first>f9a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f9b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </b:f9>\n      <b:fa>faa</b:fa>\n      <b:fa>fab</b:fa>\n      <b:fb>\n         <rdf:Bag>\n            <rdf:li>fba</rdf:li>\n            <rdf:li>fbb</rdf:li>\n         </rdf:Bag>\n      </b:fb>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        rdfXml = s.build().serialize((Object)b);
        TestUtils.assertXmlEquals(expected, rdfXml);
        b2 = (B)p.parse(rdfXml, B.class);
        TestUtils.assertEqualObjects(b, b2, true);
    }

    @Test
    public void testCollectionFormatAnnotationOnClass() throws Exception {
        C c = new C().init();
        RdfSerializerBuilder s = RdfSerializer.create().xmlabbrev().set("RdfCommon.jena.rdfXml.tab.i", (Object)3).sq().addRootProperty();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        s.collectionFormat(RdfCollectionFormat.BAG);
        String expected = "<rdf:RDF b='http://ns/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/b'>\n      <b:f2>\n         <rdf:Seq>\n            <rdf:li>f2a</rdf:li>\n            <rdf:li>f2b</rdf:li>\n         </rdf:Seq>\n      </b:f2>\n      <b:f3>\n         <rdf:Bag>\n            <rdf:li>f3a</rdf:li>\n            <rdf:li>f3b</rdf:li>\n         </rdf:Bag>\n      </b:f3>\n      <b:f4 parseType='Resource'>\n         <rdf:first>f4a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f4b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </b:f4>\n      <b:f5>f5a</b:f5>\n      <b:f5>f5b</b:f5>\n      <b:f6>\n         <rdf:Bag>\n            <rdf:li>f6a</rdf:li>\n            <rdf:li>f6b</rdf:li>\n         </rdf:Bag>\n      </b:f6>\n      <b:f7>\n         <rdf:Seq>\n            <rdf:li>f7a</rdf:li>\n            <rdf:li>f7b</rdf:li>\n         </rdf:Seq>\n      </b:f7>\n      <b:f8>\n         <rdf:Bag>\n            <rdf:li>f8a</rdf:li>\n            <rdf:li>f8b</rdf:li>\n         </rdf:Bag>\n      </b:f8>\n      <b:f9 parseType='Resource'>\n         <rdf:first>f9a</rdf:first>\n         <rdf:rest parseType='Resource'>\n            <rdf:first>f9b</rdf:first>\n            <rdf:rest resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/>\n         </rdf:rest>\n      </b:f9>\n      <b:fa>faa</b:fa>\n      <b:fa>fab</b:fa>\n      <b:fb>\n         <rdf:Bag>\n            <rdf:li>fba</rdf:li>\n            <rdf:li>fbb</rdf:li>\n         </rdf:Bag>\n      </b:fb>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        String rdfXml = s.build().serialize((Object)c);
        TestUtils.assertXmlEquals(expected, rdfXml);
        C c2 = (C)p.parse(rdfXml, C.class);
        TestUtils.assertEqualObjects(c, c2, true);
    }

    @Test
    public void testLooseCollectionsOfBeans() throws Exception {
        RdfSerializer s = RdfSerializer.create().xmlabbrev().looseCollections().build();
        RdfParser p = RdfParser.create().xml().looseCollections().build();
        List l = new LinkedList<D>();
        l.add(new D().init(1));
        l.add(new D().init(2));
        String rdfXml = s.serialize(l);
        String expected = "<rdf:RDF j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://localhost/f1/2'>\n      <jp:f2>f2</jp:f2>\n      <jp:f3 resource='http://localhost/f3/2'/>\n   </rdf:Description>\n   <rdf:Description about='http://localhost/f1/1'>\n      <jp:f2>f2</jp:f2>\n      <jp:f3 resource='http://localhost/f3/1'/>\n   </rdf:Description>\n</rdf:RDF>";
        TestUtils.assertXmlEquals(expected, rdfXml);
        l = (List)p.parse(rdfXml, LinkedList.class, new Type[]{D.class});
        D[] da = l.toArray(new D[l.size()]);
        rdfXml = s.serialize((Object)da);
        expected = "<rdf:RDF j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://localhost/f1/2'>\n      <jp:f2>f2</jp:f2>\n      <jp:f3 resource='http://localhost/f3/2'/>\n   </rdf:Description>\n   <rdf:Description about='http://localhost/f1/1'>\n      <jp:f2>f2</jp:f2>\n      <jp:f3 resource='http://localhost/f3/1'/>\n   </rdf:Description>\n</rdf:RDF>";
        TestUtils.assertXmlEquals(expected, rdfXml);
        da = (D[])p.parse(rdfXml, D[].class);
        rdfXml = s.serialize((Object)da);
        expected = "<rdf:RDF j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://localhost/f1/2'>\n      <jp:f2>f2</jp:f2>\n      <jp:f3 resource='http://localhost/f3/2'/>\n   </rdf:Description>\n   <rdf:Description about='http://localhost/f1/1'>\n      <jp:f2>f2</jp:f2>\n      <jp:f3 resource='http://localhost/f3/1'/>\n   </rdf:Description>\n</rdf:RDF>";
        TestUtils.assertXmlEquals(expected, rdfXml);
    }

    public static class D {
        @Rdf(beanUri=true)
        public URI f1;
        public String f2;
        public URI f3;

        public D init(int num) throws Exception {
            this.f1 = new URI("http://localhost/f1/" + num);
            this.f2 = "f2";
            this.f3 = new URI("http://localhost/f3/" + num);
            return this;
        }
    }

    @Rdf(collectionFormat=RdfCollectionFormat.BAG)
    public static class C
    extends B {
        @Override
        public C init() throws Exception {
            this.f1 = new URI("http://test/b");
            this.f2 = new String[]{"f2a", "f2b"};
            this.f3 = new String[]{"f3a", "f3b"};
            this.f4 = new String[]{"f4a", "f4b"};
            this.f5 = new String[]{"f5a", "f5b"};
            this.f6 = new String[]{"f6a", "f6b"};
            this.f7 = new BA().append("f7a", "f7b");
            this.f8 = new BB().append("f8a", "f8b");
            this.f9 = new BC().append("f9a", "f9b");
            this.fa = new BD().append("faa", "fab");
            this.fb = new BE().append("fba", "fbb");
            return this;
        }
    }

    @Rdf(prefix="bd", namespace="http://ns/", collectionFormat=RdfCollectionFormat.DEFAULT)
    public static class BE
    extends ArrayList<String> {
        public BE append(String ... s) {
            this.addAll(Arrays.asList(s));
            return this;
        }
    }

    @Rdf(prefix="bd", namespace="http://ns/", collectionFormat=RdfCollectionFormat.MULTI_VALUED)
    public static class BD
    extends ArrayList<String> {
        public BD append(String ... s) {
            this.addAll(Arrays.asList(s));
            return this;
        }
    }

    @Rdf(prefix="bc", namespace="http://ns/", collectionFormat=RdfCollectionFormat.LIST)
    public static class BC
    extends ArrayList<String> {
        public BC append(String ... s) {
            this.addAll(Arrays.asList(s));
            return this;
        }
    }

    @Rdf(prefix="bb", namespace="http://ns/", collectionFormat=RdfCollectionFormat.BAG)
    public static class BB
    extends ArrayList<String> {
        public BB append(String ... s) {
            this.addAll(Arrays.asList(s));
            return this;
        }
    }

    @Rdf(prefix="ba", namespace="http://ns/", collectionFormat=RdfCollectionFormat.SEQ)
    public static class BA
    extends ArrayList<String> {
        public BA append(String ... s) {
            this.addAll(Arrays.asList(s));
            return this;
        }
    }

    @Rdf(prefix="b", namespace="http://ns/")
    public static class B {
        @Rdf(beanUri=true)
        public URI f1;
        @Rdf(collectionFormat=RdfCollectionFormat.SEQ)
        public String[] f2;
        @Rdf(collectionFormat=RdfCollectionFormat.BAG)
        public String[] f3;
        @Rdf(collectionFormat=RdfCollectionFormat.LIST)
        public String[] f4;
        @Rdf(collectionFormat=RdfCollectionFormat.MULTI_VALUED)
        public String[] f5;
        @Rdf(collectionFormat=RdfCollectionFormat.DEFAULT)
        public String[] f6;
        public BA f7;
        public BB f8;
        public BC f9;
        public BD fa;
        public BE fb;

        public B init() throws Exception {
            this.f1 = new URI("http://test/b");
            this.f2 = new String[]{"f2a", "f2b"};
            this.f3 = new String[]{"f3a", "f3b"};
            this.f4 = new String[]{"f4a", "f4b"};
            this.f5 = new String[]{"f5a", "f5b"};
            this.f6 = new String[]{"f6a", "f6b"};
            this.f7 = new BA().append("f7a", "f7b");
            this.f8 = new BB().append("f8a", "f8b");
            this.f9 = new BC().append("f9a", "f9b");
            this.fa = new BD().append("faa", "fab");
            this.fb = new BE().append("fba", "fbb");
            return this;
        }
    }

    @Rdf(prefix="a", namespace="http://ns/")
    public static class A {
        @Rdf(beanUri=true)
        public URI f1;
        public String[] f2;
        public List<Integer> f3;

        public A init() throws Exception {
            this.f1 = new URI("http://test/a");
            this.f2 = new String[]{"f2a", "f2b"};
            this.f3 = Arrays.asList(1, 2);
            return this;
        }
    }
}

