/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfXmlParser;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RdfParserTest {
    @Before
    public void beforeTest() {
        TestUtils.setLocale(Locale.US);
    }

    @After
    public void afterTest() {
        TestUtils.unsetLocale();
    }

    @Test
    public void testParseIntoGenericPojos() throws Exception {
        A a = new A().init();
        RdfSerializer s = RdfSerializer.create().xmlabbrev().set("RdfCommon.jena.rdfXml.tab.i", (Object)3).sq().addRootProperty().build();
        String expected = "<rdf:RDF a='http://ns/' a1='http://ns2/' j='http://www.apache.org/juneau/' jp='http://www.apache.org/juneaubp/' rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n   <rdf:Description about='http://test/a'>\n      <a:f1>1</a:f1>\n      <a:f2>f2</a:f2>\n      <a:f4a rdf:resource='http://test/a'/>\n      <a:f4b rdf:resource='http://test/external'/>\n      <a:f5>1999-01-01T00:00:00Z</a:f5>\n      <a:f6>\n         <rdf:Seq>\n            <rdf:li>\n               <rdf:Description about='http://test/a/a1'>\n                  <a1:f1>1</a1:f1>\n                  <a1:f2>f2</a1:f2>\n                  <a1:f4a rdf:resource='http://test/a'/>\n                  <a1:f4b rdf:resource='http://test/external'/>\n                  <a1:f5>1999-01-01T00:00:00Z</a1:f5>\n               </rdf:Description>\n            </rdf:li>\n         </rdf:Seq>\n      </a:f6>\n      <j:root>true</j:root>\n   </rdf:Description>\n</rdf:RDF>";
        String rdfXml = s.serialize((Object)a);
        TestUtils.assertXmlEquals(expected, rdfXml);
        A a2 = (A)RdfXmlParser.DEFAULT.parse(rdfXml, A.class);
        TestUtils.assertEqualObjects(a, a2);
        ObjectMap m = (ObjectMap)RdfXmlParser.DEFAULT.parse(rdfXml, ObjectMap.class);
        String json = SimpleJsonSerializer.DEFAULT_READABLE.serialize((Object)m);
        String e = "{\n\turi: 'http://test/a',\n\tf6: [\n\t\t{\n\t\t\turi: 'http://test/a/a1',\n\t\t\tf5: '1999-01-01T00:00:00Z',\n\t\t\tf4b: 'http://test/external',\n\t\t\tf4a: 'http://test/a',\n\t\t\tf2: 'f2',\n\t\t\tf1: '1'\n\t\t}\n\t],\n\tf5: '1999-01-01T00:00:00Z',\n\tf4b: 'http://test/external',\n\tf4a: 'http://test/a',\n\tf2: 'f2',\n\tf1: '1',\n\troot: 'true'\n}";
        Assert.assertEquals((Object)e, (Object)json.replace("\r", ""));
    }

    @Rdf(prefix="a1", namespace="http://ns2/")
    public static class A1 {
        public int f1;
        public String f2;
        @Rdf(beanUri=true)
        public URI f3;
        public URI f4a;
        public URI f4b;
        public Calendar f5;

        public A1 init() throws Exception {
            this.f1 = 1;
            this.f2 = "f2";
            this.f3 = new URI("http://test/a/a1");
            this.f4a = new URI("http://test/a");
            this.f4b = new URI("http://test/external");
            this.f5 = GregorianCalendar.from(ZonedDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse("1999-01-01T00:00:00Z")));
            return this;
        }
    }

    @Rdf(prefix="a", namespace="http://ns/")
    public static class A {
        public int f1;
        public String f2;
        @Rdf(beanUri=true)
        public URI f3;
        public URI f4a;
        public URI f4b;
        public Calendar f5;
        public LinkedList<A1> f6 = new LinkedList();

        public A init() throws Exception {
            this.f1 = 1;
            this.f2 = "f2";
            this.f3 = new URI("http://test/a");
            this.f4a = new URI("http://test/a");
            this.f4b = new URI("http://test/external");
            this.f5 = GregorianCalendar.from(ZonedDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse("1999-01-01T00:00:00Z")));
            this.f6 = new LinkedList();
            this.f6.add(new A1().init());
            return this;
        }
    }
}

