/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.juneau.XVar;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfSerializerSession;
import org.apache.juneau.jena.annotation.RdfConfig;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class RdfConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof List) {
                return ((List)t).stream().map(TO_STRING).collect(Collectors.joining(","));
            }
            if (t.getClass().isArray()) {
                return this.apply(ArrayUtils.toList((Object)t, Object.class));
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        RdfSerializerSession x = RdfSerializer.create().applyAnnotations(al, sr).build().createSession();
        RdfConfigAnnotationTest.check("true", x.isAddBeanTypes());
        RdfConfigAnnotationTest.check("true", x.isAddLiteralTypes());
        RdfConfigAnnotationTest.check("true", x.isAddRootProp());
        RdfConfigAnnotationTest.check("true", x.isAutoDetectNamespaces());
        RdfConfigAnnotationTest.check("SEQ", x.getCollectionFormat());
        RdfConfigAnnotationTest.check("foo:http://foo", x.getJuneauBpNs());
        RdfConfigAnnotationTest.check("foo:http://foo", x.getJuneauNs());
        RdfConfigAnnotationTest.check("N3", x.getLanguage());
        RdfConfigAnnotationTest.check("true", x.isLooseCollections());
        RdfConfigAnnotationTest.check("foo:http://foo", x.getNamespaces());
        RdfConfigAnnotationTest.check("true", x.isUseXmlNamespaces());
        Map jp = x.getJenaProperties();
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.embedding.b".substring(15)));
        RdfConfigAnnotationTest.check("strict", jp.get("RdfCommon.jena.rdfXml.error-mode.s".substring(15)));
        RdfConfigAnnotationTest.check("strict", jp.get("RdfCommon.jena.rdfXml.iri-rules.s".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.abbrevBaseURI.b".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.indentProperty.i".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.minGap.i".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.objectLists.b".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.propertyColumn.i".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.subjectColumn.i".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.useDoubles.b".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.usePropertySymbols.b".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.useTripleQuotedStrings.b".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.widePropertyLen.i".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.allowBadURIs.b".substring(15)));
        RdfConfigAnnotationTest.check("'", jp.get("RdfCommon.jena.rdfXml.attributeQuoteChar.s".substring(15)));
        RdfConfigAnnotationTest.check("foo", jp.get("RdfCommon.jena.rdfXml.blockRules.s".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.longId.b".substring(15)));
        RdfConfigAnnotationTest.check("absolute", jp.get("RdfCommon.jena.rdfXml.relativeURIs.s".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.showXmlDeclaration.s".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.rdfXml.tab.i".substring(15)));
        RdfConfigAnnotationTest.check("foo", jp.get("RdfCommon.jena.rdfXml.xmlbase.s".substring(15)));
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        RdfParserSession x = RdfParser.create().applyAnnotations(al, sr).build().createSession();
        RdfConfigAnnotationTest.check("SEQ", x.getCollectionFormat());
        RdfConfigAnnotationTest.check("foo:http://foo", x.getJuneauBpNs());
        RdfConfigAnnotationTest.check("foo:http://foo", x.getJuneauNs());
        RdfConfigAnnotationTest.check("N3", x.getLanguage());
        RdfConfigAnnotationTest.check("true", x.isLooseCollections());
        RdfConfigAnnotationTest.check("true", x.isTrimWhitespace());
        Map jp = x.getJenaProperties();
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.embedding.b".substring(15)));
        RdfConfigAnnotationTest.check("strict", jp.get("RdfCommon.jena.rdfXml.error-mode.s".substring(15)));
        RdfConfigAnnotationTest.check("strict", jp.get("RdfCommon.jena.rdfXml.iri-rules.s".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.abbrevBaseURI.b".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.indentProperty.i".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.minGap.i".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.objectLists.b".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.propertyColumn.i".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.subjectColumn.i".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.useDoubles.b".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.usePropertySymbols.b".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.n3.useTripleQuotedStrings.b".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.n3.widePropertyLen.i".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.allowBadURIs.b".substring(15)));
        RdfConfigAnnotationTest.check("'", jp.get("RdfCommon.jena.rdfXml.attributeQuoteChar.s".substring(15)));
        RdfConfigAnnotationTest.check("foo", jp.get("RdfCommon.jena.rdfXml.blockRules.s".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.longId.b".substring(15)));
        RdfConfigAnnotationTest.check("absolute", jp.get("RdfCommon.jena.rdfXml.relativeURIs.s".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b".substring(15)));
        RdfConfigAnnotationTest.check("true", jp.get("RdfCommon.jena.rdfXml.showXmlDeclaration.s".substring(15)));
        RdfConfigAnnotationTest.check("1", jp.get("RdfCommon.jena.rdfXml.tab.i".substring(15)));
        RdfConfigAnnotationTest.check("foo", jp.get("RdfCommon.jena.rdfXml.xmlbase.s".substring(15)));
    }

    @Test
    public void noValuesSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        RdfSerializerSession x = RdfSerializer.create().applyAnnotations(al, sr).build().createSession();
        RdfConfigAnnotationTest.check("false", x.isAddBeanTypes());
        RdfConfigAnnotationTest.check("false", x.isAddLiteralTypes());
        RdfConfigAnnotationTest.check("false", x.isAddRootProp());
        RdfConfigAnnotationTest.check("true", x.isAutoDetectNamespaces());
        RdfConfigAnnotationTest.check("DEFAULT", x.getCollectionFormat());
        RdfConfigAnnotationTest.check("jp:http://www.apache.org/juneaubp/", x.getJuneauBpNs());
        RdfConfigAnnotationTest.check("j:http://www.apache.org/juneau/", x.getJuneauNs());
        RdfConfigAnnotationTest.check("RDF/XML-ABBREV", x.getLanguage());
        RdfConfigAnnotationTest.check("false", x.isLooseCollections());
        RdfConfigAnnotationTest.check("", x.getNamespaces());
        RdfConfigAnnotationTest.check("true", x.isUseXmlNamespaces());
        Map jp = x.getJenaProperties();
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.embedding.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.error-mode.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.iri-rules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.abbrevBaseURI.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.indentProperty.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.minGap.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.objectLists.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.propertyColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.subjectColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useDoubles.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.usePropertySymbols.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useTripleQuotedStrings.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.widePropertyLen.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.allowBadURIs.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.attributeQuoteChar.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.blockRules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.longId.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.relativeURIs.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showXmlDeclaration.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.tab.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.xmlbase.s".substring(15)));
    }

    @Test
    public void noValuesParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        RdfParserSession x = RdfParser.create().applyAnnotations(al, sr).build().createSession();
        RdfConfigAnnotationTest.check("DEFAULT", x.getCollectionFormat());
        RdfConfigAnnotationTest.check("jp:http://www.apache.org/juneaubp/", x.getJuneauBpNs());
        RdfConfigAnnotationTest.check("j:http://www.apache.org/juneau/", x.getJuneauNs());
        RdfConfigAnnotationTest.check("RDF/XML-ABBREV", x.getLanguage());
        RdfConfigAnnotationTest.check("false", x.isLooseCollections());
        RdfConfigAnnotationTest.check("false", x.isTrimWhitespace());
        Map jp = x.getJenaProperties();
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.embedding.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.error-mode.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.iri-rules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.abbrevBaseURI.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.indentProperty.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.minGap.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.objectLists.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.propertyColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.subjectColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useDoubles.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.usePropertySymbols.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useTripleQuotedStrings.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.widePropertyLen.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.allowBadURIs.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.attributeQuoteChar.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.blockRules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.longId.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.relativeURIs.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showXmlDeclaration.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.tab.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.xmlbase.s".substring(15)));
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        RdfSerializerSession x = RdfSerializer.create().applyAnnotations(al, sr).build().createSession();
        RdfConfigAnnotationTest.check("false", x.isAddBeanTypes());
        RdfConfigAnnotationTest.check("false", x.isAddLiteralTypes());
        RdfConfigAnnotationTest.check("false", x.isAddRootProp());
        RdfConfigAnnotationTest.check("true", x.isAutoDetectNamespaces());
        RdfConfigAnnotationTest.check("DEFAULT", x.getCollectionFormat());
        RdfConfigAnnotationTest.check("jp:http://www.apache.org/juneaubp/", x.getJuneauBpNs());
        RdfConfigAnnotationTest.check("j:http://www.apache.org/juneau/", x.getJuneauNs());
        RdfConfigAnnotationTest.check("RDF/XML-ABBREV", x.getLanguage());
        RdfConfigAnnotationTest.check("false", x.isLooseCollections());
        RdfConfigAnnotationTest.check("", x.getNamespaces());
        RdfConfigAnnotationTest.check("true", x.isUseXmlNamespaces());
        Map jp = x.getJenaProperties();
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.embedding.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.error-mode.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.iri-rules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.abbrevBaseURI.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.indentProperty.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.minGap.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.objectLists.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.propertyColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.subjectColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useDoubles.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.usePropertySymbols.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useTripleQuotedStrings.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.widePropertyLen.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.allowBadURIs.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.attributeQuoteChar.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.blockRules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.longId.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.relativeURIs.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showXmlDeclaration.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.tab.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.xmlbase.s".substring(15)));
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        RdfParserSession x = RdfParser.create().applyAnnotations(al, sr).build().createSession();
        RdfConfigAnnotationTest.check("DEFAULT", x.getCollectionFormat());
        RdfConfigAnnotationTest.check("jp:http://www.apache.org/juneaubp/", x.getJuneauBpNs());
        RdfConfigAnnotationTest.check("j:http://www.apache.org/juneau/", x.getJuneauNs());
        RdfConfigAnnotationTest.check("RDF/XML-ABBREV", x.getLanguage());
        RdfConfigAnnotationTest.check("false", x.isLooseCollections());
        RdfConfigAnnotationTest.check("false", x.isTrimWhitespace());
        Map jp = x.getJenaProperties();
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.embedding.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.error-mode.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.iri-rules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.abbrevBaseURI.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.indentProperty.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.minGap.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.objectLists.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.propertyColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.subjectColumn.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useDoubles.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.usePropertySymbols.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.useTripleQuotedStrings.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.n3.widePropertyLen.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.allowBadURIs.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.attributeQuoteChar.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.blockRules.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.longId.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.relativeURIs.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.showXmlDeclaration.s".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.tab.i".substring(15)));
        RdfConfigAnnotationTest.check(null, jp.get("RdfCommon.jena.rdfXml.xmlbase.s".substring(15)));
    }

    static class C {
        C() {
        }
    }

    @RdfConfig
    static class B {
        B() {
        }
    }

    @RdfConfig(addBeanTypes="$X{true}", addLiteralTypes="$X{true}", addRootProperty="$X{true}", arp_embedding="$X{true}", arp_errorMode="$X{strict}", arp_iriRules="$X{strict}", autoDetectNamespaces="$X{true}", collectionFormat="$X{SEQ}", juneauBpNs="$X{foo:http://foo}", juneauNs="$X{foo:http://foo}", language="$X{N3}", looseCollections="$X{true}", n3_abbrevBaseUri="$X{true}", n3_indentProperty="$X{1}", n3_minGap="$X{1}", n3_objectLists="$X{true}", n3_propertyColumn="$X{1}", n3_subjectColumn="$X{1}", n3_useDoubles="$X{true}", n3_usePropertySymbols="$X{true}", n3_useTripleQuotedStrings="$X{true}", n3_widePropertyLen="$X{1}", namespaces={"$X{foo:http://foo}"}, rdfxml_allowBadUris="$X{true}", rdfxml_attributeQuoteChar="$X{'}", rdfxml_blockRules="$X{foo}", rdfxml_longId="$X{true}", rdfxml_relativeUris="$X{absolute}", rdfxml_showDoctypeDeclaration="$X{true}", rdfxml_showXmlDeclaration="$X{true}", rdfxml_tab="$X{1}", rdfxml_xmlBase="$X{foo}", trimWhitespace="$X{true}", useXmlNamespaces="$X{true}")
    static class A {
        A() {
        }
    }
}

