/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.net.URL;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.jena.RdfXmlParser;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.Test;

public class CommonXmlTest {
    private RdfSerializerBuilder getBasicSerializer() {
        return RdfSerializer.create().sq().useWhitespace(false).set("RdfCommon.jena.rdfXml.allowBadURIs.b", (Object)true).set("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b", (Object)false).set("RdfCommon.jena.rdfXml.showXmlDeclaration.s", (Object)false);
    }

    private String strip(String s) {
        return s.replaceFirst("<rdf:RDF[^>]+>\\s*", "").replaceAll("</rdf:RDF>$", "").trim().replaceAll("[\\r\\n]", "");
    }

    @Test
    public void testBeanUriAnnotation() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        A t1 = A.create();
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description rdf:about='http://foo'><jp:name>bar</jp:name></rdf:Description>", (Object)this.strip(r));
        A t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    @Test
    public void testBeanUriAnnotationOnlyUriProperty() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        B t1 = B.create();
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description rdf:about='http://foo'><jp:url2 rdf:resource='http://foo/2'/></rdf:Description>", (Object)this.strip(r));
        B t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    public static class B {
        @Rdf(beanUri=true)
        @Xml(format=XmlFormat.ATTR)
        public URL url;
        public URL url2;

        public static B create() throws Exception {
            B t = new B();
            t.url = new URL("http://foo");
            t.url2 = new URL("http://foo/2");
            return t;
        }
    }

    public static class A {
        @Rdf(beanUri=true)
        @Xml(format=XmlFormat.ATTR)
        public URL url;
        public String name;

        public static A create() throws Exception {
            A t = new A();
            t.url = new URL("http://foo");
            t.name = "bar";
            return t;
        }
    }
}

